/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.provider;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.MapperUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.ContinuousOnlyMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.GuideMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.ColorMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.GuideMappers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradient2MapperProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ContinuousOnlyMapperProvider;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "low", "mid", "high", "midpoint", "", "naValue", "(Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/values/Color;)V", "myHigh", "myLow", "myMid", "myMidpoint", "Ljava/lang/Double;", "createContinuousMapper", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/GuideMapper;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "trans", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "Companion", "plot-builder"})
public final class ColorGradient2MapperProvider
extends ContinuousOnlyMapperProvider<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color myLow;
    @NotNull
    private final Color myMid;
    @NotNull
    private final Color myHigh;
    @Nullable
    private final Double myMidpoint;
    @NotNull
    private static final Color DEF_GRADIENT_LOW = Color.Companion.parseHex("#964540");
    @NotNull
    private static final Color DEF_GRADIENT_MID = Color.Companion.getWHITE();
    @NotNull
    private static final Color DEF_GRADIENT_HIGH = Color.Companion.parseHex("#3B3D96");

    public ColorGradient2MapperProvider(@Nullable Color low, @Nullable Color mid, @Nullable Color high, @Nullable Double midpoint, @NotNull Color naValue) {
        Double d;
        Color color;
        Color color2;
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        Color color3 = low;
        if (color3 == null) {
            color3 = this.myLow = DEF_GRADIENT_LOW;
        }
        if ((color2 = mid) == null) {
            color2 = this.myMid = DEF_GRADIENT_MID;
        }
        if ((color = high) == null) {
            color = this.myHigh = DEF_GRADIENT_HIGH;
        }
        if ((d = midpoint) == null) {
            d = 0.0;
        }
        this.myMidpoint = d;
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        double d = domain2.getLowerEnd();
        Double d2 = this.myMidpoint;
        Intrinsics.checkNotNull((Object)d2);
        DoubleSpan lowDomain = new DoubleSpan(d, Math.max(d2, domain2.getLowerEnd()));
        DoubleSpan highDomain = new DoubleSpan(Math.min(this.myMidpoint, domain2.getUpperEnd()), domain2.getUpperEnd());
        Function1 lowMapper = ColorMapper.gradient$default(ColorMapper.INSTANCE, lowDomain, this.myLow, this.myMid, (Color)this.getNaValue(), 0.0, 16, null);
        Function1 highMapper = ColorMapper.gradient$default(ColorMapper.INSTANCE, highDomain, this.myMid, this.myHigh, (Color)this.getNaValue(), 0.0, 16, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)lowDomain, (Object)lowMapper), TuplesKt.to((Object)highDomain, (Object)highMapper)};
        Map rangeMap = MapsKt.mapOf((Pair[])pairArray);
        ScaleMapper<Color> scaleMapper2 = new ScaleMapper<Color>(this, (Map<DoubleSpan, ? extends Function1<? super Double, Color>>)rangeMap){
            final /* synthetic */ ColorGradient2MapperProvider this$0;
            final /* synthetic */ Map<DoubleSpan, Function1<Double, Color>> $rangeMap;
            {
                this.this$0 = $receiver;
                this.$rangeMap = $rangeMap;
            }

            @NotNull
            public Color invoke(@Nullable Double v) {
                Function1 mapper = ColorGradient2MapperProvider.access$createContinuousMapper$getMapper(this.$rangeMap, v);
                Object object = mapper;
                if (object == null || (object = (Color)object.invoke((Object)v)) == null) {
                    object = (Color)this.this$0.getNaValue();
                }
                return object;
            }
        };
        return GuideMappers.INSTANCE.asContinuous((ScaleMapper)scaleMapper2);
    }

    private static final Function1<Double, Color> createContinuousMapper$getMapper(Map<DoubleSpan, ? extends Function1<? super Double, Color>> rangeMap, Double v) {
        Function1<? super Double, Color> f = null;
        if (SeriesUtil.INSTANCE.isFinite(v)) {
            double fSpan = Double.NaN;
            for (DoubleSpan range : rangeMap.keySet()) {
                Double d = v;
                Intrinsics.checkNotNull((Object)d);
                if (!range.contains(d)) continue;
                double span = range.getUpperEnd() - range.getLowerEnd();
                if (f == null || fSpan == 0.0) {
                    f = rangeMap.get(range);
                    fSpan = span;
                    continue;
                }
                if (!(span < fSpan) || !(span > 0.0)) continue;
                f = rangeMap.get(range);
                fSpan = span;
            }
        }
        return f;
    }

    public static final /* synthetic */ Function1 access$createContinuousMapper$getMapper(Map rangeMap, Double v) {
        return ColorGradient2MapperProvider.createContinuousMapper$getMapper(rangeMap, v);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradient2MapperProvider$Companion;", "", "()V", "DEF_GRADIENT_HIGH", "Lorg/jetbrains/letsPlot/commons/values/Color;", "DEF_GRADIENT_LOW", "DEF_GRADIENT_MID", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

