/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.regression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.LoessInterpolator;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.PolynomialSplineFunction;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionEvaluator;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fBC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LocalPolynomialRegression;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator;", "n", "", "meanX", "", "sumXX", "model", "Lkotlin/Function1;", "standardErrorOfEstimate", "tCritical", "(IDDLkotlin/jvm/functions/Function1;DD)V", "Companion", "plot-base"})
public final class LocalPolynomialRegression
extends RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LocalPolynomialRegression(int n, double meanX, double sumXX, Function1<? super Double, Double> model2, double standardErrorOfEstimate, double tCritical) {
        super(n, meanX, sumXX, model2, standardErrorOfEstimate, tCritical);
    }

    public /* synthetic */ LocalPolynomialRegression(int n, double meanX, double sumXX, Function1 model2, double standardErrorOfEstimate, double tCritical, DefaultConstructorMarker $constructor_marker) {
        this(n, meanX, sumXX, (Function1<? super Double, Double>)model2, standardErrorOfEstimate, tCritical);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J8\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LocalPolynomialRegression$Companion;", "", "()V", "canBeComputed", "", "n", "", "degreesOfFreedom", "", "bandwidth", "fit", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LocalPolynomialRegression;", "xs", "", "ys", "confidenceLevel", "getPolynomial", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialSplineFunction;", "xVals", "", "yVals", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalPolynomialRegression fit(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, double bandwidth) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            RegressionEvaluator.Companion.check(xs, ys, confidenceLevel);
            Pair<double[], double[]> pair2 = RegressionUtilKt.averageByX(xs, ys);
            double[] xVals = (double[])pair2.component1();
            double[] yVals = (double[])pair2.component2();
            int n = xVals.length;
            double degreesOfFreedom = (double)n - 2.0;
            if (!this.canBeComputed(n, degreesOfFreedom, bandwidth)) {
                return null;
            }
            double meanX = ArraysKt.average((double[])xVals);
            double sumXX = RegressionUtilKt.sumOfSquaredDeviations(xVals, meanX);
            PolynomialSplineFunction polynomial = this.getPolynomial(xVals, yVals, bandwidth);
            Function1 model2 = (Function1)new Function1<Double, Double>(polynomial){
                final /* synthetic */ PolynomialSplineFunction $polynomial;
                {
                    this.$polynomial = $polynomial;
                    super(1);
                }

                @NotNull
                public final Double invoke(double x2) {
                    Double d = this.$polynomial.value(x2);
                    Intrinsics.checkNotNull((Object)d);
                    return d;
                }
            };
            return new LocalPolynomialRegression(n, meanX, sumXX, model2, RegressionEvaluator.Companion.calcStandardErrorOfEstimate(xVals, yVals, (Function1<? super Double, Double>)model2, degreesOfFreedom), RegressionEvaluator.Companion.calcTCritical(degreesOfFreedom, confidenceLevel), null);
        }

        private final boolean canBeComputed(int n, double degreesOfFreedom, double bandwidth) {
            int bandwidthInPoints = (int)(bandwidth * (double)n);
            boolean bandwidthInPointsOk = bandwidthInPoints >= 2;
            return n >= 3 && degreesOfFreedom > 0.0 && bandwidthInPointsOk;
        }

        private final PolynomialSplineFunction getPolynomial(double[] xVals, double[] yVals, double bandwidth) {
            return new LoessInterpolator(bandwidth, 4, 0.0, 4, null).interpolate(xVals, yVals);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

