/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Instant;", "", "epochMillis", "", "(J)V", "kotlinxInstant", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "getKotlinxInstant$commons", "()Lkotlinx/datetime/Instant;", "add", "millis", "duration", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "compareTo", "", "other", "equals", "", "", "hashCode", "toDateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "toEpochMilliseconds", "toString", "", "commons"})
public final class Instant
implements Comparable<Instant> {
    @NotNull
    private final kotlinx.datetime.Instant kotlinxInstant;

    public Instant(long epochMillis) {
        this.kotlinxInstant = kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(epochMillis);
    }

    public Instant(@NotNull kotlinx.datetime.Instant kotlinxInstant) {
        Intrinsics.checkNotNullParameter((Object)kotlinxInstant, (String)"kotlinxInstant");
        this.kotlinxInstant = kotlinxInstant;
    }

    @NotNull
    public final kotlinx.datetime.Instant getKotlinxInstant$commons() {
        return this.kotlinxInstant;
    }

    public final long toEpochMilliseconds() {
        return this.kotlinxInstant.toEpochMilliseconds();
    }

    @NotNull
    public final DateTime toDateTime(@NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        LocalDateTime kotlinxLocalDateTime = TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)this.kotlinxInstant, (kotlinx.datetime.TimeZone)tz.getKotlinxTz$commons());
        return new DateTime(kotlinxLocalDateTime);
    }

    @NotNull
    public final Instant add(long millis) {
        return new Instant(this.kotlinxInstant.toEpochMilliseconds() + millis);
    }

    @NotNull
    public final Instant add(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Instant(this.kotlinxInstant.toEpochMilliseconds() + duration.getTotalMillis());
    }

    @Override
    public int compareTo(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.kotlinxInstant.compareTo(other.kotlinxInstant);
    }

    public int hashCode() {
        return this.kotlinxInstant.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Instant)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kotlinxInstant, (Object)((Instant)other).kotlinxInstant);
    }

    @NotNull
    public String toString() {
        return this.kotlinxInstant.toString();
    }
}

