/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.refactoring.extractComponent;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactUtil;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactBundle;
import com.intellij.react.ReactComponentContentUtil;
import com.intellij.react.ReactPropTypesUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReactExtractComponentHandlerBase
implements RefactoringActionHandler {
    public static final String HELP_ID = "javascript.refactoring.extractComponent";
    public static final DataKey<String> TEST_NAME_KEY = DataKey.create((String)"javascript.refactoring.extractComponent.test.name");
    public static final DataKey<ComponentType> TEST_COMPONENT_TYPE_KEY = DataKey.create((String)"javascript.refactoring.extractComponent.test.component.type");
    public static final String COMPONENT_TYPE_PROPERTY_KEY = "javascript.refactoring.extractComponent.property.key";
    private static final String PROP_TYPES_NAMESPACE = "PropTypes";
    public static final String NAME_TEMPLATE_PROPERTY = "NAME";
    private static final String BODY_TEMPLATE_PROPERTY = "COMPONENT_BODY";
    public static final String PROP_TYPES_TEMPLATE_PROPERTY = "PROP_TYPES";
    public static final String DEFAULT_PROPS_TEMPLATE_PROPERTY = "DEFAULT_PROPS";
    public static final String HAS_PROPS_TEMPLATE_PROPERTY = "HAS_PROPS";
    private static final Comparator<PsiElement> REVERSE_RANGE_COMPARATOR = Comparator.comparingInt(t -> t.getTextRange().getStartOffset()).reversed();

    public boolean isAvailable(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(1);
        }
        return this.getSourceExpression(editor, file) != null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(3);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        Pair<JSXmlLiteralExpression, TextRange> sourceExpressionDescriptor;
        if (project == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(4);
        }
        if ((sourceExpressionDescriptor = this.getSourceExpression(editor, file)) == null) {
            this.error(project, editor, ReactBundle.message("refactoring.extract.react.component.no.expression", new Object[0]));
            return;
        }
        JSExpression sourceExpression = (JSExpression)sourceExpressionDescriptor.first;
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)sourceExpression, (Editor)editor, (String)this.getRefactoringTitle())) {
            return;
        }
        JSPsiElementBase sourceComponent = ReactComponentContentUtil.getContainingComponent(sourceExpression);
        JSElement introductionScope = ReactExtractComponentHandlerBase.getIntroductionScope(sourceExpression);
        PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)sourceExpression, e -> e.getParent() == introductionScope);
        if (introductionScope == null || parent == null) {
            this.error(project, editor, ReactBundle.message("refactoring.extract.react.component.no.scope", new Object[0]));
            return;
        }
        PsiElement anchor = JSPsiImplUtils.findLeadingCommentOrSelf((PsiElement)parent);
        Pair<String, ComponentType> userSettings = this.getUserSettings(introductionScope, dataContext);
        if (userSettings == null) {
            return;
        }
        ComponentType type = (ComponentType)((Object)userSettings.second);
        String name = (String)userSettings.first;
        Pair<Collection<Prop>, String> result = this.buildPropsAndComponentBody(sourceExpressionDescriptor, sourceComponent, (PsiElement)introductionScope, type);
        Collection props = (Collection)result.first;
        ComponentToExtract component = new ComponentToExtract(name, props, type);
        WriteCommandAction.runWriteCommandAction((Project)sourceExpression.getProject(), (String)this.getRefactoringTitle(), null, () -> this.doRefactoring(editor, (Pair<? extends JSExpression, TextRange>)sourceExpressionDescriptor, anchor, (String)result.second, component), (PsiFile[])new PsiFile[0]);
    }

    protected abstract void doRefactoring(@NotNull Editor var1, @NotNull Pair<? extends JSExpression, TextRange> var2, @NotNull PsiElement var3, @NotNull String var4, @NotNull ComponentToExtract var5);

    @Nullable
    protected abstract Pair<String, ComponentType> getUserSettings(@NotNull JSElement var1, @NotNull DataContext var2);

    @NotNull
    public static InputValidatorEx createNameValidator(final @NotNull PsiElement introductionScope) {
        if (introductionScope == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(5);
        }
        return new InputValidatorEx(){

            @Nullable
            public String getErrorText(String inputString) {
                boolean isIdentifier = JSNamesValidation.isIdentifier((String)inputString, (PsiElement)introductionScope);
                if (!isIdentifier) {
                    return ReactBundle.message("refactoring.extract.react.component.invalid.identifier", inputString);
                }
                List existing = JSRefactoringUtil.findExistingInScope((String)inputString, (PsiElement)introductionScope, (boolean)false);
                if (!existing.isEmpty()) {
                    return JSRefactoringUtil.getMemberAlreadyExistsMessage((PsiElement)((PsiElement)existing.get(0)));
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return this.getErrorText(inputString) == null;
            }
        };
    }

    @Nullable
    private static JSElement getIntroductionScope(@Nullable JSExpression sourceExpression) {
        return sourceExpression != null ? ES6PsiUtil.getExportScope((PsiElement)sourceExpression) : null;
    }

    @Nullable
    protected abstract Pair<JSXmlLiteralExpression, TextRange> getSourceExpression(@NotNull Editor var1, @NotNull PsiFile var2);

    @NotNull
    protected abstract Pair<Collection<Prop>, String> buildPropsAndComponentBody(@NotNull Pair<JSXmlLiteralExpression, TextRange> var1, @Nullable JSPsiElementBase var2, @NotNull PsiElement var3, @NotNull ComponentType var4);

    @NotNull
    public static String replaceOccurrences(@NotNull JSElement toProcess, @NotNull TextRange textRange, @NotNull Map<? extends PsiElement, String> replacements) {
        if (toProcess == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(7);
        }
        if (replacements == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(8);
        }
        TextRange expressionRelativeRange = textRange.shiftLeft(toProcess.getTextRange().getStartOffset());
        StringBuilder result = new StringBuilder(expressionRelativeRange.substring(toProcess.getText()));
        for (PsiElement entry : ContainerUtil.sorted(replacements.keySet(), REVERSE_RANGE_COMPARATOR)) {
            TextRange rangeInFragment = entry.getTextRange().shiftLeft(textRange.getStartOffset());
            result.replace(rangeInFragment.getStartOffset(), rangeInFragment.getEndOffset(), replacements.get(entry));
        }
        String string = result.toString();
        if (string == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected static boolean isContextDependant(@NotNull JSReferenceExpression referenceExpression, @Nullable JSPsiElementBase sourceComponent, @NotNull PsiElement introductionScope) {
        JSExpression qualifier;
        if (referenceExpression == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(10);
        }
        if (introductionScope == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(11);
        }
        if ((qualifier = referenceExpression.getQualifier()) == null) {
            List resolveResults = JSResolveResult.toElements((ResolveResult[])referenceExpression.multiResolve(false));
            return resolveResults.isEmpty() || ContainerUtil.or((Iterable)resolveResults, e -> ReactExtractComponentHandlerBase.isLocallyDefined(introductionScope, e));
        }
        if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
            return true;
        }
        if (ReactExtractComponentHandlerBase.isThisMemberAccess(qualifier, "props") || ReactExtractComponentHandlerBase.isThisMemberAccess(qualifier, "state")) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null) {
            List qualifierResolveResults = JSResolveResult.toElements((ResolveResult[])((JSReferenceExpression)qualifier).multiResolve(false));
            if (sourceComponent instanceof JSFunction && ContainerUtil.or((Iterable)qualifierResolveResults, qualifierResolve -> qualifierResolve instanceof JSParameter && sourceComponent.isEquivalentTo((PsiElement)((JSParameter)qualifierResolve).getDeclaringFunction()))) {
                return true;
            }
            JSClass contextClass = JSResolveUtil.getClassOfContext((PsiElement)referenceExpression);
            if (contextClass != null && ReactExtractComponentHandlerBase.isStaticClassAccess(qualifierResolveResults, contextClass)) {
                for (PsiElement resolved : JSResolveResult.toElements((ResolveResult[])referenceExpression.multiResolve(false))) {
                    if (!(resolved instanceof JSPsiElementBase)) continue;
                    if (((JSPsiElementBase)resolved).getJSContext() != JSContext.STATIC) {
                        return true;
                    }
                    JSAttributeList.AccessType accessType = ((JSPsiElementBase)resolved).getAccessType();
                    if (accessType != JSAttributeList.AccessType.PRIVATE && accessType != JSAttributeList.AccessType.PROTECTED) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLocallyDefined(@NotNull PsiElement introductionScope, @Nullable PsiElement resolved) {
        if (introductionScope == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(12);
        }
        if (!(resolved instanceof JSNamedElement)) {
            return false;
        }
        PsiElement declarationScope = JSUseScopeProvider.getUseScopeElement((JSNamedElement)((JSNamedElement)resolved));
        return declarationScope != null && PsiTreeUtil.isAncestor((PsiElement)introductionScope, (PsiElement)declarationScope, (boolean)true);
    }

    private static boolean isStaticClassAccess(@NotNull List<PsiElement> qualifierResolveResults, @NotNull JSClass contextClass) {
        if (qualifierResolveResults == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(13);
        }
        if (contextClass == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(14);
        }
        return ContainerUtil.or(qualifierResolveResults, result -> contextClass.isEquivalentTo(result));
    }

    private static boolean isThisMemberAccess(@Nullable JSExpression expression, @NotNull String memberName) {
        if (memberName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(15);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)expression;
        JSExpression qualifier = refExpr.getQualifier();
        return (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && StringUtil.equals((CharSequence)refExpr.getReferenceName(), (CharSequence)memberName);
    }

    @NotNull
    protected static Prop propFromExpression(@NotNull JSExpression e, @NotNull Set<String> existingNames) {
        Object propName;
        if (e == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(16);
        }
        if (existingNames == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(17);
        }
        if ((propName = (String)ContainerUtil.getFirstItem((List)JSNameSuggestionsUtil.generateVariableNamesFromExpression((JSExpression)e, null, existingNames))) != null) {
            propName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)propName, null, existingNames, (boolean)true);
        }
        if (propName == null) {
            propName = "prop" + String.valueOf(existingNames.isEmpty() ? "" : Integer.valueOf(existingNames.size()));
        }
        existingNames.add((String)propName);
        return new Prop((String)propName, ReactExtractComponentHandlerBase.getUsableExpressionType(e, (PsiElement)e), e.getText());
    }

    @NotNull
    public static JSType getUsableExpressionType(@Nullable JSExpression e, @NotNull PsiElement context) {
        boolean isJavaScriptResolve;
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(18);
        }
        Object type = JSResolveUtil.getExpressionJSType((JSExpression)e);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)context);
        boolean bl = isJavaScriptResolve = dialectOptionHolder != null && dialectOptionHolder.isJavaScript();
        if (type instanceof JSNamedType && isJavaScriptResolve) {
            JSType functionType = JSTypeUtils.getFunctionType((JSType)type, (boolean)false, (PsiElement)context).findAny().orElse(null);
            if (functionType != null) {
                PsiElement functionSource = type.getSource().getSourceElement();
                type = functionSource instanceof JSFunctionItem ? TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunctionItem)functionSource)) : JSNamedTypeFactory.createFunctionType((JSTypeSource)type.getSource());
            } else if (type instanceof JSTypeImpl && !(type.getSource().getSourceElement() instanceof JSClass)) {
                type = JSAnyType.get((JSTypeSource)type.getSource());
            }
        }
        if (type == null) {
            type = JSAnyType.get((PsiElement)context);
        }
        JSType jSType = dialectOptionHolder != null && dialectOptionHolder.isFlow ? JSTypeUtils.copyWithLanguageRecursive((JSType)type, (JSTypeSource.SourceLanguage)JSTypeSource.SourceLanguage.TS) : type;
        if (jSType == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Nullable
    protected PsiElement addDeclarations(@NotNull ComponentToExtract component, @NotNull Editor editor, @NotNull PsiElement anchorBefore, @NotNull String componentBody) {
        String templateName;
        JSNamedElement createdDeclaration;
        boolean isTypedDialect;
        if (component == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(21);
        }
        if (anchorBefore == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(22);
        }
        if (componentBody == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(23);
        }
        Project project = anchorBefore.getProject();
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)anchorBefore);
        DialectOptionHolder optionHolder = languageDialect != null ? languageDialect.getOptionHolder() : null;
        boolean bl = isTypedDialect = optionHolder != null && optionHolder.hasFeature(JSLanguageFeature.TYPES);
        String propTypesText = isTypedDialect ? ReactExtractComponentHandlerBase.buildTypedPropTypesText(component.props, !optionHolder.isFlow || component.componentType != ComponentType.Class) : ReactExtractComponentHandlerBase.buildJSPropTypesText(component.props, anchorBefore);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty(NAME_TEMPLATE_PROPERTY, component.name);
        properties.setProperty(BODY_TEMPLATE_PROPERTY, componentBody);
        if (!component.props.isEmpty()) {
            properties.setProperty(HAS_PROPS_TEMPLATE_PROPERTY, "true");
        }
        if (!StringUtil.isEmpty((String)propTypesText)) {
            properties.setProperty(PROP_TYPES_TEMPLATE_PROPERTY, propTypesText);
        }
        if ((createdDeclaration = ReactExtractComponentHandlerBase.expandTemplate(anchorBefore, properties, templateName = ReactExtractComponentHandlerBase.getCodeTemplateName(component.componentType, isTypedDialect), JSNamedElement.class)) == null) {
            String message = ReactBundle.message("refactoring.react.could.not.find.in.template", component.name, templateName);
            this.error(project, editor, message);
            return null;
        }
        if (component.componentType == ComponentType.Class) {
            ReactExtractComponentHandlerBase.addRequiredImportsForClassComponent((JSClass)createdDeclaration, anchorBefore);
        }
        PsiFile createdFile = createdDeclaration.getContainingFile();
        return (PsiElement)JSChangeUtil.doAddRangeBefore((PsiElement)anchorBefore.getParent(), (PsiElement)createdFile.getFirstChild(), (PsiElement)createdFile.getLastChild(), (PsiElement)anchorBefore).first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reformatResult(Editor editor, PsiElement anchorBefore, PsiElement addedComponent) {
        if (!anchorBefore.isValid() || !addedComponent.isValid()) {
            return;
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)anchorBefore);
        boolean forceSemicolon = codeStyleSettings.FORCE_SEMICOLON_STYLE;
        boolean forceQuotes = codeStyleSettings.FORCE_QUOTE_STYlE;
        try {
            codeStyleSettings.FORCE_SEMICOLON_STYLE = true;
            codeStyleSettings.FORCE_QUOTE_STYlE = true;
            FormatFixer.create((PsiFile)addedComponent.getContainingFile(), (TextRange)new TextRange(addedComponent.getTextRange().getStartOffset(), anchorBefore.getTextRange().getStartOffset()), (Document)editor.getDocument(), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
        finally {
            codeStyleSettings.FORCE_SEMICOLON_STYLE = forceSemicolon;
            codeStyleSettings.FORCE_QUOTE_STYlE = forceQuotes;
        }
    }

    @Nullable
    public static <T extends JSNamedElement> T expandTemplate(@NotNull PsiElement context, @NotNull Properties properties, @NotNull String templateName, final @NotNull Class<T> resultClass) {
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(24);
        }
        if (properties == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(25);
        }
        if (templateName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(26);
        }
        if (resultClass == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(27);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context.getProject());
        final String componentName = properties.getProperty(NAME_TEMPLATE_PROPERTY);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(templateName);
        String text = TypeScriptImplementMemberUtil.getBodyTextFromTemplate((FileTemplate)fileTemplate, (Properties)properties).trim();
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)context);
        JSElement expandedTemplateContent = JSChangeUtil.createJSContentFromText((Project)context.getProject(), (String)text, (JSLanguageDialect)dialect);
        final Ref result = new Ref();
        expandedTemplateContent.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (resultClass.isInstance(element)) {
                    if (StringUtil.isEmpty((String)componentName) || StringUtil.equals((CharSequence)((JSNamedElement)element).getName(), (CharSequence)componentName)) {
                        result.set((Object)((JSNamedElement)element));
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase$2", "visitElement"));
            }
        });
        return (T)((JSNamedElement)result.get());
    }

    @Nullable
    public static String buildJSPropTypesText(@NotNull Collection<? extends Prop> props, @NotNull PsiElement context) {
        if (props == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(28);
        }
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(29);
        }
        if (props.isEmpty()) {
            return null;
        }
        String importedName = ReactExtractComponentHandlerBase.importModuleAsNamespace(context, "prop-types", PROP_TYPES_NAMESPACE);
        if (importedName == null) {
            return "";
        }
        return "{" + props.stream().filter(prop -> prop.type != null).map(prop -> {
            String propType = ReactPropTypesUtil.toPropType(importedName, prop.type, context);
            return String.format("%s: %s", prop.name, propType);
        }).collect(Collectors.joining(",\n")) + "}";
    }

    @Nullable
    public static String buildTypedPropTypesText(@NotNull Collection<? extends Prop> props, boolean allowEmpty) {
        if (props == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(30);
        }
        if (allowEmpty && props.isEmpty()) {
            return null;
        }
        return "{" + props.stream().filter(prop -> prop.type != null).map(prop -> {
            String propTypeText = prop.type.getTypeText(JSType.TypeTextFormat.CODE);
            return String.format("%s: %s", prop.name, propTypeText);
        }).collect(Collectors.joining(",")) + "}";
    }

    public static void addRequiredImportsForClassComponent(@NotNull JSClass jsClass, @NotNull PsiElement context) {
        JSReferenceList extendsList;
        JSExpression[] extendsExpressions;
        if (jsClass == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(31);
        }
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(32);
        }
        for (JSExpression expression : extendsExpressions = (extendsList = jsClass.getExtendsList()) != null ? extendsList.getExpressions() : JSExpression.EMPTY_ARRAY) {
            JSReferenceExpression replacement;
            String imported;
            String extendsExpressionText = expression.getText();
            if (!ReactUtil.REACT_COMPONENT_NAMES.contains(extendsExpressionText) || StringUtil.equals((CharSequence)extendsExpressionText, (CharSequence)(imported = ReactExtractComponentHandlerBase.importNamedElementIfNeeded(extendsExpressionText, context, "react"))) || (replacement = (JSReferenceExpression)JSChangeUtil.createExpressionPsiWithContext((String)imported, (PsiElement)expression, JSReferenceExpression.class)) == null) continue;
            expression.replace((JSExpression)replacement);
        }
    }

    @NotNull
    protected static String importNamedElementIfNeeded(@NotNull String elementName, @NotNull PsiElement context, @NotNull String targetModuleName) {
        PsiElement module;
        if (elementName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(33);
        }
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(34);
        }
        if (targetModuleName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(35);
        }
        if ((module = (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule((PsiElement)context), (Object)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class}))) == null) {
            String string = elementName;
            if (string == null) {
                ReactExtractComponentHandlerBase.$$$reportNull$$$0(36);
            }
            return string;
        }
        for (ES6ImportDeclaration declaration : ReactExtractComponentHandlerBase.getImportDeclarationsByModuleName(module, targetModuleName)) {
            for (ES6ImportSpecifier specifier : declaration.getImportSpecifiers()) {
                if (!StringUtil.equals((CharSequence)specifier.getReferenceName(), (CharSequence)elementName)) continue;
                String string = elementName;
                if (string == null) {
                    ReactExtractComponentHandlerBase.$$$reportNull$$$0(37);
                }
                return string;
            }
            int n = 0;
            ES6ImportSpecifier[] eS6ImportSpecifierArray = declaration.getImportedBindings();
            int n2 = eS6ImportSpecifierArray.length;
            if (n >= n2) continue;
            ES6ImportSpecifier binding = eS6ImportSpecifierArray[n];
            String string = binding.getName() + "." + elementName;
            if (string == null) {
                ReactExtractComponentHandlerBase.$$$reportNull$$$0(38);
            }
            return string;
        }
        Collection targetModules = JSFileReferencesUtil.resolveModuleReference((PsiElement)context.getContainingFile(), (String)targetModuleName);
        if (targetModules.isEmpty()) {
            String string = elementName;
            if (string == null) {
                ReactExtractComponentHandlerBase.$$$reportNull$$$0(39);
            }
            return string;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(elementName, null, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
        ES6ImportPsiUtil.insertJSImport((PsiElement)context, (JSImportedElementDescriptor)info, (PsiElement)((PsiElement)targetModules.iterator().next()));
        String string = elementName;
        if (string == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Nullable
    private static String importModuleAsNamespace(@NotNull PsiElement context, @NotNull String moduleName, @NotNull String defaultName) {
        PsiElement module;
        if (context == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(41);
        }
        if (moduleName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(42);
        }
        if (defaultName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(43);
        }
        if ((module = (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule((PsiElement)context), (Object)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class}))) == null) {
            return null;
        }
        for (ES6ImportDeclaration element : ReactExtractComponentHandlerBase.getImportDeclarationsByModuleName(module, moduleName)) {
            if (element.getImportedBindings().length <= 0) continue;
            return element.getImportedBindings()[0].getDeclaredName();
        }
        Collection targetModules = JSFileReferencesUtil.resolveModuleReference((PsiElement)context.getContainingFile(), (String)moduleName);
        if (targetModules.isEmpty()) {
            return null;
        }
        ES6ImportPsiUtil.CreateImportExportInfo importExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(defaultName, null, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        ES6ImportPsiUtil.insertJSImport((PsiElement)context, (JSImportedElementDescriptor)importExportInfo, (PsiElement)((PsiElement)targetModules.iterator().next()));
        return defaultName;
    }

    @NotNull
    public static String getCodeTemplateName(ComponentType type, boolean useTypescript) {
        if (type == ComponentType.Class && useTypescript) {
            return "Typed React Class Component.tsx";
        }
        if (type == ComponentType.Function && useTypescript) {
            return "Typed React Function Component.tsx";
        }
        return type == ComponentType.Class ? "React Class Component.jsx" : "React Function Component.jsx";
    }

    @NotNull
    protected static List<ES6ImportDeclaration> getImportDeclarationsByModuleName(@Nullable PsiElement context, @NotNull String moduleName) {
        PsiElement[] declarations;
        if (moduleName == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(44);
        }
        ArrayList<ES6ImportDeclaration> results = new ArrayList<ES6ImportDeclaration>();
        for (PsiElement element : declarations = JSResolveUtil.getStubbedChildren((PsiElement)context, (TokenSet)ES6ImportPsiUtil.ES6_IMPORT_DECLARATION)) {
            if (!(element instanceof ES6ImportDeclaration) || !moduleName.equals(ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)((ES6ImportExportDeclaration)element)))) continue;
            results.add((ES6ImportDeclaration)element);
        }
        ArrayList<ES6ImportDeclaration> arrayList = results;
        if (arrayList == null) {
            ReactExtractComponentHandlerBase.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    protected void error(Project project, Editor editor, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringTitle(), (String)HELP_ID);
    }

    public static ComponentType getLastComponentType() {
        String strValue = PropertiesComponent.getInstance().getValue(COMPONENT_TYPE_PROPERTY_KEY);
        if (strValue == null) {
            return ComponentType.Class;
        }
        return (ComponentType)StringUtil.parseEnum((String)strValue, (Enum)ComponentType.Class, ComponentType.class);
    }

    public static void setLastComponentType(ComponentType componentType) {
        PropertiesComponent.getInstance().setValue(COMPONENT_TYPE_PROPERTY_KEY, componentType.toString());
    }

    @NlsContexts.DialogTitle
    protected abstract String getRefactoringTitle();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 19, 36, 37, 38, 39, 40, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 9: 
            case 19: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResolveResults";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 18: 
            case 24: 
            case 29: 
            case 32: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentBody";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultClass";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleName";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOccurrences";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsableExpressionType";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "importNamedElementIfNeeded";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDeclarationsByModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNameValidator";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceOccurrences";
                break;
            }
            case 9: 
            case 19: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isContextDependant";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyDefined";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isStaticClassAccess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isThisMemberAccess";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "propFromExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUsableExpressionType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addDeclarations";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildJSPropTypesText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildTypedPropTypesText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredImportsForClassComponent";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "importNamedElementIfNeeded";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "importModuleAsNamespace";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getImportDeclarationsByModuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 19, 36, 37, 38, 39, 40, 45 -> new IllegalStateException(string);
        };
    }

    public static enum ComponentType {
        Class(ReactBundle.message("react.class.component.type.class", new Object[0])),
        Function(ReactBundle.message("react.class.component.type.function", new Object[0]));

        @NlsSafe
        private final String description;

        private ComponentType(String description) {
            this.description = description;
        }

        @NlsContexts.RadioButton
        @NotNull
        String getDescription() {
            String string = this.description;
            if (string == null) {
                ComponentType.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase$ComponentType", "getDescription"));
        }
    }

    protected static class ComponentToExtract {
        final String name;
        @NotNull
        final Collection<Prop> props;
        final ComponentType componentType;

        ComponentToExtract(@NotNull String name, @NotNull Collection<Prop> props, @NotNull ComponentType componentType) {
            if (name == null) {
                ComponentToExtract.$$$reportNull$$$0(0);
            }
            if (props == null) {
                ComponentToExtract.$$$reportNull$$$0(1);
            }
            if (componentType == null) {
                ComponentToExtract.$$$reportNull$$$0(2);
            }
            this.name = name;
            this.props = props;
            this.componentType = componentType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "props";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase$ComponentToExtract";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Prop {
        @NotNull
        public final String name;
        @Nullable
        public final String value;
        @Nullable
        public final JSType type;

        public Prop(@NotNull String name, @Nullable JSType type, @Nullable String value) {
            if (name == null) {
                Prop.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/react/refactoring/extractComponent/ReactExtractComponentHandlerBase$Prop", "<init>"));
        }
    }
}

