/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.xml.converters.JavaeeResolvingConverter;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModuleContextProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EjbResolveConverter
extends JavaeeResolvingConverter<EnterpriseBean> {
    private final boolean myAllowEntityBeans;
    private final boolean myAllowSessionBeans;
    private final boolean myAllowMessageDrivenBeans;

    public EjbResolveConverter() {
        this(true, true, true);
    }

    protected EjbResolveConverter(boolean allowEntityBeans, boolean allowMessageDrivenBeans, boolean allowSessionBeans) {
        this.myAllowEntityBeans = allowEntityBeans;
        this.myAllowMessageDrivenBeans = allowMessageDrivenBeans;
        this.myAllowSessionBeans = allowSessionBeans;
    }

    public EnterpriseBean fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            EjbResolveConverter.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        EnterpriseBean[] result = new EnterpriseBean[]{null};
        this.processBeans(context, (Processor<EnterpriseBean>)((Processor)enterpriseBean -> {
            if (Objects.equals(s, enterpriseBean.getEjbName().getValue())) {
                result[0] = enterpriseBean;
                return false;
            }
            return true;
        }));
        return result[0];
    }

    private static Module[] getContextModules(ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        if (domElement.getManager().isMockElement(domElement)) {
            return new Module[]{domElement.getModule()};
        }
        return ModuleContextProvider.getModules((PsiFile)context.getFile());
    }

    private void processBeans(ConvertContext context, Processor<EnterpriseBean> processor) {
        for (Module contextModule : EjbResolveConverter.getContextModules(context)) {
            List<EnterpriseBean> list = EjbCommonModelUtil.getAllEjbs(context.getProject(), contextModule, null);
            for (EnterpriseBean bean : list) {
                if (this.myAllowEntityBeans && bean instanceof EntityBean && !processor.process((Object)bean)) {
                    return;
                }
                if (this.myAllowSessionBeans && bean instanceof SessionBean && !processor.process((Object)bean)) {
                    return;
                }
                if (!this.myAllowMessageDrivenBeans || !(bean instanceof MessageDrivenBean) || processor.process((Object)bean)) continue;
                return;
            }
        }
    }

    public String getErrorMessage(String s, @NotNull ConvertContext context) {
        if (context == null) {
            EjbResolveConverter.$$$reportNull$$$0(1);
        }
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{"EJB", s});
    }

    @NotNull
    public Collection<? extends EnterpriseBean> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            EjbResolveConverter.$$$reportNull$$$0(2);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processBeans(context, (Processor<EnterpriseBean>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            EjbResolveConverter.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/xml/converters/EjbResolveConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/xml/converters/EjbResolveConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

