/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/actions/CopyQueryToConsoleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.database.impl"})
public final class CopyQueryToConsoleAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(DataGridUtil.getQueryText((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null);
        Presentation presentation = e.getPresentation();
        String string = DatabaseBundle.message((String)"action.Console.TableResult.CopyQueryToConsole.text.legacy", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"action.Console.TableResult.CopyQueryToConsole.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        presentation.setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(string, string2));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        DatabaseGridDataHookUp databaseGridDataHookUp = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid));
        if (databaseGridDataHookUp == null) {
            return;
        }
        DatabaseGridDataHookUp databaseHookUp = databaseGridDataHookUp;
        String string = DataGridUtil.getQueryText((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY));
        if (string == null) {
            return;
        }
        String query = string;
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        DbElement target = DbImplUtilCore.findElement((DbDataSource)databaseHookUp.getDataSource(), (DasObject)((DasObject)table));
        if (target != null) {
            v3 = DbActionUtils.findOrCreateEditor(target, true);
        } else {
            JdbcConsole jdbcConsole = DataGridUtil.findGridRelatedConsole(grid.getProject(), grid);
            if (jdbcConsole == null || (jdbcConsole = jdbcConsole.getVirtualFile()) == null) {
                return;
            }
            JdbcConsole consoleFile = jdbcConsole;
            FileEditor fileEditor = FileEditorManager.getInstance((Project)grid.getProject()).getSelectedEditor((VirtualFile)consoleFile);
            TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            v3 = editor2 = textEditor != null ? textEditor.getEditor() : null;
        }
        if (editor2 == null) {
            return;
        }
        DbActionUtils.moveCaretToEnd(editor2);
        WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), null, null, () -> CopyQueryToConsoleAction.actionPerformed$lambda$0(editor2, query), (PsiFile[])new PsiFile[0]);
    }

    private static final void actionPerformed$lambda$0(Editor $editor, String $query) {
        $editor.getDocument().insertString($editor.getDocument().getTextLength(), (CharSequence)$query);
    }
}

