/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.ConsolesMigrationManagerKt;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.console.queryFiles.QueryFilesOpener;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.scratch.ScratchFileTypeIcon;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenConsoleAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean relatedToDS;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        DataContext dc = e.getDataContext();
        if (DatabaseContextFun.fromDatabaseTree(dc)) {
            relatedToDS = DatabaseContextFun.getSelectionRelatedDataSources(dc).stream().anyMatch(dsn -> dsn.dataSource instanceof LocalDataSource);
        } else {
            Project project = e.getProject();
            if (project == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            JBIterable<DbElement> elements = OpenConsoleAction.getElements(dc, project);
            relatedToDS = elements.filterMap(o -> DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)o.getDataSource())).isNotEmpty();
        }
        e.getPresentation().setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.Any.text.legacy", (Object[])new Object[0]), DatabaseBundle.message((String)"action.Jdbc.OpenConsole.Any.text", (Object[])new Object[0])));
        boolean visible = relatedToDS || e.isFromActionToolbar();
        presentation.setVisible(visible);
        presentation.setEnabled(relatedToDS);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JBIterable<DbElement> elements = OpenConsoleAction.getElements(e.getDataContext(), project);
        List namespaces = elements.filterMap(o -> (DbElement)JBIterable.generate((Object)o, p -> p.getParent()).filter(p -> p instanceof DasNamespace || p instanceof DasDataSource).first()).unique().filter(o -> DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)o.getDataSource()) != null).toList();
        this.actionPerformedInner(e, namespaces);
    }

    protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(3);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = OpenConsoleAction.getRunners(project, namespaces);
        String message = ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.consoles", (Object[])new Object[0]), DatabaseBundle.message((String)"action.Jdbc.OpenConsole.files", (Object[])new Object[0]));
        RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(message, runners, (Editor)e.getData(CommonDataKeys.EDITOR), e);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull Project project, @NotNull List<DbElement> namespaces) {
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(5);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(6);
        }
        JBIterable namespacesIt = JBIterable.from(namespaces);
        DbElement single = (DbElement)namespacesIt.single();
        Set allowedIds = namespacesIt.map(o -> o.getDataSource().getUniqueId()).toSet();
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        PairConsumer consumer = (element, file) -> {
            if (file == null) {
                if (ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled() && QueryFilesOpener.getRootPath(project) == null) {
                    Messages.showErrorDialog((String)DatabaseBundle.message((String)"dialog.text.cannot.resolve.default.directory", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.cannot.resolve.default.directory", (Object[])new Object[0]));
                }
                return;
            }
            DataSourcePerFileMappingsImpl.setDataSourcePerFileMapping(project, file, DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)element.getDataSource()));
            DasNamespace namespace = (DasNamespace)ObjectUtils.tryCast((Object)element, DasNamespace.class);
            DatabaseEditorHelper.openConsoleForFile(project, (DasDataSource)element.getDataSource(), namespace, file);
        };
        for (JdbcConsole console : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (!allowedIds.contains(console.getDataSource().getUniqueId())) continue;
            result2.add(DatabaseRunners.createConsoleRunner(console, () -> consumer.consume((Object)single, (Object)console.getVirtualFile())));
        }
        if (single != null) {
            result2.addAll(DatabaseRunners.createDataSourceConsolesRunner(single.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer.consume((Object)single, file))).getSubRunners());
        } else {
            namespacesIt.unique(o -> o.getDataSource()).map(o -> DatabaseRunners.createDataSourceConsolesRunner(o.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer.consume(o, file)))).addAllTo(result2);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            OpenConsoleAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static JBIterable<DbElement> getElements(@NotNull DataContext dc, @NotNull Project project) {
        JBIterable<DbElement> fromTree;
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(9);
        }
        JBIterable<DbElement> jBIterable = fromTree = DatabaseContextFun.fromDatabaseTree(dc) ? OpenConsoleAction.getSelectedElementsFromTree(dc, project) : OpenConsoleAction.getSelectedElements2(dc, project);
        if (fromTree.isNotEmpty()) {
            JBIterable<DbElement> jBIterable2 = fromTree;
            if (jBIterable2 == null) {
                OpenConsoleAction.$$$reportNull$$$0(10);
            }
            return jBIterable2;
        }
        DbElement fileElement = OpenConsoleAction.getElementForFile(dc);
        JBIterable jBIterable3 = fileElement != null ? JBIterable.of((Object)fileElement) : JBIterable.empty();
        if (jBIterable3 == null) {
            OpenConsoleAction.$$$reportNull$$$0(11);
        }
        return jBIterable3;
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElementsFromTree(@NotNull DataContext dc, @NotNull Project project) {
        JBIterable<DbElement> selectedDbElements;
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(13);
        }
        if ((selectedDbElements = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dc)).isNotEmpty()) {
            JBIterable<DbElement> jBIterable = selectedDbElements;
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        selectedDbElements = OpenConsoleAction.getSelectedElements2(dc, project);
        if (selectedDbElements.isNotEmpty()) {
            JBIterable<DbElement> jBIterable = selectedDbElements;
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        DbElement selectedDbElementForFile = OpenConsoleAction.getElementForFile(dc);
        if (selectedDbElementForFile != null) {
            JBIterable jBIterable = JBIterable.of((Object)selectedDbElementForFile);
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            OpenConsoleAction.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements2(@NotNull DataContext dc, @NotNull Project project) {
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(18);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(19);
        }
        JBIterable byPsi = JBIterable.of((Object[])((PsiElement[])dc.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY))).filterMap(psi -> {
            if (psi instanceof DbElement) {
                return (DbElement)psi;
            }
            return null;
        });
        JBIterable byFile = JBIterable.of((Object[])((VirtualFile[])dc.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filterMap(file -> {
            if (file instanceof DatabaseElementVirtualFileImpl) {
                return ((DatabaseElementVirtualFileImpl)file).findElement(project);
            }
            if (DbVFSUtils.isConsoleFile((VirtualFile)file)) {
                return DbVFSUtils.getDataSource((Project)project, (VirtualFile)file);
            }
            return null;
        });
        JBIterable jBIterable = byPsi.append((Iterable)byFile);
        if (jBIterable == null) {
            OpenConsoleAction.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    private static DbElement getElementForFile(DataContext dc) {
        DbDataSource dataSource;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dc);
        if (file == null || project == null) {
            return null;
        }
        JdbcConsole console = JdbcConsoleProvider.getConsole(project, file);
        LocalDataSource lds = console == null ? DataSourcePerFileMappingsImpl.getDataSourcePerFileMapping(project, file) : console.getDataSource();
        DbDataSource dbDataSource = dataSource = lds == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(lds.getUniqueId());
        if (dataSource == null) {
            return null;
        }
        SearchPath path = ChooseSchemaAction.getSelectedSearchPath(project, file, lds);
        if (path == null) {
            return dataSource;
        }
        DbElement current = dataSource.findElement(path.getCurrent());
        return current == null ? dataSource : current;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 12, 13, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElementsFromTree";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements2";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedInner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElementsFromTree";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements2";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 12, 13, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    public static class CreateScratch
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            if (e == null) {
                CreateScratch.$$$reportNull$$$0(0);
            }
            if (namespaces == null) {
                CreateScratch.$$$reportNull$$$0(1);
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openNewScratchFile(namespace);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateScratch.$$$reportNull$$$0(2);
            }
            if (!ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            super.update(e);
            e.getPresentation().setText(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.Scratch.text", (Object[])new Object[0]));
            e.getPresentation().setIcon((Icon)new ScratchFileTypeIcon(DatabaseIcons.SqlScript));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaces";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction$CreateScratch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformedInner";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CreateNewInPath
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            Project project;
            if (e == null) {
                CreateNewInPath.$$$reportNull$$$0(0);
            }
            if (namespaces == null) {
                CreateNewInPath.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.singleDir();
            VirtualFile chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, null);
            if (chosen == null) {
                return;
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openNewFileInDirectory(namespace, chosen);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateNewInPath.$$$reportNull$$$0(2);
            }
            if (!ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            super.update(e);
            e.getPresentation().setText(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.New.InPath.text", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaces";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction$CreateNewInPath";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformedInner";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CreateNew
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            if (e == null) {
                CreateNew.$$$reportNull$$$0(0);
            }
            if (namespaces == null) {
                CreateNew.$$$reportNull$$$0(1);
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openConsoleFile(namespace, true);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateNew.$$$reportNull$$$0(2);
            }
            super.update(e);
            String actionId = ActionManager.getInstance().getId((AnAction)this);
            if (actionId != null && actionId.equals("Jdbc.OpenConsole.New.Generate")) {
                e.getPresentation().setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.New.Generate.text.legacy", (Object[])new Object[0]), DatabaseBundle.message((String)"action.Jdbc.OpenConsole.New.Generate.text", (Object[])new Object[0])));
            } else {
                e.getPresentation().setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.New.text.legacy", (Object[])new Object[0]), DatabaseBundle.message((String)"action.Jdbc.OpenConsole.New.text", (Object[])new Object[0])));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaces";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction$CreateNew";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformedInner";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

