/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class V8CpuOverviewChart
extends ChartPanel {
    public static final JBColor BACK_COLOR = new JBColor((Color)Gray._220, (Color)Gray._120);
    public static final JBColor SELECTION_COLOR = new JBColor((Color)Gray._255, UIUtil.getLabelBackground());
    public static final Color FILL_COLOR = new JBColor(new Color(196, 213, 248), new Color(98, 108, 161));
    public static final Color LINE_COLOR = new JBColor(new Color(156, 173, 248), new Color(76, 87, 137));
    private final V8LogCachingReader myReader;
    private long myStartTs;
    private long myEndTs;
    private List<Pair<Long, Integer>> myOverview;
    protected long myLeftBound;
    protected long myRightBound;

    public V8CpuOverviewChart(int left, int rightMargin, int top, int height, V8LogCachingReader reader, long realLeft, long realRight) throws IOException {
        super(left, rightMargin, top, height, realLeft > 0L ? realLeft : 0L, realRight > 0L ? Math.min(realRight, reader.getLastTick()) : reader.getLastTick());
        this.myTop = this.myGridTop = this.myGridFontHeight;
        this.myReader = reader;
        this.myOverview = Collections.emptyList();
        this.setInterval(this.myRealLeft, this.myRealRight);
        this.myLeftBound = this.myRealLeft;
        this.myRightBound = this.myRealRight;
        MouseAdapter mouseAdapter = this.createMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.selectionUpdated();
    }

    public void setSelection(long from, long to) {
        this.myLeftBound = Math.max(this.myRealLeft, from);
        this.myRightBound = Math.min(this.myRealRight, to);
        this.selectionUpdated();
        this.repaint();
    }

    @NotNull
    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){
            private long myDragStartValue;
            private long myDragStartLeft;
            private long myDragStartRight;
            private boolean myInsideSelection;
            private boolean myAboveRightBound;
            private boolean myAboveLeftBound;

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                if (this.myAboveLeftBound) {
                    if (x > V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myRightBound) - 10) {
                        return;
                    }
                    long was = V8CpuOverviewChart.this.myLeftBound;
                    V8CpuOverviewChart.this.myLeftBound = V8CpuOverviewChart.this.realFromPixels(Math.max(V8CpuOverviewChart.this.myLeft, x));
                    if (was != V8CpuOverviewChart.this.myLeftBound) {
                        V8CpuOverviewChart.this.selectionUpdated();
                    }
                    V8CpuOverviewChart.this.repaint();
                } else if (this.myAboveRightBound) {
                    if (x < V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myLeftBound) + 10) {
                        return;
                    }
                    long was = V8CpuOverviewChart.this.myRightBound;
                    V8CpuOverviewChart.this.myRightBound = V8CpuOverviewChart.this.realFromPixels(Math.min(x, V8CpuOverviewChart.this.getWidth() - V8CpuOverviewChart.this.myRightMargin));
                    if (was != V8CpuOverviewChart.this.myRightBound) {
                        V8CpuOverviewChart.this.selectionUpdated();
                    }
                    V8CpuOverviewChart.this.repaint();
                } else if (this.myInsideSelection && this.myDragStartValue > 0L) {
                    long delta = V8CpuOverviewChart.this.realFromPixels(x) - this.myDragStartValue;
                    long wasLeft = this.myDragStartLeft;
                    long wasRight = this.myDragStartRight;
                    V8CpuOverviewChart.this.myLeftBound = Math.max(V8CpuOverviewChart.this.myRealLeft, this.myDragStartLeft + delta);
                    V8CpuOverviewChart.this.myRightBound = Math.min(V8CpuOverviewChart.this.myRealRight, this.myDragStartRight + delta);
                    if (wasLeft != V8CpuOverviewChart.this.myLeftBound && wasRight != V8CpuOverviewChart.this.myRightBound) {
                        V8CpuOverviewChart.this.selectionUpdated();
                    }
                    V8CpuOverviewChart.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.myInsideSelection) {
                    V8CpuOverviewChart.this.setCursor(new Cursor(13));
                    this.myDragStartValue = V8CpuOverviewChart.this.realFromPixels(e.getX());
                    this.myDragStartLeft = V8CpuOverviewChart.this.myLeftBound;
                    this.myDragStartRight = V8CpuOverviewChart.this.myRightBound;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                this.myInsideSelection = false;
                int leftPixels = V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myLeftBound);
                int rightPixels = V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myRightBound);
                this.myAboveLeftBound = V8CpuOverviewChart.this.aroundBound(x, leftPixels);
                this.myAboveRightBound = V8CpuOverviewChart.this.aroundBound(x, rightPixels);
                if (this.myAboveLeftBound || this.myAboveRightBound) {
                    V8CpuOverviewChart.this.setCursor(new Cursor(10));
                    this.myDragStartValue = -1L;
                } else {
                    boolean bl = this.myInsideSelection = x > leftPixels && x < rightPixels;
                    if (this.myInsideSelection) {
                        V8CpuOverviewChart.this.setCursor(new Cursor(12));
                    } else {
                        V8CpuOverviewChart.this.setCursor(Cursor.getDefaultCursor());
                        this.myDragStartValue = -1L;
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (V8CpuOverviewChart.this.myLeftBound == V8CpuOverviewChart.this.myRealLeft && V8CpuOverviewChart.this.myRightBound == V8CpuOverviewChart.this.myRealRight) {
                    long tenPercent = (V8CpuOverviewChart.this.myRealRight - V8CpuOverviewChart.this.myRealLeft) / 10L;
                    long point = V8CpuOverviewChart.this.realFromPixels(e.getX());
                    V8CpuOverviewChart.this.setSelection(point - tenPercent / 2L, point + tenPercent / 2L);
                }
            }
        };
    }

    public void initialSelection() {
        long radius;
        long tenPercent = (this.myRealRight - this.myRealLeft) / 10L;
        long point = tenPercent * 5L;
        long l = radius = tenPercent / 1000L > TimeUnit.SECONDS.toMillis(2L) ? tenPercent / 20L : tenPercent / 2L;
        if (this.myOverview != null) {
            int step = this.myOverview.size() / 40;
            step = Math.max(1, step);
            int max = 0;
            int maxIdx = -1;
            Integer firstWhere80 = null;
            for (int i = step / 2; i < this.myOverview.size(); i += step) {
                Pair<Long, Integer> pair = this.myOverview.get(i);
                if (firstWhere80 == null && (double)((Integer)pair.getSecond()).intValue() > (double)this.myReader.getMaxStackSize() * 0.8) {
                    firstWhere80 = i;
                }
                if ((Integer)pair.getSecond() <= max) continue;
                maxIdx = i;
            }
            if (firstWhere80 != null) {
                point = (Long)this.myOverview.get(firstWhere80).getFirst();
            } else if (maxIdx >= 0) {
                point = (Long)this.myOverview.get(maxIdx).getFirst();
            }
        }
        this.setSelection(point - radius, point + radius);
    }

    public boolean isSelectionNarrow() {
        return this.myLeftBound > this.myRealLeft || this.myRightBound < this.myRealRight;
    }

    public long getLeftBound() {
        return this.myLeftBound;
    }

    public long getRightBound() {
        return this.myRightBound;
    }

    public void setInterval(long from, long to) throws IOException {
        this.myStartTs = from;
        this.myEndTs = to;
        this.myOverview = this.myReader.getStackOverview(this.myStartTs, this.myEndTs);
        if (this.myStartTs < 0L) {
            this.myStartTs = 0L;
        }
        if (this.myEndTs < 0L) {
            this.myEndTs = this.myReader.getLastTick();
        }
    }

    public boolean showsOverview() {
        return this.myOverview != null;
    }

    @Override
    protected void drawChart(Graphics2D graphics, final int left, final int top, final int width, final int height, final int gridGap) {
        V8Utils.safeDraw(graphics, (Consumer<? super Graphics2D>)new Consumer<Graphics2D>(){
            int prevX;
            int prevY;
            int nextX;
            int nextY;

            public void consume(Graphics2D graphics) {
                int leftSelection = V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myLeftBound);
                int rightSelection = V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myRightBound);
                this.fillBackground(graphics, leftSelection, rightSelection);
                if (V8CpuOverviewChart.this.myOverview == null) {
                    String text = "Too many data points. Select interval and zoom.";
                    int textWidth = V8CpuOverviewChart.this.getFontMetrics(V8CpuOverviewChart.this.getFont()).stringWidth("Too many data points. Select interval and zoom.");
                    int position = (width - left - textWidth) / 2;
                    graphics.drawString("Too many data points. Select interval and zoom.", position, top + gridGap + (height - gridGap) / 2);
                    V8CpuOverviewChart.this.drawChartBound(graphics, top, left, height, width);
                    this.drawSelectionLines(graphics, leftSelection, rightSelection, width);
                    return;
                }
                graphics.setStroke(new BasicStroke(1.0f));
                double pointsPerStackStep = (double)(height - gridGap) / (double)V8CpuOverviewChart.this.myReader.getMaxStackSize();
                graphics.setColor(FILL_COLOR);
                this.iterateDots(pointsPerStackStep, top, height, () -> graphics.fillPolygon(new int[]{this.prevX, this.prevX, this.nextX, this.nextX}, new int[]{top + height, this.prevY, this.nextY, top + height}, 4));
                graphics.setColor(LINE_COLOR);
                this.iterateDots(pointsPerStackStep, top, height, () -> graphics.drawLine(this.prevX, this.prevY, this.nextX, this.nextY));
                V8CpuOverviewChart.this.drawChartBound(graphics, top, left, height, width);
                this.drawSelectionLines(graphics, leftSelection, rightSelection, width);
            }

            private void iterateDots(double pointsPerStackStep, int top2, int height2, Runnable drawer) {
                this.prevX = V8CpuOverviewChart.this.pixelsFromReal(V8CpuOverviewChart.this.myRealLeft);
                this.prevY = top2 + height2;
                for (Pair<Long, Integer> pair : V8CpuOverviewChart.this.myOverview) {
                    this.nextX = V8CpuOverviewChart.this.pixelsFromReal((Long)pair.getFirst());
                    this.nextY = (int)((long)top2 + Math.round((double)height2 - (double)((Integer)pair.getSecond()).intValue() * pointsPerStackStep));
                    drawer.run();
                    this.prevX = this.nextX;
                    this.prevY = this.nextY;
                }
            }

            private void drawSelectionLines(Graphics2D graphics, int leftSelection, int rightSelection, int width2) {
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.setColor(Color.gray);
                leftSelection = leftSelection == 0 ? 2 : leftSelection;
                rightSelection = rightSelection == width2 ? rightSelection - 2 : rightSelection;
                graphics.drawLine(leftSelection, 0, leftSelection, top + height);
                graphics.drawLine(rightSelection, 0, rightSelection, top + height);
            }

            private void fillBackground(Graphics2D graphics, int leftSelection, int rightSelection) {
                graphics.setColor((Color)BACK_COLOR);
                graphics.drawRect(left, 0, leftSelection - left, height + top);
                graphics.fillRect(left, 0, leftSelection - left, height + top);
                graphics.setColor((Color)SELECTION_COLOR);
                graphics.drawRect(leftSelection, 0, rightSelection - leftSelection, height + top);
                graphics.fillRect(leftSelection, 0, rightSelection - leftSelection, height + top);
                graphics.setColor((Color)BACK_COLOR);
                graphics.drawRect(rightSelection, 0, left + width - rightSelection, height + top);
                graphics.fillRect(rightSelection, 0, left + width - rightSelection, height + top);
            }
        });
    }

    private void drawChartBound(Graphics2D graphics, int top, int left, int height, int width) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, top, left, height);
        graphics.fillRect(left + width, top, this.getWidth() - (left + width), height);
    }

    protected abstract void selectionUpdated();
}

