MIT License

Copyright © 2003-2024 JabRef Authors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

--- Privacy Policy ----

# Privacy Policy

Last updated: 2023-08-24

Your privacy is a fundamental right JabRef e.V. respects and supports.
By using JabRef and its related online services, you choose to share
some of your personal information. In this Privacy Policy we explain how
we collect, use, and share information about you, along with the choices
you have.

The term \'Personal information\' in this policy means any information
that either directly identifies you or can be somehow linked to you.
\'JabRef\' refers to the desktop application that is provided by JabRef
e.V.

Please remember that no method of transmission over the Internet, or
method of electronic storage is absolute secure. While we strive to use
commercially acceptable means to protect your Personal Data, we cannot
guarantee its absolute security. Also, whenever you communicate through
the internet, your IP-Address will always be transmitted and retained by
third parties for technical and in some cases for legal reasons.

## JabRef Desktop Application

### Collecting information

JabRef does not collect any personal information directly linked to you.
However, on certain occasions JabRef will send some information to the
online services of JabRef e.V.:

- On application start, JabRef will check for the latest version
    online (by default *enabled*).
- Information about a journal you are citing when looking for more
    information about this journal, using our journal database (by
    default *enabled*).
- A pdf document you automatically want to extract citation
    information from, using our GROBID service (by default *disabled*).
- Anonymized statistical data on the use of the graphical user
    interface for internal analysis purposes (by default *disabled*).

### Storing information

JabRef only stores the following personal information locally on your
computer:

- Your proxy username and password, if you decide to store them (by
    default *disabled*).
- Any personal API key you use to access third party online services
    (by default *disabled*).

### Sharing information

Certain operations you perform in JabRef may trigger requests to public
third-party services such as Zotero, Crossref or the Library of Congress
for metadata retrieval. These third parties may log additional
information besides your IP address and the search terms (e.g., DOI,
ISBN or the current URL) according to their privacy policies.

These third-party services are the following:

Service;Privacy Policy
[ACM](https://www.acm.org/);<https://www.acm.org/privacy-policy>
[ACS Publications](https://pubs.acs.org/);<https://www.acs.org/privacy.html>
[APS Advancing Physics](https://harvest.aps.org/);<https://www.aps.org/about/privacy.cfm#privacy>
[arXiv.org](https://arxiv.org/);<https://info.arxiv.org/help/policies/privacy_policy.html>
[Bibliotheksverbund Bayern](https://www.bib-bvb.de/);<https://www.bib-bvb.de/web/guest/datenschutzerklaerung-bvb-homepage>
[Biodiversity Heritage Library](https://www.biodiversitylibrary.org/);<https://www.si.edu/Privacy>
[Collection of Computer Science Bibliographies](https://en.wikipedia.org/wiki/Collection_of_Computer_Science_Bibliographies);**currently unavailable**, offline
[CrossRef](https://www.crossref.org/);<https://www.crossref.org/operations-and-sustainability/privacy/>
[dblp](https://dblp.uni-trier.de/);<https://dblp.uni-trier.de/db/about/privacy.html>
[Directory of Open Access Books](https://www.doabooks.org/);<https://www.doabooks.org/en/resources/accessibility>
[Digitala Vetenskapliga Arkivet](https://www.diva-portal.org/);<https://www.uu.se/en/about-uu/data-protection-policy/>
[DOI Foundation](https://www.doi.org/);<https://www.doi.org/privacy-policy/>
[Elsevier](https://www.elsevier.com/);<https://www.elsevier.com/legal/privacy-policy>
[Google Scholar](https://scholar.google.com/);<https://policies.google.com/privacy>
[Gemeinsamer Verbundkatalog](https://www.gbv.de/);<https://www.gbv.de/datenschutz>
[IACR](https://www.iacr.org/);<https://www.iacr.org/privacy.html>
[IEEEXplore](https://ieeexplore.ieee.org/Xplore/home.jsp);<https://www.ieee.org/security-privacy.html>
[INSPIRE](https://inspirehep.net/);<https://cern.service-now.com/service-portal?id=privacy_policy&se=INSPIRE-Online&notice=main>
[JSTOR](https://www.jstor.org/);<https://www.ithaka.org/privacypolicy/>
[Library of Congress](https://lccn.loc.gov/);<https://www.loc.gov/legal/>
[National Library of Medicine](https://www.ncbi.nlm.nih.gov/);<https://www.nlm.nih.gov/web_policies.html>
[MathSciNet](http://www.ams.org/mathscinet);<https://www.ams.org/about-us/privacy>
[mEDRA](https://www.medra.org/);<https://www.medra.org/stdoc/en/Servizio_DOI_Informativa_ENG.pdf>
[Mr. DLib](https://mr-dlib.org/) [1];<https://support.dataverse.harvard.edu/harvard-dataverse-privacy-policy>
[Openlibrary](https://openlibrary.org);<https://archive.org/about/terms.php>
[ResearchGate](https://www.researchgate.net/);<https://www.researchgate.net/privacy-policy>
[IETF Datatracker](https://datatracker.ietf.org/);<https://www.ietf.org/privacy-statement/>
[Semantic Scholar](https://www.semanticscholar.org/), powered by [Allen Institute for AI](https://allenai.org/);<https://allenai.org/privacy-policy>
[Springer Nature](https://dev.springernature.com/);<https://dev.springernature.com/privacy-policy/>
[The SAO/NASA Astrophysics Data System](https://ui.adsabs.harvard.edu/);<https://ui.adsabs.harvard.edu/help/privacy/>
[Unpaywall](https://unpaywall.org/);<https://unpaywall.org/legal/privacy>
[zbMATH Open](https://www.zbmath.org);<https://zbmath.org/privacy-policy/>

[1]: *Note: The Mr. DLib service is used for the related articles tab in the entry editor and collects also your language, your browser and operating system (by default*disabled*).*;

## JabRef Browser Extension

No personal data (like name, email address, billing address or credit
card) is collected by the Browser Extension itself. But be aware that
the browser Extension uses Zotero services, where [Zotero\'s Privacy
Policy](https://www.zotero.org/support/privacy) applies.

### Collecting information

When actively used, the extension has access to the current website and
its content to process citation information. In particular, the
following information is used:

- the url of the current website you are visiting,
- the content of the current website.

### Storing information

No data will be stored by the Browser Extension.

### Sharing information

The Browser Extension does not share any data except with the local
instance of the JabRef software application, which stores the citation
data as a new entry in its library.

## Links to other Websites

Our Service may contain links to other websites that are not operated by
us. If you click on a third party link, you will be directed to that
third party\'s site. We strongly advise you to review the Privacy Policy
of every site you visit.

We have no control over and assume no responsibility for the content,
privacy policies or practices of any third party sites or services.

## Changes to this Privacy Policy

This privacy policy may be changed eventually. We encourage you to check
this Privacy Policy periodically for any changes. Any material change
will be mentioned in the changelog of the desktop application and in our
[blog](https://blog.jabref.org/).

This privacy policy is in effect as of the day mentioned as \"last
updated\" above and will remain in effect except with respect to any
changes in its provisions in the future, which will be in effect
immediately after being posted on this page.

## Contact

If you get in touch with us, we may aks you to provide us with certain
personal information (e.g. name and email address) to stay in contact
with you. For any questions or concerns regarding the privacy policy,
please send us an email to <vorstand@jabref.org> or write to

JabRef e.V.\
Josef-Lanner-Str. 9\
71069 Sindelfingen\
Germany
