//===--- no_implicit_sugar_report_cxx11.cc - test input file for iwyu -----===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// IWYU_ARGS: -I . -std=c++11

#include "tests/cxx/no_implicit_sugar_report_cxx11-direct.h"

// Tests that IWYU doesn't suggest headers due to any type sugaring crawled into
// an implicitly generated code. C++11 is required for the test because, in this
// mode, clang places more 'TypeLoc's instead of 'QualType's into the implicit
// stuff.

void Fn() {
  auto i = GetInt();
  // GetInt() returns int written as TypedefHost::Int type alias. However, this
  // is irrelevant when not explicitly written. Hence, TypedefHost should be
  // reported neither for a lambda capture...
  [i] {}();
  // ... nor for an autogenerated lambda conversion function prototype.
  [] { return GetInt(); }();
}

/**** IWYU_SUMMARY

(tests/cxx/no_implicit_sugar_report_cxx11.cc has correct #includes/fwd-decls)

***** IWYU_SUMMARY */
