// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/actions_testing.proto

package sdk

import (
	context "context"
	reflect "reflect"
	sync "sync"

	conversation "google.golang.org/genproto/googleapis/actions/sdk/v2/conversation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the input source, typed query or voice query.
type UserInput_InputType int32

const (
	// Unspecified input source.
	UserInput_INPUT_TYPE_UNSPECIFIED UserInput_InputType = 0
	// Query from a GUI interaction.
	UserInput_TOUCH UserInput_InputType = 1
	// Voice query.
	UserInput_VOICE UserInput_InputType = 2
	// Typed query.
	UserInput_KEYBOARD UserInput_InputType = 3
	// The action was triggered by a URL link.
	UserInput_URL UserInput_InputType = 4
)

// Enum value maps for UserInput_InputType.
var (
	UserInput_InputType_name = map[int32]string{
		0: "INPUT_TYPE_UNSPECIFIED",
		1: "TOUCH",
		2: "VOICE",
		3: "KEYBOARD",
		4: "URL",
	}
	UserInput_InputType_value = map[string]int32{
		"INPUT_TYPE_UNSPECIFIED": 0,
		"TOUCH":                  1,
		"VOICE":                  2,
		"KEYBOARD":               3,
		"URL":                    4,
	}
)

func (x UserInput_InputType) Enum() *UserInput_InputType {
	p := new(UserInput_InputType)
	*p = x
	return p
}

func (x UserInput_InputType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserInput_InputType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_actions_testing_proto_enumTypes[0].Descriptor()
}

func (UserInput_InputType) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_actions_testing_proto_enumTypes[0]
}

func (x UserInput_InputType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserInput_InputType.Descriptor instead.
func (UserInput_InputType) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{1, 0}
}

// Possible surfaces used to interact with the Action.
// Additional values may be included in the future.
type DeviceProperties_Surface int32

const (
	// Default value. This value is unused.
	DeviceProperties_SURFACE_UNSPECIFIED DeviceProperties_Surface = 0
	// Speaker (e.g. Google Home).
	DeviceProperties_SPEAKER DeviceProperties_Surface = 1
	// Phone.
	DeviceProperties_PHONE DeviceProperties_Surface = 2
	// Allo Chat.
	DeviceProperties_ALLO DeviceProperties_Surface = 3
	// Smart Display Device.
	DeviceProperties_SMART_DISPLAY DeviceProperties_Surface = 4
	// KaiOS.
	DeviceProperties_KAI_OS DeviceProperties_Surface = 5
)

// Enum value maps for DeviceProperties_Surface.
var (
	DeviceProperties_Surface_name = map[int32]string{
		0: "SURFACE_UNSPECIFIED",
		1: "SPEAKER",
		2: "PHONE",
		3: "ALLO",
		4: "SMART_DISPLAY",
		5: "KAI_OS",
	}
	DeviceProperties_Surface_value = map[string]int32{
		"SURFACE_UNSPECIFIED": 0,
		"SPEAKER":             1,
		"PHONE":               2,
		"ALLO":                3,
		"SMART_DISPLAY":       4,
		"KAI_OS":              5,
	}
)

func (x DeviceProperties_Surface) Enum() *DeviceProperties_Surface {
	p := new(DeviceProperties_Surface)
	*p = x
	return p
}

func (x DeviceProperties_Surface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceProperties_Surface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_actions_testing_proto_enumTypes[1].Descriptor()
}

func (DeviceProperties_Surface) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_actions_testing_proto_enumTypes[1]
}

func (x DeviceProperties_Surface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceProperties_Surface.Descriptor instead.
func (DeviceProperties_Surface) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{2, 0}
}

// Request for playing a round of the conversation.
type SendInteractionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project being tested, indicated by the Project ID.
	// Format: projects/{project}
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Required. Input provided by the user.
	Input *UserInput `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// Required. Properties of the device used for interacting with the Action.
	DeviceProperties *DeviceProperties `protobuf:"bytes,3,opt,name=device_properties,json=deviceProperties,proto3" json:"device_properties,omitempty"`
	// Opaque token that must be passed as received from SendInteractionResponse
	// on the previous interaction. This can be left unset in order to start a new
	// conversation, either as the first interaction of a testing session or to
	// abandon a previous conversation and start a new one.
	ConversationToken string `protobuf:"bytes,4,opt,name=conversation_token,json=conversationToken,proto3" json:"conversation_token,omitempty"`
}

func (x *SendInteractionRequest) Reset() {
	*x = SendInteractionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendInteractionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendInteractionRequest) ProtoMessage() {}

func (x *SendInteractionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendInteractionRequest.ProtoReflect.Descriptor instead.
func (*SendInteractionRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{0}
}

func (x *SendInteractionRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SendInteractionRequest) GetInput() *UserInput {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *SendInteractionRequest) GetDeviceProperties() *DeviceProperties {
	if x != nil {
		return x.DeviceProperties
	}
	return nil
}

func (x *SendInteractionRequest) GetConversationToken() string {
	if x != nil {
		return x.ConversationToken
	}
	return ""
}

// User input provided on a conversation round.
type UserInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the input sent by the user.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Type of the input.
	Type UserInput_InputType `protobuf:"varint,2,opt,name=type,proto3,enum=google.actions.sdk.v2.UserInput_InputType" json:"type,omitempty"`
}

func (x *UserInput) Reset() {
	*x = UserInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInput) ProtoMessage() {}

func (x *UserInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInput.ProtoReflect.Descriptor instead.
func (*UserInput) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{1}
}

func (x *UserInput) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *UserInput) GetType() UserInput_InputType {
	if x != nil {
		return x.Type
	}
	return UserInput_INPUT_TYPE_UNSPECIFIED
}

// Properties of device relevant to a conversation round.
type DeviceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Surface used for interacting with the Action.
	Surface DeviceProperties_Surface `protobuf:"varint,1,opt,name=surface,proto3,enum=google.actions.sdk.v2.DeviceProperties_Surface" json:"surface,omitempty"`
	// Device location such as latitude, longitude, and formatted address.
	Location *Location `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Locale as set on the device.
	// The format should follow BCP 47: https://tools.ietf.org/html/bcp47
	// Examples: en, en-US, es-419 (more examples at
	// https://tools.ietf.org/html/bcp47#appendix-A).
	Locale string `protobuf:"bytes,3,opt,name=locale,proto3" json:"locale,omitempty"`
	// Time zone as set on the device.
	// The format should follow the IANA Time Zone Database, e.g.
	// "America/New_York": https://www.iana.org/time-zones
	TimeZone string `protobuf:"bytes,4,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *DeviceProperties) Reset() {
	*x = DeviceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceProperties) ProtoMessage() {}

func (x *DeviceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceProperties.ProtoReflect.Descriptor instead.
func (*DeviceProperties) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{2}
}

func (x *DeviceProperties) GetSurface() DeviceProperties_Surface {
	if x != nil {
		return x.Surface
	}
	return DeviceProperties_SURFACE_UNSPECIFIED
}

func (x *DeviceProperties) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *DeviceProperties) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

func (x *DeviceProperties) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

// Container that represents a location.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Geo coordinates.
	// Requires the [DEVICE_PRECISE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_PRECISE_LOCATION] permission.
	Coordinates *latlng.LatLng `protobuf:"bytes,1,opt,name=coordinates,proto3" json:"coordinates,omitempty"`
	// Display address, e.g., "1600 Amphitheatre Pkwy, Mountain View, CA 94043".
	// Requires the [DEVICE_PRECISE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_PRECISE_LOCATION] permission.
	FormattedAddress string `protobuf:"bytes,2,opt,name=formatted_address,json=formattedAddress,proto3" json:"formatted_address,omitempty"`
	// Zip code.
	// Requires the [DEVICE_PRECISE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_PRECISE_LOCATION] or
	// [DEVICE_COARSE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_COARSE_LOCATION] permission.
	ZipCode string `protobuf:"bytes,3,opt,name=zip_code,json=zipCode,proto3" json:"zip_code,omitempty"`
	// City.
	// Requires the [DEVICE_PRECISE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_PRECISE_LOCATION] or
	// [DEVICE_COARSE_LOCATION]
	// [google.actions.v2.Permission.DEVICE_COARSE_LOCATION] permission.
	City string `protobuf:"bytes,4,opt,name=city,proto3" json:"city,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{3}
}

func (x *Location) GetCoordinates() *latlng.LatLng {
	if x != nil {
		return x.Coordinates
	}
	return nil
}

func (x *Location) GetFormattedAddress() string {
	if x != nil {
		return x.FormattedAddress
	}
	return ""
}

func (x *Location) GetZipCode() string {
	if x != nil {
		return x.ZipCode
	}
	return ""
}

func (x *Location) GetCity() string {
	if x != nil {
		return x.City
	}
	return ""
}

// Response to a round of the conversation.
type SendInteractionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output provided to the user.
	Output *Output `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
	// Diagnostics information that explains how the request was handled.
	Diagnostics *Diagnostics `protobuf:"bytes,2,opt,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// Opaque token to be set on SendInteractionRequest on the next RPC call in
	// order to continue the same conversation.
	ConversationToken string `protobuf:"bytes,3,opt,name=conversation_token,json=conversationToken,proto3" json:"conversation_token,omitempty"`
}

func (x *SendInteractionResponse) Reset() {
	*x = SendInteractionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendInteractionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendInteractionResponse) ProtoMessage() {}

func (x *SendInteractionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendInteractionResponse.ProtoReflect.Descriptor instead.
func (*SendInteractionResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{4}
}

func (x *SendInteractionResponse) GetOutput() *Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *SendInteractionResponse) GetDiagnostics() *Diagnostics {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *SendInteractionResponse) GetConversationToken() string {
	if x != nil {
		return x.ConversationToken
	}
	return ""
}

// User-visible output to the conversation round.
type Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Spoken response sent to user as a plain string.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Speech content produced by the Action. This may include markup elements
	// such as SSML.
	Speech []string `protobuf:"bytes,2,rep,name=speech,proto3" json:"speech,omitempty"`
	// Interactive Canvas content.
	Canvas *conversation.Canvas `protobuf:"bytes,3,opt,name=canvas,proto3" json:"canvas,omitempty"`
	// State of the prompt at the end of the conversation round.
	// More information about the prompt:
	// https://developers.google.com/assistant/conversational/prompts
	ActionsBuilderPrompt *conversation.Prompt `protobuf:"bytes,4,opt,name=actions_builder_prompt,json=actionsBuilderPrompt,proto3" json:"actions_builder_prompt,omitempty"`
}

func (x *Output) Reset() {
	*x = Output{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Output) ProtoMessage() {}

func (x *Output) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Output.ProtoReflect.Descriptor instead.
func (*Output) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{5}
}

func (x *Output) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Output) GetSpeech() []string {
	if x != nil {
		return x.Speech
	}
	return nil
}

func (x *Output) GetCanvas() *conversation.Canvas {
	if x != nil {
		return x.Canvas
	}
	return nil
}

func (x *Output) GetActionsBuilderPrompt() *conversation.Prompt {
	if x != nil {
		return x.ActionsBuilderPrompt
	}
	return nil
}

// Diagnostics information related to the conversation round.
type Diagnostics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of events with details about processing of the conversation round
	// throughout the stages of the Actions Builder interaction model.
	// Populated for Actions Builder & Actions SDK apps only.
	ActionsBuilderEvents []*ExecutionEvent `protobuf:"bytes,1,rep,name=actions_builder_events,json=actionsBuilderEvents,proto3" json:"actions_builder_events,omitempty"`
}

func (x *Diagnostics) Reset() {
	*x = Diagnostics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Diagnostics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostics) ProtoMessage() {}

func (x *Diagnostics) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostics.ProtoReflect.Descriptor instead.
func (*Diagnostics) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{6}
}

func (x *Diagnostics) GetActionsBuilderEvents() []*ExecutionEvent {
	if x != nil {
		return x.ActionsBuilderEvents
	}
	return nil
}

// Request for finding matching intents.
type MatchIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project being tested, indicated by the Project ID.
	// Format: projects/{project}
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Required. User query as plain text.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Required. Locale to use to evaluate the query, such as "en".
	// The format should follow BCP 47: https://tools.ietf.org/html/bcp47
	// See the list of supported languages in
	// https://developers.google.com/assistant/console/languages-locales
	Locale string `protobuf:"bytes,3,opt,name=locale,proto3" json:"locale,omitempty"`
}

func (x *MatchIntentsRequest) Reset() {
	*x = MatchIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentsRequest) ProtoMessage() {}

func (x *MatchIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentsRequest.ProtoReflect.Descriptor instead.
func (*MatchIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{7}
}

func (x *MatchIntentsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *MatchIntentsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *MatchIntentsRequest) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

// Response for finding matching intents.
type MatchIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Intents matched, ordered from most to least relevant. Only the first
	// 50 matches are returned.
	MatchedIntents []*conversation.Intent `protobuf:"bytes,1,rep,name=matched_intents,json=matchedIntents,proto3" json:"matched_intents,omitempty"`
}

func (x *MatchIntentsResponse) Reset() {
	*x = MatchIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentsResponse) ProtoMessage() {}

func (x *MatchIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentsResponse.ProtoReflect.Descriptor instead.
func (*MatchIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{8}
}

func (x *MatchIntentsResponse) GetMatchedIntents() []*conversation.Intent {
	if x != nil {
		return x.MatchedIntents
	}
	return nil
}

// Request for setting Web & App Activity preferences.
type SetWebAndAppActivityControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the setting should be set to an enabled or disabled state.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *SetWebAndAppActivityControlRequest) Reset() {
	*x = SetWebAndAppActivityControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetWebAndAppActivityControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetWebAndAppActivityControlRequest) ProtoMessage() {}

func (x *SetWebAndAppActivityControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_actions_testing_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetWebAndAppActivityControlRequest.ProtoReflect.Descriptor instead.
func (*SetWebAndAppActivityControlRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP(), []int{9}
}

func (x *SetWebAndAppActivityControlRequest) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_google_actions_sdk_v2_actions_testing_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_actions_testing_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2f, 0x63, 0x61, 0x6e, 0x76, 0x61, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64,
	0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfe, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3b,
	0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x59, 0x0a, 0x11, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb7, 0x01, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x09, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x4f, 0x55, 0x43, 0x48, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4b, 0x45, 0x59, 0x42,
	0x4f, 0x41, 0x52, 0x44, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x52, 0x4c, 0x10, 0x04, 0x22,
	0xb4, 0x02, 0x0a, 0x10, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x53,
	0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x07, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12,
	0x3b, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x22, 0x63, 0x0a, 0x07, 0x53, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x13,
	0x53, 0x55, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x50, 0x45, 0x41, 0x4b, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x41, 0x4c, 0x4c, 0x4f, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4d, 0x41, 0x52, 0x54,
	0x5f, 0x44, 0x49, 0x53, 0x50, 0x4c, 0x41, 0x59, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x41,
	0x49, 0x5f, 0x4f, 0x53, 0x10, 0x05, 0x22, 0x9d, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0b, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0b, 0x63,
	0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x7a, 0x69, 0x70, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x7a, 0x69, 0x70, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x63, 0x69, 0x74, 0x79, 0x22, 0xc5, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x6e, 0x64, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x44, 0x0a, 0x0b, 0x64, 0x69, 0x61,
	0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12,
	0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xda,
	0x01, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x61, 0x6e, 0x76, 0x61, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6e, 0x76, 0x61,
	0x73, 0x52, 0x06, 0x63, 0x61, 0x6e, 0x76, 0x61, 0x73, 0x12, 0x60, 0x0a, 0x16, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x22, 0x6a, 0x0a, 0x0b, 0x44,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x5b, 0x0a, 0x16, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x6c, 0x0a, 0x13, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x19, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x65, 0x22, 0x6b, 0x0a, 0x14, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a,
	0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x3e, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x57, 0x65, 0x62, 0x41, 0x6e, 0x64, 0x41,
	0x70, 0x70, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x32, 0xaf, 0x04, 0x0a, 0x0e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0xa5, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x6e, 0x64, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d,
	0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x6e, 0x64, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0x12, 0xb0, 0x01,
	0x0a, 0x0c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22,
	0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x14, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65,
	0x12, 0xa6, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x57, 0x65, 0x62, 0x41, 0x6e, 0x64, 0x41, 0x70,
	0x70, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x57, 0x65, 0x62, 0x41,
	0x6e, 0x64, 0x41, 0x70, 0x70, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x22, 0x1f, 0x2f, 0x76, 0x32,
	0x3a, 0x73, 0x65, 0x74, 0x57, 0x65, 0x62, 0x41, 0x6e, 0x64, 0x41, 0x70, 0x70, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x19, 0xca, 0x41, 0x16, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x6c, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x42, 0x13, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x3b, 0x73,
	0x64, 0x6b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_actions_testing_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_actions_testing_proto_rawDescData = file_google_actions_sdk_v2_actions_testing_proto_rawDesc
)

func file_google_actions_sdk_v2_actions_testing_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_actions_testing_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_actions_testing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_actions_testing_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_actions_testing_proto_rawDescData
}

var file_google_actions_sdk_v2_actions_testing_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_actions_sdk_v2_actions_testing_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_actions_sdk_v2_actions_testing_proto_goTypes = []interface{}{
	(UserInput_InputType)(0),                   // 0: google.actions.sdk.v2.UserInput.InputType
	(DeviceProperties_Surface)(0),              // 1: google.actions.sdk.v2.DeviceProperties.Surface
	(*SendInteractionRequest)(nil),             // 2: google.actions.sdk.v2.SendInteractionRequest
	(*UserInput)(nil),                          // 3: google.actions.sdk.v2.UserInput
	(*DeviceProperties)(nil),                   // 4: google.actions.sdk.v2.DeviceProperties
	(*Location)(nil),                           // 5: google.actions.sdk.v2.Location
	(*SendInteractionResponse)(nil),            // 6: google.actions.sdk.v2.SendInteractionResponse
	(*Output)(nil),                             // 7: google.actions.sdk.v2.Output
	(*Diagnostics)(nil),                        // 8: google.actions.sdk.v2.Diagnostics
	(*MatchIntentsRequest)(nil),                // 9: google.actions.sdk.v2.MatchIntentsRequest
	(*MatchIntentsResponse)(nil),               // 10: google.actions.sdk.v2.MatchIntentsResponse
	(*SetWebAndAppActivityControlRequest)(nil), // 11: google.actions.sdk.v2.SetWebAndAppActivityControlRequest
	(*latlng.LatLng)(nil),                      // 12: google.type.LatLng
	(*conversation.Canvas)(nil),                // 13: google.actions.sdk.v2.conversation.Canvas
	(*conversation.Prompt)(nil),                // 14: google.actions.sdk.v2.conversation.Prompt
	(*ExecutionEvent)(nil),                     // 15: google.actions.sdk.v2.ExecutionEvent
	(*conversation.Intent)(nil),                // 16: google.actions.sdk.v2.conversation.Intent
	(*emptypb.Empty)(nil),                      // 17: google.protobuf.Empty
}
var file_google_actions_sdk_v2_actions_testing_proto_depIdxs = []int32{
	3,  // 0: google.actions.sdk.v2.SendInteractionRequest.input:type_name -> google.actions.sdk.v2.UserInput
	4,  // 1: google.actions.sdk.v2.SendInteractionRequest.device_properties:type_name -> google.actions.sdk.v2.DeviceProperties
	0,  // 2: google.actions.sdk.v2.UserInput.type:type_name -> google.actions.sdk.v2.UserInput.InputType
	1,  // 3: google.actions.sdk.v2.DeviceProperties.surface:type_name -> google.actions.sdk.v2.DeviceProperties.Surface
	5,  // 4: google.actions.sdk.v2.DeviceProperties.location:type_name -> google.actions.sdk.v2.Location
	12, // 5: google.actions.sdk.v2.Location.coordinates:type_name -> google.type.LatLng
	7,  // 6: google.actions.sdk.v2.SendInteractionResponse.output:type_name -> google.actions.sdk.v2.Output
	8,  // 7: google.actions.sdk.v2.SendInteractionResponse.diagnostics:type_name -> google.actions.sdk.v2.Diagnostics
	13, // 8: google.actions.sdk.v2.Output.canvas:type_name -> google.actions.sdk.v2.conversation.Canvas
	14, // 9: google.actions.sdk.v2.Output.actions_builder_prompt:type_name -> google.actions.sdk.v2.conversation.Prompt
	15, // 10: google.actions.sdk.v2.Diagnostics.actions_builder_events:type_name -> google.actions.sdk.v2.ExecutionEvent
	16, // 11: google.actions.sdk.v2.MatchIntentsResponse.matched_intents:type_name -> google.actions.sdk.v2.conversation.Intent
	2,  // 12: google.actions.sdk.v2.ActionsTesting.SendInteraction:input_type -> google.actions.sdk.v2.SendInteractionRequest
	9,  // 13: google.actions.sdk.v2.ActionsTesting.MatchIntents:input_type -> google.actions.sdk.v2.MatchIntentsRequest
	11, // 14: google.actions.sdk.v2.ActionsTesting.SetWebAndAppActivityControl:input_type -> google.actions.sdk.v2.SetWebAndAppActivityControlRequest
	6,  // 15: google.actions.sdk.v2.ActionsTesting.SendInteraction:output_type -> google.actions.sdk.v2.SendInteractionResponse
	10, // 16: google.actions.sdk.v2.ActionsTesting.MatchIntents:output_type -> google.actions.sdk.v2.MatchIntentsResponse
	17, // 17: google.actions.sdk.v2.ActionsTesting.SetWebAndAppActivityControl:output_type -> google.protobuf.Empty
	15, // [15:18] is the sub-list for method output_type
	12, // [12:15] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_actions_testing_proto_init() }
func file_google_actions_sdk_v2_actions_testing_proto_init() {
	if File_google_actions_sdk_v2_actions_testing_proto != nil {
		return
	}
	file_google_actions_sdk_v2_event_logs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendInteractionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendInteractionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Output); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Diagnostics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MatchIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MatchIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_actions_testing_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetWebAndAppActivityControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_actions_testing_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_actions_sdk_v2_actions_testing_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_actions_testing_proto_depIdxs,
		EnumInfos:         file_google_actions_sdk_v2_actions_testing_proto_enumTypes,
		MessageInfos:      file_google_actions_sdk_v2_actions_testing_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_actions_testing_proto = out.File
	file_google_actions_sdk_v2_actions_testing_proto_rawDesc = nil
	file_google_actions_sdk_v2_actions_testing_proto_goTypes = nil
	file_google_actions_sdk_v2_actions_testing_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ActionsTestingClient is the client API for ActionsTesting service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ActionsTestingClient interface {
	// Plays one round of the conversation.
	SendInteraction(ctx context.Context, in *SendInteractionRequest, opts ...grpc.CallOption) (*SendInteractionResponse, error)
	// Finds the intents that match a given query.
	MatchIntents(ctx context.Context, in *MatchIntentsRequest, opts ...grpc.CallOption) (*MatchIntentsResponse, error)
	// Sets the Web & App Activity control on a service account.
	//
	// It is necessary to have this setting enabled in order to use call Actions.
	// The setting is originally disabled for service accounts, and it is
	// preserved until set to a different value. This means it only needs to be
	// enabled once per account (and not necessarily once per test), unless it is
	// later disabled.
	//
	// Returns an error if the caller is not a service account. User accounts can
	// change this setting via the Activity Controls page. See
	// https://support.google.com/websearch/answer/54068.
	SetWebAndAppActivityControl(ctx context.Context, in *SetWebAndAppActivityControlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type actionsTestingClient struct {
	cc grpc.ClientConnInterface
}

func NewActionsTestingClient(cc grpc.ClientConnInterface) ActionsTestingClient {
	return &actionsTestingClient{cc}
}

func (c *actionsTestingClient) SendInteraction(ctx context.Context, in *SendInteractionRequest, opts ...grpc.CallOption) (*SendInteractionResponse, error) {
	out := new(SendInteractionResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsTesting/SendInteraction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsTestingClient) MatchIntents(ctx context.Context, in *MatchIntentsRequest, opts ...grpc.CallOption) (*MatchIntentsResponse, error) {
	out := new(MatchIntentsResponse)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsTesting/MatchIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionsTestingClient) SetWebAndAppActivityControl(ctx context.Context, in *SetWebAndAppActivityControlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.actions.sdk.v2.ActionsTesting/SetWebAndAppActivityControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ActionsTestingServer is the server API for ActionsTesting service.
type ActionsTestingServer interface {
	// Plays one round of the conversation.
	SendInteraction(context.Context, *SendInteractionRequest) (*SendInteractionResponse, error)
	// Finds the intents that match a given query.
	MatchIntents(context.Context, *MatchIntentsRequest) (*MatchIntentsResponse, error)
	// Sets the Web & App Activity control on a service account.
	//
	// It is necessary to have this setting enabled in order to use call Actions.
	// The setting is originally disabled for service accounts, and it is
	// preserved until set to a different value. This means it only needs to be
	// enabled once per account (and not necessarily once per test), unless it is
	// later disabled.
	//
	// Returns an error if the caller is not a service account. User accounts can
	// change this setting via the Activity Controls page. See
	// https://support.google.com/websearch/answer/54068.
	SetWebAndAppActivityControl(context.Context, *SetWebAndAppActivityControlRequest) (*emptypb.Empty, error)
}

// UnimplementedActionsTestingServer can be embedded to have forward compatible implementations.
type UnimplementedActionsTestingServer struct {
}

func (*UnimplementedActionsTestingServer) SendInteraction(context.Context, *SendInteractionRequest) (*SendInteractionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendInteraction not implemented")
}
func (*UnimplementedActionsTestingServer) MatchIntents(context.Context, *MatchIntentsRequest) (*MatchIntentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MatchIntents not implemented")
}
func (*UnimplementedActionsTestingServer) SetWebAndAppActivityControl(context.Context, *SetWebAndAppActivityControlRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetWebAndAppActivityControl not implemented")
}

func RegisterActionsTestingServer(s *grpc.Server, srv ActionsTestingServer) {
	s.RegisterService(&_ActionsTesting_serviceDesc, srv)
}

func _ActionsTesting_SendInteraction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendInteractionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsTestingServer).SendInteraction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsTesting/SendInteraction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsTestingServer).SendInteraction(ctx, req.(*SendInteractionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsTesting_MatchIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MatchIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsTestingServer).MatchIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsTesting/MatchIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsTestingServer).MatchIntents(ctx, req.(*MatchIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionsTesting_SetWebAndAppActivityControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetWebAndAppActivityControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionsTestingServer).SetWebAndAppActivityControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.actions.sdk.v2.ActionsTesting/SetWebAndAppActivityControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionsTestingServer).SetWebAndAppActivityControl(ctx, req.(*SetWebAndAppActivityControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ActionsTesting_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.actions.sdk.v2.ActionsTesting",
	HandlerType: (*ActionsTestingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SendInteraction",
			Handler:    _ActionsTesting_SendInteraction_Handler,
		},
		{
			MethodName: "MatchIntents",
			Handler:    _ActionsTesting_MatchIntents_Handler,
		},
		{
			MethodName: "SetWebAndAppActivityControl",
			Handler:    _ActionsTesting_SetWebAndAppActivityControl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/actions/sdk/v2/actions_testing.proto",
}
