/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class BackwardBranchMarker
implements InstructionVisitor {
    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        this.markBackwardBranch(method, branchInstruction.branchOffset);
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.markBackwardBranch(method, switchInstruction.defaultOffset);
        for (int index = 0; index < switchInstruction.jumpOffsets.length; ++index) {
            this.markBackwardBranch(method, switchInstruction.jumpOffsets[index]);
        }
    }

    private void markBackwardBranch(Method method, int branchOffset) {
        if (branchOffset < 0) {
            BackwardBranchMarker.setBranchesBackward(method);
        }
    }

    private static void setBranchesBackward(Method method) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setBranchesBackward();
    }

    public static boolean branchesBackward(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).branchesBackward();
    }
}

