/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class ClassRenamer
implements ClassVisitor,
MemberVisitor,
ConstantVisitor {
    private final ClassVisitor extraClassVisitor;
    private final MemberVisitor extraMemberVisitor;

    public ClassRenamer() {
        this(null, null);
    }

    public ClassRenamer(ClassVisitor extraClassVisitor, MemberVisitor extraMemberVisitor) {
        this.extraClassVisitor = extraClassVisitor;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.thisClassConstantAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        String name = libraryClass.getName();
        String newName = ClassObfuscator.newClassName(libraryClass);
        if (newName != null && !newName.equals(name)) {
            libraryClass.thisClassName = newName;
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitLibraryClass(libraryClass);
            }
        }
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        String name = programMember.getName(programClass);
        String newName = MemberObfuscator.newMemberName(programMember);
        if (newName != null && !newName.equals(name)) {
            programMember.u2nameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(newName);
            if (this.extraMemberVisitor != null) {
                programMember.accept(programClass, this.extraMemberVisitor);
            }
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        String name = libraryMember.getName(libraryClass);
        String newName = MemberObfuscator.newMemberName(libraryMember);
        if (newName != null && !newName.equals(name)) {
            libraryMember.name = newName;
            if (this.extraMemberVisitor != null) {
                libraryMember.accept(libraryClass, this.extraMemberVisitor);
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String name = clazz.getName();
        String newName = ClassObfuscator.newClassName(clazz);
        if (newName != null && !newName.equals(name)) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newName);
            if (this.extraClassVisitor != null) {
                clazz.accept(this.extraClassVisitor);
            }
        }
    }
}

