/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class InstructionOpCodeFilter
implements InstructionVisitor {
    private final int[] opcodes;
    private final InstructionVisitor acceptedVisitor;
    private final InstructionVisitor rejectedVisitor;

    public InstructionOpCodeFilter(int[] opcodes, InstructionVisitor acceptedVisitor) {
        this(opcodes, acceptedVisitor, null);
    }

    public InstructionOpCodeFilter(int[] opcodes, InstructionVisitor acceptedVisitor, InstructionVisitor rejectedVisitor) {
        this.opcodes = opcodes;
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        InstructionVisitor delegate = this.getDelegateVisitor(instruction.opcode);
        if (delegate != null) {
            instruction.accept(clazz, method, codeAttribute, offset, delegate);
        }
    }

    private InstructionVisitor getDelegateVisitor(int opcode) {
        for (int allowedOpcode : this.opcodes) {
            if (opcode != allowedOpcode) continue;
            return this.acceptedVisitor;
        }
        return this.rejectedVisitor;
    }
}

