/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class SimpleInstruction
extends Instruction {
    public int constant;

    public SimpleInstruction() {
    }

    public SimpleInstruction(byte opcode) {
        this.opcode = opcode;
        this.constant = SimpleInstruction.embeddedConstant(opcode);
    }

    public SimpleInstruction(byte opcode, int constant) {
        this.opcode = SimpleInstruction.embeddingOpcode(opcode, constant);
        this.constant = constant;
    }

    public SimpleInstruction copy(SimpleInstruction simpleInstruction) {
        this.opcode = simpleInstruction.opcode;
        this.constant = simpleInstruction.constant;
        return this;
    }

    private static byte embeddingOpcode(byte opcode, int constant) {
        switch (opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return constant >= -1 && constant <= 5 ? (byte)(3 + constant) : opcode;
            }
            case 9: 
            case 10: {
                return constant == 0 || constant == 1 ? (byte)(9 + constant) : opcode;
            }
            case 11: 
            case 12: 
            case 13: {
                return constant >= 0 && constant <= 2 ? (byte)(11 + constant) : opcode;
            }
            case 14: 
            case 15: {
                return constant == 0 || constant == 1 ? (byte)(14 + constant) : opcode;
            }
        }
        return opcode;
    }

    private static int embeddedConstant(byte opcode) {
        switch (opcode) {
            case 2: {
                return -1;
            }
            case 4: 
            case 10: 
            case 12: 
            case 15: {
                return 1;
            }
            case 5: 
            case 13: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public byte canonicalOpcode() {
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return 3;
            }
            case 9: 
            case 10: {
                return 9;
            }
            case 11: 
            case 12: 
            case 13: {
                return 11;
            }
            case 14: 
            case 15: {
                return 14;
            }
        }
        return this.opcode;
    }

    @Override
    public Instruction shrink() {
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                switch (this.requiredConstantSize()) {
                    case 0: {
                        this.opcode = (byte)(3 + this.constant);
                        break;
                    }
                    case 1: {
                        this.opcode = (byte)16;
                        break;
                    }
                    case 2: {
                        this.opcode = (byte)17;
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                this.opcode = (byte)(9 + this.constant);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.opcode = (byte)(11 + this.constant);
                break;
            }
            case 14: 
            case 15: {
                this.opcode = (byte)(14 + this.constant);
            }
        }
        return this;
    }

    @Override
    protected void readInfo(byte[] code, int offset) {
        int constantSize = this.constantSize();
        this.constant = constantSize == 0 ? SimpleInstruction.embeddedConstant(this.opcode) : SimpleInstruction.readSignedValue(code, offset, constantSize);
    }

    @Override
    protected void writeInfo(byte[] code, int offset) {
        int constantSize = this.constantSize();
        if (this.requiredConstantSize() > constantSize) {
            throw new IllegalArgumentException("Instruction has invalid constant size (" + this.toString(offset) + ")");
        }
        SimpleInstruction.writeSignedValue(code, offset, this.constant, constantSize);
    }

    @Override
    public int length(int offset) {
        return 1 + this.constantSize();
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public int stackEntryIndexBefore(Clazz clazz, int stackEntryIndexAfter) {
        switch (this.opcode) {
            case 89: {
                return 0;
            }
            case 90: {
                return stackEntryIndexAfter >= 2 ? 0 : stackEntryIndexAfter;
            }
            case 91: {
                return stackEntryIndexAfter >= 3 ? 0 : stackEntryIndexAfter;
            }
            case 92: {
                return stackEntryIndexAfter >= 2 ? stackEntryIndexAfter - 2 : stackEntryIndexAfter;
            }
            case 93: {
                return stackEntryIndexAfter >= 3 ? stackEntryIndexAfter - 3 : stackEntryIndexAfter;
            }
            case 94: {
                return stackEntryIndexAfter >= 4 ? stackEntryIndexAfter - 4 : stackEntryIndexAfter;
            }
            case 95: {
                return 1 - stackEntryIndexAfter;
            }
        }
        return -1;
    }

    public String toString() {
        return this.getName() + (this.constantSize() > 0 || this.constant != SimpleInstruction.embeddedConstant(this.opcode) ? " " + this.constant : "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInstruction that = (SimpleInstruction)o;
        return this.opcode == that.opcode && this.constant == that.constant;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.opcode, this.constant);
    }

    private int constantSize() {
        return this.opcode == 16 || this.opcode == -68 ? 1 : (this.opcode == 17 ? 2 : 0);
    }

    private int requiredConstantSize() {
        return this.constant >= -1 && this.constant <= 5 ? 0 : ((byte)this.constant == this.constant ? 1 : ((short)this.constant == this.constant ? 2 : 4));
    }
}

