/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.util.ConstantLookupVisitor;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.cpa.jvm.witness.JvmHeapLocation;
import proguard.analysis.cpa.jvm.witness.JvmLocalVariableLocation;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.ClassConstantValueFactory;
import proguard.evaluation.value.ParticularValueFactory;

public class JvmMemoryLocationTransferRelation<AbstractStateT extends LatticeAbstractState<AbstractStateT>>
implements TransferRelation {
    private final AbstractStateT threshold;

    public JvmMemoryLocationTransferRelation(AbstractStateT threshold) {
        this.threshold = threshold;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState abstractState, Precision precision) {
        if (!(abstractState instanceof JvmMemoryLocationAbstractState)) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not support " + abstractState.getClass().getName());
        }
        JvmMemoryLocationAbstractState state = (JvmMemoryLocationAbstractState)abstractState.copy();
        ArrayList<JvmMemoryLocationAbstractState> successors = new ArrayList<JvmMemoryLocationAbstractState>();
        for (ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> parent : state.getArgNode().getParents()) {
            LatticeAbstractState value;
            if (parent.getProgramLocation().equals(state.getProgramLocation())) {
                JvmMemoryLocation memoryLocation = state.getMemoryLocation().copy();
                memoryLocation.setArgNode(parent);
                successors.add(new JvmMemoryLocationAbstractState(memoryLocation));
                continue;
            }
            MethodSignature parentSignature = parent.getProgramLocation().getSignature();
            MethodSignature currentSignature = state.getProgramLocation().getSignature();
            Optional<JvmCfaEdge> optionalEdge = parent.getProgramLocation().getLeavingEdges().stream().filter(e -> state.getProgramLocation().getEnteringEdges().contains(e)).findFirst();
            if (optionalEdge.isPresent()) {
                JvmCfaEdge edge = optionalEdge.get();
                JvmAbstractState predecessorState = (JvmAbstractState)parent.getWrappedState().getStateByName("Jvm");
                ArrayList<JvmMemoryLocation> successorMemoryLocations = new ArrayList<JvmMemoryLocation>();
                if (edge instanceof JvmInstructionCfaEdge) {
                    successorMemoryLocations.addAll(this.getSuccessorMemoryLocationsForInstruction(state, parent, ((JvmInstructionCfaEdge)edge).getInstruction(), state.getProgramLocation().getClazz(), precision).stream().map(JvmMemoryLocation::copy).collect(Collectors.toList()));
                } else if (edge instanceof JvmCallCfaEdge) {
                    if (state.getProgramLocation().getOffset() != 0) continue;
                    if (state.getMemoryLocation() instanceof JvmLocalVariableLocation) {
                        JvmLocalVariableLocation argumentLocation = (JvmLocalVariableLocation)state.getMemoryLocation();
                        Call call = ((JvmCallCfaEdge)edge).getCall();
                        boolean isStatic = call.invocationOpcode == -72 || call.invocationOpcode == -70;
                        String currentDescriptor = currentSignature.descriptor.toString();
                        int parameterNumber = ClassUtil.internalMethodParameterNumber(currentDescriptor, isStatic, argumentLocation.index);
                        int parameterSize = ClassUtil.internalMethodParameterSize(currentDescriptor, isStatic);
                        boolean isCategory2 = ClassUtil.isInternalCategory2Type(ClassUtil.internalMethodParameterType(currentDescriptor, parameterNumber));
                        JvmStackLocation operandLocation = new JvmStackLocation(parameterSize - argumentLocation.index - (isCategory2 ? (parameterNumber == ClassUtil.internalMethodParameterNumber(currentDescriptor, isStatic, argumentLocation.index + 1) ? 2 : 0) : 1));
                        successorMemoryLocations.add(operandLocation);
                    } else {
                        successorMemoryLocations.add(state.getMemoryLocation().copy());
                    }
                } else {
                    successorMemoryLocations.add(state.getMemoryLocation().copy());
                }
                successors.addAll(successorMemoryLocations.stream().filter(l -> !((LatticeAbstractState)l.extractValueOrDefault(predecessorState, this.threshold)).isLessOrEqual(this.threshold)).peek(l -> l.setArgNode(parent)).map(JvmMemoryLocationAbstractState::new).collect(Collectors.toList()));
                continue;
            }
            if (!parentSignature.equals(state.getProgramLocation().getSignature())) {
                if (state.getMemoryLocation() instanceof JvmLocalVariableLocation) continue;
                if (state.getMemoryLocation() instanceof JvmStackLocation) {
                    JvmStackLocation stackLocation = (JvmStackLocation)state.getMemoryLocation();
                    int index = stackLocation.getIndex();
                    if (!(parent.getProgramLocation().getOffset() == -1 && index <= ClassUtil.internalTypeSize(parentSignature.descriptor.returnType) || parent.getProgramLocation().getOffset() == -2 && index == 0)) {
                        continue;
                    }
                }
            } else if (state.getMemoryLocation() instanceof JvmStackLocation && ((JvmStackLocation)state.getMemoryLocation()).getIndex() != 0) continue;
            if ((value = (LatticeAbstractState)state.getMemoryLocation().extractValueOrDefault((JvmAbstractState)parent.getWrappedState().getStateByName("Jvm"), this.threshold)).isLessOrEqual(this.threshold)) continue;
            JvmMemoryLocation parentLocation = state.getMemoryLocation().copy();
            parentLocation.setArgNode(parent);
            successors.add(new JvmMemoryLocationAbstractState(parentLocation));
        }
        successors.forEach(s -> state.addSourceLocation(s.getMemoryLocation()));
        successors.add(state);
        return successors;
    }

    private List<JvmMemoryLocation> getSuccessorMemoryLocationsForInstruction(JvmMemoryLocationAbstractState abstractState, ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> parentState, Instruction instruction, Clazz clazz, Precision precision) {
        ArrayList<JvmMemoryLocation> answer = new ArrayList<JvmMemoryLocation>();
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(answer, abstractState.getMemoryLocation(), parentState));
        return answer;
    }

    private List<JvmMemoryLocation> backtraceStackLocation(JvmMemoryLocation memoryLocation, Instruction instruction, Clazz clazz) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        if (!(memoryLocation instanceof JvmStackLocation)) {
            result.add(memoryLocation);
            return result;
        }
        int index = ((JvmStackLocation)memoryLocation).getIndex();
        int pushCount = instruction.stackPushCount(clazz);
        int popCount = instruction.stackPopCount(clazz);
        if (index >= pushCount) {
            result.add(new JvmStackLocation(index - pushCount + popCount));
            return result;
        }
        result.addAll(this.getPoppedLocations(popCount));
        return result;
    }

    private List<JvmMemoryLocation> getPoppedLocations(int popCount) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        for (int i = 0; i < popCount; ++i) {
            result.add(new JvmStackLocation(i));
        }
        return result;
    }

    private List<JvmMemoryLocation> processCall(JvmMemoryLocation memoryLocation, ConstantInstruction callInstruction, Clazz clazz) {
        return memoryLocation instanceof JvmLocalVariableLocation ? Collections.singletonList(memoryLocation) : (memoryLocation instanceof JvmStackLocation && this.isStackLocationTooDeep((JvmStackLocation)memoryLocation, callInstruction, clazz) || this.doesMemoryLocationDependOnReturnValue(memoryLocation) ? this.backtraceStackLocation(memoryLocation, callInstruction, clazz) : Collections.emptyList());
    }

    private boolean isStackLocationTooDeep(JvmStackLocation stackLocation, Instruction instruction, Clazz clazz) {
        return stackLocation.index >= instruction.stackPushCount(clazz);
    }

    private boolean doesMemoryLocationDependOnReturnValue(JvmMemoryLocation memoryLocation) {
        return memoryLocation.getArgNode().getParents().stream().noneMatch(p -> ((JvmCfaNode)p.getProgramLocation()).isExitNode());
    }

    private class InstructionAbstractInterpreter
    implements InstructionVisitor {
        private final List<JvmMemoryLocation> answer;
        private final JvmMemoryLocation memoryLocation;
        private final ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> parentState;
        private final ClassConstantValueFactory classConstantValueFactory = new ClassConstantValueFactory(new ParticularValueFactory());
        private final ConstantLookupVisitor constantLookupVisitor = new ConstantLookupVisitor();

        public InstructionAbstractInterpreter(List<JvmMemoryLocation> answer, JvmMemoryLocation memoryLocation, ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> parentState) {
            this.answer = answer;
            this.memoryLocation = memoryLocation;
            this.parentState = parentState;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (simpleInstruction.opcode >= 79 && simpleInstruction.opcode <= 86 && this.memoryLocation instanceof JvmHeapLocation) {
                this.answer.add(this.memoryLocation);
                if (((JvmAbstractState)this.parentState.getWrappedState().getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState) {
                    SetAbstractState arrayReference = (SetAbstractState)((JvmReferenceAbstractState)this.parentState.getWrappedState().getStateByName("Reference")).peek(simpleInstruction.isCategory2() ? 3 : 2);
                    JvmHeapLocation heapLocation = (JvmHeapLocation)this.memoryLocation;
                    if (heapLocation.reference.stream().anyMatch(arrayReference::contains) && heapLocation.field.equals("[]")) {
                        this.answer.add(new JvmStackLocation(0));
                    }
                }
                return;
            }
            if (!(this.memoryLocation instanceof JvmStackLocation) || InstructionClassifier.isReturn(simpleInstruction.opcode)) {
                this.answer.add(this.memoryLocation);
                return;
            }
            int index = ((JvmStackLocation)this.memoryLocation).getIndex();
            if (JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, simpleInstruction, clazz)) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                return;
            }
            switch (simpleInstruction.opcode) {
                case 89: {
                    this.answer.add(new JvmStackLocation(0));
                    break;
                }
                case 90: {
                    this.answer.add(index == 2 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 91: {
                    this.answer.add(index == 3 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 92: {
                    this.answer.add(index > 1 ? new JvmStackLocation(index - 2) : this.memoryLocation);
                    break;
                }
                case 93: {
                    this.answer.add(index > 2 ? new JvmStackLocation(index - 3) : this.memoryLocation);
                    break;
                }
                case 94: {
                    this.answer.add(index > 3 ? new JvmStackLocation(index - 4) : this.memoryLocation);
                    break;
                }
                case 95: {
                    this.answer.add(new JvmStackLocation(1 - index));
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.answer.add(new JvmStackLocation(0));
                    this.answer.add(new JvmStackLocation(1));
                    if (!(((JvmAbstractState)this.parentState.getWrappedState().getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) break;
                    this.answer.add(new JvmHeapLocation((SetAbstractState)((JvmReferenceAbstractState)this.parentState.getWrappedState().getStateByName("Reference")).peek(1), "[]"));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode == -124) {
                this.answer.add(this.memoryLocation);
                return;
            }
            if (variableInstruction.isLoad()) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, variableInstruction, clazz));
                if (this.memoryLocation instanceof JvmStackLocation && !JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, variableInstruction, clazz)) {
                    this.answer.add(new JvmLocalVariableLocation(variableInstruction.variableIndex + ((JvmStackLocation)this.memoryLocation).index));
                }
                return;
            }
            if (!(this.memoryLocation instanceof JvmLocalVariableLocation) || ((JvmLocalVariableLocation)this.memoryLocation).index != variableInstruction.variableIndex) {
                this.answer.add(this.memoryLocation);
            }
            this.answer.add(new JvmStackLocation(0));
            if (variableInstruction.isCategory2()) {
                this.answer.add(new JvmStackLocation(1));
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -78: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    if (!(this.memoryLocation instanceof JvmStackLocation) || JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, constantInstruction, clazz)) break;
                    this.answer.add(new JvmStaticFieldLocation(this.constantLookupVisitor.result));
                    break;
                }
                case -77: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).getIndex() + this.constantLookupVisitor.resultSize));
                        break;
                    }
                    if (this.memoryLocation instanceof JvmStaticFieldLocation) {
                        this.answer.add(new JvmStackLocation(0));
                        if (this.constantLookupVisitor.resultSize != 2) break;
                        this.answer.add(new JvmStackLocation(1));
                        break;
                    }
                    this.answer.add(this.memoryLocation);
                    break;
                }
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    if (!(this.memoryLocation instanceof JvmStackLocation) || JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, constantInstruction, clazz) || !(((JvmAbstractState)this.parentState.getWrappedState().getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) break;
                    this.answer.add(new JvmHeapLocation((SetAbstractState)((JvmReferenceAbstractState)this.parentState.getWrappedState().getStateByName("Reference")).peek(), this.constantLookupVisitor.result));
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).index + this.constantLookupVisitor.resultSize + 1));
                        break;
                    }
                    if (!(this.memoryLocation instanceof JvmHeapLocation)) {
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    JvmHeapLocation heapLocation = (JvmHeapLocation)this.memoryLocation;
                    if (!this.constantLookupVisitor.result.equals(heapLocation.field) || !(((JvmAbstractState)this.parentState.getWrappedState().getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) {
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    SetAbstractState reference = (SetAbstractState)((JvmReferenceAbstractState)this.parentState.getWrappedState().getStateByName("Reference")).peek(this.constantLookupVisitor.resultSize);
                    SetAbstractState referenceIntersection = heapLocation.reference.stream().filter(reference::contains).collect(Collectors.toCollection(() -> new SetAbstractState<Reference>(new Reference[0])));
                    if (reference.size() != 1 || reference.equals(heapLocation.reference) || this.constantLookupVisitor.result.endsWith("[]")) {
                        this.answer.add(this.memoryLocation);
                    }
                    if (referenceIntersection.size() <= 0) break;
                    this.answer.add(new JvmStackLocation(0));
                    if (this.constantLookupVisitor.resultSize <= 1) break;
                    this.answer.add(new JvmStackLocation(1));
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.processCall(this.memoryLocation, constantInstruction, clazz));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, branchInstruction, clazz));
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, switchInstruction, clazz));
        }
    }
}

