package machinelearningservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/machinelearningservices/mgmt/2021-07-01/machinelearningservices"

// AKS a Machine Learning compute based on AKS.
type AKS struct {
	// Properties - AKS properties
	Properties *AKSProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	a.ComputeType = ComputeTypeBasicComputeComputeTypeAKS
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.ComputeLocation != nil {
		objectMap["computeLocation"] = a.ComputeLocation
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.ResourceID != nil {
		objectMap["resourceId"] = a.ResourceID
	}
	if a.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = a.DisableLocalAuth
	}
	if a.ComputeType != "" {
		objectMap["computeType"] = a.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AKS.
func (a AKS) AsAKS() (*AKS, bool) {
	return &a, true
}

// AsAmlCompute is the BasicCompute implementation for AKS.
func (a AKS) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for AKS.
func (a AKS) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AKS.
func (a AKS) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AKS.
func (a AKS) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AKS.
func (a AKS) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AKS.
func (a AKS) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AKS.
func (a AKS) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for AKS.
func (a AKS) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AKS.
func (a AKS) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AKS.
func (a AKS) AsBasicCompute() (BasicCompute, bool) {
	return &a, true
}

// AksComputeSecrets secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// ComputeType - The type of compute. Possible values include: 'ComputeTypeAKS', 'ComputeTypeKubernetes', 'ComputeTypeAmlCompute', 'ComputeTypeComputeInstance', 'ComputeTypeDataFactory', 'ComputeTypeVirtualMachine', 'ComputeTypeHDInsight', 'ComputeTypeDatabricks', 'ComputeTypeDataLakeAnalytics', 'ComputeTypeSynapseSpark'
	ComputeType ComputeType `json:"computeType,omitempty"`
	// UserKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
	// AdminKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`
	// ImagePullSecretName - Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`
}

// AksComputeSecretsProperties properties of AksComputeSecrets
type AksComputeSecretsProperties struct {
	// UserKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
	// AdminKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`
	// ImagePullSecretName - Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`
}

// AksNetworkingConfiguration advance configuration for AKS networking
type AksNetworkingConfiguration struct {
	// SubnetID - Virtual network subnet resource ID the compute nodes belong to
	SubnetID *string `json:"subnetId,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
}

// AKSProperties AKS properties
type AKSProperties struct {
	// ClusterFqdn - Cluster full qualified domain name
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`
	// SystemServices - READ-ONLY; System services
	SystemServices *[]SystemService `json:"systemServices,omitempty"`
	// AgentCount - Number of agents
	AgentCount *int32 `json:"agentCount,omitempty"`
	// AgentVMSize - Agent virtual machine size
	AgentVMSize *string `json:"agentVmSize,omitempty"`
	// ClusterPurpose - Intended usage of the cluster. Possible values include: 'ClusterPurposeFastProd', 'ClusterPurposeDenseProd', 'ClusterPurposeDevTest'
	ClusterPurpose ClusterPurpose `json:"clusterPurpose,omitempty"`
	// SslConfiguration - SSL configuration
	SslConfiguration *SslConfiguration `json:"sslConfiguration,omitempty"`
	// AksNetworkingConfiguration - AKS networking configuration for vnet
	AksNetworkingConfiguration *AksNetworkingConfiguration `json:"aksNetworkingConfiguration,omitempty"`
	// LoadBalancerType - Load Balancer Type. Possible values include: 'LoadBalancerTypePublicIP', 'LoadBalancerTypeInternalLoadBalancer'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// LoadBalancerSubnet - Load Balancer Subnet
	LoadBalancerSubnet *string `json:"loadBalancerSubnet,omitempty"`
}

// MarshalJSON is the custom marshaler for AKSProperties.
func (a AKSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ClusterFqdn != nil {
		objectMap["clusterFqdn"] = a.ClusterFqdn
	}
	if a.AgentCount != nil {
		objectMap["agentCount"] = a.AgentCount
	}
	if a.AgentVMSize != nil {
		objectMap["agentVmSize"] = a.AgentVMSize
	}
	if a.ClusterPurpose != "" {
		objectMap["clusterPurpose"] = a.ClusterPurpose
	}
	if a.SslConfiguration != nil {
		objectMap["sslConfiguration"] = a.SslConfiguration
	}
	if a.AksNetworkingConfiguration != nil {
		objectMap["aksNetworkingConfiguration"] = a.AksNetworkingConfiguration
	}
	if a.LoadBalancerType != "" {
		objectMap["loadBalancerType"] = a.LoadBalancerType
	}
	if a.LoadBalancerSubnet != nil {
		objectMap["loadBalancerSubnet"] = a.LoadBalancerSubnet
	}
	return json.Marshal(objectMap)
}

// AmlCompute an Azure Machine Learning compute.
type AmlCompute struct {
	// Properties - Properties of AmlCompute
	Properties *AmlComputeProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlCompute.
func (ac AmlCompute) MarshalJSON() ([]byte, error) {
	ac.ComputeType = ComputeTypeBasicComputeComputeTypeAmlCompute
	objectMap := make(map[string]interface{})
	if ac.Properties != nil {
		objectMap["properties"] = ac.Properties
	}
	if ac.ComputeLocation != nil {
		objectMap["computeLocation"] = ac.ComputeLocation
	}
	if ac.Description != nil {
		objectMap["description"] = ac.Description
	}
	if ac.ResourceID != nil {
		objectMap["resourceId"] = ac.ResourceID
	}
	if ac.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ac.DisableLocalAuth
	}
	if ac.ComputeType != "" {
		objectMap["computeType"] = ac.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAmlCompute() (*AmlCompute, bool) {
	return &ac, true
}

// AsComputeInstance is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsBasicCompute() (BasicCompute, bool) {
	return &ac, true
}

// AmlComputeNodeInformation compute node information related to a AmlCompute.
type AmlComputeNodeInformation struct {
	// NodeID - READ-ONLY; ID of the compute node.
	NodeID *string `json:"nodeId,omitempty"`
	// PrivateIPAddress - READ-ONLY; Private IP address of the compute node.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address of the compute node.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Port - READ-ONLY; SSH port number of the node.
	Port *float64 `json:"port,omitempty"`
	// NodeState - READ-ONLY; State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted. Possible values include: 'NodeStateIdle', 'NodeStateRunning', 'NodeStatePreparing', 'NodeStateUnusable', 'NodeStateLeaving', 'NodeStatePreempted'
	NodeState NodeState `json:"nodeState,omitempty"`
	// RunID - READ-ONLY; ID of the Experiment running on the node, if any else null.
	RunID *string `json:"runId,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeNodeInformation.
func (acni AmlComputeNodeInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AmlComputeNodesInformation result of AmlCompute Nodes
type AmlComputeNodesInformation struct {
	autorest.Response `json:"-"`
	// Nodes - READ-ONLY; The collection of returned AmlCompute nodes details.
	Nodes *[]AmlComputeNodeInformation `json:"nodes,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AmlComputeNodesInformationIterator provides access to a complete listing of AmlComputeNodeInformation
// values.
type AmlComputeNodesInformationIterator struct {
	i    int
	page AmlComputeNodesInformationPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AmlComputeNodesInformationIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AmlComputeNodesInformationIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AmlComputeNodesInformationIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AmlComputeNodesInformationIterator) Response() AmlComputeNodesInformation {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AmlComputeNodesInformationIterator) Value() AmlComputeNodeInformation {
	if !iter.page.NotDone() {
		return AmlComputeNodeInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AmlComputeNodesInformationIterator type.
func NewAmlComputeNodesInformationIterator(page AmlComputeNodesInformationPage) AmlComputeNodesInformationIterator {
	return AmlComputeNodesInformationIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (acni AmlComputeNodesInformation) IsEmpty() bool {
	return acni.Nodes == nil || len(*acni.Nodes) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (acni AmlComputeNodesInformation) hasNextLink() bool {
	return acni.NextLink != nil && len(*acni.NextLink) != 0
}

// amlComputeNodesInformationPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (acni AmlComputeNodesInformation) amlComputeNodesInformationPreparer(ctx context.Context) (*http.Request, error) {
	if !acni.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(acni.NextLink)))
}

// AmlComputeNodesInformationPage contains a page of AmlComputeNodeInformation values.
type AmlComputeNodesInformationPage struct {
	fn   func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)
	acni AmlComputeNodesInformation
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AmlComputeNodesInformationPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.acni)
		if err != nil {
			return err
		}
		page.acni = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AmlComputeNodesInformationPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AmlComputeNodesInformationPage) NotDone() bool {
	return !page.acni.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AmlComputeNodesInformationPage) Response() AmlComputeNodesInformation {
	return page.acni
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AmlComputeNodesInformationPage) Values() []AmlComputeNodeInformation {
	if page.acni.IsEmpty() {
		return nil
	}
	return *page.acni.Nodes
}

// Creates a new instance of the AmlComputeNodesInformationPage type.
func NewAmlComputeNodesInformationPage(cur AmlComputeNodesInformation, getNextPage func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)) AmlComputeNodesInformationPage {
	return AmlComputeNodesInformationPage{
		fn:   getNextPage,
		acni: cur,
	}
}

// AmlComputeProperties AML Compute properties
type AmlComputeProperties struct {
	// OsType - Compute OS Type. Possible values include: 'OsTypeLinux', 'OsTypeWindows'
	OsType OsType `json:"osType,omitempty"`
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - Virtual Machine priority. Possible values include: 'VMPriorityDedicated', 'VMPriorityLowPriority'
	VMPriority VMPriority `json:"vmPriority,omitempty"`
	// VirtualMachineImage - Virtual Machine image for AML Compute - windows only
	VirtualMachineImage *VirtualMachineImage `json:"virtualMachineImage,omitempty"`
	// IsolatedNetwork - Network is isolated or not
	IsolatedNetwork *bool `json:"isolatedNetwork,omitempty"`
	// ScaleSettings - Scale settings for AML Compute
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
	// UserAccountCredentials - Credentials for an administrator user account that will be created on each compute node.
	UserAccountCredentials *UserAccountCredentials `json:"userAccountCredentials,omitempty"`
	// Subnet - Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// RemoteLoginPortPublicAccess - State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. Possible values include: 'RemoteLoginPortPublicAccessEnabled', 'RemoteLoginPortPublicAccessDisabled', 'RemoteLoginPortPublicAccessNotSpecified'
	RemoteLoginPortPublicAccess RemoteLoginPortPublicAccess `json:"remoteLoginPortPublicAccess,omitempty"`
	// AllocationState - READ-ONLY; Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. Possible values include: 'AllocationStateSteady', 'AllocationStateResizing'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY; The time at which the compute entered its current allocation state.
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors *[]ErrorResponse `json:"errors,omitempty"`
	// CurrentNodeCount - READ-ONLY; The number of compute nodes currently assigned to the compute.
	CurrentNodeCount *int32 `json:"currentNodeCount,omitempty"`
	// TargetNodeCount - READ-ONLY; The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty"`
	// NodeStateCounts - READ-ONLY; Counts of various node states on the compute.
	NodeStateCounts *NodeStateCounts `json:"nodeStateCounts,omitempty"`
	// EnableNodePublicIP - Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
	EnableNodePublicIP *bool `json:"enableNodePublicIp,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeProperties.
func (acp AmlComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.OsType != "" {
		objectMap["osType"] = acp.OsType
	}
	if acp.VMSize != nil {
		objectMap["vmSize"] = acp.VMSize
	}
	if acp.VMPriority != "" {
		objectMap["vmPriority"] = acp.VMPriority
	}
	if acp.VirtualMachineImage != nil {
		objectMap["virtualMachineImage"] = acp.VirtualMachineImage
	}
	if acp.IsolatedNetwork != nil {
		objectMap["isolatedNetwork"] = acp.IsolatedNetwork
	}
	if acp.ScaleSettings != nil {
		objectMap["scaleSettings"] = acp.ScaleSettings
	}
	if acp.UserAccountCredentials != nil {
		objectMap["userAccountCredentials"] = acp.UserAccountCredentials
	}
	if acp.Subnet != nil {
		objectMap["subnet"] = acp.Subnet
	}
	if acp.RemoteLoginPortPublicAccess != "" {
		objectMap["remoteLoginPortPublicAccess"] = acp.RemoteLoginPortPublicAccess
	}
	if acp.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIp"] = acp.EnableNodePublicIP
	}
	return json.Marshal(objectMap)
}

// AmlUserFeature features enabled for a workspace
type AmlUserFeature struct {
	// ID - Specifies the feature ID
	ID *string `json:"id,omitempty"`
	// DisplayName - Specifies the feature name
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Describes the feature for user experience
	Description *string `json:"description,omitempty"`
}

// AssignedUser a user that can be assigned to a compute instance.
type AssignedUser struct {
	// ObjectID - User’s AAD Object Id.
	ObjectID *string `json:"objectId,omitempty"`
	// TenantID - User’s AAD Tenant Id.
	TenantID *string `json:"tenantId,omitempty"`
}

// AutoPauseProperties auto pause properties
type AutoPauseProperties struct {
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`
	Enabled        *bool  `json:"enabled,omitempty"`
}

// AutoScaleProperties auto scale properties
type AutoScaleProperties struct {
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	Enabled      *bool  `json:"enabled,omitempty"`
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterUpdateParameters amlCompute update parameters.
type ClusterUpdateParameters struct {
	// ClusterUpdateProperties - The properties of the amlCompute.
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterUpdateProperties != nil {
		objectMap["properties"] = cup.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cup.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a amlCompute that need to be updated.
type ClusterUpdateProperties struct {
	// Properties - Properties of ClusterUpdate
	Properties *ScaleSettingsInformation `json:"properties,omitempty"`
}

// BasicCompute machine Learning compute object.
type BasicCompute interface {
	AsAKS() (*AKS, bool)
	AsAmlCompute() (*AmlCompute, bool)
	AsComputeInstance() (*ComputeInstance, bool)
	AsVirtualMachine() (*VirtualMachine, bool)
	AsHDInsight() (*HDInsight, bool)
	AsDataFactory() (*DataFactory, bool)
	AsDatabricks() (*Databricks, bool)
	AsDataLakeAnalytics() (*DataLakeAnalytics, bool)
	AsSynapseSpark() (*SynapseSpark, bool)
	AsCompute() (*Compute, bool)
}

// Compute machine Learning compute object.
type Compute struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

func unmarshalBasicCompute(body []byte) (BasicCompute, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeComputeTypeAKS):
		var a AKS
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ComputeTypeBasicComputeComputeTypeAmlCompute):
		var ac AmlCompute
		err := json.Unmarshal(body, &ac)
		return ac, err
	case string(ComputeTypeBasicComputeComputeTypeComputeInstance):
		var ci ComputeInstance
		err := json.Unmarshal(body, &ci)
		return ci, err
	case string(ComputeTypeBasicComputeComputeTypeVirtualMachine):
		var VM VirtualMachine
		err := json.Unmarshal(body, &VM)
		return VM, err
	case string(ComputeTypeBasicComputeComputeTypeHDInsight):
		var hi HDInsight
		err := json.Unmarshal(body, &hi)
		return hi, err
	case string(ComputeTypeBasicComputeComputeTypeDataFactory):
		var df DataFactory
		err := json.Unmarshal(body, &df)
		return df, err
	case string(ComputeTypeBasicComputeComputeTypeDatabricks):
		var d Databricks
		err := json.Unmarshal(body, &d)
		return d, err
	case string(ComputeTypeBasicComputeComputeTypeDataLakeAnalytics):
		var dla DataLakeAnalytics
		err := json.Unmarshal(body, &dla)
		return dla, err
	case string(ComputeTypeBasicComputeComputeTypeSynapseSpark):
		var ss SynapseSpark
		err := json.Unmarshal(body, &ss)
		return ss, err
	default:
		var c Compute
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicComputeArray(body []byte) ([]BasicCompute, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicCompute, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicCompute(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	c.ComputeType = ComputeTypeBasicComputeComputeTypeCompute
	objectMap := make(map[string]interface{})
	if c.ComputeLocation != nil {
		objectMap["computeLocation"] = c.ComputeLocation
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	if c.ResourceID != nil {
		objectMap["resourceId"] = c.ResourceID
	}
	if c.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = c.DisableLocalAuth
	}
	if c.ComputeType != "" {
		objectMap["computeType"] = c.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Compute.
func (c Compute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Compute.
func (c Compute) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for Compute.
func (c Compute) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Compute.
func (c Compute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Compute.
func (c Compute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Compute.
func (c Compute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Compute.
func (c Compute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for Compute.
func (c Compute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for Compute.
func (c Compute) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Compute.
func (c Compute) AsCompute() (*Compute, bool) {
	return &c, true
}

// AsBasicCompute is the BasicCompute implementation for Compute.
func (c Compute) AsBasicCompute() (BasicCompute, bool) {
	return &c, true
}

// ComputeCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ComputeCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (ComputeResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeCreateOrUpdateFuture.Result.
func (future *ComputeCreateOrUpdateFuture) result(client ComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ComputeDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ComputeDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeDeleteFuture.Result.
func (future *ComputeDeleteFuture) result(client ComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ComputeInstance an Azure Machine Learning compute instance.
type ComputeInstance struct {
	// Properties - Properties of ComputeInstance
	Properties *ComputeInstanceProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstance.
func (ci ComputeInstance) MarshalJSON() ([]byte, error) {
	ci.ComputeType = ComputeTypeBasicComputeComputeTypeComputeInstance
	objectMap := make(map[string]interface{})
	if ci.Properties != nil {
		objectMap["properties"] = ci.Properties
	}
	if ci.ComputeLocation != nil {
		objectMap["computeLocation"] = ci.ComputeLocation
	}
	if ci.Description != nil {
		objectMap["description"] = ci.Description
	}
	if ci.ResourceID != nil {
		objectMap["resourceId"] = ci.ResourceID
	}
	if ci.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ci.DisableLocalAuth
	}
	if ci.ComputeType != "" {
		objectMap["computeType"] = ci.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsComputeInstance() (*ComputeInstance, bool) {
	return &ci, true
}

// AsVirtualMachine is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsBasicCompute() (BasicCompute, bool) {
	return &ci, true
}

// ComputeInstanceApplication defines an Aml Instance application and its connectivity endpoint URI.
type ComputeInstanceApplication struct {
	// DisplayName - Name of the ComputeInstance application.
	DisplayName *string `json:"displayName,omitempty"`
	// EndpointURI - Application' endpoint URI.
	EndpointURI *string `json:"endpointUri,omitempty"`
}

// ComputeInstanceConnectivityEndpoints defines all connectivity endpoints and properties for an
// ComputeInstance.
type ComputeInstanceConnectivityEndpoints struct {
	// PublicIPAddress - READ-ONLY; Public IP Address of this ComputeInstance.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - READ-ONLY; Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceConnectivityEndpoints.
func (cice ComputeInstanceConnectivityEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComputeInstanceCreatedBy describes information on user who created this ComputeInstance.
type ComputeInstanceCreatedBy struct {
	// UserName - READ-ONLY; Name of the user.
	UserName *string `json:"userName,omitempty"`
	// UserOrgID - READ-ONLY; Uniquely identifies user' Azure Active Directory organization.
	UserOrgID *string `json:"userOrgId,omitempty"`
	// UserID - READ-ONLY; Uniquely identifies the user within his/her organization.
	UserID *string `json:"userId,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceCreatedBy.
func (cicb ComputeInstanceCreatedBy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComputeInstanceLastOperation the last operation on ComputeInstance.
type ComputeInstanceLastOperation struct {
	// OperationName - Name of the last operation. Possible values include: 'OperationNameCreate', 'OperationNameStart', 'OperationNameStop', 'OperationNameRestart', 'OperationNameReimage', 'OperationNameDelete'
	OperationName OperationName `json:"operationName,omitempty"`
	// OperationTime - Time of the last operation.
	OperationTime *date.Time `json:"operationTime,omitempty"`
	// OperationStatus - Operation status. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusCreateFailed', 'OperationStatusStartFailed', 'OperationStatusStopFailed', 'OperationStatusRestartFailed', 'OperationStatusReimageFailed', 'OperationStatusDeleteFailed'
	OperationStatus OperationStatus `json:"operationStatus,omitempty"`
}

// ComputeInstanceProperties compute Instance properties
type ComputeInstanceProperties struct {
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// Subnet - Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// ApplicationSharingPolicy - Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role. Possible values include: 'ApplicationSharingPolicyPersonal', 'ApplicationSharingPolicyShared'
	ApplicationSharingPolicy ApplicationSharingPolicy `json:"applicationSharingPolicy,omitempty"`
	// SSHSettings - Specifies policy and settings for SSH access.
	SSHSettings *ComputeInstanceSSHSettings `json:"sshSettings,omitempty"`
	// ConnectivityEndpoints - READ-ONLY; Describes all connectivity endpoints available for this ComputeInstance.
	ConnectivityEndpoints *ComputeInstanceConnectivityEndpoints `json:"connectivityEndpoints,omitempty"`
	// Applications - READ-ONLY; Describes available applications and their endpoints on this ComputeInstance.
	Applications *[]ComputeInstanceApplication `json:"applications,omitempty"`
	// CreatedBy - READ-ONLY; Describes information on user who created this ComputeInstance.
	CreatedBy *ComputeInstanceCreatedBy `json:"createdBy,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered on this ComputeInstance.
	Errors *[]ErrorResponse `json:"errors,omitempty"`
	// State - READ-ONLY; The current state of this ComputeInstance. Possible values include: 'ComputeInstanceStateCreating', 'ComputeInstanceStateCreateFailed', 'ComputeInstanceStateDeleting', 'ComputeInstanceStateRunning', 'ComputeInstanceStateRestarting', 'ComputeInstanceStateJobRunning', 'ComputeInstanceStateSettingUp', 'ComputeInstanceStateSetupFailed', 'ComputeInstanceStateStarting', 'ComputeInstanceStateStopped', 'ComputeInstanceStateStopping', 'ComputeInstanceStateUserSettingUp', 'ComputeInstanceStateUserSetupFailed', 'ComputeInstanceStateUnknown', 'ComputeInstanceStateUnusable'
	State ComputeInstanceState `json:"state,omitempty"`
	// ComputeInstanceAuthorizationType - The Compute Instance Authorization type. Available values are personal (default). Possible values include: 'ComputeInstanceAuthorizationTypePersonal'
	ComputeInstanceAuthorizationType ComputeInstanceAuthorizationType `json:"computeInstanceAuthorizationType,omitempty"`
	// PersonalComputeInstanceSettings - Settings for a personal compute instance.
	PersonalComputeInstanceSettings *PersonalComputeInstanceSettings `json:"personalComputeInstanceSettings,omitempty"`
	// SetupScripts - Details of customized scripts to execute for setting up the cluster.
	SetupScripts *SetupScripts `json:"setupScripts,omitempty"`
	// LastOperation - READ-ONLY; The last operation on ComputeInstance.
	LastOperation *ComputeInstanceLastOperation `json:"lastOperation,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceProperties.
func (cip ComputeInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.VMSize != nil {
		objectMap["vmSize"] = cip.VMSize
	}
	if cip.Subnet != nil {
		objectMap["subnet"] = cip.Subnet
	}
	if cip.ApplicationSharingPolicy != "" {
		objectMap["applicationSharingPolicy"] = cip.ApplicationSharingPolicy
	}
	if cip.SSHSettings != nil {
		objectMap["sshSettings"] = cip.SSHSettings
	}
	if cip.ComputeInstanceAuthorizationType != "" {
		objectMap["computeInstanceAuthorizationType"] = cip.ComputeInstanceAuthorizationType
	}
	if cip.PersonalComputeInstanceSettings != nil {
		objectMap["personalComputeInstanceSettings"] = cip.PersonalComputeInstanceSettings
	}
	if cip.SetupScripts != nil {
		objectMap["setupScripts"] = cip.SetupScripts
	}
	return json.Marshal(objectMap)
}

// ComputeInstanceSSHSettings specifies policy and settings for SSH access.
type ComputeInstanceSSHSettings struct {
	// SSHPublicAccess - State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable. Possible values include: 'SSHPublicAccessEnabled', 'SSHPublicAccessDisabled'
	SSHPublicAccess SSHPublicAccess `json:"sshPublicAccess,omitempty"`
	// AdminUserName - READ-ONLY; Describes the admin user name.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// SSHPort - READ-ONLY; Describes the port for connecting through SSH.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// AdminPublicKey - Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
	AdminPublicKey *string `json:"adminPublicKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceSSHSettings.
func (ciss ComputeInstanceSSHSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ciss.SSHPublicAccess != "" {
		objectMap["sshPublicAccess"] = ciss.SSHPublicAccess
	}
	if ciss.AdminPublicKey != nil {
		objectMap["adminPublicKey"] = ciss.AdminPublicKey
	}
	return json.Marshal(objectMap)
}

// ComputeResource machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	autorest.Response `json:"-"`
	// Properties - Compute properties
	Properties BasicCompute `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeResource.
func (cr ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = cr.Properties
	if cr.Identity != nil {
		objectMap["identity"] = cr.Identity
	}
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	if cr.Sku != nil {
		objectMap["sku"] = cr.Sku
	}
	if cr.SystemData != nil {
		objectMap["systemData"] = cr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComputeResource struct.
func (cr *ComputeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicCompute(*v)
				if err != nil {
					return err
				}
				cr.Properties = properties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cr.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		}
	}

	return nil
}

// ComputeRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ComputeRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeRestartFuture.Result.
func (future *ComputeRestartFuture) result(client ComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type BasicComputeSecrets interface {
	AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool)
	AsComputeSecrets() (*ComputeSecrets, bool)
}

// ComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	autorest.Response `json:"-"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

func unmarshalBasicComputeSecrets(body []byte) (BasicComputeSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine):
		var vms VirtualMachineSecrets
		err := json.Unmarshal(body, &vms)
		return vms, err
	default:
		var cs ComputeSecrets
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicComputeSecretsArray(body []byte) ([]BasicComputeSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicComputeSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicComputeSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ComputeSecrets.
func (cs ComputeSecrets) MarshalJSON() ([]byte, error) {
	cs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets
	objectMap := make(map[string]interface{})
	if cs.ComputeType != "" {
		objectMap["computeType"] = cs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return &cs, true
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &cs, true
}

// ComputeSecretsModel ...
type ComputeSecretsModel struct {
	autorest.Response `json:"-"`
	Value             BasicComputeSecrets `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ComputeSecretsModel struct.
func (csm *ComputeSecretsModel) UnmarshalJSON(body []byte) error {
	cs, err := unmarshalBasicComputeSecrets(body)
	if err != nil {
		return err
	}
	csm.Value = cs

	return nil
}

// ComputeStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ComputeStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeStartFuture.Result.
func (future *ComputeStartFuture) result(client ComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ComputeStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ComputeStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeStopFuture.Result.
func (future *ComputeStopFuture) result(client ComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ComputeUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ComputeUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ComputeClient) (ComputeResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ComputeUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ComputeUpdateFuture.Result.
func (future *ComputeUpdateFuture) result(client ComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.ComputeUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.UpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.ComputeUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainerResourceRequirements the resource requirements for the container (cpu and memory).
type ContainerResourceRequirements struct {
	// CPU - The minimum amount of CPU cores to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPU *float64 `json:"cpu,omitempty"`
	// CPULimit - The maximum amount of CPU cores allowed to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPULimit *float64 `json:"cpuLimit,omitempty"`
	// MemoryInGB - The minimum amount of memory (in GB) to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// MemoryInGBLimit - The maximum amount of memory (in GB) allowed to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGBLimit *float64 `json:"memoryInGBLimit,omitempty"`
	// Gpu - The number of GPU cores in the container.
	Gpu *int32 `json:"gpu,omitempty"`
	// Fpga - The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
	Fpga *int32 `json:"fpga,omitempty"`
}

// CosmosDbSettings ...
type CosmosDbSettings struct {
	// CollectionsThroughput - The throughput of the collections in cosmosdb database
	CollectionsThroughput *int32 `json:"collectionsThroughput,omitempty"`
}

// Databricks a DataFactory compute.
type Databricks struct {
	Properties *DatabricksProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for Databricks.
func (d Databricks) MarshalJSON() ([]byte, error) {
	d.ComputeType = ComputeTypeBasicComputeComputeTypeDatabricks
	objectMap := make(map[string]interface{})
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	if d.ComputeLocation != nil {
		objectMap["computeLocation"] = d.ComputeLocation
	}
	if d.Description != nil {
		objectMap["description"] = d.Description
	}
	if d.ResourceID != nil {
		objectMap["resourceId"] = d.ResourceID
	}
	if d.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = d.DisableLocalAuth
	}
	if d.ComputeType != "" {
		objectMap["computeType"] = d.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Databricks.
func (d Databricks) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for Databricks.
func (d Databricks) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Databricks.
func (d Databricks) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Databricks.
func (d Databricks) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Databricks.
func (d Databricks) AsDatabricks() (*Databricks, bool) {
	return &d, true
}

// AsDataLakeAnalytics is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for Databricks.
func (d Databricks) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsBasicCompute() (BasicCompute, bool) {
	return &d, true
}

// DatabricksComputeSecrets secrets related to a Machine Learning compute based on Databricks.
type DatabricksComputeSecrets struct {
	// ComputeType - The type of compute. Possible values include: 'ComputeTypeAKS', 'ComputeTypeKubernetes', 'ComputeTypeAmlCompute', 'ComputeTypeComputeInstance', 'ComputeTypeDataFactory', 'ComputeTypeVirtualMachine', 'ComputeTypeHDInsight', 'ComputeTypeDatabricks', 'ComputeTypeDataLakeAnalytics', 'ComputeTypeSynapseSpark'
	ComputeType ComputeType `json:"computeType,omitempty"`
	// DatabricksAccessToken - access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
}

// DatabricksComputeSecretsProperties properties of Databricks Compute Secrets
type DatabricksComputeSecretsProperties struct {
	// DatabricksAccessToken - access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
}

// DatabricksProperties properties of Databricks
type DatabricksProperties struct {
	// DatabricksAccessToken - Databricks access token
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
	// WorkspaceURL - Workspace Url
	WorkspaceURL *string `json:"workspaceUrl,omitempty"`
}

// DataFactory a DataFactory compute.
type DataFactory struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataFactory.
func (df DataFactory) MarshalJSON() ([]byte, error) {
	df.ComputeType = ComputeTypeBasicComputeComputeTypeDataFactory
	objectMap := make(map[string]interface{})
	if df.ComputeLocation != nil {
		objectMap["computeLocation"] = df.ComputeLocation
	}
	if df.Description != nil {
		objectMap["description"] = df.Description
	}
	if df.ResourceID != nil {
		objectMap["resourceId"] = df.ResourceID
	}
	if df.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = df.DisableLocalAuth
	}
	if df.ComputeType != "" {
		objectMap["computeType"] = df.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataFactory() (*DataFactory, bool) {
	return &df, true
}

// AsDatabricks is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsBasicCompute() (BasicCompute, bool) {
	return &df, true
}

// DataLakeAnalytics a DataLakeAnalytics compute.
type DataLakeAnalytics struct {
	Properties *DataLakeAnalyticsProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalytics.
func (dla DataLakeAnalytics) MarshalJSON() ([]byte, error) {
	dla.ComputeType = ComputeTypeBasicComputeComputeTypeDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if dla.Properties != nil {
		objectMap["properties"] = dla.Properties
	}
	if dla.ComputeLocation != nil {
		objectMap["computeLocation"] = dla.ComputeLocation
	}
	if dla.Description != nil {
		objectMap["description"] = dla.Description
	}
	if dla.ResourceID != nil {
		objectMap["resourceId"] = dla.ResourceID
	}
	if dla.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = dla.DisableLocalAuth
	}
	if dla.ComputeType != "" {
		objectMap["computeType"] = dla.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return &dla, true
}

// AsSynapseSpark is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsBasicCompute() (BasicCompute, bool) {
	return &dla, true
}

// DataLakeAnalyticsProperties ...
type DataLakeAnalyticsProperties struct {
	// DataLakeStoreAccountName - DataLake Store Account Name
	DataLakeStoreAccountName *string `json:"dataLakeStoreAccountName,omitempty"`
}

// DiagnoseRequestProperties ...
type DiagnoseRequestProperties struct {
	// Udr - Setting for diagnosing user defined routing
	Udr map[string]interface{} `json:"udr"`
	// Nsg - Setting for diagnosing network security group
	Nsg map[string]interface{} `json:"nsg"`
	// ResourceLock - Setting for diagnosing resource lock
	ResourceLock map[string]interface{} `json:"resourceLock"`
	// DNSResolution - Setting for diagnosing dns resolution
	DNSResolution map[string]interface{} `json:"dnsResolution"`
	// StorageAccount - Setting for diagnosing dependent storage account
	StorageAccount map[string]interface{} `json:"storageAccount"`
	// KeyVault - Setting for diagnosing dependent key vault
	KeyVault map[string]interface{} `json:"keyVault"`
	// ContainerRegistry - Setting for diagnosing dependent container registry
	ContainerRegistry map[string]interface{} `json:"containerRegistry"`
	// ApplicationInsights - Setting for diagnosing dependent application insights
	ApplicationInsights map[string]interface{} `json:"applicationInsights"`
	// Others - Setting for diagnosing unclassified category of problems
	Others map[string]interface{} `json:"others"`
}

// MarshalJSON is the custom marshaler for DiagnoseRequestProperties.
func (drp DiagnoseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drp.Udr != nil {
		objectMap["udr"] = drp.Udr
	}
	if drp.Nsg != nil {
		objectMap["nsg"] = drp.Nsg
	}
	if drp.ResourceLock != nil {
		objectMap["resourceLock"] = drp.ResourceLock
	}
	if drp.DNSResolution != nil {
		objectMap["dnsResolution"] = drp.DNSResolution
	}
	if drp.StorageAccount != nil {
		objectMap["storageAccount"] = drp.StorageAccount
	}
	if drp.KeyVault != nil {
		objectMap["keyVault"] = drp.KeyVault
	}
	if drp.ContainerRegistry != nil {
		objectMap["containerRegistry"] = drp.ContainerRegistry
	}
	if drp.ApplicationInsights != nil {
		objectMap["applicationInsights"] = drp.ApplicationInsights
	}
	if drp.Others != nil {
		objectMap["others"] = drp.Others
	}
	return json.Marshal(objectMap)
}

// DiagnoseResponseResult ...
type DiagnoseResponseResult struct {
	autorest.Response `json:"-"`
	Value             *DiagnoseResponseResultValue `json:"value,omitempty"`
}

// DiagnoseResponseResultValue ...
type DiagnoseResponseResultValue struct {
	UserDefinedRouteResults    *[]DiagnoseResult `json:"userDefinedRouteResults,omitempty"`
	NetworkSecurityRuleResults *[]DiagnoseResult `json:"networkSecurityRuleResults,omitempty"`
	ResourceLockResults        *[]DiagnoseResult `json:"resourceLockResults,omitempty"`
	DNSResolutionResults       *[]DiagnoseResult `json:"dnsResolutionResults,omitempty"`
	StorageAccountResults      *[]DiagnoseResult `json:"storageAccountResults,omitempty"`
	KeyVaultResults            *[]DiagnoseResult `json:"keyVaultResults,omitempty"`
	ContainerRegistryResults   *[]DiagnoseResult `json:"containerRegistryResults,omitempty"`
	ApplicationInsightsResults *[]DiagnoseResult `json:"applicationInsightsResults,omitempty"`
	OtherResults               *[]DiagnoseResult `json:"otherResults,omitempty"`
}

// DiagnoseResult result of Diagnose
type DiagnoseResult struct {
	// Code - READ-ONLY; Code for workspace setup error
	Code *string `json:"code,omitempty"`
	// Level - READ-ONLY; Level of workspace setup error. Possible values include: 'DiagnoseResultLevelWarning', 'DiagnoseResultLevelError', 'DiagnoseResultLevelInformation'
	Level DiagnoseResultLevel `json:"level,omitempty"`
	// Message - READ-ONLY; Message of workspace setup error
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnoseResult.
func (dr DiagnoseResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DiagnoseWorkspaceParameters parameters to diagnose a workspace
type DiagnoseWorkspaceParameters struct {
	// Value - Value of Parameters
	Value *DiagnoseRequestProperties `json:"value,omitempty"`
}

// EncryptionProperty ...
type EncryptionProperty struct {
	// Status - Indicates whether or not the encryption is enabled for the workspace. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	Status EncryptionStatus `json:"status,omitempty"`
	// Identity - The identity that will be used to access the key vault for encryption at rest.
	Identity *IdentityForCmk `json:"identity,omitempty"`
	// KeyVaultProperties - Customer Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EstimatedVMPrice the estimated price info for using a VM of a particular OS type, tier, etc.
type EstimatedVMPrice struct {
	// RetailPrice - The price charged for using the VM.
	RetailPrice *float64 `json:"retailPrice,omitempty"`
	// OsType - Operating system type used by the VM. Possible values include: 'VMPriceOSTypeLinux', 'VMPriceOSTypeWindows'
	OsType VMPriceOSType `json:"osType,omitempty"`
	// VMTier - The type of the VM. Possible values include: 'VMTierStandard', 'VMTierLowPriority', 'VMTierSpot'
	VMTier VMTier `json:"vmTier,omitempty"`
}

// EstimatedVMPrices the estimated price info for using a VM.
type EstimatedVMPrices struct {
	// BillingCurrency - Three lettered code specifying the currency of the VM price. Example: USD
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// UnitOfMeasure - The unit of time measurement for the specified VM price. Example: OneHour
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// Values - The list of estimated prices for using a VM of a particular OS type, tier, etc.
	Values *[]EstimatedVMPrice `json:"values,omitempty"`
}

// ExternalFQDNResponse ...
type ExternalFQDNResponse struct {
	autorest.Response `json:"-"`
	Value             *[]FQDNEndpoints `json:"value,omitempty"`
}

// FQDNEndpoint ...
type FQDNEndpoint struct {
	DomainName      *string               `json:"domainName,omitempty"`
	EndpointDetails *[]FQDNEndpointDetail `json:"endpointDetails,omitempty"`
}

// FQDNEndpointDetail ...
type FQDNEndpointDetail struct {
	Port *int32 `json:"port,omitempty"`
}

// FQDNEndpoints ...
type FQDNEndpoints struct {
	Properties *FQDNEndpointsProperties `json:"properties,omitempty"`
}

// FQDNEndpointsProperties ...
type FQDNEndpointsProperties struct {
	Category  *string         `json:"category,omitempty"`
	Endpoints *[]FQDNEndpoint `json:"endpoints,omitempty"`
}

// HDInsight a HDInsight compute.
type HDInsight struct {
	Properties *HDInsightProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for HDInsight.
func (hi HDInsight) MarshalJSON() ([]byte, error) {
	hi.ComputeType = ComputeTypeBasicComputeComputeTypeHDInsight
	objectMap := make(map[string]interface{})
	if hi.Properties != nil {
		objectMap["properties"] = hi.Properties
	}
	if hi.ComputeLocation != nil {
		objectMap["computeLocation"] = hi.ComputeLocation
	}
	if hi.Description != nil {
		objectMap["description"] = hi.Description
	}
	if hi.ResourceID != nil {
		objectMap["resourceId"] = hi.ResourceID
	}
	if hi.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = hi.DisableLocalAuth
	}
	if hi.ComputeType != "" {
		objectMap["computeType"] = hi.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsHDInsight() (*HDInsight, bool) {
	return &hi, true
}

// AsDataFactory is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsBasicCompute() (BasicCompute, bool) {
	return &hi, true
}

// HDInsightProperties hDInsight compute properties
type HDInsightProperties struct {
	// SSHPort - Port open for ssh connections on the master node of the cluster.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the master node of the cluster.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The user assigned identities associated with the resource.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IdentityForCmk identity that will be used to access key vault for encryption at rest
type IdentityForCmk struct {
	// UserAssignedIdentity - The ArmId of the user assigned identity that will be used to access the customer managed key vault
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// InstanceTypeSchema instance type schema.
type InstanceTypeSchema struct {
	// NodeSelector - Node Selector
	NodeSelector map[string]*string `json:"nodeSelector"`
	// Resources - Resource requests/limits for this instance type
	Resources *InstanceTypeSchemaResources `json:"resources,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceTypeSchema.
func (its InstanceTypeSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if its.NodeSelector != nil {
		objectMap["nodeSelector"] = its.NodeSelector
	}
	if its.Resources != nil {
		objectMap["resources"] = its.Resources
	}
	return json.Marshal(objectMap)
}

// InstanceTypeSchemaResources resource requests/limits for this instance type
type InstanceTypeSchemaResources struct {
	// Requests - Resource requests for this instance type
	Requests map[string]*string `json:"requests"`
	// Limits - Resource limits for this instance type
	Limits map[string]*string `json:"limits"`
}

// MarshalJSON is the custom marshaler for InstanceTypeSchemaResources.
func (its InstanceTypeSchemaResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if its.Requests != nil {
		objectMap["requests"] = its.Requests
	}
	if its.Limits != nil {
		objectMap["limits"] = its.Limits
	}
	return json.Marshal(objectMap)
}

// KeyVaultProperties ...
type KeyVaultProperties struct {
	// KeyVaultArmID - The ArmId of the keyVault where the customer owned encryption key is present.
	KeyVaultArmID *string `json:"keyVaultArmId,omitempty"`
	// KeyIdentifier - Key vault uri to access the encryption key.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// IdentityClientID - For future use - The client id of the identity which will be used to access key vault.
	IdentityClientID *string `json:"identityClientId,omitempty"`
}

// Kubernetes a Machine Learning compute based on Kubernetes Compute.
type Kubernetes struct {
	// ComputeType - The type of compute. Possible values include: 'ComputeTypeAKS', 'ComputeTypeKubernetes', 'ComputeTypeAmlCompute', 'ComputeTypeComputeInstance', 'ComputeTypeDataFactory', 'ComputeTypeVirtualMachine', 'ComputeTypeHDInsight', 'ComputeTypeDatabricks', 'ComputeTypeDataLakeAnalytics', 'ComputeTypeSynapseSpark'
	ComputeType ComputeType `json:"computeType,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// Properties - Properties of Kubernetes
	Properties *KubernetesProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Kubernetes.
func (kVar Kubernetes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kVar.ComputeType != "" {
		objectMap["computeType"] = kVar.ComputeType
	}
	if kVar.ComputeLocation != nil {
		objectMap["computeLocation"] = kVar.ComputeLocation
	}
	if kVar.Description != nil {
		objectMap["description"] = kVar.Description
	}
	if kVar.ResourceID != nil {
		objectMap["resourceId"] = kVar.ResourceID
	}
	if kVar.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = kVar.DisableLocalAuth
	}
	if kVar.Properties != nil {
		objectMap["properties"] = kVar.Properties
	}
	return json.Marshal(objectMap)
}

// KubernetesProperties kubernetes properties
type KubernetesProperties struct {
	// RelayConnectionString - Relay connection string.
	RelayConnectionString *string `json:"relayConnectionString,omitempty"`
	// ServiceBusConnectionString - ServiceBus connection string.
	ServiceBusConnectionString *string `json:"serviceBusConnectionString,omitempty"`
	// ExtensionPrincipalID - Extension principal-id.
	ExtensionPrincipalID *string `json:"extensionPrincipalId,omitempty"`
	// ExtensionInstanceReleaseTrain - Extension instance release train.
	ExtensionInstanceReleaseTrain *string `json:"extensionInstanceReleaseTrain,omitempty"`
	// VcName - VC name.
	VcName *string `json:"vcName,omitempty"`
	// Namespace - Compute namespace
	Namespace *string `json:"namespace,omitempty"`
	// DefaultInstanceType - Default instance type
	DefaultInstanceType *string `json:"defaultInstanceType,omitempty"`
	// InstanceTypes - Instance Type Schema
	InstanceTypes map[string]*InstanceTypeSchema `json:"instanceTypes"`
}

// MarshalJSON is the custom marshaler for KubernetesProperties.
func (kp KubernetesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kp.RelayConnectionString != nil {
		objectMap["relayConnectionString"] = kp.RelayConnectionString
	}
	if kp.ServiceBusConnectionString != nil {
		objectMap["serviceBusConnectionString"] = kp.ServiceBusConnectionString
	}
	if kp.ExtensionPrincipalID != nil {
		objectMap["extensionPrincipalId"] = kp.ExtensionPrincipalID
	}
	if kp.ExtensionInstanceReleaseTrain != nil {
		objectMap["extensionInstanceReleaseTrain"] = kp.ExtensionInstanceReleaseTrain
	}
	if kp.VcName != nil {
		objectMap["vcName"] = kp.VcName
	}
	if kp.Namespace != nil {
		objectMap["namespace"] = kp.Namespace
	}
	if kp.DefaultInstanceType != nil {
		objectMap["defaultInstanceType"] = kp.DefaultInstanceType
	}
	if kp.InstanceTypes != nil {
		objectMap["instanceTypes"] = kp.InstanceTypes
	}
	return json.Marshal(objectMap)
}

// KubernetesSchema kubernetes Compute Schema
type KubernetesSchema struct {
	// Properties - Properties of Kubernetes
	Properties *KubernetesProperties `json:"properties,omitempty"`
}

// ListAmlUserFeatureResult the List Aml user feature operation response.
type ListAmlUserFeatureResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of AML user facing features.
	Value *[]AmlUserFeature `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next page of AML user features information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListAmlUserFeatureResult.
func (laufr ListAmlUserFeatureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListAmlUserFeatureResultIterator provides access to a complete listing of AmlUserFeature values.
type ListAmlUserFeatureResultIterator struct {
	i    int
	page ListAmlUserFeatureResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListAmlUserFeatureResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListAmlUserFeatureResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListAmlUserFeatureResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListAmlUserFeatureResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListAmlUserFeatureResultIterator) Response() ListAmlUserFeatureResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListAmlUserFeatureResultIterator) Value() AmlUserFeature {
	if !iter.page.NotDone() {
		return AmlUserFeature{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListAmlUserFeatureResultIterator type.
func NewListAmlUserFeatureResultIterator(page ListAmlUserFeatureResultPage) ListAmlUserFeatureResultIterator {
	return ListAmlUserFeatureResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (laufr ListAmlUserFeatureResult) IsEmpty() bool {
	return laufr.Value == nil || len(*laufr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (laufr ListAmlUserFeatureResult) hasNextLink() bool {
	return laufr.NextLink != nil && len(*laufr.NextLink) != 0
}

// listAmlUserFeatureResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (laufr ListAmlUserFeatureResult) listAmlUserFeatureResultPreparer(ctx context.Context) (*http.Request, error) {
	if !laufr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(laufr.NextLink)))
}

// ListAmlUserFeatureResultPage contains a page of AmlUserFeature values.
type ListAmlUserFeatureResultPage struct {
	fn    func(context.Context, ListAmlUserFeatureResult) (ListAmlUserFeatureResult, error)
	laufr ListAmlUserFeatureResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListAmlUserFeatureResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListAmlUserFeatureResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.laufr)
		if err != nil {
			return err
		}
		page.laufr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListAmlUserFeatureResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListAmlUserFeatureResultPage) NotDone() bool {
	return !page.laufr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListAmlUserFeatureResultPage) Response() ListAmlUserFeatureResult {
	return page.laufr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListAmlUserFeatureResultPage) Values() []AmlUserFeature {
	if page.laufr.IsEmpty() {
		return nil
	}
	return *page.laufr.Value
}

// Creates a new instance of the ListAmlUserFeatureResultPage type.
func NewListAmlUserFeatureResultPage(cur ListAmlUserFeatureResult, getNextPage func(context.Context, ListAmlUserFeatureResult) (ListAmlUserFeatureResult, error)) ListAmlUserFeatureResultPage {
	return ListAmlUserFeatureResultPage{
		fn:    getNextPage,
		laufr: cur,
	}
}

// ListNotebookKeysResult ...
type ListNotebookKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryAccessKey - READ-ONLY
	PrimaryAccessKey *string `json:"primaryAccessKey,omitempty"`
	// SecondaryAccessKey - READ-ONLY
	SecondaryAccessKey *string `json:"secondaryAccessKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ListNotebookKeysResult.
func (lnkr ListNotebookKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListStorageAccountKeysResult ...
type ListStorageAccountKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ListStorageAccountKeysResult.
func (lsakr ListStorageAccountKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of AML resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next page of AML resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListUsagesResult.
func (lur ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lur ListUsagesResult) hasNextLink() bool {
	return lur.NextLink != nil && len(*lur.NextLink) != 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lur.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lur)
		if err != nil {
			return err
		}
		page.lur = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{
		fn:  getNextPage,
		lur: cur,
	}
}

// ListWorkspaceKeysResult ...
type ListWorkspaceKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
	// UserStorageResourceID - READ-ONLY
	UserStorageResourceID *string `json:"userStorageResourceId,omitempty"`
	// AppInsightsInstrumentationKey - READ-ONLY
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`
	// ContainerRegistryCredentials - READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult `json:"containerRegistryCredentials,omitempty"`
	// NotebookAccessKeys - READ-ONLY
	NotebookAccessKeys *ListNotebookKeysResult `json:"notebookAccessKeys,omitempty"`
}

// MarshalJSON is the custom marshaler for ListWorkspaceKeysResult.
func (lwkr ListWorkspaceKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListWorkspaceQuotas the List WorkspaceQuotasByVMFamily operation response.
type ListWorkspaceQuotas struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Workspace Quotas by VM Family
	Value *[]ResourceQuota `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch the next page of Workspace Quota information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListWorkspaceQuotas.
func (lwq ListWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListWorkspaceQuotasIterator provides access to a complete listing of ResourceQuota values.
type ListWorkspaceQuotasIterator struct {
	i    int
	page ListWorkspaceQuotasPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListWorkspaceQuotasIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListWorkspaceQuotasIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListWorkspaceQuotasIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListWorkspaceQuotasIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListWorkspaceQuotasIterator) Response() ListWorkspaceQuotas {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListWorkspaceQuotasIterator) Value() ResourceQuota {
	if !iter.page.NotDone() {
		return ResourceQuota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListWorkspaceQuotasIterator type.
func NewListWorkspaceQuotasIterator(page ListWorkspaceQuotasPage) ListWorkspaceQuotasIterator {
	return ListWorkspaceQuotasIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lwq ListWorkspaceQuotas) IsEmpty() bool {
	return lwq.Value == nil || len(*lwq.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lwq ListWorkspaceQuotas) hasNextLink() bool {
	return lwq.NextLink != nil && len(*lwq.NextLink) != 0
}

// listWorkspaceQuotasPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lwq ListWorkspaceQuotas) listWorkspaceQuotasPreparer(ctx context.Context) (*http.Request, error) {
	if !lwq.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lwq.NextLink)))
}

// ListWorkspaceQuotasPage contains a page of ResourceQuota values.
type ListWorkspaceQuotasPage struct {
	fn  func(context.Context, ListWorkspaceQuotas) (ListWorkspaceQuotas, error)
	lwq ListWorkspaceQuotas
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListWorkspaceQuotasPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListWorkspaceQuotasPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lwq)
		if err != nil {
			return err
		}
		page.lwq = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListWorkspaceQuotasPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListWorkspaceQuotasPage) NotDone() bool {
	return !page.lwq.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListWorkspaceQuotasPage) Response() ListWorkspaceQuotas {
	return page.lwq
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListWorkspaceQuotasPage) Values() []ResourceQuota {
	if page.lwq.IsEmpty() {
		return nil
	}
	return *page.lwq.Value
}

// Creates a new instance of the ListWorkspaceQuotasPage type.
func NewListWorkspaceQuotasPage(cur ListWorkspaceQuotas, getNextPage func(context.Context, ListWorkspaceQuotas) (ListWorkspaceQuotas, error)) ListWorkspaceQuotasPage {
	return ListWorkspaceQuotasPage{
		fn:  getNextPage,
		lwq: cur,
	}
}

// NodeStateCounts counts of various compute node states on the amlCompute.
type NodeStateCounts struct {
	// IdleNodeCount - READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32 `json:"idleNodeCount,omitempty"`
	// RunningNodeCount - READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32 `json:"runningNodeCount,omitempty"`
	// PreparingNodeCount - READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty"`
	// UnusableNodeCount - READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32 `json:"unusableNodeCount,omitempty"`
	// LeavingNodeCount - READ-ONLY; Number of compute nodes which are leaving the amlCompute.
	LeavingNodeCount *int32 `json:"leavingNodeCount,omitempty"`
	// PreemptedNodeCount - READ-ONLY; Number of compute nodes which are in preempted state.
	PreemptedNodeCount *int32 `json:"preemptedNodeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeStateCounts.
func (nsc NodeStateCounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NotebookAccessTokenResult ...
type NotebookAccessTokenResult struct {
	autorest.Response `json:"-"`
	// NotebookResourceID - READ-ONLY
	NotebookResourceID *string `json:"notebookResourceId,omitempty"`
	// HostName - READ-ONLY
	HostName *string `json:"hostName,omitempty"`
	// PublicDNS - READ-ONLY
	PublicDNS *string `json:"publicDns,omitempty"`
	// AccessToken - READ-ONLY
	AccessToken *string `json:"accessToken,omitempty"`
	// TokenType - READ-ONLY
	TokenType *string `json:"tokenType,omitempty"`
	// ExpiresIn - READ-ONLY
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
	// RefreshToken - READ-ONLY
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - READ-ONLY
	Scope *string `json:"scope,omitempty"`
}

// MarshalJSON is the custom marshaler for NotebookAccessTokenResult.
func (natr NotebookAccessTokenResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NotebookPreparationError ...
type NotebookPreparationError struct {
	ErrorMessage *string `json:"errorMessage,omitempty"`
	StatusCode   *int32  `json:"statusCode,omitempty"`
}

// NotebookResourceInfo ...
type NotebookResourceInfo struct {
	autorest.Response `json:"-"`
	Fqdn              *string `json:"fqdn,omitempty"`
	// ResourceID - the data plane resourceId that used to initialize notebook component
	ResourceID *string `json:"resourceId,omitempty"`
	// NotebookPreparationError - The error that occurs when preparing notebook.
	NotebookPreparationError *NotebookPreparationError `json:"notebookPreparationError,omitempty"`
}

// Operation azure Machine Learning workspace REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display name of operation
type OperationDisplay struct {
	// Provider - The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult an array of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of AML workspace operations supported by the AML workspace resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// PaginatedComputeResourcesList paginated list of Machine Learning compute objects wrapped in ARM resource
// envelope.
type PaginatedComputeResourcesList struct {
	autorest.Response `json:"-"`
	// Value - An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value *[]ComputeResource `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaginatedComputeResourcesListIterator provides access to a complete listing of ComputeResource values.
type PaginatedComputeResourcesListIterator struct {
	i    int
	page PaginatedComputeResourcesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedComputeResourcesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedComputeResourcesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedComputeResourcesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedComputeResourcesListIterator) Response() PaginatedComputeResourcesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedComputeResourcesListIterator) Value() ComputeResource {
	if !iter.page.NotDone() {
		return ComputeResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedComputeResourcesListIterator type.
func NewPaginatedComputeResourcesListIterator(page PaginatedComputeResourcesListPage) PaginatedComputeResourcesListIterator {
	return PaginatedComputeResourcesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl PaginatedComputeResourcesList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcrl PaginatedComputeResourcesList) hasNextLink() bool {
	return pcrl.NextLink != nil && len(*pcrl.NextLink) != 0
}

// paginatedComputeResourcesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl PaginatedComputeResourcesList) paginatedComputeResourcesListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// PaginatedComputeResourcesListPage contains a page of ComputeResource values.
type PaginatedComputeResourcesListPage struct {
	fn   func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)
	pcrl PaginatedComputeResourcesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedComputeResourcesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcrl)
		if err != nil {
			return err
		}
		page.pcrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedComputeResourcesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedComputeResourcesListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedComputeResourcesListPage) Response() PaginatedComputeResourcesList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedComputeResourcesListPage) Values() []ComputeResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the PaginatedComputeResourcesListPage type.
func NewPaginatedComputeResourcesListPage(cur PaginatedComputeResourcesList, getNextPage func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)) PaginatedComputeResourcesListPage {
	return PaginatedComputeResourcesListPage{
		fn:   getNextPage,
		pcrl: cur,
	}
}

// PaginatedWorkspaceConnectionsList paginated list of Workspace connection objects.
type PaginatedWorkspaceConnectionsList struct {
	autorest.Response `json:"-"`
	// Value - An array of Workspace connection objects.
	Value *[]WorkspaceConnection `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// Password ...
type Password struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Password.
func (p Password) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PersonalComputeInstanceSettings settings for a personal compute instance.
type PersonalComputeInstanceSettings struct {
	// AssignedUser - A user explicitly assigned to a personal compute instance.
	AssignedUser *AssignedUser `json:"assignedUser,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
	// SubnetArmID - READ-ONLY; The ARM identifier for Subnet resource that private endpoint links to
	SubnetArmID *string `json:"subnetArmId,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	if pec.Identity != nil {
		objectMap["identity"] = pec.Identity
	}
	if pec.Location != nil {
		objectMap["location"] = pec.Location
	}
	if pec.Tags != nil {
		objectMap["tags"] = pec.Tags
	}
	if pec.Sku != nil {
		objectMap["sku"] = pec.Sku
	}
	if pec.SystemData != nil {
		objectMap["systemData"] = pec.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				pec.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pec.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pec.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pec.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// workspace
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	if plr.Identity != nil {
		objectMap["identity"] = plr.Identity
	}
	if plr.Location != nil {
		objectMap["location"] = plr.Location
	}
	if plr.Tags != nil {
		objectMap["tags"] = plr.Tags
	}
	if plr.Sku != nil {
		objectMap["sku"] = plr.Sku
	}
	if plr.SystemData != nil {
		objectMap["systemData"] = plr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				plr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				plr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				plr.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected', 'PrivateEndpointServiceConnectionStatusDisconnected', 'PrivateEndpointServiceConnectionStatusTimeout'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QuotaBaseProperties the properties for Quota update or retrieval.
type QuotaBaseProperties struct {
	// ID - Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Limit - The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
}

// QuotaUpdateParameters quota update parameters.
type QuotaUpdateParameters struct {
	// Value - The list for update quota.
	Value *[]QuotaBaseProperties `json:"value,omitempty"`
	// Location - Region of workspace quota to be updated.
	Location *string `json:"location,omitempty"`
}

// RegistryListCredentialsResult ...
type RegistryListCredentialsResult struct {
	// Location - READ-ONLY
	Location *string `json:"location,omitempty"`
	// Username - READ-ONLY
	Username  *string     `json:"username,omitempty"`
	Passwords *[]Password `json:"passwords,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryListCredentialsResult.
func (rlcr RegistryListCredentialsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rlcr.Passwords != nil {
		objectMap["passwords"] = rlcr.Passwords
	}
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceID represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ResourceName the Resource Name.
type ResourceName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceName.
func (rn ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceQuota the quota assigned to a resource.
type ResourceQuota struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// AmlWorkspaceLocation - READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of the resource.
	Name *ResourceName `json:"name,omitempty"`
	// Limit - READ-ONLY; The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceQuota.
func (rq ResourceQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuLocationInfo ...
type ResourceSkuLocationInfo struct {
	// Location - READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuLocationInfo.
func (rsli ResourceSkuLocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuZoneDetails describes The zonal capabilities of a SKU.
type ResourceSkuZoneDetails struct {
	// Name - READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuZoneDetails.
func (rszd ResourceSkuZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Restriction the restriction because of which SKU cannot be used.
type Restriction struct {
	// Type - READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for the restriction. Possible values include: 'ReasonCodeNotSpecified', 'ReasonCodeNotAvailableForRegion', 'ReasonCodeNotAvailableForSubscription'
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReasonCode != "" {
		objectMap["reasonCode"] = r.ReasonCode
	}
	return json.Marshal(objectMap)
}

// ScaleSettings scale settings for AML Compute
type ScaleSettings struct {
	// MaxNodeCount - Max number of nodes to use
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
	// MinNodeCount - Min number of nodes to use
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// NodeIdleTimeBeforeScaleDown - Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
	NodeIdleTimeBeforeScaleDown *string `json:"nodeIdleTimeBeforeScaleDown,omitempty"`
}

// ScaleSettingsInformation desired scale settings for the amlCompute.
type ScaleSettingsInformation struct {
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// ScriptReference script reference
type ScriptReference struct {
	// ScriptSource - The storage source of the script: inline, workspace.
	ScriptSource *string `json:"scriptSource,omitempty"`
	// ScriptData - The location of scripts in the mounted volume.
	ScriptData *string `json:"scriptData,omitempty"`
	// ScriptArguments - Optional command line arguments passed to the script to run.
	ScriptArguments *string `json:"scriptArguments,omitempty"`
	// Timeout - Optional time period passed to timeout command.
	Timeout *string `json:"timeout,omitempty"`
}

// ScriptsToExecute customized setup scripts
type ScriptsToExecute struct {
	// StartupScript - Script that's run every time the machine starts.
	StartupScript *ScriptReference `json:"startupScript,omitempty"`
	// CreationScript - Script that's run only once during provision of the compute.
	CreationScript *ScriptReference `json:"creationScript,omitempty"`
}

// ServiceManagedResourcesSettings ...
type ServiceManagedResourcesSettings struct {
	// CosmosDb - The settings for the service managed cosmosdb account.
	CosmosDb *CosmosDbSettings `json:"cosmosDb,omitempty"`
}

// ServicePrincipalCredentials service principal credentials.
type ServicePrincipalCredentials struct {
	// ClientID - Client Id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// SetupScripts details of customized scripts to execute for setting up the cluster.
type SetupScripts struct {
	// Scripts - Customized setup scripts
	Scripts *ScriptsToExecute `json:"scripts,omitempty"`
}

// SharedPrivateLinkResource ...
type SharedPrivateLinkResource struct {
	// Name - Unique name of the private link.
	Name *string `json:"name,omitempty"`
	// SharedPrivateLinkResourceProperty - Resource properties.
	*SharedPrivateLinkResourceProperty `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedPrivateLinkResource.
func (splr SharedPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splr.Name != nil {
		objectMap["name"] = splr.Name
	}
	if splr.SharedPrivateLinkResourceProperty != nil {
		objectMap["properties"] = splr.SharedPrivateLinkResourceProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedPrivateLinkResource struct.
func (splr *SharedPrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				splr.Name = &name
			}
		case "properties":
			if v != nil {
				var sharedPrivateLinkResourceProperty SharedPrivateLinkResourceProperty
				err = json.Unmarshal(*v, &sharedPrivateLinkResourceProperty)
				if err != nil {
					return err
				}
				splr.SharedPrivateLinkResourceProperty = &sharedPrivateLinkResourceProperty
			}
		}
	}

	return nil
}

// SharedPrivateLinkResourceProperty properties of a shared private link resource.
type SharedPrivateLinkResourceProperty struct {
	// PrivateLinkResourceID - The resource id that private link links to.
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// GroupID - The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequestMessage - Request message.
	RequestMessage *string `json:"requestMessage,omitempty"`
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected', 'PrivateEndpointServiceConnectionStatusDisconnected', 'PrivateEndpointServiceConnectionStatusTimeout'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Sku sku of the resource
type Sku struct {
	// Name - Name of the sku
	Name *string `json:"name,omitempty"`
	// Tier - Tier of the sku like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
}

// SKUCapability features/user capabilities associated with the sku
type SKUCapability struct {
	// Name - Capability/Feature ID
	Name *string `json:"name,omitempty"`
	// Value - Details about the feature/capability
	Value *string `json:"value,omitempty"`
}

// SkuListResult list of skus with features
type SkuListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkspaceSku `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of Workspace Skus. Call ListNext() with this URI to fetch the next page of Workspace Skus
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuListResultIterator provides access to a complete listing of WorkspaceSku values.
type SkuListResultIterator struct {
	i    int
	page SkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuListResultIterator) Response() SkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuListResultIterator) Value() WorkspaceSku {
	if !iter.page.NotDone() {
		return WorkspaceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuListResultIterator type.
func NewSkuListResultIterator(page SkuListResultPage) SkuListResultIterator {
	return SkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SkuListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SkuListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// skuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SkuListResult) skuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SkuListResultPage contains a page of WorkspaceSku values.
type SkuListResultPage struct {
	fn  func(context.Context, SkuListResult) (SkuListResult, error)
	slr SkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuListResultPage) Response() SkuListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuListResultPage) Values() []WorkspaceSku {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SkuListResultPage type.
func NewSkuListResultPage(cur SkuListResult, getNextPage func(context.Context, SkuListResult) (SkuListResult, error)) SkuListResultPage {
	return SkuListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SslConfiguration the ssl configuration for scoring
type SslConfiguration struct {
	// Status - Enable or disable ssl for scoring. Possible values include: 'Status1Disabled', 'Status1Enabled', 'Status1Auto'
	Status Status1 `json:"status,omitempty"`
	// Cert - Cert data
	Cert *string `json:"cert,omitempty"`
	// Key - Key data
	Key *string `json:"key,omitempty"`
	// Cname - CNAME of the cert
	Cname *string `json:"cname,omitempty"`
	// LeafDomainLabel - Leaf domain label of public endpoint
	LeafDomainLabel *string `json:"leafDomainLabel,omitempty"`
	// OverwriteExistingDomain - Indicates whether to overwrite existing domain label.
	OverwriteExistingDomain *bool `json:"overwriteExistingDomain,omitempty"`
}

// SynapseSpark a SynapseSpark compute.
type SynapseSpark struct {
	Properties *SynapseSparkProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for SynapseSpark.
func (ss SynapseSpark) MarshalJSON() ([]byte, error) {
	ss.ComputeType = ComputeTypeBasicComputeComputeTypeSynapseSpark
	objectMap := make(map[string]interface{})
	if ss.Properties != nil {
		objectMap["properties"] = ss.Properties
	}
	if ss.ComputeLocation != nil {
		objectMap["computeLocation"] = ss.ComputeLocation
	}
	if ss.Description != nil {
		objectMap["description"] = ss.Description
	}
	if ss.ResourceID != nil {
		objectMap["resourceId"] = ss.ResourceID
	}
	if ss.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ss.DisableLocalAuth
	}
	if ss.ComputeType != "" {
		objectMap["computeType"] = ss.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsSynapseSpark() (*SynapseSpark, bool) {
	return &ss, true
}

// AsCompute is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for SynapseSpark.
func (ss SynapseSpark) AsBasicCompute() (BasicCompute, bool) {
	return &ss, true
}

// SynapseSparkProperties ...
type SynapseSparkProperties struct {
	// AutoScaleProperties - Auto scale properties.
	AutoScaleProperties *AutoScaleProperties `json:"autoScaleProperties,omitempty"`
	// AutoPauseProperties - Auto pause properties.
	AutoPauseProperties *AutoPauseProperties `json:"autoPauseProperties,omitempty"`
	// SparkVersion - Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`
	// NodeCount - The number of compute nodes currently assigned to the compute.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// NodeSize - Node size.
	NodeSize *string `json:"nodeSize,omitempty"`
	// NodeSizeFamily - Node size family.
	NodeSizeFamily *string `json:"nodeSizeFamily,omitempty"`
	// SubscriptionID - Azure subscription identifier.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - Name of the resource group in which workspace is located.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// WorkspaceName - Name of Azure Machine Learning workspace.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// PoolName - Pool name.
	PoolName *string `json:"poolName,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// SystemService a system service running on a compute.
type SystemService struct {
	// SystemServiceType - READ-ONLY; The type of this system service.
	SystemServiceType *string `json:"systemServiceType,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Version - READ-ONLY; The version for this type.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for SystemService.
func (ss SystemService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateWorkspaceQuotas the properties for update Quota response.
type UpdateWorkspaceQuotas struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Limit - The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
	// Status - Status of update workspace quota. Possible values include: 'StatusUndefined', 'StatusSuccess', 'StatusFailure', 'StatusInvalidQuotaBelowClusterMinimum', 'StatusInvalidQuotaExceedsSubscriptionLimit', 'StatusInvalidVMFamilyName', 'StatusOperationNotSupportedForSku', 'StatusOperationNotEnabledForRegion'
	Status Status `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateWorkspaceQuotas.
func (uwq UpdateWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uwq.Limit != nil {
		objectMap["limit"] = uwq.Limit
	}
	if uwq.Status != "" {
		objectMap["status"] = uwq.Status
	}
	return json.Marshal(objectMap)
}

// UpdateWorkspaceQuotasResult the result of update workspace quota.
type UpdateWorkspaceQuotasResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of workspace quota update result.
	Value *[]UpdateWorkspaceQuotas `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next page of Workspace Quota update result.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateWorkspaceQuotasResult.
func (uwqr UpdateWorkspaceQuotasResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Usage describes AML Resource Usage.
type Usage struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// AmlWorkspaceLocation - READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of usage measurement. Possible values include: 'UsageUnitCount'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current usage of the resource.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - READ-ONLY; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageName.
func (un UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserAccountCredentials settings for user account that gets created on each on the nodes of a compute.
type UserAccountCredentials struct {
	// AdminUserName - Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// AdminUserSSHPublicKey - SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
	// AdminUserPassword - Password of the administrator user account.
	AdminUserPassword *string `json:"adminUserPassword,omitempty"`
}

// UserAssignedIdentity user Assigned Identity
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the user assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// ClientID - READ-ONLY; The clientId(aka appId) of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachine a Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	Properties *VirtualMachineProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]ErrorResponse `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics', 'ComputeTypeBasicComputeComputeTypeSynapseSpark'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	VM.ComputeType = ComputeTypeBasicComputeComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if VM.Properties != nil {
		objectMap["properties"] = VM.Properties
	}
	if VM.ComputeLocation != nil {
		objectMap["computeLocation"] = VM.ComputeLocation
	}
	if VM.Description != nil {
		objectMap["description"] = VM.Description
	}
	if VM.ResourceID != nil {
		objectMap["resourceId"] = VM.ResourceID
	}
	if VM.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = VM.DisableLocalAuth
	}
	if VM.ComputeType != "" {
		objectMap["computeType"] = VM.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsVirtualMachine() (*VirtualMachine, bool) {
	return &VM, true
}

// AsHDInsight is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsSynapseSpark is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsSynapseSpark() (*SynapseSpark, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsBasicCompute() (BasicCompute, bool) {
	return &VM, true
}

// VirtualMachineImage virtual Machine image for Windows AML Compute
type VirtualMachineImage struct {
	// ID - Virtual Machine image path
	ID *string `json:"id,omitempty"`
}

// VirtualMachineProperties ...
type VirtualMachineProperties struct {
	// VirtualMachineSize - Virtual Machine size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
	// SSHPort - Port open for ssh connections.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the virtual machine.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// IsNotebookInstanceCompute - Indicates whether this compute will be used for running notebooks.
	IsNotebookInstanceCompute *bool `json:"isNotebookInstanceCompute,omitempty"`
}

// VirtualMachineSecrets secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// AdministratorAccount - Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) MarshalJSON() ([]byte, error) {
	vms.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if vms.AdministratorAccount != nil {
		objectMap["administratorAccount"] = vms.AdministratorAccount
	}
	if vms.ComputeType != "" {
		objectMap["computeType"] = vms.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return &vms, true
}

// AsComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &vms, true
}

// VirtualMachineSize describes the properties of a VM size.
type VirtualMachineSize struct {
	// Name - READ-ONLY; The name of the virtual machine size.
	Name *string `json:"name,omitempty"`
	// Family - READ-ONLY; The family name of the virtual machine size.
	Family *string `json:"family,omitempty"`
	// VCPUs - READ-ONLY; The number of vCPUs supported by the virtual machine size.
	VCPUs *int32 `json:"vCPUs,omitempty"`
	// Gpus - READ-ONLY; The number of gPUs supported by the virtual machine size.
	Gpus *int32 `json:"gpus,omitempty"`
	// OsVhdSizeMB - READ-ONLY; The OS VHD disk size, in MB, allowed by the virtual machine size.
	OsVhdSizeMB *int32 `json:"osVhdSizeMB,omitempty"`
	// MaxResourceVolumeMB - READ-ONLY; The resource volume size, in MB, allowed by the virtual machine size.
	MaxResourceVolumeMB *int32 `json:"maxResourceVolumeMB,omitempty"`
	// MemoryGB - READ-ONLY; The amount of memory, in GB, supported by the virtual machine size.
	MemoryGB *float64 `json:"memoryGB,omitempty"`
	// LowPriorityCapable - READ-ONLY; Specifies if the virtual machine size supports low priority VMs.
	LowPriorityCapable *bool `json:"lowPriorityCapable,omitempty"`
	// PremiumIO - READ-ONLY; Specifies if the virtual machine size supports premium IO.
	PremiumIO *bool `json:"premiumIO,omitempty"`
	// EstimatedVMPrices - The estimated price information for using a VM.
	EstimatedVMPrices *EstimatedVMPrices `json:"estimatedVMPrices,omitempty"`
	// SupportedComputeTypes - Specifies the compute types supported by the virtual machine size.
	SupportedComputeTypes *[]string `json:"supportedComputeTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSize.
func (vms VirtualMachineSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vms.EstimatedVMPrices != nil {
		objectMap["estimatedVMPrices"] = vms.EstimatedVMPrices
	}
	if vms.SupportedComputeTypes != nil {
		objectMap["supportedComputeTypes"] = vms.SupportedComputeTypes
	}
	return json.Marshal(objectMap)
}

// VirtualMachineSizeListResult the List Virtual Machine size operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of virtual machine sizes supported by AmlCompute.
	Value *[]VirtualMachineSize `json:"value,omitempty"`
}

// VirtualMachineSSHCredentials admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Username - Username of admin account
	Username *string `json:"username,omitempty"`
	// Password - Password of admin account
	Password *string `json:"password,omitempty"`
	// PublicKeyData - Public key data
	PublicKeyData *string `json:"publicKeyData,omitempty"`
	// PrivateKeyData - Private key data
	PrivateKeyData *string `json:"privateKeyData,omitempty"`
}

// Workspace an object that represents a machine learning workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties of the machine learning workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - System data
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Sku != nil {
		objectMap["sku"] = w.Sku
	}
	if w.SystemData != nil {
		objectMap["systemData"] = w.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				w.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceConnection workspace connection.
type WorkspaceConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ResourceId of the workspace connection.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Friendly name of the workspace connection.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of workspace connection.
	Type *string `json:"type,omitempty"`
	// WorkspaceConnectionProps - Properties of workspace connection.
	*WorkspaceConnectionProps `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceConnection.
func (wc WorkspaceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WorkspaceConnectionProps != nil {
		objectMap["properties"] = wc.WorkspaceConnectionProps
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceConnection struct.
func (wc *WorkspaceConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wc.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var workspaceConnectionProps WorkspaceConnectionProps
				err = json.Unmarshal(*v, &workspaceConnectionProps)
				if err != nil {
					return err
				}
				wc.WorkspaceConnectionProps = &workspaceConnectionProps
			}
		}
	}

	return nil
}

// WorkspaceConnectionProps workspace Connection specific properties.
type WorkspaceConnectionProps struct {
	// Category - Category of the workspace connection.
	Category *string `json:"category,omitempty"`
	// Target - Target of the workspace connection.
	Target *string `json:"target,omitempty"`
	// AuthType - Authorization type of the workspace connection.
	AuthType *string `json:"authType,omitempty"`
	// Value - Value details of the workspace connection.
	Value *string `json:"value,omitempty"`
	// ValueFormat - format for the workspace connection value. Possible values include: 'ValueFormatJSON'
	ValueFormat ValueFormat `json:"valueFormat,omitempty"`
}

// WorkspaceListResult the result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkspaceListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkspaceProperties the properties of a machine learning workspace.
type WorkspaceProperties struct {
	// WorkspaceID - READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace. This name in mutable
	FriendlyName *string `json:"friendlyName,omitempty"`
	// KeyVault - ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string `json:"keyVault,omitempty"`
	// ApplicationInsights - ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created
	ApplicationInsights *string `json:"applicationInsights,omitempty"`
	// ContainerRegistry - ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created
	ContainerRegistry *string `json:"containerRegistry,omitempty"`
	// StorageAccount - ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string `json:"storageAccount,omitempty"`
	// DiscoveryURL - Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string `json:"discoveryUrl,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Encryption - The encryption settings of Azure ML workspace.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`
	// HbiWorkspace - The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
	HbiWorkspace *bool `json:"hbiWorkspace,omitempty"`
	// ServiceProvisionedResourceGroup - READ-ONLY; The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace
	ServiceProvisionedResourceGroup *string `json:"serviceProvisionedResourceGroup,omitempty"`
	// PrivateLinkCount - READ-ONLY; Count of private connections in the workspace
	PrivateLinkCount *int32 `json:"privateLinkCount,omitempty"`
	// ImageBuildCompute - The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`
	// AllowPublicAccessWhenBehindVnet - The flag to indicate whether to allow public access when behind VNet.
	AllowPublicAccessWhenBehindVnet *bool `json:"allowPublicAccessWhenBehindVnet,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The list of private endpoint connections in the workspace.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// SharedPrivateLinkResources - The list of shared private link resources in this workspace.
	SharedPrivateLinkResources *[]SharedPrivateLinkResource `json:"sharedPrivateLinkResources,omitempty"`
	// NotebookInfo - READ-ONLY; The notebook info of Azure ML workspace.
	NotebookInfo *NotebookResourceInfo `json:"notebookInfo,omitempty"`
	// ServiceManagedResourcesSettings - The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`
	// PrimaryUserAssignedIdentity - The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with this workspace.
	TenantID *string `json:"tenantId,omitempty"`
	// StorageHnsEnabled - READ-ONLY; If the storage associated with the workspace has hierarchical namespace(HNS) enabled.
	StorageHnsEnabled *bool `json:"storageHnsEnabled,omitempty"`
	// MlFlowTrackingURI - READ-ONLY; The URI associated with this workspace that machine learning flow must point at to set up tracking.
	MlFlowTrackingURI *string `json:"mlFlowTrackingUri,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	if wp.FriendlyName != nil {
		objectMap["friendlyName"] = wp.FriendlyName
	}
	if wp.KeyVault != nil {
		objectMap["keyVault"] = wp.KeyVault
	}
	if wp.ApplicationInsights != nil {
		objectMap["applicationInsights"] = wp.ApplicationInsights
	}
	if wp.ContainerRegistry != nil {
		objectMap["containerRegistry"] = wp.ContainerRegistry
	}
	if wp.StorageAccount != nil {
		objectMap["storageAccount"] = wp.StorageAccount
	}
	if wp.DiscoveryURL != nil {
		objectMap["discoveryUrl"] = wp.DiscoveryURL
	}
	if wp.Encryption != nil {
		objectMap["encryption"] = wp.Encryption
	}
	if wp.HbiWorkspace != nil {
		objectMap["hbiWorkspace"] = wp.HbiWorkspace
	}
	if wp.ImageBuildCompute != nil {
		objectMap["imageBuildCompute"] = wp.ImageBuildCompute
	}
	if wp.AllowPublicAccessWhenBehindVnet != nil {
		objectMap["allowPublicAccessWhenBehindVnet"] = wp.AllowPublicAccessWhenBehindVnet
	}
	if wp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = wp.PublicNetworkAccess
	}
	if wp.SharedPrivateLinkResources != nil {
		objectMap["sharedPrivateLinkResources"] = wp.SharedPrivateLinkResources
	}
	if wp.ServiceManagedResourcesSettings != nil {
		objectMap["serviceManagedResourcesSettings"] = wp.ServiceManagedResourcesSettings
	}
	if wp.PrimaryUserAssignedIdentity != nil {
		objectMap["primaryUserAssignedIdentity"] = wp.PrimaryUserAssignedIdentity
	}
	return json.Marshal(objectMap)
}

// WorkspacePropertiesUpdateParameters the parameters for updating the properties of a machine learning
// workspace.
type WorkspacePropertiesUpdateParameters struct {
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ImageBuildCompute - The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`
	// ServiceManagedResourcesSettings - The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`
	// PrimaryUserAssignedIdentity - The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateOrUpdateFuture.Result.
func (future *WorkspacesCreateOrUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspacesDiagnoseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDiagnoseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (DiagnoseResponseResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDiagnoseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDiagnoseFuture.Result.
func (future *WorkspacesDiagnoseFuture) result(client WorkspacesClient) (drr DiagnoseResponseResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesDiagnoseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		drr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesDiagnoseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if drr.Response.Response, err = future.GetResult(sender); err == nil && drr.Response.Response.StatusCode != http.StatusNoContent {
		drr, err = client.DiagnoseResponder(drr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesDiagnoseFuture", "Result", drr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspaceSku describes Workspace Sku details and features
type WorkspaceSku struct {
	// Locations - READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo *[]ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// Tier - READ-ONLY; Sku Tier like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
	// ResourceType - READ-ONLY
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; List of features/user capabilities associated with the sku
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]Restriction `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSku.
func (ws WorkspaceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.Restrictions != nil {
		objectMap["restrictions"] = ws.Restrictions
	}
	return json.Marshal(objectMap)
}

// WorkspacesPrepareNotebookFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesPrepareNotebookFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (NotebookResourceInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesPrepareNotebookFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesPrepareNotebookFuture.Result.
func (future *WorkspacesPrepareNotebookFuture) result(client WorkspacesClient) (nri NotebookResourceInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesPrepareNotebookFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		nri.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesPrepareNotebookFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nri.Response.Response, err = future.GetResult(sender); err == nil && nri.Response.Response.StatusCode != http.StatusNoContent {
		nri, err = client.PrepareNotebookResponder(nri.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesPrepareNotebookFuture", "Result", nri.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesResyncKeysFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesResyncKeysFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesResyncKeysFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesResyncKeysFuture.Result.
func (future *WorkspacesResyncKeysFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesResyncKeysFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesResyncKeysFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceUpdateParameters the parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// Tags - The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// WorkspacePropertiesUpdateParameters - The properties that the machine learning workspace will be updated with.
	*WorkspacePropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceUpdateParameters.
func (wup WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.Sku != nil {
		objectMap["sku"] = wup.Sku
	}
	if wup.Identity != nil {
		objectMap["identity"] = wup.Identity
	}
	if wup.WorkspacePropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WorkspacePropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceUpdateParameters struct.
func (wup *WorkspaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wup.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				wup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var workspacePropertiesUpdateParameters WorkspacePropertiesUpdateParameters
				err = json.Unmarshal(*v, &workspacePropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WorkspacePropertiesUpdateParameters = &workspacePropertiesUpdateParameters
			}
		}
	}

	return nil
}
