/* box.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./box.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _surfaceProvider = require("../../utils/surface-provider");
var _excluded = ["as", "children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "style", "testId", "xcss"],
  _excluded2 = ["className"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Can either Exclude or Extract - here we're excluding all SVG-related elements, <button> elements (handled by Pressable), and <a> elements (handled by Anchor)

// Basically just ElementType but without ComponentType, it makes sense to keep the "Type" suffix
// eslint-disable-next-line @repo/internal/react/consistent-types-definitions

var baseStyles = null;
var backgroundColorMap = {
  'color.background.accent.lime.subtlest': "_bfhkm890",
  'color.background.accent.lime.subtlest.hovered': "_bfhkd4y8",
  'color.background.accent.lime.subtlest.pressed': "_bfhk1fno",
  'color.background.accent.lime.subtler': "_bfhkz2ec",
  'color.background.accent.lime.subtler.hovered': "_bfhk1eds",
  'color.background.accent.lime.subtler.pressed': "_bfhk1hgz",
  'color.background.accent.lime.subtle': "_bfhkbq5w",
  'color.background.accent.lime.subtle.hovered': "_bfhkfoww",
  'color.background.accent.lime.subtle.pressed': "_bfhkhgj8",
  'color.background.accent.lime.bolder': "_bfhktde4",
  'color.background.accent.lime.bolder.hovered': "_bfhknzpa",
  'color.background.accent.lime.bolder.pressed': "_bfhk1b17",
  'color.background.accent.red.subtlest': "_bfhk1vk5",
  'color.background.accent.red.subtlest.hovered': "_bfhk1i6i",
  'color.background.accent.red.subtlest.pressed': "_bfhk1pbw",
  'color.background.accent.red.subtler': "_bfhk1rtt",
  'color.background.accent.red.subtler.hovered': "_bfhkrw5d",
  'color.background.accent.red.subtler.pressed': "_bfhk69rw",
  'color.background.accent.red.subtle': "_bfhkkrt9",
  'color.background.accent.red.subtle.hovered': "_bfhk1sou",
  'color.background.accent.red.subtle.pressed': "_bfhk1tf4",
  'color.background.accent.red.bolder': "_bfhkuibq",
  'color.background.accent.red.bolder.hovered': "_bfhk100f",
  'color.background.accent.red.bolder.pressed': "_bfhkprmn",
  'color.background.accent.orange.subtlest': "_bfhk1g3m",
  'color.background.accent.orange.subtlest.hovered': "_bfhkg4tm",
  'color.background.accent.orange.subtlest.pressed': "_bfhk1ya0",
  'color.background.accent.orange.subtler': "_bfhkf2vu",
  'color.background.accent.orange.subtler.hovered': "_bfhk1lml",
  'color.background.accent.orange.subtler.pressed': "_bfhkuxsx",
  'color.background.accent.orange.subtle': "_bfhk1g6e",
  'color.background.accent.orange.subtle.hovered': "_bfhk1oew",
  'color.background.accent.orange.subtle.pressed': "_bfhk1phk",
  'color.background.accent.orange.bolder': "_bfhkjgng",
  'color.background.accent.orange.bolder.hovered': "_bfhkhi52",
  'color.background.accent.orange.bolder.pressed': "_bfhkf767",
  'color.background.accent.yellow.subtlest': "_bfhk1ozg",
  'color.background.accent.yellow.subtlest.hovered': "_bfhk19g9",
  'color.background.accent.yellow.subtlest.pressed': "_bfhk31d1",
  'color.background.accent.yellow.subtler': "_bfhk3fv2",
  'color.background.accent.yellow.subtler.hovered': "_bfhklg04",
  'color.background.accent.yellow.subtler.pressed': "_bfhk1d44",
  'color.background.accent.yellow.subtle': "_bfhkry5t",
  'color.background.accent.yellow.subtle.hovered': "_bfhk17e6",
  'color.background.accent.yellow.subtle.pressed': "_bfhko0y5",
  'color.background.accent.yellow.bolder': "_bfhk1vop",
  'color.background.accent.yellow.bolder.hovered': "_bfhkkjqf",
  'color.background.accent.yellow.bolder.pressed': "_bfhk32kj",
  'color.background.accent.green.subtlest': "_bfhkn729",
  'color.background.accent.green.subtlest.hovered': "_bfhk3utz",
  'color.background.accent.green.subtlest.pressed': "_bfhkv5yf",
  'color.background.accent.green.subtler': "_bfhk1wnw",
  'color.background.accent.green.subtler.hovered': "_bfhkung8",
  'color.background.accent.green.subtler.pressed': "_bfhk1p19",
  'color.background.accent.green.subtle': "_bfhk1rsu",
  'color.background.accent.green.subtle.hovered': "_bfhk12e3",
  'color.background.accent.green.subtle.pressed': "_bfhk8h4p",
  'color.background.accent.green.bolder': "_bfhk1e5c",
  'color.background.accent.green.bolder.hovered': "_bfhka5yi",
  'color.background.accent.green.bolder.pressed': "_bfhk1azz",
  'color.background.accent.teal.subtlest': "_bfhk7xuz",
  'color.background.accent.teal.subtlest.hovered': "_bfhk108c",
  'color.background.accent.teal.subtlest.pressed': "_bfhk1j2h",
  'color.background.accent.teal.subtler': "_bfhk1a17",
  'color.background.accent.teal.subtler.hovered': "_bfhkg5py",
  'color.background.accent.teal.subtler.pressed': "_bfhkq7li",
  'color.background.accent.teal.subtle': "_bfhktdv8",
  'color.background.accent.teal.subtle.hovered': "_bfhkzh8h",
  'color.background.accent.teal.subtle.pressed': "_bfhk10ai",
  'color.background.accent.teal.bolder': "_bfhk2c8p",
  'color.background.accent.teal.bolder.hovered': "_bfhkl3ve",
  'color.background.accent.teal.bolder.pressed': "_bfhkse6l",
  'color.background.accent.blue.subtlest': "_bfhkavxe",
  'color.background.accent.blue.subtlest.hovered': "_bfhkay3p",
  'color.background.accent.blue.subtlest.pressed': "_bfhk1xmr",
  'color.background.accent.blue.subtler': "_bfhk4v9p",
  'color.background.accent.blue.subtler.hovered': "_bfhk16e6",
  'color.background.accent.blue.subtler.pressed': "_bfhk1uh7",
  'color.background.accent.blue.subtle': "_bfhk1j89",
  'color.background.accent.blue.subtle.hovered': "_bfhk1f4s",
  'color.background.accent.blue.subtle.pressed': "_bfhkqctv",
  'color.background.accent.blue.bolder': "_bfhkc8cv",
  'color.background.accent.blue.bolder.hovered': "_bfhk1cwi",
  'color.background.accent.blue.bolder.pressed': "_bfhkhcrq",
  'color.background.accent.purple.subtlest': "_bfhkp7j4",
  'color.background.accent.purple.subtlest.hovered': "_bfhkm0d5",
  'color.background.accent.purple.subtlest.pressed': "_bfhkgslw",
  'color.background.accent.purple.subtler': "_bfhk1jkz",
  'color.background.accent.purple.subtler.hovered': "_bfhk1wyu",
  'color.background.accent.purple.subtler.pressed': "_bfhk5fkp",
  'color.background.accent.purple.subtle': "_bfhkdh45",
  'color.background.accent.purple.subtle.hovered': "_bfhk1wob",
  'color.background.accent.purple.subtle.pressed': "_bfhkwz05",
  'color.background.accent.purple.bolder': "_bfhkygwo",
  'color.background.accent.purple.bolder.hovered': "_bfhkadgs",
  'color.background.accent.purple.bolder.pressed': "_bfhk1uro",
  'color.background.accent.magenta.subtlest': "_bfhk8tvm",
  'color.background.accent.magenta.subtlest.hovered': "_bfhkr3zd",
  'color.background.accent.magenta.subtlest.pressed': "_bfhk1een",
  'color.background.accent.magenta.subtler': "_bfhkv9ra",
  'color.background.accent.magenta.subtler.hovered': "_bfhk1r0p",
  'color.background.accent.magenta.subtler.pressed': "_bfhkxuzc",
  'color.background.accent.magenta.subtle': "_bfhk1mi6",
  'color.background.accent.magenta.subtle.hovered': "_bfhkrwyz",
  'color.background.accent.magenta.subtle.pressed': "_bfhk1ovh",
  'color.background.accent.magenta.bolder': "_bfhkc3uk",
  'color.background.accent.magenta.bolder.hovered': "_bfhk1ok8",
  'color.background.accent.magenta.bolder.pressed': "_bfhkwaw3",
  'color.background.accent.gray.subtlest': "_bfhk11bn",
  'color.background.accent.gray.subtlest.hovered': "_bfhk12j4",
  'color.background.accent.gray.subtlest.pressed': "_bfhk1lb4",
  'color.background.accent.gray.subtler': "_bfhk1v33",
  'color.background.accent.gray.subtler.hovered': "_bfhk1f7l",
  'color.background.accent.gray.subtler.pressed': "_bfhkd8a2",
  'color.background.accent.gray.subtle': "_bfhk1t05",
  'color.background.accent.gray.subtle.hovered': "_bfhk1a2l",
  'color.background.accent.gray.subtle.pressed': "_bfhk1z0s",
  'color.background.accent.gray.bolder': "_bfhk1t1b",
  'color.background.accent.gray.bolder.hovered': "_bfhke4nv",
  'color.background.accent.gray.bolder.pressed': "_bfhk82ra",
  'color.background.disabled': "_bfhksyzs",
  'color.background.input': "_bfhk1j9a",
  'color.background.input.hovered': "_bfhk1d5g",
  'color.background.input.pressed': "_bfhkr01l",
  'color.background.inverse.subtle': "_bfhk1vck",
  'color.background.inverse.subtle.hovered': "_bfhkmpja",
  'color.background.inverse.subtle.pressed': "_bfhk1gii",
  'color.background.neutral': "_bfhkm7j4",
  'color.background.neutral.hovered': "_bfhk15ej",
  'color.background.neutral.pressed': "_bfhkip91",
  'color.background.neutral.subtle': "_bfhksm61",
  'color.background.neutral.subtle.hovered': "_bfhk166n",
  'color.background.neutral.subtle.pressed': "_bfhk1dty",
  'color.background.neutral.bold': "_bfhkcdhy",
  'color.background.neutral.bold.hovered': "_bfhk1bsc",
  'color.background.neutral.bold.pressed': "_bfhk1b6k",
  'color.background.selected': "_bfhkfg4m",
  'color.background.selected.hovered': "_bfhki1yw",
  'color.background.selected.pressed': "_bfhk19ru",
  'color.background.selected.bold': "_bfhk1fvw",
  'color.background.selected.bold.hovered': "_bfhk18hz",
  'color.background.selected.bold.pressed': "_bfhkgr1v",
  'color.background.brand.subtlest': "_bfhk3wxy",
  'color.background.brand.subtlest.hovered': "_bfhkezq1",
  'color.background.brand.subtlest.pressed': "_bfhk2ggb",
  'color.background.brand.bold': "_bfhkb29m",
  'color.background.brand.bold.hovered': "_bfhku1se",
  'color.background.brand.bold.pressed': "_bfhkqkzo",
  'color.background.brand.boldest': "_bfhk15mt",
  'color.background.brand.boldest.hovered': "_bfhk1uwk",
  'color.background.brand.boldest.pressed': "_bfhk17jr",
  'color.background.danger': "_bfhk1gly",
  'color.background.danger.hovered': "_bfhk1yvi",
  'color.background.danger.pressed': "_bfhk1io2",
  'color.background.danger.bold': "_bfhkybec",
  'color.background.danger.bold.hovered': "_bfhks9hg",
  'color.background.danger.bold.pressed': "_bfhk9pqq",
  'color.background.warning': "_bfhk1tzq",
  'color.background.warning.hovered': "_bfhk1rd4",
  'color.background.warning.pressed': "_bfhk11dh",
  'color.background.warning.bold': "_bfhk190i",
  'color.background.warning.bold.hovered': "_bfhk1i4c",
  'color.background.warning.bold.pressed': "_bfhkrj9s",
  'color.background.success': "_bfhkmv6i",
  'color.background.success.hovered': "_bfhk1jgi",
  'color.background.success.pressed': "_bfhky4f1",
  'color.background.success.bold': "_bfhk8emd",
  'color.background.success.bold.hovered': "_bfhk1q4l",
  'color.background.success.bold.pressed': "_bfhkcrcn",
  'color.background.discovery': "_bfhk1nvp",
  'color.background.discovery.hovered': "_bfhk1xp7",
  'color.background.discovery.pressed': "_bfhkdlkp",
  'color.background.discovery.bold': "_bfhk1lri",
  'color.background.discovery.bold.hovered': "_bfhk1w72",
  'color.background.discovery.bold.pressed': "_bfhkrb53",
  'color.background.information': "_bfhk33gi",
  'color.background.information.hovered': "_bfhk1vps",
  'color.background.information.pressed': "_bfhk1s0z",
  'color.background.information.bold': "_bfhk14wj",
  'color.background.information.bold.hovered': "_bfhk1amz",
  'color.background.information.bold.pressed': "_bfhk5bth",
  'color.blanket': "_bfhk10xm",
  'color.blanket.selected': "_bfhk7wq0",
  'color.blanket.danger': "_bfhkrprw",
  'color.skeleton': "_bfhkn82g",
  'color.skeleton.subtle': "_bfhkh3tw",
  'elevation.surface': "_bfhkvuon",
  'elevation.surface.hovered': "_bfhk108i",
  'elevation.surface.pressed': "_bfhk1ji5",
  'elevation.surface.overlay': "_bfhk1bhr",
  'elevation.surface.overlay.hovered': "_bfhk16qz",
  'elevation.surface.overlay.pressed': "_bfhkvq0a",
  'elevation.surface.raised': "_bfhkhp5a",
  'elevation.surface.raised.hovered': "_bfhk1a0f",
  'elevation.surface.raised.pressed': "_bfhkf7u5",
  'elevation.surface.sunken': "_bfhkqbzx",
  'utility.elevation.surface.current': "_bfhkchd4"
};
var CURRENT_SURFACE_CSS_VAR = "--ds-elevation-surface-current";
var setSurfaceTokenMap = {
  'elevation.surface': "_1q1lvuon",
  'elevation.surface.hovered': "_1q1l108i",
  'elevation.surface.pressed': "_1q1l1ji5",
  'elevation.surface.overlay': "_1q1l1bhr",
  'elevation.surface.overlay.hovered': "_1q1l16qz",
  'elevation.surface.overlay.pressed': "_1q1lvq0a",
  'elevation.surface.raised': "_1q1lhp5a",
  'elevation.surface.raised.hovered': "_1q1l1a0f",
  'elevation.surface.raised.pressed': "_1q1lf7u5",
  'elevation.surface.sunken': "_1q1lqbzx"
};
var paddingBlockStartMap = {
  'space.0': "_1q51ze3t",
  'space.025': "_1q51v77o",
  'space.050': "_1q511b66",
  'space.075': "_1q5112x7",
  'space.100': "_1q51u2gc",
  'space.150': "_1q51utpp",
  'space.200': "_1q51pxbi",
  'space.250': "_1q51v47k",
  'space.300': "_1q511ejb",
  'space.400': "_1q51xy5q",
  'space.500': "_1q511jfw",
  'space.600': "_1q51oahv",
  'space.800': "_1q51xncg",
  'space.1000': "_1q511epz"
};
var paddingBlockEndMap = {
  'space.0': "_85i5ze3t",
  'space.025': "_85i5v77o",
  'space.050': "_85i51b66",
  'space.075': "_85i512x7",
  'space.100': "_85i5u2gc",
  'space.150': "_85i5utpp",
  'space.200': "_85i5pxbi",
  'space.250': "_85i5v47k",
  'space.300': "_85i51ejb",
  'space.400': "_85i5xy5q",
  'space.500': "_85i51jfw",
  'space.600': "_85i5oahv",
  'space.800': "_85i5xncg",
  'space.1000': "_85i51epz"
};
var paddingInlineStartMap = {
  'space.0': "_bozgze3t",
  'space.025': "_bozgv77o",
  'space.050': "_bozg1b66",
  'space.075': "_bozg12x7",
  'space.100': "_bozgu2gc",
  'space.150': "_bozgutpp",
  'space.200': "_bozgpxbi",
  'space.250': "_bozgv47k",
  'space.300': "_bozg1ejb",
  'space.400': "_bozgxy5q",
  'space.500': "_bozg1jfw",
  'space.600': "_bozgoahv",
  'space.800': "_bozgxncg",
  'space.1000': "_bozg1epz"
};
var paddingInlineEndMap = {
  'space.0': "_y4tize3t",
  'space.025': "_y4tiv77o",
  'space.050': "_y4ti1b66",
  'space.075': "_y4ti12x7",
  'space.100': "_y4tiu2gc",
  'space.150': "_y4tiutpp",
  'space.200': "_y4tipxbi",
  'space.250': "_y4tiv47k",
  'space.300': "_y4ti1ejb",
  'space.400': "_y4tixy5q",
  'space.500': "_y4ti1jfw",
  'space.600': "_y4tioahv",
  'space.800': "_y4tixncg",
  'space.1000': "_y4ti1epz"
};

/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
var Box = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'div' : _ref$as,
    children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    _ref$paddingBlock = _ref.paddingBlock,
    paddingBlock = _ref$paddingBlock === void 0 ? padding : _ref$paddingBlock,
    _ref$paddingBlockStar = _ref.paddingBlockStart,
    paddingBlockStart = _ref$paddingBlockStar === void 0 ? paddingBlock : _ref$paddingBlockStar,
    _ref$paddingBlockEnd = _ref.paddingBlockEnd,
    paddingBlockEnd = _ref$paddingBlockEnd === void 0 ? paddingBlock : _ref$paddingBlockEnd,
    _ref$paddingInline = _ref.paddingInline,
    paddingInline = _ref$paddingInline === void 0 ? padding : _ref$paddingInline,
    _ref$paddingInlineSta = _ref.paddingInlineStart,
    paddingInlineStart = _ref$paddingInlineSta === void 0 ? paddingInline : _ref$paddingInlineSta,
    _ref$paddingInlineEnd = _ref.paddingInlineEnd,
    paddingInlineEnd = _ref$paddingInlineEnd === void 0 ? paddingInline : _ref$paddingInlineEnd,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error -- className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  var node = /*#__PURE__*/React.createElement(Component
  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  , (0, _extends2.default)({
    style: style
    // @ts-ignore -- Expression produces a union type that is too complex to represent. We may be able to narrow the type here but unsure.
    ,
    ref: ref,
    className: (0, _runtime.ax)(["_19itglyw _vchhusvi _r06hglyw", backgroundColor && backgroundColorMap[backgroundColor], backgroundColor && isSurfaceToken(backgroundColor) && setSurfaceTokenMap[backgroundColor], paddingBlockStart && paddingBlockStartMap[paddingBlockStart], paddingBlockEnd && paddingBlockEndMap[paddingBlockEnd], paddingInlineStart && paddingInlineStartMap[paddingInlineStart], paddingInlineEnd && paddingInlineEndMap[paddingInlineEnd], xcss])
  }, safeHtmlAttributes, {
    "data-testid": testId
  }), children);
  if (backgroundColor) {
    return /*#__PURE__*/React.createElement(_surfaceProvider.SurfaceContext.Provider, {
      value: backgroundColor
    }, node);
  }
  return node;
}
// @ts-ignore This typescript error has been surpessed while locally enrolling `@atlaskit/primitives` into Jira
// The return type of `BoxComponent` does not match the return type of `forwardRef` in React 18
);
var _default = exports.default = Box;
function isSurfaceToken(backgroundColor) {
  return backgroundColor in setSurfaceTokenMap;
}