/*
 * Copyright (C) 2024 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#ifndef VBOX_INCLUDED_SRC_Graphics_vmsvga_include_vbsvga3d_dx_h
#define VBOX_INCLUDED_SRC_Graphics_vmsvga_include_vbsvga3d_dx_h
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "svga3d_dx.h"

/* Extended capabilities returned by SVGA3D_DEVCAP_3D if VBoxSVGA virtual device is enabled. */
/* The original "3D support" capability. */
#define VBSVGA3D_CAP_3D    0x00000001
/* The host supports SVGA_3D_CMD_DX_DEFINE_RASTERIZER_STATE_V2 command. */
#define VBSVGA3D_CAP_RASTERIZER_STATE_V2 0x00000004

#endif /* !VBOX_INCLUDED_SRC_Graphics_vmsvga_include_vbsvga3d_dx_h */
