/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    long layoutText = 0L;
    long layoutMessage = 0L;
    long provider;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
        parent.addToolTip(this);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    void configure() {
        int[] polyline;
        long monitorList;
        if (GTK.GTK4) {
            System.err.println("SWT Error: ToolTip.java: ToolTip with style SWT.BALLOON not supported on GTK 4.");
            return;
        }
        GTK.gtk_widget_realize(this.handle);
        Point point = this.getLocation();
        GdkRectangle dest = new GdkRectangle();
        long displayHandle = GDK.gdk_display_get_default();
        boolean multipleMonitors = GTK.GTK4 ? OS.g_list_model_get_n_items(monitorList = GDK.gdk_display_get_monitors(displayHandle)) > 1 : GDK.gdk_display_get_n_monitors(displayHandle) > 1;
        long monitor = GDK.gdk_display_get_monitor_at_point(displayHandle, point.x, point.y);
        GDK.gdk_monitor_get_geometry(monitor, dest);
        point = this.getSize(dest.width / 4);
        int w = point.x;
        int h = point.y;
        point = this.getLocation();
        int x = point.x;
        int y = point.y;
        GTK3.gtk_window_resize(this.handle, w, h + 20);
        Rectangle bounds = this.display.getBounds();
        int width = bounds != null && GTK.GTK4 ? bounds.width : GDK.gdk_screen_width();
        boolean bl = this.spikeAbove = dest.height >= y + h + 20;
        if (dest.width >= x + w || multipleMonitors && width >= x + w) {
            if (dest.height >= y + h + 20) {
                t = 20;
                int[] nArray = new int[68];
                nArray[1] = 5 + t;
                nArray[2] = 1;
                nArray[3] = 5 + t;
                nArray[4] = 1;
                nArray[5] = 3 + t;
                nArray[6] = 3;
                nArray[7] = 1 + t;
                nArray[8] = 5;
                nArray[9] = 1 + t;
                nArray[10] = 5;
                nArray[11] = t;
                nArray[12] = 16;
                nArray[13] = t;
                nArray[14] = 16;
                nArray[16] = 35;
                nArray[17] = t;
                nArray[18] = w - 5;
                nArray[19] = t;
                nArray[20] = w - 5;
                nArray[21] = 1 + t;
                nArray[22] = w - 3;
                nArray[23] = 1 + t;
                nArray[24] = w - 1;
                nArray[25] = 3 + t;
                nArray[26] = w - 1;
                nArray[27] = 5 + t;
                nArray[28] = w;
                nArray[29] = 5 + t;
                nArray[30] = w;
                nArray[31] = h - 5 + t;
                nArray[32] = w - 1;
                nArray[33] = h - 5 + t;
                nArray[34] = w - 1;
                nArray[35] = h - 3 + t;
                nArray[36] = w - 2;
                nArray[37] = h - 3 + t;
                nArray[38] = w - 2;
                nArray[39] = h - 2 + t;
                nArray[40] = w - 3;
                nArray[41] = h - 2 + t;
                nArray[42] = w - 3;
                nArray[43] = h - 1 + t;
                nArray[44] = w - 5;
                nArray[45] = h - 1 + t;
                nArray[46] = w - 5;
                nArray[47] = h + t;
                nArray[48] = 5;
                nArray[49] = h + t;
                nArray[50] = 5;
                nArray[51] = h - 1 + t;
                nArray[52] = 3;
                nArray[53] = h - 1 + t;
                nArray[54] = 3;
                nArray[55] = h - 2 + t;
                nArray[56] = 2;
                nArray[57] = h - 2 + t;
                nArray[58] = 2;
                nArray[59] = h - 3 + t;
                nArray[60] = 1;
                nArray[61] = h - 3 + t;
                nArray[62] = 1;
                nArray[63] = h - 5 + t;
                nArray[65] = h - 5 + t;
                nArray[67] = 5 + t;
                polyline = nArray;
                int[] nArray2 = new int[56];
                nArray2[1] = 5 + t;
                nArray2[2] = 1;
                nArray2[3] = 4 + t;
                nArray2[4] = 1;
                nArray2[5] = 3 + t;
                nArray2[6] = 3;
                nArray2[7] = 1 + t;
                nArray2[8] = 4;
                nArray2[9] = 1 + t;
                nArray2[10] = 5;
                nArray2[11] = t;
                nArray2[12] = 16;
                nArray2[13] = t;
                nArray2[14] = 16;
                nArray2[15] = 1;
                nArray2[16] = 35;
                nArray2[17] = t;
                nArray2[18] = w - 6;
                nArray2[19] = 0 + t;
                nArray2[20] = w - 5;
                nArray2[21] = 1 + t;
                nArray2[22] = w - 4;
                nArray2[23] = 1 + t;
                nArray2[24] = w - 2;
                nArray2[25] = 3 + t;
                nArray2[26] = w - 2;
                nArray2[27] = 4 + t;
                nArray2[28] = w - 1;
                nArray2[29] = 5 + t;
                nArray2[30] = w - 1;
                nArray2[31] = h - 6 + t;
                nArray2[32] = w - 2;
                nArray2[33] = h - 5 + t;
                nArray2[34] = w - 2;
                nArray2[35] = h - 4 + t;
                nArray2[36] = w - 4;
                nArray2[37] = h - 2 + t;
                nArray2[38] = w - 5;
                nArray2[39] = h - 2 + t;
                nArray2[40] = w - 6;
                nArray2[41] = h - 1 + t;
                nArray2[42] = 5;
                nArray2[43] = h - 1 + t;
                nArray2[44] = 4;
                nArray2[45] = h - 2 + t;
                nArray2[46] = 3;
                nArray2[47] = h - 2 + t;
                nArray2[48] = 1;
                nArray2[49] = h - 4 + t;
                nArray2[50] = 1;
                nArray2[51] = h - 5 + t;
                nArray2[53] = h - 6 + t;
                nArray2[55] = 5 + t;
                this.borderPolygon = nArray2;
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[12] = w - 36;
                    polyline[14] = w - 16;
                    polyline[16] = w - 15;
                    this.borderPolygon[12] = w - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = w - 16;
                }
                GTK3.gtk_window_move(this.handle, Math.max(0, x - 17), y);
            } else {
                int[] nArray = new int[68];
                nArray[1] = 5;
                nArray[2] = 1;
                nArray[3] = 5;
                nArray[4] = 1;
                nArray[5] = 3;
                nArray[6] = 3;
                nArray[7] = 1;
                nArray[8] = 5;
                nArray[9] = 1;
                nArray[10] = 5;
                nArray[12] = w - 5;
                nArray[14] = w - 5;
                nArray[15] = 1;
                nArray[16] = w - 3;
                nArray[17] = 1;
                nArray[18] = w - 1;
                nArray[19] = 3;
                nArray[20] = w - 1;
                nArray[21] = 5;
                nArray[22] = w;
                nArray[23] = 5;
                nArray[24] = w;
                nArray[25] = h - 5;
                nArray[26] = w - 1;
                nArray[27] = h - 5;
                nArray[28] = w - 1;
                nArray[29] = h - 3;
                nArray[30] = w - 2;
                nArray[31] = h - 3;
                nArray[32] = w - 2;
                nArray[33] = h - 2;
                nArray[34] = w - 3;
                nArray[35] = h - 2;
                nArray[36] = w - 3;
                nArray[37] = h - 1;
                nArray[38] = w - 5;
                nArray[39] = h - 1;
                nArray[40] = w - 5;
                nArray[41] = h;
                nArray[42] = 35;
                nArray[43] = h;
                nArray[44] = 16;
                nArray[45] = h + 20;
                nArray[46] = 16;
                nArray[47] = h;
                nArray[48] = 5;
                nArray[49] = h;
                nArray[50] = 5;
                nArray[51] = h - 1;
                nArray[52] = 3;
                nArray[53] = h - 1;
                nArray[54] = 3;
                nArray[55] = h - 2;
                nArray[56] = 2;
                nArray[57] = h - 2;
                nArray[58] = 2;
                nArray[59] = h - 3;
                nArray[60] = 1;
                nArray[61] = h - 3;
                nArray[62] = 1;
                nArray[63] = h - 5;
                nArray[65] = h - 5;
                nArray[67] = 5;
                polyline = nArray;
                int[] nArray3 = new int[56];
                nArray3[1] = 5;
                nArray3[2] = 1;
                nArray3[3] = 4;
                nArray3[4] = 1;
                nArray3[5] = 3;
                nArray3[6] = 3;
                nArray3[7] = 1;
                nArray3[8] = 4;
                nArray3[9] = 1;
                nArray3[10] = 5;
                nArray3[12] = w - 6;
                nArray3[14] = w - 5;
                nArray3[15] = 1;
                nArray3[16] = w - 4;
                nArray3[17] = 1;
                nArray3[18] = w - 2;
                nArray3[19] = 3;
                nArray3[20] = w - 2;
                nArray3[21] = 4;
                nArray3[22] = w - 1;
                nArray3[23] = 5;
                nArray3[24] = w - 1;
                nArray3[25] = h - 6;
                nArray3[26] = w - 2;
                nArray3[27] = h - 5;
                nArray3[28] = w - 2;
                nArray3[29] = h - 4;
                nArray3[30] = w - 4;
                nArray3[31] = h - 2;
                nArray3[32] = w - 5;
                nArray3[33] = h - 2;
                nArray3[34] = w - 6;
                nArray3[35] = h - 1;
                nArray3[36] = 35;
                nArray3[37] = h - 1;
                nArray3[38] = 17;
                nArray3[39] = h + 20 - 2;
                nArray3[40] = 17;
                nArray3[41] = h - 1;
                nArray3[42] = 5;
                nArray3[43] = h - 1;
                nArray3[44] = 4;
                nArray3[45] = h - 2;
                nArray3[46] = 3;
                nArray3[47] = h - 2;
                nArray3[48] = 1;
                nArray3[49] = h - 4;
                nArray3[50] = 1;
                nArray3[51] = h - 5;
                nArray3[53] = h - 6;
                nArray3[55] = 5;
                this.borderPolygon = nArray3;
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[42] = polyline[44] = w - 16;
                    polyline[46] = w - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = w - 17;
                    this.borderPolygon[40] = w - 35;
                }
                GTK3.gtk_window_move(this.handle, Math.max(0, x - 17), y - h - 20);
            }
        } else if (dest.height >= y + h + 20) {
            t = 20;
            int[] nArray = new int[68];
            nArray[1] = 5 + t;
            nArray[2] = 1;
            nArray[3] = 5 + t;
            nArray[4] = 1;
            nArray[5] = 3 + t;
            nArray[6] = 3;
            nArray[7] = 1 + t;
            nArray[8] = 5;
            nArray[9] = 1 + t;
            nArray[10] = 5;
            nArray[11] = t;
            nArray[12] = w - 35;
            nArray[13] = t;
            nArray[14] = w - 16;
            nArray[16] = w - 16;
            nArray[17] = t;
            nArray[18] = w - 5;
            nArray[19] = t;
            nArray[20] = w - 5;
            nArray[21] = 1 + t;
            nArray[22] = w - 3;
            nArray[23] = 1 + t;
            nArray[24] = w - 1;
            nArray[25] = 3 + t;
            nArray[26] = w - 1;
            nArray[27] = 5 + t;
            nArray[28] = w;
            nArray[29] = 5 + t;
            nArray[30] = w;
            nArray[31] = h - 5 + t;
            nArray[32] = w - 1;
            nArray[33] = h - 5 + t;
            nArray[34] = w - 1;
            nArray[35] = h - 3 + t;
            nArray[36] = w - 2;
            nArray[37] = h - 3 + t;
            nArray[38] = w - 2;
            nArray[39] = h - 2 + t;
            nArray[40] = w - 3;
            nArray[41] = h - 2 + t;
            nArray[42] = w - 3;
            nArray[43] = h - 1 + t;
            nArray[44] = w - 5;
            nArray[45] = h - 1 + t;
            nArray[46] = w - 5;
            nArray[47] = h + t;
            nArray[48] = 5;
            nArray[49] = h + t;
            nArray[50] = 5;
            nArray[51] = h - 1 + t;
            nArray[52] = 3;
            nArray[53] = h - 1 + t;
            nArray[54] = 3;
            nArray[55] = h - 2 + t;
            nArray[56] = 2;
            nArray[57] = h - 2 + t;
            nArray[58] = 2;
            nArray[59] = h - 3 + t;
            nArray[60] = 1;
            nArray[61] = h - 3 + t;
            nArray[62] = 1;
            nArray[63] = h - 5 + t;
            nArray[65] = h - 5 + t;
            nArray[67] = 5 + t;
            polyline = nArray;
            int[] nArray4 = new int[56];
            nArray4[1] = 5 + t;
            nArray4[2] = 1;
            nArray4[3] = 4 + t;
            nArray4[4] = 1;
            nArray4[5] = 3 + t;
            nArray4[6] = 3;
            nArray4[7] = 1 + t;
            nArray4[8] = 4;
            nArray4[9] = 1 + t;
            nArray4[10] = 5;
            nArray4[11] = t;
            nArray4[12] = w - 35;
            nArray4[13] = t;
            nArray4[14] = w - 17;
            nArray4[15] = 2;
            nArray4[16] = w - 17;
            nArray4[17] = t;
            nArray4[18] = w - 6;
            nArray4[19] = t;
            nArray4[20] = w - 5;
            nArray4[21] = 1 + t;
            nArray4[22] = w - 4;
            nArray4[23] = 1 + t;
            nArray4[24] = w - 2;
            nArray4[25] = 3 + t;
            nArray4[26] = w - 2;
            nArray4[27] = 4 + t;
            nArray4[28] = w - 1;
            nArray4[29] = 5 + t;
            nArray4[30] = w - 1;
            nArray4[31] = h - 6 + t;
            nArray4[32] = w - 2;
            nArray4[33] = h - 5 + t;
            nArray4[34] = w - 2;
            nArray4[35] = h - 4 + t;
            nArray4[36] = w - 4;
            nArray4[37] = h - 2 + t;
            nArray4[38] = w - 5;
            nArray4[39] = h - 2 + t;
            nArray4[40] = w - 6;
            nArray4[41] = h - 1 + t;
            nArray4[42] = 5;
            nArray4[43] = h - 1 + t;
            nArray4[44] = 4;
            nArray4[45] = h - 2 + t;
            nArray4[46] = 3;
            nArray4[47] = h - 2 + t;
            nArray4[48] = 1;
            nArray4[49] = h - 4 + t;
            nArray4[50] = 1;
            nArray4[51] = h - 5 + t;
            nArray4[53] = h - 6 + t;
            nArray4[55] = 5 + t;
            this.borderPolygon = nArray4;
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[14] = 16;
                polyline[12] = 16;
                polyline[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            GTK3.gtk_window_move(this.handle, Math.max(dest.width - w, x - w + 17), y);
        } else {
            int[] nArray = new int[68];
            nArray[1] = 5;
            nArray[2] = 1;
            nArray[3] = 5;
            nArray[4] = 1;
            nArray[5] = 3;
            nArray[6] = 3;
            nArray[7] = 1;
            nArray[8] = 5;
            nArray[9] = 1;
            nArray[10] = 5;
            nArray[12] = w - 5;
            nArray[14] = w - 5;
            nArray[15] = 1;
            nArray[16] = w - 3;
            nArray[17] = 1;
            nArray[18] = w - 1;
            nArray[19] = 3;
            nArray[20] = w - 1;
            nArray[21] = 5;
            nArray[22] = w;
            nArray[23] = 5;
            nArray[24] = w;
            nArray[25] = h - 5;
            nArray[26] = w - 1;
            nArray[27] = h - 5;
            nArray[28] = w - 1;
            nArray[29] = h - 3;
            nArray[30] = w - 2;
            nArray[31] = h - 3;
            nArray[32] = w - 2;
            nArray[33] = h - 2;
            nArray[34] = w - 3;
            nArray[35] = h - 2;
            nArray[36] = w - 3;
            nArray[37] = h - 1;
            nArray[38] = w - 5;
            nArray[39] = h - 1;
            nArray[40] = w - 5;
            nArray[41] = h;
            nArray[42] = w - 16;
            nArray[43] = h;
            nArray[44] = w - 16;
            nArray[45] = h + 20;
            nArray[46] = w - 35;
            nArray[47] = h;
            nArray[48] = 5;
            nArray[49] = h;
            nArray[50] = 5;
            nArray[51] = h - 1;
            nArray[52] = 3;
            nArray[53] = h - 1;
            nArray[54] = 3;
            nArray[55] = h - 2;
            nArray[56] = 2;
            nArray[57] = h - 2;
            nArray[58] = 2;
            nArray[59] = h - 3;
            nArray[60] = 1;
            nArray[61] = h - 3;
            nArray[62] = 1;
            nArray[63] = h - 5;
            nArray[65] = h - 5;
            nArray[67] = 5;
            polyline = nArray;
            int[] nArray5 = new int[56];
            nArray5[1] = 5;
            nArray5[2] = 1;
            nArray5[3] = 4;
            nArray5[4] = 1;
            nArray5[5] = 3;
            nArray5[6] = 3;
            nArray5[7] = 1;
            nArray5[8] = 4;
            nArray5[9] = 1;
            nArray5[10] = 5;
            nArray5[12] = w - 6;
            nArray5[14] = w - 5;
            nArray5[15] = 1;
            nArray5[16] = w - 4;
            nArray5[17] = 1;
            nArray5[18] = w - 2;
            nArray5[19] = 3;
            nArray5[20] = w - 2;
            nArray5[21] = 4;
            nArray5[22] = w - 1;
            nArray5[23] = 5;
            nArray5[24] = w - 1;
            nArray5[25] = h - 6;
            nArray5[26] = w - 2;
            nArray5[27] = h - 5;
            nArray5[28] = w - 2;
            nArray5[29] = h - 4;
            nArray5[30] = w - 4;
            nArray5[31] = h - 2;
            nArray5[32] = w - 5;
            nArray5[33] = h - 2;
            nArray5[34] = w - 6;
            nArray5[35] = h - 1;
            nArray5[36] = w - 17;
            nArray5[37] = h - 1;
            nArray5[38] = w - 17;
            nArray5[39] = h + 20 - 2;
            nArray5[40] = w - 36;
            nArray5[41] = h - 1;
            nArray5[42] = 5;
            nArray5[43] = h - 1;
            nArray5[44] = 4;
            nArray5[45] = h - 2;
            nArray5[46] = 3;
            nArray5[47] = h - 2;
            nArray5[48] = 1;
            nArray5[49] = h - 4;
            nArray5[50] = 1;
            nArray5[51] = h - 5;
            nArray5[53] = h - 6;
            nArray5[55] = 5;
            this.borderPolygon = nArray5;
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[42] = 35;
                polyline[46] = 16;
                polyline[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            GTK3.gtk_window_move(this.handle, Math.max(dest.width - w, x - w + 17), y - h - 20);
        }
        GTK.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(polyline);
        GTK3.gtk_widget_shape_combine_region(this.handle, region.handle);
        region.dispose();
    }

    @Override
    void createHandle(int index) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            if (!GTK.GTK4) {
                this.handle = GTK3.gtk_window_new(1);
                Color background = this.display.getSystemColor(29);
                long context = GTK.gtk_widget_get_style_context(this.handle);
                GdkRGBA bgRGBA = background.handle;
                String css = "window {background-color: " + this.display.gtk_rgba_to_css_string(bgRGBA) + ";}";
                this.gtk_css_provider_load_from_css(context, css);
                GTK3.gtk_style_context_invalidate(context);
                GTK3.gtk_window_set_type_hint(this.handle, 10);
            }
        }
    }

    void gtk_css_provider_load_from_css(long context, String css) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L, null);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    @Override
    void destroyWidget() {
        long topHandle = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (topHandle != 0L && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                if (GTK.GTK4) {
                    OS.g_object_unref(topHandle);
                } else {
                    GTK3.gtk_widget_destroy(topHandle);
                }
            } else {
                OS.g_object_unref(topHandle);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int x = this.x;
        int y = this.y;
        if (this.item != null) {
            long itemHandle = this.item.handle;
            GdkRectangle area = new GdkRectangle();
            GTK3.gtk_status_icon_get_geometry(itemHandle, 0L, area, 0L);
            x = area.x + area.width / 2;
            y = area.y + area.height / 2;
        }
        if (x == -1 || y == -1) {
            if (GTK.GTK4) {
                double[] px = new double[1];
                double[] py = new double[1];
                this.display.getPointerPosition(px, py);
                x = (int)px[0];
                y = (int)py[0];
            } else {
                int[] px = new int[1];
                int[] py = new int[1];
                this.display.getWindowPointerPosition(0L, px, py, null);
                x = px[0];
                y = py[0];
            }
        }
        return new Point(x, y);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textWidth = w[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageWidth = w[0];
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != 0L && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, (maxWidth - textTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textHeight = h[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, (maxWidth - messageTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageHeight = h[0];
        }
        int height = 20 + messageHeight;
        if (this.layoutText != 0L) {
            height += Math.max(16, textHeight) + 10;
        }
        return new Point(width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return GTK.gtk_widget_get_visible(this.handle);
        }
        return false;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0L;
    }

    void drawTooltip(long cairo) {
        int count;
        int x = 10;
        int y = 10;
        if (cairo == 0L) {
            this.error(2);
        }
        if ((count = this.borderPolygon.length / 2) != 0) {
            Cairo.cairo_set_line_width(cairo, 1.0);
            Cairo.cairo_move_to(cairo, this.borderPolygon[0], this.borderPolygon[1]);
            int i = 1;
            int j = 2;
            while (i < count) {
                Cairo.cairo_line_to(cairo, (double)this.borderPolygon[j] + 0.5, (double)this.borderPolygon[j + 1] + 0.5);
                ++i;
                j += 2;
            }
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_stroke(cairo);
        }
        if (this.spikeAbove) {
            y += 20;
        }
        if (this.layoutText != 0L) {
            byte[] buffer = null;
            int id = this.style & 0xB;
            switch (id) {
                case 1: {
                    buffer = Converter.wcsToMbcs("dialog-error", true);
                    break;
                }
                case 2: {
                    buffer = Converter.wcsToMbcs("dialog-information", true);
                    break;
                }
                case 8: {
                    buffer = Converter.wcsToMbcs("dialog-warning", true);
                }
            }
            if (buffer != null) {
                long iconTheme = GTK.GTK4 ? GTK4.gtk_icon_theme_get_for_display(GDK.gdk_display_get_default()) : GTK3.gtk_icon_theme_get_default();
                long pixbuf = GTK3.gtk_icon_theme_load_icon(iconTheme, buffer, 1, 0, 0L);
                GDK.gdk_cairo_set_source_pixbuf(cairo, pixbuf, x, y);
                Cairo.cairo_paint(cairo);
                OS.g_object_unref(pixbuf);
                x += 16;
            }
            int[] w = new int[1];
            int[] h = new int[1];
            Color foreground = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(cairo, foreground.handle);
            Cairo.cairo_move_to(cairo, x += 4, y);
            OS.pango_cairo_show_layout(cairo, this.layoutText);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            y += 10 + Math.max(16, h[0]);
        }
        if (this.layoutMessage != 0L) {
            x = 14;
            Color foreground = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(cairo, foreground.handle);
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layoutMessage);
        }
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(cairo);
        return 0L;
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        Point point = this.getLocation();
        int x = point.x;
        int y = point.y;
        GTK.gtk_widget_realize(widget);
        GdkRectangle dest = new GdkRectangle();
        long display = GDK.gdk_display_get_default();
        long monitor = GDK.gdk_display_get_monitor_at_point(display, x, y);
        GDK.gdk_monitor_get_geometry(monitor, dest);
        GtkAllocation widgetAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, widgetAllocation);
        int w = widgetAllocation.width;
        int h = widgetAllocation.height;
        if (dest.height < y + h) {
            y -= h;
        }
        if (dest.width < x + w) {
            x -= w;
        }
        GTK3.gtk_window_move(widget, x, y);
        return 0L;
    }

    @Override
    void hookEvents() {
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[19], 0, this.display.getClosure(19), true);
            if (GTK.GTK4) {
                long clickController = GTK4.gtk_gesture_click_new();
                GTK4.gtk_widget_add_controller(this.handle, clickController);
                OS.g_signal_connect(clickController, OS.pressed, this.display.gesturePressReleaseProc, 100L);
            } else {
                GTK3.gtk_widget_add_events(this.handle, 256);
                OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.getClosure(2), false);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autohide = autoHide;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        if ((this.style & 0x1000) != 0 && GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.message.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(this.message, true);
            this.layoutMessage = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.text.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(this.text, true);
            this.layoutText = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            long boldAttr = OS.pango_attr_weight_new(700);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, boldAttr, (long)PangoAttribute.sizeof);
            attribute.start_index = 0;
            attribute.end_index = buffer.length;
            OS.memmove(boldAttr, attribute, (long)PangoAttribute.sizeof);
            long attrList = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(attrList, boldAttr);
            OS.pango_layout_set_attributes(this.layoutText, attrList);
            OS.pango_attr_list_unref(attrList);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (visible) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                this.gtk_widget_show(this.handle);
            } else {
                long vboxHandle = this.parent.vboxHandle;
                StringBuilder string = new StringBuilder(this.text);
                if (this.text.length() > 0) {
                    string.append("\n\n");
                }
                string.append(this.message);
                byte[] buffer = Converter.wcsToMbcs(string.toString(), true);
                GTK.gtk_widget_set_tooltip_text(vboxHandle, buffer);
            }
            if (this.autohide) {
                this.timerId = GTK.GTK4 ? OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle) : GDK.gdk_threads_add_timeout(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            this.gtk_widget_hide(this.handle);
        } else {
            long vboxHandle = this.parent.vboxHandle;
            byte[] buffer = Converter.wcsToMbcs("", true);
            GTK.gtk_widget_set_tooltip_text(vboxHandle, buffer);
        }
    }

    @Override
    long timerProc(long widget) {
        if ((this.style & 0x1000) != 0) {
            this.gtk_widget_hide(this.handle);
        }
        return 0L;
    }
}

