# Release Notes - v2.8.33

**Date**: 2026-01-31

## 📝 Executive Summary

```text
2.8.33 2026-01-31

- feat: add automated validation (regex/coderef) for CLI options like `--port` and `--defaultarch`.
- feat: implement option implications (e.g., `--feature` implies `--verbose`) in metadata.
- feat: add SSL/TLS security checks for missing configuration, insecure protocols (TLSv1.0, TLSv1.1), and secure transport enforcement.
- feat: add automated detection of current session encryption status.
- feat: add observability warning and explicit recommendation when `performance_schema` is disabled.
- fix: improved cPanel/Flex detection and refined `skip-name-resolve` recommendation (issue #863).
- fix: resolve numeric comparison warnings and prevent full workstation path leakage in CLI output.
- fix: resolve contradictory key_buffer_size recommendations by adding a usage threshold to the increase recommendation (issue #774).
- test: add enhanced unit test `tests/issue_863_enhanced.t` for cPanel detection verification.
- test: add unit test `tests/cli_validation.t` for comprehensive option validation verification.
- test: add unit test `tests/ssl_tls_validation.t` for comprehensive SSL/TLS verification.
- test: add unit test `tests/pfs_observability.t` to verify `performance_schema` diagnostics.
- test: add unit test `tests/issue_774.t` to verify key_buffer_size recommendation logic.
- docs: consolidate project governance rules and resolve backwards compatibility contradiction (00_constitution.md, 03_execution_rules.md).
- style: promote session-discovered rules to Tier 04 Best Practices and reset `remembers.md`.
- docs: cleanup MongoDB and PostgreSQL references from `ROADMAP.md` and README files.
- refactor: implement metadata-driven CLI option parsing to centralize defaults, validation, and documentation.
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 9 | +9 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 1 | +1 | 🚀 |
| Information Points | 8 | +8 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- Table $dbname.$tbname has no index defined
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Auto-generating raw output file: $raw_output_file
- Dumpdir: $opt{dumpdir}
- Dumping information schema
- Dumping performance schema
- Dumping sys schema
- General MyIsam metrics:
- InnoDB Snapshot Isolation: 
- SKIPPING $sys_view
- Transaction Isolation Level: $isolation
- table_definition_cache (

## 🛠️ Internal Commit History

- feat: synchronize version 2.8.33 and robust pretty URLs (aac5ccd)
- chore: Exclude the `.agent` directory from rsync deployment arguments. (0e53913)
- fix: prioritize index.php and enable rsync delete for live site cleanup (fcb91a3)
- chore: bump version to 1.0.4 (31596c9)

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--CLOUD`
- `--CONNECTION`
- `--MISC`
- `--Modeling`
- `--OUTPUT`
- `--PERFORMANCE`
- `--Performance`
- `--Security`
- `--System`
- `--azure`
- `--bannedports`
- `--buffers`
- `--checkversion`
- `--cloud`
- `--container`
- `--cvefile`
- `--data`
- `--dbgpattern`
- `--debug`
- `--defaultarch`
- `--defaults-extra-file`
- `--defaults-file`
- `--dumpdir`
- `--experimental`
- `--feature`
- `--forcemem`
- `--forceswap`
- `--host`
- `--ignore-tables`
- `--json`
- `--max-password-checks`
- `--maxportallowed`
- `--mysqladmin`
- `--mysqlcmd`
- `--noask`
- `--nobad`
- `--nogood`
- `--noinfo`
- `--nondedicated`
- `--noprettyicon`
- `--noprocess`
- `--outputfile`
- `--passenv`
- `--passwordfile`
- `--pipe`
- `--pipe_name`
- `--port`
- `--prettyjson`
- `--protocol`
- `--reportfile`
- `--schemadir`
- `--server-log`
- `--silent`
- `--skippassword`
- `--skipsize`
- `--socket`
- `--ssh-host`
- `--ssh-identity-file`
- `--ssh-password`
- `--ssh-user`
- `--ssl-ca`
- `--template`
- `--updateversion`
- `--userenv`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
