use criterion::{black_box, criterion_group, criterion_main, Criterion};
use xim_parser::{Request, XimWrite};

static CONNECT: &[u8] = b"\x01\x00\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00";
static OPEN_REPLY: &[u8] = b"\x1f\x00\x59\x00\x01\x00\x18\x00\x00\x00\x0a\x00\x0f\x00\x71\x75\x65\x72\x79\x49\x6e\x70\x75\x74\x53\x74\x79\x6c\x65\x00\x00\x00\x44\x01\x00\x00\x01\x00\x03\x00\x0a\x00\x69\x6e\x70\x75\x74\x53\x74\x79\x6c\x65\x02\x00\x05\x00\x0c\x00\x63\x6c\x69\x65\x6e\x74\x57\x69\x6e\x64\x6f\x77\x00\x00\x03\x00\x05\x00\x0b\x00\x66\x6f\x63\x75\x73\x57\x69\x6e\x64\x6f\x77\x00\x00\x00\x04\x00\x03\x00\x0c\x00\x66\x69\x6c\x74\x65\x72\x45\x76\x65\x6e\x74\x73\x00\x00\x05\x00\xff\x7f\x11\x00\x70\x72\x65\x65\x64\x69\x74\x41\x74\x74\x72\x69\x62\x75\x74\x65\x73\x00\x06\x00\xff\x7f\x10\x00\x73\x74\x61\x74\x75\x73\x41\x74\x74\x72\x69\x62\x75\x74\x65\x73\x00\x00\x07\x00\x0d\x00\x07\x00\x66\x6f\x6e\x74\x53\x65\x74\x00\x00\x00\x08\x00\x0b\x00\x04\x00\x61\x72\x65\x61\x00\x00\x09\x00\x0b\x00\x0a\x00\x61\x72\x65\x61\x4e\x65\x65\x64\x65\x64\x0a\x00\x03\x00\x08\x00\x63\x6f\x6c\x6f\x72\x4d\x61\x70\x00\x00\x0b\x00\x03\x00\x0b\x00\x73\x74\x64\x43\x6f\x6c\x6f\x72\x4d\x61\x70\x00\x00\x00\x0c\x00\x03\x00\x0a\x00\x66\x6f\x72\x65\x67\x72\x6f\x75\x6e\x64\x0d\x00\x03\x00\x0a\x00\x62\x61\x63\x6b\x67\x72\x6f\x75\x6e\x64\x0e\x00\x03\x00\x10\x00\x62\x61\x63\x6b\x67\x72\x6f\x75\x6e\x64\x50\x69\x78\x6d\x61\x70\x00\x00\x0f\x00\x0c\x00\x0c\x00\x73\x70\x6f\x74\x4c\x6f\x63\x61\x74\x69\x6f\x6e\x00\x00\x10\x00\x03\x00\x09\x00\x6c\x69\x6e\x65\x53\x70\x61\x63\x65\x00\x11\x00\x00\x00\x15\x00\x73\x65\x70\x61\x72\x61\x74\x6f\x72\x6f\x66\x4e\x65\x73\x74\x65\x64\x4c\x69\x73\x74\x00";

fn read_request(c: &mut Criterion) {
    c.bench_function("read connect", |b| {
        b.iter(|| black_box(xim_parser::read::<Request>(CONNECT).unwrap()))
    })
    .bench_function("read open_reply", |b| {
        b.iter(|| black_box(xim_parser::read::<Request>(OPEN_REPLY).unwrap()))
    });
}

fn write_request(c: &mut Criterion) {
    let connect: Request = xim_parser::read(CONNECT).unwrap();
    let open_reply: Request = xim_parser::read(OPEN_REPLY).unwrap();

    let mut buf = Vec::new();

    c.bench_function("write connect", |b| {
        b.iter(|| {
            buf.resize(connect.size(), 0);
            xim_parser::write(&connect, &mut buf);
            buf.clear();
        });
    })
    .bench_function("write open_reply", |b| {
        b.iter(|| {
            buf.resize(open_reply.size(), 0);
            xim_parser::write(&open_reply, &mut buf);
            buf.clear();
        });
    });
}

criterion_group!(read_benchmarks, read_request);
criterion_group!(write_benchmarks, write_request);
criterion_main!(read_benchmarks, write_benchmarks);
