/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a+\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015*\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0019\u001a\u0012\u0010\u001a\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000b\u001a#\u0010\u001c\u001a\u00020\b*\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001d\u001a#\u0010\u001e\u001a\u00020\u000b*\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0018\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001f\u001a\n\u0010 \u001a\u00020\b*\u00020\u0015\u001a\n\u0010!\u001a\u00020\u0015*\u00020\u0015\u001a\n\u0010\"\u001a\u00020#*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006$"}, d2={"rootCause", "", "getRootCause", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "executeAndAwait", "", "timeoutSeconds", "directory", "Ljava/io/File;", "args", "", "", "executeAwait", "process", "Ljava/lang/Process;", "drainTo", "", "Ljava/io/BufferedReader;", "pw", "Ljava/io/PrintStream;", "resolveNewDirectories", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "parts", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/nio/file/Path;", "resolveTwinVerified", "extension", "resolveVerified", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/io/File;", "resolveVerifiedToAbsoluteString", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/lang/String;", "verified", "verifiedPath", "wasInterrupted", "", "src_main_kotlin_io_bazel_kotlin_builder_utils-utils"})
@JvmName(name="IOUtils")
public final class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int executeAwait(int timeoutSeconds, Process process) {
        try {
            if (!process.waitFor(timeoutSeconds, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            int n = process.exitValue();
            return n;
        }
        finally {
            if (process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int executeAndAwait(int timeoutSeconds, @Nullable File directory, @NotNull List<String> args2) {
        PrintStream printStream;
        int n;
        Comparable<File> comparable;
        Intrinsics.checkNotNullParameter(args2, "args");
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ProcessBuilder pb = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length));
        boolean bl = false;
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        File file = directory;
        if (file != null) {
            File it = comparable = file;
            boolean bl2 = false;
            pb.directory(it);
        }
        Process process = pb.start();
        BufferedReader isr = null;
        BufferedReader esr = null;
        try {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream, "process.inputStream");
            InputStream inputStream2 = inputStream;
            comparable = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, (Charset)comparable);
            int n2 = 8192;
            isr = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
            InputStream inputStream3 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue(inputStream3, "process.errorStream");
            inputStream2 = inputStream3;
            comparable = Charsets.UTF_8;
            reader = new InputStreamReader(inputStream2, (Charset)comparable);
            n2 = 8192;
            esr = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
            Intrinsics.checkNotNullExpressionValue(process, "process");
            n = IOUtils.executeAwait(timeoutSeconds, process);
            printStream = System.out;
        }
        catch (Throwable throwable) {
            block4: {
                BufferedReader bufferedReader = isr;
                if (bufferedReader != null) {
                    PrintStream printStream2 = System.out;
                    Intrinsics.checkNotNullExpressionValue(printStream2, "out");
                    IOUtils.drainTo(bufferedReader, printStream2);
                }
                BufferedReader bufferedReader2 = esr;
                if (bufferedReader2 == null) break block4;
                PrintStream printStream3 = System.err;
                Intrinsics.checkNotNullExpressionValue(printStream3, "err");
                IOUtils.drainTo(bufferedReader2, printStream3);
            }
            throw throwable;
        }
        Intrinsics.checkNotNullExpressionValue(printStream, "out");
        IOUtils.drainTo(isr, printStream);
        PrintStream printStream4 = System.err;
        Intrinsics.checkNotNullExpressionValue(printStream4, "err");
        IOUtils.drainTo(esr, printStream4);
        return n;
    }

    public static /* synthetic */ int executeAndAwait$default(int n, File file, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            file = null;
        }
        return IOUtils.executeAndAwait(n, file, list);
    }

    private static final void drainTo(BufferedReader $this$drainTo, PrintStream pw) {
        $this$drainTo.lines().forEach(new Consumer(pw){
            final /* synthetic */ PrintStream $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(String p0) {
                this.$tmp0.println(p0);
            }
        });
        $this$drainTo.close();
    }

    @NotNull
    public static final Path resolveTwinVerified(@NotNull Path $this$resolveTwinVerified, @NotNull String extension) {
        Intrinsics.checkNotNullParameter($this$resolveTwinVerified, "<this>");
        Intrinsics.checkNotNullParameter(extension, "extension");
        Path path = $this$resolveTwinVerified.getParent();
        StringBuilder stringBuilder = new StringBuilder();
        File file = $this$resolveTwinVerified.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile()");
        Path path2 = path.resolve(stringBuilder.append(FilesKt.getNameWithoutExtension(file)).append(StringsKt.startsWith$default(extension, ".", false, 2, null) ? "" : ".").append(extension).toString());
        Intrinsics.checkNotNullExpressionValue(path2, "parent\n    .resolve(\n   \u2026se \".\"}$extension\",\n    )");
        Path path3 = IOUtils.verified(path2).toPath();
        Intrinsics.checkNotNullExpressionValue(path3, "parent\n    .resolve(\n   \u2026.verified()\n    .toPath()");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    public static final Path resolveNewDirectories(@NotNull Path $this$resolveNewDirectories, String ... parts) {
        Intrinsics.checkNotNullParameter($this$resolveNewDirectories, "<this>");
        Intrinsics.checkNotNullParameter(parts, "parts");
        String[] $this$fold$iv = parts;
        boolean $i$f$fold = false;
        Path accumulator$iv = $this$resolveNewDirectories;
        int n = $this$fold$iv.length;
        for (int i = 0; i < n; ++i) {
            void p1;
            String element$iv;
            String string = element$iv = $this$fold$iv[i];
            Path p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.resolve((String)p1);
        }
        return Files.createDirectories(accumulator$iv, new FileAttribute[0]);
    }

    @NotNull
    public static final File resolveVerified(@NotNull Path $this$resolveVerified, String ... parts) {
        Intrinsics.checkNotNullParameter($this$resolveVerified, "<this>");
        Intrinsics.checkNotNullParameter(parts, "parts");
        String[] stringArray = Arrays.copyOfRange(parts, 1, parts.length);
        Path path = $this$resolveVerified.resolve(Paths.get(parts[0], Arrays.copyOf(stringArray, stringArray.length)));
        Intrinsics.checkNotNullExpressionValue(path, "resolve(Paths.get(parts[\u2026e(parts, 1, parts.size)))");
        return IOUtils.verified(path);
    }

    @NotNull
    public static final String resolveVerifiedToAbsoluteString(@NotNull Path $this$resolveVerifiedToAbsoluteString, String ... parts) {
        Intrinsics.checkNotNullParameter($this$resolveVerifiedToAbsoluteString, "<this>");
        Intrinsics.checkNotNullParameter(parts, "parts");
        return IOUtils.resolveVerified($this$resolveVerifiedToAbsoluteString, Arrays.copyOf(parts, parts.length)).getAbsolutePath().toString();
    }

    @NotNull
    public static final File verified(@NotNull Path $this$verified) {
        File file;
        Intrinsics.checkNotNullParameter($this$verified, "<this>");
        File it = file = $this$verified.toFile();
        boolean bl = false;
        if (!it.exists()) {
            boolean bl2 = false;
            String string = "file did not exist: " + $this$verified;
            throw new IllegalStateException(string.toString());
        }
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue(file2, "this\n    .toFile()\n    .\u2026did not exist: $this\" } }");
        return file2;
    }

    @NotNull
    public static final Path verifiedPath(@NotNull Path $this$verifiedPath) {
        File file;
        Intrinsics.checkNotNullParameter($this$verifiedPath, "<this>");
        File it = file = $this$verifiedPath.toFile();
        boolean bl = false;
        if (!it.exists()) {
            boolean bl2 = false;
            String string = "file did not exist: " + $this$verifiedPath;
            throw new IllegalStateException(string.toString());
        }
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "this\n    .toFile()\n    .\u2026 $this\" } }\n    .toPath()");
        return path;
    }

    @NotNull
    public static final Throwable getRootCause(@NotNull Throwable $this$rootCause) {
        Throwable cause;
        Intrinsics.checkNotNullParameter($this$rootCause, "<this>");
        Throwable result = $this$rootCause;
        do {
            if ((cause = result.getCause()) == null) continue;
            result = cause;
        } while (cause != null && !Intrinsics.areEqual(result, cause));
        return result;
    }

    public static final boolean wasInterrupted(@NotNull Throwable $this$wasInterrupted) {
        Intrinsics.checkNotNullParameter($this$wasInterrupted, "<this>");
        Throwable cause = IOUtils.getRootCause($this$wasInterrupted);
        return cause instanceof InterruptedException || cause instanceof InterruptedIOException;
    }
}

