// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bcmdataexports

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateExport = "CreateExport"

// CreateExportRequest generates a "aws/request.Request" representing the
// client's request for the CreateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExport for more information on using the CreateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExportRequest method.
//	req, resp := client.CreateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/CreateExport
func (c *BCMDataExports) CreateExportRequest(input *CreateExportInput) (req *request.Request, output *CreateExportOutput) {
	op := &request.Operation{
		Name:       opCreateExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExportInput{}
	}

	output = &CreateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExport API operation for AWS Billing and Cost Management Data Exports.
//
// Creates a data export and specifies the data query, the delivery preference,
// and any optional resource tags.
//
// A DataQuery consists of both a QueryStatement and TableConfigurations.
//
// The QueryStatement is an SQL statement. Data Exports only supports a limited
// subset of the SQL syntax. For more information on the SQL syntax that is
// supported, see Data query (https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html).
// To view the available tables and columns, see the Data Exports table dictionary
// (https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html).
//
// The TableConfigurations is a collection of specified TableProperties for
// the table being queried in the QueryStatement. TableProperties are additional
// configurations you can provide to change the data and schema of a table.
// Each table can have different TableProperties. However, tables are not required
// to have any TableProperties. Each table property has a default value that
// it assumes if not specified. For more information on table configurations,
// see Data query (https://docs.aws.amazon.com/cur/latest/userguide/de-data-query.html).
// To view the table properties available for each table, see the Data Exports
// table dictionary (https://docs.aws.amazon.com/cur/latest/userguide/de-table-dictionary.html)
// or use the ListTables API to get a response of all tables and their available
// properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation CreateExport for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You've reached the limit on the number of resources you can create, or exceeded
//     the size of an individual resource.
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/CreateExport
func (c *BCMDataExports) CreateExport(input *CreateExportInput) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	return out, req.Send()
}

// CreateExportWithContext is the same as CreateExport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) CreateExportWithContext(ctx aws.Context, input *CreateExportInput, opts ...request.Option) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExport = "DeleteExport"

// DeleteExportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExport for more information on using the DeleteExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExportRequest method.
//	req, resp := client.DeleteExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/DeleteExport
func (c *BCMDataExports) DeleteExportRequest(input *DeleteExportInput) (req *request.Request, output *DeleteExportOutput) {
	op := &request.Operation{
		Name:       opDeleteExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExportInput{}
	}

	output = &DeleteExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExport API operation for AWS Billing and Cost Management Data Exports.
//
// Deletes an existing data export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation DeleteExport for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/DeleteExport
func (c *BCMDataExports) DeleteExport(input *DeleteExportInput) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	return out, req.Send()
}

// DeleteExportWithContext is the same as DeleteExport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) DeleteExportWithContext(ctx aws.Context, input *DeleteExportInput, opts ...request.Option) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExecution = "GetExecution"

// GetExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExecution for more information on using the GetExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExecutionRequest method.
//	req, resp := client.GetExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetExecution
func (c *BCMDataExports) GetExecutionRequest(input *GetExecutionInput) (req *request.Request, output *GetExecutionOutput) {
	op := &request.Operation{
		Name:       opGetExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetExecutionInput{}
	}

	output = &GetExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExecution API operation for AWS Billing and Cost Management Data Exports.
//
// Exports data based on the source data update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation GetExecution for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetExecution
func (c *BCMDataExports) GetExecution(input *GetExecutionInput) (*GetExecutionOutput, error) {
	req, out := c.GetExecutionRequest(input)
	return out, req.Send()
}

// GetExecutionWithContext is the same as GetExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) GetExecutionWithContext(ctx aws.Context, input *GetExecutionInput, opts ...request.Option) (*GetExecutionOutput, error) {
	req, out := c.GetExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExport = "GetExport"

// GetExportRequest generates a "aws/request.Request" representing the
// client's request for the GetExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExport for more information on using the GetExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExportRequest method.
//	req, resp := client.GetExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetExport
func (c *BCMDataExports) GetExportRequest(input *GetExportInput) (req *request.Request, output *GetExportOutput) {
	op := &request.Operation{
		Name:       opGetExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetExportInput{}
	}

	output = &GetExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExport API operation for AWS Billing and Cost Management Data Exports.
//
// Views the definition of an existing data export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation GetExport for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetExport
func (c *BCMDataExports) GetExport(input *GetExportInput) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	return out, req.Send()
}

// GetExportWithContext is the same as GetExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) GetExportWithContext(ctx aws.Context, input *GetExportInput, opts ...request.Option) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTable = "GetTable"

// GetTableRequest generates a "aws/request.Request" representing the
// client's request for the GetTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTable for more information on using the GetTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTableRequest method.
//	req, resp := client.GetTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetTable
func (c *BCMDataExports) GetTableRequest(input *GetTableInput) (req *request.Request, output *GetTableOutput) {
	op := &request.Operation{
		Name:       opGetTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableInput{}
	}

	output = &GetTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTable API operation for AWS Billing and Cost Management Data Exports.
//
// Returns the metadata for the specified table and table properties. This includes
// the list of columns in the table schema, their data types, and column descriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation GetTable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/GetTable
func (c *BCMDataExports) GetTable(input *GetTableInput) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	return out, req.Send()
}

// GetTableWithContext is the same as GetTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) GetTableWithContext(ctx aws.Context, input *GetTableInput, opts ...request.Option) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExecutions = "ListExecutions"

// ListExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExecutions for more information on using the ListExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExecutionsRequest method.
//	req, resp := client.ListExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListExecutions
func (c *BCMDataExports) ListExecutionsRequest(input *ListExecutionsInput) (req *request.Request, output *ListExecutionsOutput) {
	op := &request.Operation{
		Name:       opListExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExecutionsInput{}
	}

	output = &ListExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExecutions API operation for AWS Billing and Cost Management Data Exports.
//
// Lists the historical executions for the export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation ListExecutions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListExecutions
func (c *BCMDataExports) ListExecutions(input *ListExecutionsInput) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	return out, req.Send()
}

// ListExecutionsWithContext is the same as ListExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListExecutionsWithContext(ctx aws.Context, input *ListExecutionsInput, opts ...request.Option) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExecutionsPages iterates over the pages of a ListExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExecutions operation.
//	pageNum := 0
//	err := client.ListExecutionsPages(params,
//	    func(page *bcmdataexports.ListExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BCMDataExports) ListExecutionsPages(input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool) error {
	return c.ListExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExecutionsPagesWithContext same as ListExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListExecutionsPagesWithContext(ctx aws.Context, input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExports for more information on using the ListExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExportsRequest method.
//	req, resp := client.ListExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListExports
func (c *BCMDataExports) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for AWS Billing and Cost Management Data Exports.
//
// Lists all data export definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation ListExports for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListExports
func (c *BCMDataExports) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	return out, req.Send()
}

// ListExportsWithContext is the same as ListExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListExportsWithContext(ctx aws.Context, input *ListExportsInput, opts ...request.Option) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExportsPages iterates over the pages of a ListExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExports operation.
//	pageNum := 0
//	err := client.ListExportsPages(params,
//	    func(page *bcmdataexports.ListExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BCMDataExports) ListExportsPages(input *ListExportsInput, fn func(*ListExportsOutput, bool) bool) error {
	return c.ListExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExportsPagesWithContext same as ListExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListExportsPagesWithContext(ctx aws.Context, input *ListExportsInput, fn func(*ListExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTablesRequest method.
//	req, resp := client.ListTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListTables
func (c *BCMDataExports) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTables API operation for AWS Billing and Cost Management Data Exports.
//
// Lists all available tables in data exports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListTables
func (c *BCMDataExports) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTables operation.
//	pageNum := 0
//	err := client.ListTablesPages(params,
//	    func(page *bcmdataexports.ListTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BCMDataExports) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListTagsForResource
func (c *BCMDataExports) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Billing and Cost Management Data Exports.
//
// List tags associated with an existing data export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ListTagsForResource
func (c *BCMDataExports) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/TagResource
func (c *BCMDataExports) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Billing and Cost Management Data Exports.
//
// Adds tags for an existing data export definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/TagResource
func (c *BCMDataExports) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/UntagResource
func (c *BCMDataExports) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Billing and Cost Management Data Exports.
//
// Deletes tags associated with an existing data export definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/UntagResource
func (c *BCMDataExports) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExport = "UpdateExport"

// UpdateExportRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExport for more information on using the UpdateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExportRequest method.
//	req, resp := client.UpdateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/UpdateExport
func (c *BCMDataExports) UpdateExportRequest(input *UpdateExportInput) (req *request.Request, output *UpdateExportOutput) {
	op := &request.Operation{
		Name:       opUpdateExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateExportInput{}
	}

	output = &UpdateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExport API operation for AWS Billing and Cost Management Data Exports.
//
// Updates an existing data export by overwriting all export parameters. All
// export parameters must be provided in the UpdateExport request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Billing and Cost Management Data Exports's
// API operation UpdateExport for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An error on the server occurred during the processing of your request. Try
//     again later.
//
//   - ResourceNotFoundException
//     The specified Amazon Resource Name (ARN) in the request doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/UpdateExport
func (c *BCMDataExports) UpdateExport(input *UpdateExportInput) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	return out, req.Send()
}

// UpdateExportWithContext is the same as UpdateExport with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BCMDataExports) UpdateExportWithContext(ctx aws.Context, input *UpdateExportInput, opts ...request.Option) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Includes basic information for a data column such as its description, name,
// and type.
type Column struct {
	_ struct{} `type:"structure"`

	// The description for a column.
	Description *string `type:"string"`

	// The column name.
	Name *string `type:"string"`

	// The kind of data a column stores.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Column) SetDescription(v string) *Column {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Column) SetName(v string) *Column {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Column) SetType(v string) *Column {
	s.Type = &v
	return s
}

type CreateExportInput struct {
	_ struct{} `type:"structure"`

	// The details of the export, including data query, name, description, and destination
	// configuration.
	//
	// Export is a required field
	Export *Export `type:"structure" required:"true"`

	// An optional list of tags to associate with the specified export. Each tag
	// consists of a key and a value, and each key must be unique for the resource.
	ResourceTags []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportInput"}
	if s.Export == nil {
		invalidParams.Add(request.NewErrParamRequired("Export"))
	}
	if s.Export != nil {
		if err := s.Export.Validate(); err != nil {
			invalidParams.AddNested("Export", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExport sets the Export field's value.
func (s *CreateExportInput) SetExport(v *Export) *CreateExportInput {
	s.Export = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateExportInput) SetResourceTags(v []*ResourceTag) *CreateExportInput {
	s.ResourceTags = v
	return s
}

type CreateExportOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) GoString() string {
	return s.String()
}

// SetExportArn sets the ExportArn field's value.
func (s *CreateExportOutput) SetExportArn(v string) *CreateExportOutput {
	s.ExportArn = &v
	return s
}

// The SQL query of column selections and row filters from the data table you
// want.
type DataQuery struct {
	_ struct{} `type:"structure"`

	// The query statement.
	//
	// QueryStatement is a required field
	QueryStatement *string `min:"1" type:"string" required:"true"`

	// The table configuration.
	TableConfigurations map[string]map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataQuery"}
	if s.QueryStatement == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStatement"))
	}
	if s.QueryStatement != nil && len(*s.QueryStatement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryStatement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryStatement sets the QueryStatement field's value.
func (s *DataQuery) SetQueryStatement(v string) *DataQuery {
	s.QueryStatement = &v
	return s
}

// SetTableConfigurations sets the TableConfigurations field's value.
func (s *DataQuery) SetTableConfigurations(v map[string]map[string]*string) *DataQuery {
	s.TableConfigurations = v
	return s
}

type DeleteExportInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExportInput"}
	if s.ExportArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportArn"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportArn sets the ExportArn field's value.
func (s *DeleteExportInput) SetExportArn(v string) *DeleteExportInput {
	s.ExportArn = &v
	return s
}

type DeleteExportOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) GoString() string {
	return s.String()
}

// SetExportArn sets the ExportArn field's value.
func (s *DeleteExportOutput) SetExportArn(v string) *DeleteExportOutput {
	s.ExportArn = &v
	return s
}

// The destinations used for data exports.
type DestinationConfigurations struct {
	_ struct{} `type:"structure"`

	// An object that describes the destination of the data exports file.
	//
	// S3Destination is a required field
	S3Destination *S3Destination `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfigurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfigurations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfigurations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfigurations"}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Destination sets the S3Destination field's value.
func (s *DestinationConfigurations) SetS3Destination(v *S3Destination) *DestinationConfigurations {
	s.S3Destination = v
	return s
}

// The reference for the data export update.
type ExecutionReference struct {
	_ struct{} `type:"structure"`

	// The ID for this specific execution.
	//
	// ExecutionId is a required field
	ExecutionId *string `type:"string" required:"true"`

	// The status of this specific execution.
	//
	// ExecutionStatus is a required field
	ExecutionStatus *ExecutionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionReference) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *ExecutionReference) SetExecutionId(v string) *ExecutionReference {
	s.ExecutionId = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *ExecutionReference) SetExecutionStatus(v *ExecutionStatus) *ExecutionReference {
	s.ExecutionStatus = v
	return s
}

// The status of the execution.
type ExecutionStatus struct {
	_ struct{} `type:"structure"`

	// The time when the execution was completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time when the execution was created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time when the execution was last updated.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The code for the status of the execution.
	StatusCode *string `type:"string" enum:"ExecutionStatusCode"`

	// The reason for the failed status.
	StatusReason *string `type:"string" enum:"ExecutionStatusReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatus) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *ExecutionStatus) SetCompletedAt(v time.Time) *ExecutionStatus {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ExecutionStatus) SetCreatedAt(v time.Time) *ExecutionStatus {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ExecutionStatus) SetLastUpdatedAt(v time.Time) *ExecutionStatus {
	s.LastUpdatedAt = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ExecutionStatus) SetStatusCode(v string) *ExecutionStatus {
	s.StatusCode = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ExecutionStatus) SetStatusReason(v string) *ExecutionStatus {
	s.StatusReason = &v
	return s
}

// The details that are available for an export.
type Export struct {
	_ struct{} `type:"structure"`

	// The data query for this specific data export.
	//
	// DataQuery is a required field
	DataQuery *DataQuery `type:"structure" required:"true"`

	// The description for this specific data export.
	Description *string `type:"string"`

	// The destination configuration for this specific data export.
	//
	// DestinationConfigurations is a required field
	DestinationConfigurations *DestinationConfigurations `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string `min:"20" type:"string"`

	// The name of this specific data export.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The cadence for Amazon Web Services to update the export in your S3 bucket.
	//
	// RefreshCadence is a required field
	RefreshCadence *RefreshCadence `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Export) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Export) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Export"}
	if s.DataQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("DataQuery"))
	}
	if s.DestinationConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfigurations"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RefreshCadence == nil {
		invalidParams.Add(request.NewErrParamRequired("RefreshCadence"))
	}
	if s.DataQuery != nil {
		if err := s.DataQuery.Validate(); err != nil {
			invalidParams.AddNested("DataQuery", err.(request.ErrInvalidParams))
		}
	}
	if s.DestinationConfigurations != nil {
		if err := s.DestinationConfigurations.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfigurations", err.(request.ErrInvalidParams))
		}
	}
	if s.RefreshCadence != nil {
		if err := s.RefreshCadence.Validate(); err != nil {
			invalidParams.AddNested("RefreshCadence", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataQuery sets the DataQuery field's value.
func (s *Export) SetDataQuery(v *DataQuery) *Export {
	s.DataQuery = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Export) SetDescription(v string) *Export {
	s.Description = &v
	return s
}

// SetDestinationConfigurations sets the DestinationConfigurations field's value.
func (s *Export) SetDestinationConfigurations(v *DestinationConfigurations) *Export {
	s.DestinationConfigurations = v
	return s
}

// SetExportArn sets the ExportArn field's value.
func (s *Export) SetExportArn(v string) *Export {
	s.ExportArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Export) SetName(v string) *Export {
	s.Name = &v
	return s
}

// SetRefreshCadence sets the RefreshCadence field's value.
func (s *Export) SetRefreshCadence(v *RefreshCadence) *Export {
	s.RefreshCadence = v
	return s
}

// The reference details for a given export.
type ExportReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`

	// The name of this specific data export.
	//
	// ExportName is a required field
	ExportName *string `min:"1" type:"string" required:"true"`

	// The status of this specific data export.
	//
	// ExportStatus is a required field
	ExportStatus *ExportStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportReference) GoString() string {
	return s.String()
}

// SetExportArn sets the ExportArn field's value.
func (s *ExportReference) SetExportArn(v string) *ExportReference {
	s.ExportArn = &v
	return s
}

// SetExportName sets the ExportName field's value.
func (s *ExportReference) SetExportName(v string) *ExportReference {
	s.ExportName = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportReference) SetExportStatus(v *ExportStatus) *ExportReference {
	s.ExportStatus = v
	return s
}

// The status of the data export.
type ExportStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the export was created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The timestamp of when the export was last generated.
	LastRefreshedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The timestamp of when the export was updated.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status code for the request.
	StatusCode *string `type:"string" enum:"ExportStatusCode"`

	// The description for the status code.
	StatusReason *string `type:"string" enum:"ExecutionStatusReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportStatus) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ExportStatus) SetCreatedAt(v time.Time) *ExportStatus {
	s.CreatedAt = &v
	return s
}

// SetLastRefreshedAt sets the LastRefreshedAt field's value.
func (s *ExportStatus) SetLastRefreshedAt(v time.Time) *ExportStatus {
	s.LastRefreshedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ExportStatus) SetLastUpdatedAt(v time.Time) *ExportStatus {
	s.LastUpdatedAt = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ExportStatus) SetStatusCode(v string) *ExportStatus {
	s.StatusCode = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ExportStatus) SetStatusReason(v string) *ExportStatus {
	s.StatusReason = &v
	return s
}

type GetExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID for this specific execution.
	//
	// ExecutionId is a required field
	ExecutionId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Export object that generated this specific
	// execution.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExecutionInput"}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.ExportArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportArn"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionId sets the ExecutionId field's value.
func (s *GetExecutionInput) SetExecutionId(v string) *GetExecutionInput {
	s.ExecutionId = &v
	return s
}

// SetExportArn sets the ExportArn field's value.
func (s *GetExecutionInput) SetExportArn(v string) *GetExecutionInput {
	s.ExportArn = &v
	return s
}

type GetExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ID for this specific execution.
	ExecutionId *string `type:"string"`

	// The status of this specific execution.
	ExecutionStatus *ExecutionStatus `type:"structure"`

	// The export data for this specific execution. This export data is a snapshot
	// from when the execution was generated. The data could be different from the
	// current export data if the export was updated since the execution was generated.
	Export *Export `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *GetExecutionOutput) SetExecutionId(v string) *GetExecutionOutput {
	s.ExecutionId = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *GetExecutionOutput) SetExecutionStatus(v *ExecutionStatus) *GetExecutionOutput {
	s.ExecutionStatus = v
	return s
}

// SetExport sets the Export field's value.
func (s *GetExecutionOutput) SetExport(v *Export) *GetExecutionOutput {
	s.Export = v
	return s
}

type GetExportInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportInput"}
	if s.ExportArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportArn"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportArn sets the ExportArn field's value.
func (s *GetExportInput) SetExportArn(v string) *GetExportInput {
	s.ExportArn = &v
	return s
}

type GetExportOutput struct {
	_ struct{} `type:"structure"`

	// The data for this specific export.
	Export *Export `type:"structure"`

	// The status of this specific export.
	ExportStatus *ExportStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportOutput) GoString() string {
	return s.String()
}

// SetExport sets the Export field's value.
func (s *GetExportOutput) SetExport(v *Export) *GetExportOutput {
	s.Export = v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *GetExportOutput) SetExportStatus(v *ExportStatus) *GetExportOutput {
	s.ExportStatus = v
	return s
}

type GetTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`

	// TableProperties are additional configurations you can provide to change the
	// data and schema of a table. Each table can have different TableProperties.
	// Tables are not required to have any TableProperties. Each table property
	// has a default value that it assumes if not specified.
	TableProperties map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *GetTableInput) SetTableName(v string) *GetTableInput {
	s.TableName = &v
	return s
}

// SetTableProperties sets the TableProperties field's value.
func (s *GetTableInput) SetTableProperties(v map[string]*string) *GetTableInput {
	s.TableProperties = v
	return s
}

type GetTableOutput struct {
	_ struct{} `type:"structure"`

	// The table description.
	Description *string `type:"string"`

	// The schema of the table.
	Schema []*Column `type:"list"`

	// The name of the table.
	TableName *string `type:"string"`

	// TableProperties are additional configurations you can provide to change the
	// data and schema of a table. Each table can have different TableProperties.
	// Tables are not required to have any TableProperties. Each table property
	// has a default value that it assumes if not specified.
	TableProperties map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetTableOutput) SetDescription(v string) *GetTableOutput {
	s.Description = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *GetTableOutput) SetSchema(v []*Column) *GetTableOutput {
	s.Schema = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableOutput) SetTableName(v string) *GetTableOutput {
	s.TableName = &v
	return s
}

// SetTableProperties sets the TableProperties field's value.
func (s *GetTableOutput) SetTableProperties(v map[string]*string) *GetTableOutput {
	s.TableProperties = v
	return s
}

// An error on the server occurred during the processing of your request. Try
// again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of objects that are returned for the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExecutionsInput"}
	if s.ExportArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportArn"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportArn sets the ExportArn field's value.
func (s *ListExecutionsInput) SetExportArn(v string) *ListExecutionsInput {
	s.ExportArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExecutionsInput) SetMaxResults(v int64) *ListExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsInput) SetNextToken(v string) *ListExecutionsInput {
	s.NextToken = &v
	return s
}

type ListExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of executions.
	Executions []*ExecutionReference `type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutions sets the Executions field's value.
func (s *ListExecutionsOutput) SetExecutions(v []*ExecutionReference) *ListExecutionsOutput {
	s.Executions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsOutput) SetNextToken(v string) *ListExecutionsOutput {
	s.NextToken = &v
	return s
}

type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that are returned for the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExportsInput) SetMaxResults(v int64) *ListExportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsInput) SetNextToken(v string) *ListExportsInput {
	s.NextToken = &v
	return s
}

type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the exports, including name and export status.
	Exports []*ExportReference `type:"list"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *ListExportsOutput) SetExports(v []*ExportReference) *ListExportsOutput {
	s.Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsOutput) SetNextToken(v string) *ListExportsOutput {
	s.NextToken = &v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that are returned for the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The list of tables.
	Tables []*Table `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*Table) *ListTablesOutput {
	s.Tables = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that are returned for the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The unique identifier for the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results.
	NextToken *string `type:"string"`

	// An optional list of tags to associate with the specified export. Each tag
	// consists of a key and a value, and each key must be unique for the resource.
	ResourceTags []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ListTagsForResourceOutput) SetResourceTags(v []*ResourceTag) *ListTagsForResourceOutput {
	s.ResourceTags = v
	return s
}

// The cadence for Amazon Web Services to update the data export in your S3
// bucket.
type RefreshCadence struct {
	_ struct{} `type:"structure"`

	// The frequency that data exports are updated. The export refreshes each time
	// the source data updates, up to three times daily.
	//
	// Frequency is a required field
	Frequency *string `type:"string" required:"true" enum:"FrequencyOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshCadence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshCadence) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshCadence) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshCadence"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrequency sets the Frequency field's value.
func (s *RefreshCadence) SetFrequency(v string) *RefreshCadence {
	s.Frequency = &v
	return s
}

// The specified Amazon Resource Name (ARN) in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the resource that was not found.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the resource that was not found.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The tag structure that contains a tag key and value.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The key that's associated with the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value that's associated with the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceTag) SetKey(v string) *ResourceTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTag) SetValue(v string) *ResourceTag {
	s.Value = &v
	return s
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket
// name and object keys of a data exports file.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket used as the destination of a data export
	// file.
	//
	// S3Bucket is a required field
	S3Bucket *string `type:"string" required:"true"`

	// The output configuration for the data export.
	//
	// S3OutputConfigurations is a required field
	S3OutputConfigurations *S3OutputConfigurations `type:"structure" required:"true"`

	// The S3 path prefix you want prepended to the name of your data export.
	//
	// S3Prefix is a required field
	S3Prefix *string `type:"string" required:"true"`

	// The S3 bucket Region.
	//
	// S3Region is a required field
	S3Region *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Destination"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3OutputConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputConfigurations"))
	}
	if s.S3Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Prefix"))
	}
	if s.S3Region == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Region"))
	}
	if s.S3OutputConfigurations != nil {
		if err := s.S3OutputConfigurations.Validate(); err != nil {
			invalidParams.AddNested("S3OutputConfigurations", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *S3Destination) SetS3Bucket(v string) *S3Destination {
	s.S3Bucket = &v
	return s
}

// SetS3OutputConfigurations sets the S3OutputConfigurations field's value.
func (s *S3Destination) SetS3OutputConfigurations(v *S3OutputConfigurations) *S3Destination {
	s.S3OutputConfigurations = v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *S3Destination) SetS3Prefix(v string) *S3Destination {
	s.S3Prefix = &v
	return s
}

// SetS3Region sets the S3Region field's value.
func (s *S3Destination) SetS3Region(v string) *S3Destination {
	s.S3Region = &v
	return s
}

// The compression type, file format, and overwrite preference for the data
// export.
type S3OutputConfigurations struct {
	_ struct{} `type:"structure"`

	// The compression type for the data export.
	//
	// Compression is a required field
	Compression *string `type:"string" required:"true" enum:"CompressionOption"`

	// The file format for the data export.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"FormatOption"`

	// The output type for the data export.
	//
	// OutputType is a required field
	OutputType *string `type:"string" required:"true" enum:"S3OutputType"`

	// The rule to follow when generating a version of the data export file. You
	// have the choice to overwrite the previous version or to be delivered in addition
	// to the previous versions. Overwriting exports can save on Amazon S3 storage
	// costs. Creating new export versions allows you to track the changes in cost
	// and usage data over time.
	//
	// Overwrite is a required field
	Overwrite *string `type:"string" required:"true" enum:"OverwriteOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3OutputConfigurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3OutputConfigurations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OutputConfigurations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3OutputConfigurations"}
	if s.Compression == nil {
		invalidParams.Add(request.NewErrParamRequired("Compression"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.OutputType == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputType"))
	}
	if s.Overwrite == nil {
		invalidParams.Add(request.NewErrParamRequired("Overwrite"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompression sets the Compression field's value.
func (s *S3OutputConfigurations) SetCompression(v string) *S3OutputConfigurations {
	s.Compression = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *S3OutputConfigurations) SetFormat(v string) *S3OutputConfigurations {
	s.Format = &v
	return s
}

// SetOutputType sets the OutputType field's value.
func (s *S3OutputConfigurations) SetOutputType(v string) *S3OutputConfigurations {
	s.OutputType = &v
	return s
}

// SetOverwrite sets the Overwrite field's value.
func (s *S3OutputConfigurations) SetOverwrite(v string) *S3OutputConfigurations {
	s.Overwrite = &v
	return s
}

// You've reached the limit on the number of resources you can create, or exceeded
// the size of an individual resource.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota code that was exceeded.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// The identifier of the resource that exceeded quota.
	ResourceId *string `type:"string"`

	// The type of the resource that exceeded quota.
	ResourceType *string `type:"string"`

	// The service code that exceeded quota. It will always be “AWSBillingAndCostManagementDataExports”.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details for the data export table.
type Table struct {
	_ struct{} `type:"structure"`

	// The description for the table.
	Description *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The properties for the table.
	TableProperties []*TablePropertyDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Table) SetDescription(v string) *Table {
	s.Description = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Table) SetTableName(v string) *Table {
	s.TableName = &v
	return s
}

// SetTableProperties sets the TableProperties field's value.
func (s *Table) SetTableProperties(v []*TablePropertyDescription) *Table {
	s.TableProperties = v
	return s
}

// The properties for the data export table.
type TablePropertyDescription struct {
	_ struct{} `type:"structure"`

	// The default value for the table.
	DefaultValue *string `type:"string"`

	// The description for the table.
	Description *string `type:"string"`

	// The name of the table.
	Name *string `type:"string"`

	// The valid values for the table.
	ValidValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TablePropertyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TablePropertyDescription) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TablePropertyDescription) SetDefaultValue(v string) *TablePropertyDescription {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TablePropertyDescription) SetDescription(v string) *TablePropertyDescription {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *TablePropertyDescription) SetName(v string) *TablePropertyDescription {
	s.Name = &v
	return s
}

// SetValidValues sets the ValidValues field's value.
func (s *TablePropertyDescription) SetValidValues(v []*string) *TablePropertyDescription {
	s.ValidValues = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The tags to associate with the resource. Each tag consists of a key and a
	// value, and each key must be unique for the resource.
	//
	// ResourceTags is a required field
	ResourceTags []*ResourceTag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.ResourceTags == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTags"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *TagResourceInput) SetResourceTags(v []*ResourceTag) *TagResourceInput {
	s.ResourceTags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota code that exceeded the throttling limit.
	QuotaCode *string `type:"string"`

	// The service code that exceeded the throttling limit. It will always be “AWSBillingAndCostManagementDataExports”.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The tag keys that are associated with the resource ARN.
	//
	// ResourceTagKeys is a required field
	ResourceTagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.ResourceTagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceTagKeys sets the ResourceTagKeys field's value.
func (s *UntagResourceInput) SetResourceTagKeys(v []*string) *UntagResourceInput {
	s.ResourceTagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateExportInput struct {
	_ struct{} `type:"structure"`

	// The name and query details for the export.
	//
	// Export is a required field
	Export *Export `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for this export.
	//
	// ExportArn is a required field
	ExportArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExportInput"}
	if s.Export == nil {
		invalidParams.Add(request.NewErrParamRequired("Export"))
	}
	if s.ExportArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportArn"))
	}
	if s.ExportArn != nil && len(*s.ExportArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExportArn", 20))
	}
	if s.Export != nil {
		if err := s.Export.Validate(); err != nil {
			invalidParams.AddNested("Export", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExport sets the Export field's value.
func (s *UpdateExportInput) SetExport(v *Export) *UpdateExportInput {
	s.Export = v
	return s
}

// SetExportArn sets the ExportArn field's value.
func (s *UpdateExportInput) SetExportArn(v string) *UpdateExportInput {
	s.ExportArn = &v
	return s
}

type UpdateExportOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExportOutput) GoString() string {
	return s.String()
}

// SetExportArn sets the ExportArn field's value.
func (s *UpdateExportOutput) SetExportArn(v string) *UpdateExportOutput {
	s.ExportArn = &v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that are invalid.
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the validation exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message with the reason for the validation exception error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The field name where the invalid entry was detected.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// CompressionOptionGzip is a CompressionOption enum value
	CompressionOptionGzip = "GZIP"

	// CompressionOptionParquet is a CompressionOption enum value
	CompressionOptionParquet = "PARQUET"
)

// CompressionOption_Values returns all elements of the CompressionOption enum
func CompressionOption_Values() []string {
	return []string{
		CompressionOptionGzip,
		CompressionOptionParquet,
	}
}

const (
	// ExecutionStatusCodeInitiationInProcess is a ExecutionStatusCode enum value
	ExecutionStatusCodeInitiationInProcess = "INITIATION_IN_PROCESS"

	// ExecutionStatusCodeQueryQueued is a ExecutionStatusCode enum value
	ExecutionStatusCodeQueryQueued = "QUERY_QUEUED"

	// ExecutionStatusCodeQueryInProcess is a ExecutionStatusCode enum value
	ExecutionStatusCodeQueryInProcess = "QUERY_IN_PROCESS"

	// ExecutionStatusCodeQueryFailure is a ExecutionStatusCode enum value
	ExecutionStatusCodeQueryFailure = "QUERY_FAILURE"

	// ExecutionStatusCodeDeliveryInProcess is a ExecutionStatusCode enum value
	ExecutionStatusCodeDeliveryInProcess = "DELIVERY_IN_PROCESS"

	// ExecutionStatusCodeDeliverySuccess is a ExecutionStatusCode enum value
	ExecutionStatusCodeDeliverySuccess = "DELIVERY_SUCCESS"

	// ExecutionStatusCodeDeliveryFailure is a ExecutionStatusCode enum value
	ExecutionStatusCodeDeliveryFailure = "DELIVERY_FAILURE"
)

// ExecutionStatusCode_Values returns all elements of the ExecutionStatusCode enum
func ExecutionStatusCode_Values() []string {
	return []string{
		ExecutionStatusCodeInitiationInProcess,
		ExecutionStatusCodeQueryQueued,
		ExecutionStatusCodeQueryInProcess,
		ExecutionStatusCodeQueryFailure,
		ExecutionStatusCodeDeliveryInProcess,
		ExecutionStatusCodeDeliverySuccess,
		ExecutionStatusCodeDeliveryFailure,
	}
}

const (
	// ExecutionStatusReasonInsufficientPermission is a ExecutionStatusReason enum value
	ExecutionStatusReasonInsufficientPermission = "INSUFFICIENT_PERMISSION"

	// ExecutionStatusReasonBillOwnerChanged is a ExecutionStatusReason enum value
	ExecutionStatusReasonBillOwnerChanged = "BILL_OWNER_CHANGED"

	// ExecutionStatusReasonInternalFailure is a ExecutionStatusReason enum value
	ExecutionStatusReasonInternalFailure = "INTERNAL_FAILURE"
)

// ExecutionStatusReason_Values returns all elements of the ExecutionStatusReason enum
func ExecutionStatusReason_Values() []string {
	return []string{
		ExecutionStatusReasonInsufficientPermission,
		ExecutionStatusReasonBillOwnerChanged,
		ExecutionStatusReasonInternalFailure,
	}
}

const (
	// ExportStatusCodeHealthy is a ExportStatusCode enum value
	ExportStatusCodeHealthy = "HEALTHY"

	// ExportStatusCodeUnhealthy is a ExportStatusCode enum value
	ExportStatusCodeUnhealthy = "UNHEALTHY"
)

// ExportStatusCode_Values returns all elements of the ExportStatusCode enum
func ExportStatusCode_Values() []string {
	return []string{
		ExportStatusCodeHealthy,
		ExportStatusCodeUnhealthy,
	}
}

const (
	// FormatOptionTextOrCsv is a FormatOption enum value
	FormatOptionTextOrCsv = "TEXT_OR_CSV"

	// FormatOptionParquet is a FormatOption enum value
	FormatOptionParquet = "PARQUET"
)

// FormatOption_Values returns all elements of the FormatOption enum
func FormatOption_Values() []string {
	return []string{
		FormatOptionTextOrCsv,
		FormatOptionParquet,
	}
}

const (
	// FrequencyOptionSynchronous is a FrequencyOption enum value
	FrequencyOptionSynchronous = "SYNCHRONOUS"
)

// FrequencyOption_Values returns all elements of the FrequencyOption enum
func FrequencyOption_Values() []string {
	return []string{
		FrequencyOptionSynchronous,
	}
}

const (
	// OverwriteOptionCreateNewReport is a OverwriteOption enum value
	OverwriteOptionCreateNewReport = "CREATE_NEW_REPORT"

	// OverwriteOptionOverwriteReport is a OverwriteOption enum value
	OverwriteOptionOverwriteReport = "OVERWRITE_REPORT"
)

// OverwriteOption_Values returns all elements of the OverwriteOption enum
func OverwriteOption_Values() []string {
	return []string{
		OverwriteOptionCreateNewReport,
		OverwriteOptionOverwriteReport,
	}
}

const (
	// S3OutputTypeCustom is a S3OutputType enum value
	S3OutputTypeCustom = "CUSTOM"
)

// S3OutputType_Values returns all elements of the S3OutputType enum
func S3OutputType_Values() []string {
	return []string{
		S3OutputTypeCustom,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
