/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.discovery;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.DiscoveryServiceRegistry;
import org.openhab.core.config.discovery.ScanListener;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.core.discovery.DiscoveryInfoDTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="discovery")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="discovery")
@Component(service={RESTResource.class, DiscoveryResource.class})
@JaxrsResource
@JaxrsName(value="discovery")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class DiscoveryResource
implements RESTResource {
    public static final String PATH_DISCOVERY = "discovery";
    private final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);
    private final DiscoveryServiceRegistry discoveryServiceRegistry;
    private final LocaleService localeService;
    private final TranslationProvider i18nProvider;

    @Activate
    public DiscoveryResource(@Reference DiscoveryServiceRegistry discoveryServiceRegistry, @Reference TranslationProvider translationProvider, @Reference LocaleService localeService) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
        this.i18nProvider = translationProvider;
        this.localeService = localeService;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getBindingsWithDiscoverySupport", summary="Gets all bindings that support discovery.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class), uniqueItems=true))})})
    public Response getDiscoveryServices() {
        List supportedBindings = this.discoveryServiceRegistry.getSupportedBindings();
        return Response.ok(new LinkedHashSet(supportedBindings)).build();
    }

    @GET
    @Path(value="/bindings/{bindingId}/info")
    @Produces(value={"application/json"})
    @Operation(operationId="getDiscoveryServicesInfo", summary="Gets information about the discovery services for a binding.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DiscoveryInfoDTO.class))}), @ApiResponse(responseCode="404", description="Discovery service not found")})
    public Response getDiscoveryServicesInfo(@PathParam(value="bindingId") @Parameter(description="binding Id") String bindingId, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        String label = null;
        String description = null;
        boolean supported = false;
        Set discoveryServices = this.discoveryServiceRegistry.getDiscoveryServices(bindingId);
        if (discoveryServices.isEmpty()) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)("No discovery service found for binding " + bindingId));
        }
        for (DiscoveryService discoveryService : discoveryServices) {
            if (!discoveryService.isScanInputSupported()) continue;
            Bundle bundle = FrameworkUtil.getBundle(discoveryService.getClass());
            label = discoveryService.getScanInputLabel();
            if (label != null) {
                label = this.i18nProvider.getText(bundle, I18nUtil.stripConstant((String)label), label, locale);
            }
            if ((description = discoveryService.getScanInputDescription()) != null) {
                description = this.i18nProvider.getText(bundle, I18nUtil.stripConstant((String)description), description, locale);
            }
            supported = true;
            break;
        }
        return Response.ok((Object)new DiscoveryInfoDTO(supported, label, description)).build();
    }

    @POST
    @Path(value="/bindings/{bindingId}/scan")
    @Produces(value={"text/plain"})
    @Operation(operationId="scan", summary="Starts asynchronous discovery process for a binding and returns the timeout in seconds of the discovery operation.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="404", description="Discovery service not found")})
    public Response scan(final @PathParam(value="bindingId") @Parameter(description="binding Id") String bindingId, @QueryParam(value="input") @Parameter(description="input parameter to start the discovery") @Nullable String input) {
        if (this.discoveryServiceRegistry.getDiscoveryServices(bindingId).isEmpty()) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)("No discovery service found for binding " + bindingId));
        }
        this.discoveryServiceRegistry.startScan(bindingId, input, new ScanListener(){

            public void onErrorOccurred(@Nullable Exception exception) {
                DiscoveryResource.this.logger.error("Error occurred while scanning for binding '{}'", (Object)bindingId, (Object)exception);
            }

            public void onFinished() {
                DiscoveryResource.this.logger.debug("Scan for binding '{}' successfully finished.", (Object)bindingId);
            }
        });
        return Response.ok((Object)this.discoveryServiceRegistry.getMaxScanTimeout(bindingId)).build();
    }
}

