<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2022 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class Fatdown extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function ba(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var ca=[""],da=[0,0],ea=["","t"],fa=["","id"],ka={flags:0},la=["","type"],na={flags:514},oa={flags:3089},pa={flags:3201},sa=[65519,65457],ta=[32960,33025],ua=[65477,65409],va=[39819,65457],wa=[32896,33153],xa=[65519,65441],ya=[65424,65408],za=[65408,65416],Aa=[63463,65441],Ba=[65408,65408],Ca=["","album_id"],Da=["","track_id"],Ea=["","type","id"],Fa=["","playlist_id"],Ga=["","channel","clip_id"],x={c:[],q:!1},Ha={c:[],q:!0},Ia={"class":x},A={C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,
"html:i":1,"html:strong":1,"html:u":1},Ja=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,fa]],Ka={C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rp":1,"html:rt":1,"html:strong":1,"html:u":1};function La(a,b){var c={},d;for(d in b.b){var l=b.b[d],k=!1;if(d in a.b){k=l.c;var h=d,t=a.b[d];B.y=h;for(var p=0;p<k.length&&(t=k[p](t,h),!1!==t);++p);delete B.y;k=t}!1!==k?c[d]=k:l.q&&C(a)}Ma(a,c)}
var F=[La],Oa=[function(a){return Na(a,/^[-0-9A-Za-z_]+$/)}],Pa={c:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],q:!1},Wa=[function(a){var b=Qa.urlConfig,c=B,d=Ta(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Ua(b,d))?(c&&(d.attrValue=a,c.add("err",b,d)),a=!1):a=Va(d);return a}],Xa={c:Oa,q:!0},Ya={c:[function(a){return Na(a,/^[- +,.0-9A-Za-z_]+$/)}],q:!1},Za={c:Wa,q:!0},$a={m:A,flags:268,n:A},
ab={m:A,flags:3460,n:A},bb={m:A,flags:3456,n:A},cb={d:da,b:{},i:0,c:F,f:10,e:{flags:66},g:5E3},db={d:ua,b:{},i:0,c:F,f:10,e:{flags:2},g:5E3},eb={d:ua,b:{},i:0,c:F,f:10,e:ka,g:5E3},fb={d:sa,b:{},i:0,c:F,f:10,e:{flags:512},g:5E3},gb={m:{C:1,EM:1,EMAIL:1,LI:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:li":1,"html:strong":1,"html:u":1},flags:264,n:A},hb={m:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:dd":1,"html:dt":1,"html:i":1,"html:strong":1,"html:u":1},flags:256,n:A},
mb={m:{C:1,EM:1,EMAIL:1,STRONG:1,TD:1,TH:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:u":1},flags:256,n:A},nb={d:ta,b:{id:x},i:2,c:F,f:10,e:oa,g:5E3},ob={d:wa,b:{"char":Ha},i:8,c:F,f:10,e:oa,g:5E3},pb={align:{c:[function(a){return a.toLowerCase()},function(a){return Na(a,/^(?:center|justify|left|right)$/)}],q:!1}},qb={d:ua,b:{},i:3,c:F,f:10,e:{m:A,flags:260,n:A},g:5E3},rb={d:[65408,65418],b:{},i:1,c:F,f:10,e:ab,g:5E3},sb={d:za,b:{},i:9,c:F,f:10,e:bb,g:5E3},
tb={d:ya,b:{},i:1,c:F,f:10,e:ab,g:5E3},ub={d:Ba,b:{},i:14,c:F,f:10,e:bb,g:5E3},vb={d:[65408,65412],b:{},i:11,c:F,f:10,e:{m:{C:1,EM:1,EMAIL:1,STRONG:1,TD:1,TH:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:tr":1,"html:u":1},flags:3456,n:A},g:5E3},wb={d:za,b:{},i:9,c:F,f:10,e:{m:{C:1,EM:1,EMAIL:1,STRONG:1,TBODY:1,TD:1,TH:1,THEAD:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:tbody":1,"html:td":1,"html:th":1,"html:thead":1,"html:tr":1,
"html:u":1},flags:3456,n:A},g:5E3},xb=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="urn:s9e:TextFormatter:html" exclude-result-prefixes="html"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$pMEDIAEMBED_THEME"/><xsl:param$pTASKLISTS_EDITABLE"/>$aBANDCAMP"><$w$hbandcamp"$k$g400px"><$w$k$d100%"><$t$i"$q$x$nno"$k$f><$l$psrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$u><$v$o@album_id">album=$c@album_id"/><$s$o@track_num">/t=$c@track_num"/></$s></$v><$r>track=$c@track_id"/></$r></$u><$s$o$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</$s></$l></$t></$w></$w>$b$aC"><code>$e</code>$b$aCODE"><pre><code><$s$o@lang"><$l$pclass">language-$c@lang"/></$l></$s>$e</code></pre>$b$aDAILYMOTION"><$w$hdailymotion"$k$g640px"><$w$k$d56.25%"><$t$i"$q$x$nno"$k$f><$l$psrc">//www.dailymotion.com/embed/video/$c@id"/><$s$o@t">?start=$c@t"/></$s></$l></$t></$w></$w>$b$aDEL|EM|H1|H2|H3|H4|H5|H6|STRONG|SUB|SUP|TABLE|TBODY|THEAD|TR|html:b|html:br|html:code|html:dd|html:del|html:dl|html:dt|html:i|html:ins|html:li|html:ol|html:pre|html:rb|html:rp|html:rt|html:rtc|html:ruby|html:strong|html:sub|html:sup|html:table|html:tbody|html:tfoot|html:thead|html:tr|html:u|html:ul|p"><xsl:element$p{translate(local-name(),\\\'ABDEGHLMNOPRSTUY\\\',\\\'abdeghlmnoprstuy\\\')}">$e</xsl:element>$b$aEMAIL"><a href="mailto:{@email}">$e</a>$b$aESC">$e$b$aFACEBOOK"><$t$hfacebook"$i"$mstyle"$q$x onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$nno"$yhttps://s9e.github.io/$t/2/facebook.min.html#{@type}{@id}"$kborder:0;height:360px;max-width:640px;width:100%"/>$b$aFP|HE">$c@char"/>$b$aHC"><xsl:comment>$c@content"/></xsl:comment>$b$aHR"><hr/>$b$aIMG"><img$y{@src}">$jalt|@title"/></img>$b$aISPOILER"><$w class="spoiler"$mstyle" onclick="removeAttribute(\\\'style\\\')"$kbackground:#444;color:transparent">$e</$w>$b$aLI"><li><$s$oTASK"><$l$pdata-s9e-livepreview-ignore-attrs">data-task-id</$l><$l$pdata-task-id">$cTASK/@id"/></$l><$l$pdata-task-state">$cTASK/@state"/></$l></$s>$e</li>$b$aLIST"><$u><$v$onot(@type)"><ul>$e</ul></$v><$r><ol>$jstart"/>$e</ol></$r></$u>$b$aLIVELEAK"><$w$hliveleak"$k$g640px"><$w$k$d56.25%"><$t$i"$q$x$nno"$y//www.liveleak.com/e/{@id}"$k$f/></$w></$w>$b$aQUOTE"><blockquote>$e</blockquote>$b$aSOUNDCLOUD"><$t$hsoundcloud"$i"$q$x$nno"><$l$psrc">https://w.soundcloud.com/player/?url=<$u><$v$o$z">https%3A//api.soundcloud.com/playlists/$c$z"/>%3Fsecret_token%3D$c@secret_token"/></$v><$v$o@track_id">https%3A//api.soundcloud.com/tracks/$c@track_id"/>%3Fsecret_token%3D$c@secret_token"/></$v><$r><$s$onot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$s>$c@id"/></$r></$u></$l><$l$pstyle">border:0;height:<$u><$v$o$z or contains(@id,\\\'/sets/\\\')">450</$v><$r>166</$r></$u>px;max-width:900px;width:100%</$l></$t>$b$aSPOILER"><details class="spoiler"$mopen">$e</details>$b$aSPOTIFY"><$u><$v$ostarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$t$hspotify" allow="encrypted-media"$i"$q$x$nno"$yhttps://open.spotify.com/embed/{@id}"$kborder:0;height:152px;max-width:900px;width:100%"/></$v><$r><$w$hspotify"$k$g320px"><$w$k$d125%;padding-bottom:calc(100% + 80px)"><$t allow="encrypted-media"$i"$q$x$nno"$yhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$k$f/></$w></$w></$r></$u>$b$aTASK"><input data-task-id="{@id}"$mdata-task-id" type="checkbox"><$s$o@state=\\\'checked\\\'"><$l$pchecked"/></$s><$s$onot($TASKLISTS_EDITABLE)"><$l$pdisabled"/></$s></input>$b$aTD"><td><$s$o@align"><$l$pstyle">text-align:$c@align"/></$l></$s>$e</td>$b$aTH"><th><$s$o@align"><$l$pstyle">text-align:$c@align"/></$l></$s>$e</th>$b$aTWITCH"><$w$htwitch"$k$g640px"><$w$k$d56.25%"><$t$i"$q$x onload="contentWindow.postMessage(\\\'\\\',\\\'https://s9e.github.io\\\')"$nno"$yhttps://s9e.github.io/$t/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$k$f/></$w></$w>$b$aURL"><a href="{@url}">$jtitle"/>$e</a>$b$aVIMEO"><$w$hvimeo"$k$g640px"><$w$k$d56.25%"><$t$i"$q$x$nno"$k$f><$l$psrc">//player.vimeo.com/video/$c@id"/><$s$o@h">?h=$c@h"/></$s><$s$o@t">#t=$c@t"/></$s></$l></$t></$w></$w>$b$aVINE"><$w$hvine"$k$g480px"><$w$k$d100%"><$t$i"$q$x$nno"$yhttps://vine.co/v/{@id}/embed/simple?audio=1"$k$f/></$w></$w>$b$aYOUTUBE"><$w$hyoutube"$k$g640px"><$w$k$d56.25%"><$t$i"$q$x$nno"$kbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$f><$l$psrc">https://www.youtube.com/embed/$c@id"/><$s$o@list">?list=$c@list"/></$s><$s$o@t"><$u><$v$o@list">&amp;</$v><$r>?</$r></$u>start=$c@t"/></$s></$l></$t></$w></$w>$b$abr"><br/>$b$ae|i|s"/>$ahtml:abbr"><abbr>$jtitle"/>$e</abbr>$b$ahtml:div"><div>$jclass"/>$e</div>$b$ahtml:img"><img>$jalt|@height|@src|@title|@width"/>$e</img>$b$ahtml:$w"><$w>$jclass"/>$e</$w>$b$ahtml:td"><td>$jcol$w|@row$w"/>$e</td>$b$ahtml:th"><th>$jcol$w|@row$w|@scope"/>$e</th>$b</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:\'<xsl:template match="\',$b:"</xsl:template>",$c:\'<xsl:value-of select="\',$d:"display:block;overflow:hidden;position:relative;padding-bottom:",$e:"<xsl:apply-templates/>",$f:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$g:"display:inline-block;width:100%;max-width:",$h:\' data-s9e-mediaembed="\',$i:\' allowfullscreen="\',$j:\'<xsl:copy-of select="@\',$k:\' style="\',$l:"xsl:attribute",$m:\' data-s9e-livepreview-ignore-attrs="\',$n:\' scrolling="\',$o:\' test="\',$p:\' name="\',
$q:\' loading="\',$r:"xsl:otherwise",$s:"xsl:if",$t:"iframe",$u:"xsl:choose",$v:"xsl:when",$w:"span",$x:\'lazy"\',$y:\' src="\',$z:"@playlist_id"}[a]});function Na(a,b){return b.test(a)?a:!1}
function Ta(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(d,l){c[d]=""<b[l+1]?b[l+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function Va(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=yb(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+yb(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(d){return d.toUpperCase()},c);b+=zb(c);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));return b}
function zb(a){return a.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,function(b){return"%"+b[0].charCodeAt(0).toString(16).toUpperCase()})}
function Ua(a,b){if(""!==b.scheme&&!a.S.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var d=4,l=c.split(".");0<=--d;){if("0"===l[d][0]||255<l[d]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.U&&
a.U.test(b.host)||a.X&&!a.X.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function Ab(a){var b=document.createElement("b");Ab=function(c){b.innerHTML=c.replace(/</g,"&lt;");return b.textContent};return Ab(a)}function Bb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}
function Cb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function yb(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}function Db(){this.p={};this.r=[]}Db.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.y||(c.attrName=this.y);"tag"in c||!this.l||(c.tag=this.l);this.p[a]&&this.p[a].forEach(function(d){d(b,c)});this.r.push([a,b,c])};Db.prototype.getLogs=function(){return this.r};
Db.prototype.on=function(a,b){this.p[a].push(b)};function Eb(a,b){B.add("debug",a,b)}function Fb(a,b,c,d,l){this.l=+a;this.name=b;this.j=+c;this.k=+d;this.r=+l||0;this.b={};this.O=[];isNaN(a+c+d)&&C(this)}Fb.prototype.p=!1;function Gb(a,b){a.O.push(b);a.p&&C(b)}function C(a){a.p||(a.p=!0,a.O.forEach(function(b){C(b)}))}function Hb(a,b){Ib(a,b)?(a.z=b,b.G=a,Gb(a,b)):Ib(b,a)&&(a.G=b,b.z=a)}function Ib(a,b){return a.name===b.name&&1===a.l&&2===b.l&&a.j<=a.j}
function Jb(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function Kb(a,b){return a.p||!Ib(b,a)||a.G&&a.G!==b||b.z&&b.z!==a?!1:!0}function Ma(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var Lb,Mb,G,Nb,H,Ob,B=new Db,Pb,I,J,Sb={Autoemail:{u:function(a,b){b.forEach(function(c){var d=K(1,"EMAIL",c[0][1],0,0);d.b.email=c[0][0];c=Qb("EMAIL",c[0][1]+c[0][0].length,0);Hb(d,c)})},v:"@",w:/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/ig,x:5E4},Autolink:{u:function(a,b){b.forEach(function(c){var d=c[0][1],l=c[0][0].replace(/(?:(?![-=+)\\/_])[\\s!-.:-@[-`{-~])+$/,""),k=d+l.length,h=Qb("URL",k,0);"."===l[3]&&(l="http://"+l);c=K(1,"URL",d,0,1);c.b.url=l;Hb(c,h);d=K(3,"v",d,k-d,1E3);Gb(c,d)})},v:":",w:/\\b(?:ftp|https?|mailto):(?:[^\\s()\\[\\]\\uFF01-\\uFF0F\\uFF1A-\\uFF20\\uFF3B-\\uFF40\\uFF5B-\\uFF65]|\\([^\\s()]*\\)|\\[\\w*\\])+/ig,
x:5E4},Escaper:{u:function(a,b){b.forEach(function(c){L("ESC",c[0][1],1,c[0][1]+c[0][0].length,0)})},v:"\\\\",w:/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/g,x:5E4},FancyPants:{u:function(a){function b(f,m,n,v){f=K(3,r,f,m,v||0);f.b[e]=n;return f}function c(){if(!(0>a.indexOf("...")&&0>a.indexOf("--")))for(var f={"--":"\\u2013","---":"\\u2014","...":"\\u2026"},m=/---?|\\.\\.\\./g,n;n=m.exec(a);)b(n.index,n[0].length,f[n[0]])}function d(){if(!(0>a.indexOf("/")))for(var f={"0/3":"\\u2189","1/10":"\\u2152","1/2":"\\u00bd","1/3":"\\u2153",
"1/4":"\\u00bc","1/5":"\\u2155","1/6":"\\u2159","1/7":"\\u2150","1/8":"\\u215b","1/9":"\\u2151","2/3":"\\u2154","2/5":"\\u2156","3/4":"\\u00be","3/5":"\\u2157","3/8":"\\u215c","4/5":"\\u2158","5/6":"\\u215a","5/8":"\\u215d","7/8":"\\u215e"},m,n=/\\b(?:0\\/3|1\\/(?:[2-9]|10)|2\\/[35]|3\\/[458]|4\\/5|5\\/[68]|7\\/8)\\b/g;m=n.exec(a);)b(m.index,m[0].length,f[m[0]])}function l(){if(!(0>a.indexOf("<<")))for(var f,m=/<<( ?)(?! )[^\\n<>]*?[^\\n <>]\\1>>(?!>)/g;f=m.exec(a);){var n=b(f.index,2,"\\u00ab");f=b(f.index+f[0].length-2,2,
"\\u00bb");Gb(n,f)}}function k(){if(!(0>a.indexOf("!=")&&0>a.indexOf("=/=")))for(var f,m=/\\b (?:!|=\\/)=(?= \\b)/g;f=m.exec(a);)b(f.index+1,f[0].length-1,"\\u2260")}function h(f,m,n,v){for(var z;z=m.exec(a);){var y=b(z.index+z[0].indexOf(f),1,n);z=b(z.index+z[0].length-1,1,v);Gb(y,z)}}function t(){if(g)for(var f,m=/[a-z]\'|(?:^|\\s)\'(?=[a-z]|[0-9]{2})/gi;f=m.exec(a);)b(f.index+f[0].indexOf("\'"),1,"\\u2019",10)}function p(){if(g||q||!(0>a.indexOf("x")))for(var f={"\'s":"\\u2019","\'":"\\u2032","\' ":"\\u2032",
"\'x":"\\u2032",\'"\':"\\u2033",\'" \':"\\u2033",\'"x\':"\\u2033"},m,n=/[0-9](?:\'s|["\']? ?x(?= ?[0-9])|["\'])/g;m=n.exec(a);){"x"===m[0][m[0].length-1]&&b(m.index+m[0].length-1,1,"\\u00d7");var v=m[0].substring(1,3);f[v]&&b(m.index+1,1,f[v])}}function u(){if(!(0>a.indexOf("(")))for(var f={"(c)":"\\u00a9","(r)":"\\u00ae","(tm)":"\\u2122"},m=/\\((?:c|r|tm)\\)/gi,n;n=m.exec(a);)b(n.index,n[0].length,f[n[0].toLowerCase()])}var w={y:"char",K:"FP"},e=w.y,g=0<=a.indexOf("\'"),q=0<=a.indexOf(\'"\'),r=w.K;"undefined"===typeof w.ba&&
(t(),g&&h("\'",/(?:^|\\W)\'.+?\'(?!\\w)/g,"\\u2018","\\u2019"),q&&h(\'"\',/(?:^|\\W)".+?"(?!\\w)/g,"\\u201c","\\u201d"));"undefined"===typeof w.Z&&l();"undefined"===typeof w.$&&(k(),p(),d());"undefined"===typeof w.aa&&c();"undefined"===typeof w.ca&&u()}},HTMLComments:{u:function(a,b){b.forEach(function(c){var d=Ab(c[0][0].substring(4,c[0][0].length-3));d=d.replace(/[<>]/g,"");d=d.replace(/-+$/,"");d=d.replace(/--/g,"");K(3,"HC",c[0][1],c[0][0].length,0).b.content=d})},v:"\\x3c!--",w:/\\x3c!--(?!\\[if)[\\s\\S]*?--\\x3e/ig,
x:5E4},HTMLElements:{u:function(a,b){var c={a:{"":"URL",href:"url"},em:{"":"EM"},hr:{"":"HR"},s:{"":"S"},strong:{"":"STRONG"},sup:{"":"SUP"}};b.forEach(function(d){var l="/"===a[d[0][1]+1],k=d[0][1],h=d[0][0].length,t=d[2-l][0].toLowerCase(),p=c&&c[t]&&c[t][""]?c[t][""]:"html:"+t;if(l)Qb(p,k,h);else for(l=/(<\\S+|[\'"\\s])\\/>$/.test(d[0][0])?L(p,k,h,k+h,0):K(1,p,k,h,0),d=d[3][0],k=/([a-z][-a-z0-9]*)(?:\\s*=\\s*("[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?/gi;p=k.exec(d);)h=p[1].toLowerCase(),p="undefined"!==typeof p[2]?
p[2]:h,c&&c[t]&&c[t][h]&&(h=c[t][h]),/^["\']/.test(p)&&(p=p.substring(1,p.length-1)),p=Ab(p),l.b[h]=p})},v:"<",w:/<(?:\\/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?:\\s+[a-z][-a-z0-9]*(?:\\s*=\\s*(?:"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*)\\s*\\/?)\\s*>/ig,x:5E4},
HTMLEntities:{u:function(a,b){b.forEach(function(c){var d=c[0][0],l=Ab(d);l===d||32>l.charCodeAt(0)||(K(3,"HE",c[0][1],d.length,0).b["char"]=l)})},v:"&",w:/&(?:[a-z]+|#(?:[0-9]+|x[0-9a-f]+));/ig,x:5E4},Litedown:{u:function(a){function b(e){-1<e.indexOf("&")&&(e=Ab(e));e=e.replace(/\\x1A/g,"");p&&(e=e.replace(/\\x1B./g,function(g){return{"\\u001b0":"!","\\u001b1":\'"\',"\\u001b2":"\'","\\u001b3":"(","\\u001b4":")","\\u001b5":"*","\\u001b6":"<","\\u001b7":">","\\u001b8":"[","\\u001b9":"\\\\","\\u001bA":"]","\\u001bB":"^",
"\\u001bC":"_","\\u001bD":"`","\\u001bE":"~"}[g]}));return e}function c(e){return 0<" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(e)}function d(e){a=a.substring(0,e)+"\\u0017"+a.substring(e+1)}function l(e,g){0<g&&(a=a.substring(0,e)+Array(1+g).join("\\u001a")+a.substring(e+g))}function k(e,g,q){if(-1!==a.indexOf(e))for(var r;r=g.exec(a);)e=r.index,r=e+r[0].length-2,L(q,e,2,r,2),l(e,2),l(r,2)}function h(e,g,q,r){function f(n){n=a.indexOf(g+"(",n);if(-1!==n){var v;for(r.lastIndex=
n;v=r.exec(a);){var z=v[0];v=v.index;var y=z.length;L(e,v,2,v+y-1,1);l(v,y)}z&&f(n)}}var m=a.indexOf(g);-1!==m&&(function(n){var v;for(q.lastIndex=n;v=q.exec(a);){n=v[0];v=v.index;var z=n.length;n=n.charAt(z-1)===g?1:0;L(e,v,1,v+z-n,n)}}(m),f(m))}function t(e,g,q){var r=g.replace(/^\\s*/,"").replace(/\\s*$/,"");g="";var f=r.indexOf(" ");-1!==f&&(g=r.substring(f).replace(/^\\s*\\S/,"").replace(/\\S\\s*$/,""),r=r.substring(0,f));/^<.+>$/.test(r)&&(r=r.replace(/^<(.+)>$/,"$1").replace(/\\\\>/g,">"));r=b(r);
e.b[q]=r;""<g&&(q=b(g),e.b.title=q)}var p=!1,u=!1,w={};0<=a.indexOf("\\\\")&&(p=!0,a=a.replace(/\\\\[!"\'()*<>[\\\\\\]^_`~]/g,function(e){return{"\\\\!":"\\u001b0",\'\\\\"\':"\\u001b1","\\\\\'":"\\u001b2","\\\\(":"\\u001b3","\\\\)":"\\u001b4","\\\\*":"\\u001b5","\\\\<":"\\u001b6","\\\\>":"\\u001b7","\\\\[":"\\u001b8","\\\\\\\\":"\\u001b9","\\\\]":"\\u001bA","\\\\^":"\\u001bB","\\\\_":"\\u001bC","\\\\`":"\\u001bD","\\\\~":"\\u001bE"}[e]}));a+="\\n\\n\\u0017";(function(){function e(m,n){Hb(Qb("LIST",n,0),m.V);Hb(Qb("LI",n,0),m.I);m.Q&&m.J.forEach(function(v){v.flags&=
-9})}function g(m,n){for(var v=m;0<=--n;)v=v.replace(/^ *>!? ?/,"");return m.length-v.length}function q(m){for(var n=[],v=/>!?/g,z;z=v.exec(m);)n.push(z[0]);return n}function r(){if(-1!==a.indexOf("-")||-1!==a.indexOf("="))for(var m,n=/^(?=[-=>])(?:>!? ?)*(?=[-=])(?:-+|=+) *$/gm;m=n.exec(a);){var v=m[0];m=m.index;for(var z=m-1;0<z&&" "===a[z-1];)--z;f[m-1]={M:m+v.length-z,N:z,T:v.length-v.replace(/>/g,"").length,K:"="===v[0]?"H1":"H2"}}}var f={};(function(){r();for(var m=[],n=0,v,z=4,y,M=!0,E=[],
N=0,ha=!1,O=0,ma,Z,S,ib,ac,U,Q,jb,Ra,ia,ja,qa,bc=[],kb,Sa=/^(?:(?=[-*+\\d \\t>`~#_])((?: {0,3}>(?:(?!!)|!(?![^\\n>]*?!<)) ?)+)?([ \\t]+)?(\\* *\\* *\\*[* ]*$|- *- *-[- ]*$|_ *_ *_[_ ]*$)?((?:[-*+]|\\d+\\.)[ \\t]+(?=\\S))?[ \\t]*(#{1,6}[ \\t]+|```+[^`\\n]*$|~~~+[^~\\n]*$)?)?/gm;kb=Sa.exec(a);)bc.push(kb),kb.index===Sa.lastIndex&&++Sa.lastIndex;bc.forEach(function(D){var aa=[],V=D.index,ra=D[0].length,R;ia=S=0;Z=!M;U=a.indexOf("\\n",V);M=U===V+ra&&!D[3]&&!D[4]&&!D[5];ra||++Sa.lastIndex;ma=M&&Z;D[1]&&(aa=q(D[1]),ia=
aa.length,S=D[1].length,y&&"blockDepth"in y.b&&(ia=Math.min(ia,y.b.blockDepth),S=g(D[1],ia)),l(V,S));if(ia<n&&!Z){ha=!0;do{var W=m.pop();Hb(Qb(W.name,O,0),W)}while(ia<--n)}if(ia>n&&!M){ha=!0;do m.push(K(1,">!"===aa[n]?"SPOILER":"QUOTE",V,0,-999));while(ia>++n)}W=R=0;if(D[2]&&!v){ib=D[2];ac=ib.length;do" "===ib[W]?++R:R=R+4&-4;while(++W<ac&&R<z)}y&&!v&&R<z&&!M&&(ha=!0);ha&&(ha=!1,y&&(O>y.j?(l(y.j,O-y.j),Hb(y,Qb("CODE",O,0,-1))):C(y),v=y=null),E.forEach(function(lb){e(lb,O)}),E=[],N=0,V&&d(V-1));if(R>=
z){if(y||!Z)S=(D[1]||"").length+W,y||(y=K(1,"CODE",V+S,0,-999)),D={}}else if(!y){aa=!!D[4];if(R||Z||aa)if(Z&&!aa)Q=N-1;else if(N)for(Q=0;Q<N&&R>E[Q].P;)++Q;else Q=aa?0:-1;else Q=-1;for(;Q<N-1;)e(E.pop(),O),--N;Q!==N||aa||--Q;if(aa&&0<=Q)if(ma=!0,ja=V+S+W,qa=D[4].length,W=K(1,"LI",ja,qa,0),l(ja,qa),Q<N)Hb(Qb("LI",O,0),E[Q].I),E[Q].I=W,E[Q].J.push(W);else{++N;Q?(Ra=E[Q-1].P+1,jb=Math.max(Ra,4*Q)):(Ra=0,jb=R);R=K(1,"LIST",ja,0,0);if(-1<D[4].indexOf(".")){R.b.type="decimal";var cc=+D[4];1!==cc&&(R.b.start=
cc)}E.push({V:R,I:W,J:[W],da:Ra,P:jb,Q:!0})}!N||Z||M||(1<E[0].J.length||!aa)&&E.forEach(function(lb){lb.Q=!1});z=4*(N+1)}if(D[5])if("#"===D[5][0])W=D[5].length,aa=V+ra-W,R=/[ \\t]*#*[ \\t]*$/.exec(a.substring(V+ra,U))[0].length,ra=U-R,L("H"+/#{1,6}/.exec(D[5])[0].length,aa,W,ra,R),d(aa),d(U),Z&&(ma=!0);else{if("`"===D[5][0]||"~"===D[5][0])ja=V+S,qa=U-ja,y&&D[5]===v?(Hb(y,Qb("CODE",ja,qa,-1)),Rb(O,ja-O),l(y.j,ja+qa-y.j),v=y=null):y||(y=K(1,"CODE",ja,qa,0),v=D[5].replace(/[^`~]+/,""),y.b.blockDepth=ia,
Rb(ja+qa,1),D=D[5].replace(/^[`~\\s]*/,"").replace(/\\s+$/,""),""!==D&&(y.b.lang=D))}else D[3]&&!N&&"\\u0017"!==a[V+ra]?(K(3,"HR",V+S,ra-S,0),ma=!0,d(U)):!f[U]||f[U].T!==ia||M||N||y||(L(f[U].K,V+S,0,f[U].N,f[U].M),d(f[U].N+f[U].M));ma&&(K(3,"pb",O,0,0),d(O));M||(O=U);S&&Rb(V,S,1E3)})})()})();(function(){if(!(0>a.indexOf("]:")))for(var e,g=/^\\x1A* {0,3}\\[([^\\x17\\]]+)\\]: *([^[\\s\\x17]+ *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))?) *(?=$|\\x17)\\n?/gm;e=g.exec(a);){Rb(e.index,e[0].length);var q=e[1].toLowerCase();
w[q]||(u=!0,w[q]=e[2])}})();(function(){var e=a.indexOf("`");if(0>e)var g=[];else{g=/(`+)(\\s*)[^\\x17`]*/g;var q=0,r=[],f=a.replace(/\\x1BD/g,"\\\\`");for(g.lastIndex=e;e=g.exec(f);)r.push({j:e.index,k:e[1].length,R:q,Y:e[2].length,next:e.index+e[0].length}),q=e[0].length-e[0].replace(/\\s+$/,"").length;g=r}f=-1;for(q=g.length;++f<q-1;)for(e=g[f].next,r=f,"`"!==a[g[f].j]&&(++g[f].j,--g[f].k);++r<q&&g[r].j===e;){if(g[r].k===g[f].k){f=g[f];var m=g[r];e=f.j;var n=m.j-m.R;m=m.k+m.R;L("C",e,f.k+f.Y,n,m);l(e,
n+m-e);f=r;break}e=g[r].next}})();(function(){function e(g,q,r,f,m){var n=L("IMG",g,2,q,r);t(n,f,"src");f=b(m);n.b.alt=f;l(g,q+r-g)}(function(){var g=a.indexOf("![");if(-1!==g){if(0<a.indexOf("](",g))for(var q=/!\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:[^\\x17\\s()]|\\([^\\x17\\s()]*\\))*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;g=q.exec(a);){var r=g[1],f=g.index,m=3+r.length;e(f,f+g[0].length-m,m,r,g[0].substring(2,g[0].length-m))}if(u)for(q=/!\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\](?: ?\\[([^\\x17[\\]]+)\\])?/g;g=
q.exec(a);){r=g.index;f=r+2+g[1].length;m=1;var n=g[1],v=n;if(""<g[2]&&w[g[2]])m=g[0].length-n.length-2,v=g[2];else if(!w[v])continue;e(r,f,m,w[v],n)}}})()})();k(">!",/>![^\\x17]+?!</g,"ISPOILER");k("||",/\\|\\|[^\\x17]+?\\|\\|/g,"ISPOILER");(function(){function e(f,m,n,v){var z=L("URL",f,1,m,n,1===n?1:-1);t(z,v,"url");l(f,1);l(m,n)}function g(){for(var f,m=/<[-+.\\w]+([:@])[^\\x17\\s>]+?(?:>|\\x1B7)/g;f=m.exec(a);){var n=b(f[0].replace(/\\x1B/g,"\\\\\\u001b")).replace(/^<(.+)>$/,"$1"),v=f.index,z=":"===f[1]?"URL":
"EMAIL",y=z.toLowerCase();L(z,v,1,v+f[0].length-1,1).b[y]=n}}function q(){for(var f,m=/\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:\\([^\\x17\\s()]*\\)|[^\\x17\\s)])*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;f=m.exec(a);){var n=f[1],v=f.index,z=3+n.length;e(v,v+f[0].length-z,z,n)}}function r(){for(var f={},m,n=/\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\]/g;m=n.exec(a);)f[m.index]=m[1].toLowerCase();for(var v in f){m=f[v];n=+v+2+m.length;var z=n-1,y=1;" "===a[n]&&++n;""<f[n]&&w[f[n]]&&(m=f[n],
y=n+2+m.length-z);w[m]&&e(+v,z,y,w[m])}}-1!==a.indexOf("](")&&q();-1!==a.indexOf("<")&&g();u&&r()})();k("~~",/~~[^\\x17]+?~~(?!~)/g,"DEL");h("SUB","~",/~[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+~?/g,/~\\([^\\x17()]+\\)/g);h("SUP","^",/\\^[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+\\^?/g,/\\^\\([^\\x17()]+\\)/g);(function(){function e(y,M){var E=a.indexOf(y);if(-1!==E){y=[];var N=[],ha=a.indexOf("\\u0017",E),O;for(M.lastIndex=E;O=M.exec(a);){E=O.index;O=O[0].length;E>ha&&(N.push(y),y=[],ha=a.indexOf("\\u0017",
E));var ma,Z=E,S=O;if(ma="_"===a.charAt(Z)&&1===S)ma=0<Z&&c(a[Z-1])&&c(a[Z+S]);ma||y.push([E,O])}N.push(y);N.forEach(g)}}function g(y){v=f=-1;y.forEach(function(M){var E=M[0];M=M[1];var N=!(-1<" \\n\\t".indexOf(a[E+M-1+1])),ha=0<E&&-1<" \\n\\t".indexOf(a.charAt(E-1))?0:Math.min(M,3);q=!!(ha&1)&&0<=f;r=!!(ha&2)&&0<=v;z=m=E;n=M;0<=f&&f===v&&(q?f+=2:++v);q&&r&&(f<v?m+=2:++z);q&&(--n,L("EM",f,1,m,1),f=-1);r&&(n-=2,L("STRONG",v,2,z,2),v=-1);n=N?Math.min(n,3):0;E+=M;n&1&&(f=E-n);n&2&&(v=E-n)})}var q,r,f,m,
n,v,z;e("*",/\\*+/g);e("_",/_+/g)})();(function(){for(var e=a.indexOf("  \\n");0<e;)Gb(K(3,"br",e+2,0,0),K(3,"v",e+2,1,0)),e=a.indexOf("  \\n",e+3)})()}},MediaEmbed:{u:function(a,b){b.forEach(function(c){var d=c[0][0];K(3,"MEDIA",c[0][1],d.length,-10).b.url=d})},v:"://",w:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,x:5E4},PipeTables:{u:function(a){function b(w,e){k=e.j;e.F.split("|").forEach(function(g,q){0<q&&(Gb(t,Rb(k,1,1E3)),++k);q=h.L[q]?h.L[q]:"";var r=k,f=r+g.length;k=f;var m=/^( *).*?( *)$/.exec(g);m[1]&&(g=
m[1].length,Gb(t,Rb(r,g,1E3)),r+=g);m[2]&&(g=m[2].length,Gb(t,Rb(f-g,g,1E3)),f-=g);f=r===f?K(3,w,r,0,-101):L(w,r,0,f,0,-101);q&&(f.b.align=q)});L("TR",e.j,0,k,0,-102)}function c(){if(h&&2<h.o.length&&/^ *:?-+:?(?:(?:\\+| *\\| *):?-+:?)+ */.test(h.o[1].F)){for(var w=h,e=h.o[1].F,g=["","right","left","center"],q=[],r=/(:?)-+(:?)/g,f;f=r.exec(e);)q.push(g[(f[1]?2:0)+(f[2]?1:0)]);w.L=q;p.push(h)}h=null}function d(w){return w.replace(/[!>]/g," ")}function l(w){return w.replace(/\\|/g,".")}var k,h=null,t,
p,u=a;-1<u.indexOf("`")&&(u=u.replace(/`[^`]*`/g,l));-1<u.indexOf(">")&&(u=u.replace(/^(?:>!? ?)+/gm,d));-1<u.indexOf("\\\\|")&&(u=u.replace(/\\\\[\\\\|]/g,".."));(function(){h=null;p=[];k=0;u.split("\\n").forEach(function(w){if(0>w.indexOf("|"))c();else{var e=w,g=0;h||(h={o:[]},g=/^ */.exec(e)[0].length,e=e.substring(g));e=e.replace(/^( *)\\|/,"$1 ").replace(/\\|( *)$/," $1");h.o.push({F:e,j:k+g})}k+=1+w.length});c()})();(function(){for(var w=-1,e=p.length;++w<e;){h=p[w];var g=h.o[h.o.length-1];t=L("TABLE",
h.o[0].j,0,g.j+g.F.length,0,-104);b("TH",h.o[0]);L("THEAD",h.o[0].j,0,k,0,-103);g=h.o[1];Gb(t,Rb(g.j-1,1+g.F.length,1E3));g=1;for(var q=h.o.length;++g<q;)b("TD",h.o[g]);L("TBODY",h.o[2].j,0,k,0,-103)}})()},v:"|"}},P,Qa={"MediaEmbed.hosts":{"bandcamp.com":"bandcamp","dai.ly":"dailymotion","dailymotion.com":"dailymotion","facebook.com":"facebook","fb.watch":"facebook","link.tospotify.com":"spotify","liveleak.com":"liveleak","open.spotify.com":"spotify","play.spotify.com":"spotify","soundcloud.com":"soundcloud",
"twitch.tv":"twitch","vimeo.com":"vimeo","vine.co":"vine","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{bandcamp:[[],[{A:[[/\\/album=(\\d+)/,Ca]],match:[[/bandcamp\\.com\\/album\\/./,ca]]},{A:[[/"album_id":(\\d+)/,Ca],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,Da]],match:[[/bandcamp\\.com\\/track\\/./,ca]]}]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,fa],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,fa],[/start=(\\d+)/,ea]],[]],
facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,fa],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,la],[/facebook\\.com\\/watch\\/\\?([pv])=/,la],[/facebook.com\\/groups\\/[^\\/]*\\/(p)osts\\/(\\d+)/,Ea]],[{A:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,Ea],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,["","user","type","id"]]],
H:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,ca]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,fa]],[{A:[[/liveleak\\.com\\/e\\/(\\w+)/,fa]],match:[[/liveleak\\.com\\/view\\?t=/,ca]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,fa],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,Fa],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists\\/|tracks\\/)[-\\w]+\\/(?:sets\\/)?[-\\w]+\\/(?=s-)([-\\w]+)/,
["","secret_token"]]],[{A:[[/soundcloud(?::\\/)?:tracks:(\\d+)/,Da]],H:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,ca]]},{A:[[/soundcloud(?::\\/)?\\/playlists:(\\d+)/,Fa]],H:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/[-\\w]+\\/sets\\//,ca]]}]],spotify:[Ja,[{A:Ja,H:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,ca]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,["","video_id"]],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,
Ga],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,ea],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,Ga]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)(?:\\/(\\w+))?\\b/,["","id","h"]],[/#t=([\\dhms]+)/,ea]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,fa]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|shorts\\/|v\\/|attribution_link.*?v%3D)([-\\w]+)/,fa],[/youtu\\.be\\/([-\\w]+)/,fa],[/[#&?]t=(\\d[\\dhms]*)/,ea],[/[&?]list=([-\\w]+)/,["","list"]]],[]]},urlConfig:{S:/^(?:ftp|https?|mailto)$/i}},Tb={d:sa,flags:8},X={BANDCAMP:{d:ta,
b:{album_id:x,track_id:x,track_num:x},i:2,c:F,f:10,e:oa,g:5E3},C:cb,CODE:{d:da,b:{lang:Ya},i:1,c:F,f:10,e:{m:A,flags:4436,n:A},g:5E3},DAILYMOTION:{d:ta,b:{id:x,t:x},i:2,c:F,f:10,e:oa,g:5E3},DEL:fb,EM:db,EMAIL:{d:va,b:{email:{c:[function(a){return/^[-\\w.+]+@[-\\w.]+$/.test(a)?a:!1}],q:!0}},i:2,c:F,f:10,e:na,g:5E3},ESC:{d:da,b:{},i:7,c:F,f:10,e:{flags:1616},g:5E3},FACEBOOK:{d:ta,b:{id:x,type:x,user:x},i:2,c:F,f:10,e:oa,g:5E3},FP:ob,H1:qb,H2:qb,H3:qb,H4:qb,H5:qb,H6:qb,HC:{d:da,b:{content:Ha},i:7,c:F,
f:10,e:{flags:3153},g:5E3},HE:ob,HR:{d:wa,b:{},i:1,c:F,f:10,e:{m:A,flags:3349},g:5E3},IMG:{d:wa,b:{alt:x,src:Za,title:x},i:0,c:F,f:10,e:oa,g:5E3},ISPOILER:eb,LI:{d:xa,b:{},i:4,c:[La,function(a){for(var b=a.j+a.k;" "===T.charAt(b);)++b;var c=T.substring(b,b+3);if(/\\[[ Xx]\\]/.test(c)){var d=Math.random().toString(16).substring(2);c="[ ]"===c?"unchecked":"checked";b=K(3,"TASK",b,3,0);b.b.id=d;b.b.state=c;Gb(a,b)}}],f:10,e:gb,g:5E3},LIST:{d:ya,b:{start:{c:[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?
a:!1}],q:!1},type:Ya},i:1,c:F,f:10,e:ab,g:5E3},LIVELEAK:nb,MEDIA:{d:[65519,65329],b:{},i:15,c:[function(a){return function(b,c,d){function l(k,h,t){var p=!1;t.forEach(function(u){var w=u[1],e=u[0].exec(h);e&&(p=!0,w.forEach(function(g,q){""<e[q]&&""<g&&(k[g]=e[q])}))});return p}(function(k,h,t){C(k);if("url"in k.b){var p=k.b.url,u;a:{for(u=/^https?:\\/\\/([^\\/]+)/.exec(p.toLowerCase())[1]||"";""<u;){if(h[u]){u=h[u];break a}u=u.replace(/^[^.]*./,"")}u=""}if(t[u]){h={};l(h,p,t[u][0]);a:{for(var w in h){t=
!1;break a}t=!0}if(!t){t=k.j;var e=k.z;e?(p=k.k,w=e.j,e=e.k):(p=0,w=k.j+k.k,e=0);k=L(u.toUpperCase(),t,p,w,e,k.r);Ma(k,h)}}}})(b,c,d)}(a,Qa["MediaEmbed.hosts"],Qa["MediaEmbed.sites"],Qa.cacheDir)}],f:10,e:{flags:513},g:5E3},QUOTE:{d:xa,b:{},i:1,c:F,f:10,e:$a,g:5E3},SOUNDCLOUD:{d:ta,b:{id:x,playlist_id:x,secret_token:x,track_id:x},i:2,c:F,f:10,e:oa,g:5E3},SPOILER:{d:xa,b:{},i:5,c:F,f:10,e:$a,g:5E3},SPOTIFY:nb,STRONG:db,SUB:eb,SUP:eb,TABLE:rb,TASK:{d:wa,b:{id:Xa,state:Xa},i:2,c:F,f:10,e:oa,g:5E3},TBODY:wb,
TD:{d:xa,b:pb,i:10,c:F,f:10,e:mb,g:5E3},TH:{d:Aa,b:pb,i:10,c:F,f:10,e:mb,g:5E3},THEAD:sb,TR:vb,TWITCH:{d:ta,b:{channel:x,clip_id:x,t:x,video_id:x},i:2,c:F,f:10,e:oa,g:5E3},URL:{d:va,b:{title:x,url:Za},i:6,c:F,f:10,e:na,g:5E3},VIMEO:{d:ta,b:{h:x,id:x,t:Pa},i:2,c:F,f:10,e:oa,g:5E3},VINE:nb,YOUTUBE:{d:ta,b:{id:{c:Oa,q:!1},list:x,t:Pa},i:2,c:F,f:10,e:oa,g:5E3},"html:abbr":{d:ua,b:{title:x},i:0,c:F,f:10,e:ka,g:5E3},"html:b":db,"html:br":{d:Ba,b:{},i:0,c:F,f:10,e:pa,g:5E3},"html:code":cb,"html:dd":{d:xa,
b:{},i:12,c:F,f:10,e:hb,g:5E3},"html:del":fb,"html:div":{d:sa,b:Ia,i:13,c:F,f:10,e:$a,g:5E3},"html:dl":{d:[65408,65456],b:{},i:1,c:F,f:10,e:ab,g:5E3},"html:dt":{d:Aa,b:{},i:12,c:F,f:10,e:hb,g:5E3},"html:i":db,"html:img":{d:Ba,b:{alt:x,height:x,src:{c:Wa,q:!1},title:x,width:x},i:0,c:F,f:10,e:pa,g:5E3},"html:ins":fb,"html:li":{d:xa,b:{},i:4,c:F,f:10,e:gb,g:5E3},"html:ol":tb,"html:pre":{d:ua,b:{},i:1,c:F,f:10,e:{m:A,flags:276,n:A},g:5E3},"html:rb":ub,"html:rp":{d:wa,b:{},i:14,c:F,f:10,e:{m:Ka,flags:3344,
n:A},g:5E3},"html:rt":{d:ua,b:{},i:14,c:F,f:10,e:{m:Ka,flags:256,n:A},g:5E3},"html:rtc":ub,"html:ruby":{d:[65477,65473],b:{},i:0,c:F,f:10,e:ka,g:5E3},"html:span":{d:ua,b:Ia,i:0,c:F,f:10,e:ka,g:5E3},"html:strong":db,"html:sub":eb,"html:sup":eb,"html:table":rb,"html:tbody":wb,"html:td":{d:xa,b:{colspan:x,rowspan:x},i:10,c:F,f:10,e:mb,g:5E3},"html:tfoot":wb,"html:th":{d:Aa,b:{colspan:x,rowspan:x,scope:x},i:10,c:F,f:10,e:mb,g:5E3},"html:thead":sb,"html:tr":vb,"html:u":db,"html:ul":tb},Y,Ub,T,Vb,Wb=0,
Xb;
function Yb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=B;b.r=[];delete b.y;delete b.l;Lb={};Mb={};Nb=0;H=null;Ob=!1;Pb={};I=[];J="";P=0;Y=[];Ub=!1;T=a;Vb=T.length;Xb=0;G=Tb;G.B=!1;++Wb;a=Wb;for(var c in Sb)if(!Sb[c].D)a:{b=c;var d=Sb[b];if(!(d.v&&0>T.indexOf(d.v))){var l=[];if("undefined"!==typeof d.w&&"undefined"!==typeof d.x){l=void 0;var k=d.w;d=d.x;k.lastIndex=0;for(var h=[],t=0;++t<=d&&(l=k.exec(T));){for(var p=l.index,u=[[l[0],p]],w=0;++w<l.length;){var e=l[w];
void 0===e?u.push(["",-1]):(u.push([e,T.indexOf(e,p)]),p+=e.length)}h.push(u)}l=h;if(!l.length)break a}(0,Sb[b].u)(T,l)}}Zb();$b(Vb,0,!0);do c=J,J=J.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(J!==c);J=J.replace(/<\\/i><i>/g,"");J=J.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");J=J.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,dc);b=Ob?"r":"t";c="<"+b;for(var g in Pb)c+=" xmlns:"+g+\'="urn:s9e:TextFormatter:\'+g+\'"\';J=c+">"+J+"</"+b+">";if(Wb!==a)throw"The parser has been reset during execution";1E4<Nb&&B.add("warn",
"Fixing cost limit exceeded",void 0);return J}function ec(a){var b={},c;for(c in X[a])b[c]=X[a][c];return X[a]=b}function dc(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function fc(a){Ob=!0;var b=a.name,c=a.j,d=a.k,l=a.flags,k=0,h=0;l&256&&(k=1,h=a.l&2?2:1);$b(c,k,!(a.l&1&&!(l&4)));k=d?Cb(T.substring(c,c+d)):"";if(a.l&1){l&4||gc(c);l=b.indexOf(":");0<l&&(Pb[b.substring(0,l)]=0);J+="<"+b;var t=Jb(a);l=[];for(var p in t)l.push(p);l.sort(function(u,w){return u>w?1:-1});l.forEach(function(u){J+=" "+u+\'="\'+Bb(t[u].toString()).replace(/\\n/g,"&#10;")+\'"\'});J=3===a.l?d?J+(">"+k+"</"+b+">"):J+"/>":d?J+("><s>"+k+"</s>"):J+">"}else d&&(J+="<e>"+k+"</e>"),J+="</"+b+">";for(Xb=
P=c+d;h&&Xb<Vb&&"\\n"===T[Xb];)--h,++Xb}
function $b(a,b,c){c&&(G.flags&8?b=-1:c=!1);P>=a&&c&&hc();if(Xb>P){var d=Math.min(a,Xb);J+=T.substring(P,d);P=d;P>=a&&c&&hc()}if(G.flags&128)b=T.substring(P,a),/^[ \\n\\t]*$/.test(b)||(b="<i>"+Cb(b)+"</i>"),J+=b,P=a,c&&hc();else{var l=a;for(d=0;b&&--l>=P;){var k=T[l];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--b;++d}a-=d;if(G.flags&8)for(G.B||(ic(a),a>P&&gc(a)),b=T.indexOf("\\n\\n",P);-1<b&&b<a;)$b(b,0,!0),gc(a),b=T.indexOf("\\n\\n",P);a>P&&(b=Cb(T.substring(P,a)),J+=b);c&&hc();d&&(J+=T.substring(a,
a+d));P=a+d}}function jc(a){var b=a.j;a=a.k;var c=T.substring(b,b+a);$b(b,0,!1);J+="<i>"+Cb(c)+"</i>";Ob=!0;P=b+a}function gc(a){!G.B&&G.flags&8&&(ic(a),P<Vb&&(J+="<p>",G.B=!0))}function hc(){G.B&&(J+="</p>",G.B=!1)}function ic(a){for(;P<a&&-1<" \\n\\t".indexOf(T[P]);)J+=T[P],++P}function kc(a,b,c){var d=a.name;(H.flags|a.flags)&256&&(b=lc(b));b=Qb(d,b,0,c||0);Hb(b,a)}function lc(a){for(;a>P&&-1<" \\n\\t".indexOf(T[a-1]);)--a;return a}
function Zb(){if(Y.length){for(var a in X)Lb[a]=0,Mb[a]=0;do{for(;Y.length;)Ub||mc(),H=Y.pop(),nc();I.forEach(function(b){kc(b,Vb)})}while(Y.length)}}
function nc(){G.flags&64&&!Kb(H,I[I.length-1])&&!(-1<"br i pb v".indexOf(H.name))&&C(H);var a=H.j,b=H.k;if(P>a&&!H.p){var c;if((c=H.G)&&0<=I.indexOf(c)){Hb(Qb(c.name,P,Math.max(0,a+b-P)),c);return}if("i"===H.name&&(a=a+b-P,0<a)){Rb(P,a);return}C(H)}if(!H.p)if("i"===H.name)jc(H);else if("br"===H.name)G.flags&1024||($b(H.j,0,!1),J+="<br/>");else if("pb"===H.name)$b(H.j,0,!0);else if("v"===H.name)a=G.flags,G.flags=H.flags,$b(H.j+H.k,0,!1),G.flags=a;else if(H.l&1)if(a=H,b=a.name,c=X[b],Mb[b]>=c.g)B.add("err",
"Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.g}),C(a);else{var d=a,l=X[d.name];B.l=d;for(var k=0;k<l.c.length&&!d.p;++k)l.c[k](d,l);delete B.l;if(!(d=a.p)&&(d=1E4>Nb)){a:{d=a;if(I.length){k=d.name;var h=X[k];if(h.e.n){l=I[I.length-1];var t=l.name;if(h.e.n[t]){if(t!==k&&1E4>Nb){k=d.j+d.k;Y.length?(h=Y[Y.length-1],h=h.j):h=Vb+1;for(;k<h&&-1<" \\n\\t".indexOf(T[k]);)++k;k=oc(l,k);Gb(d,k)}Y.push(d);kc(l,d.j,d.r-1);Nb+=4;d=!0;break a}}}d=!1}if(!d)a:{d=a;if(I.length&&(l=X[d.name],l.e.m&&(k=I[I.length-
1],l.e.m[k.name]))){++Nb;Y.push(d);kc(k,d.j,d.r-1);d=!0;break a}d=!1}d=d||!1}d||(Lb[b]>=c.f?(B.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.f}),C(a)):(c=X[b].i,G.d[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.l)||a.z||Y.length&&Kb(Y[Y.length-1],a)||(b=new Fb(3,b,a.j,a.k),Ma(b,Jb(a)),b.flags=a.flags,a=b),a.flags&4096&&"\\n"===T[a.j+a.k]&&Rb(a.j+a.k,1),fc(a),pc(a)):(b={tag:a,tagName:b},0<a.k?B.add("warn","Tag is not allowed in this context",b):Eb("Tag is not allowed in this context",b),C(a))))}else qc()}
function qc(){var a=H;if(Lb[a.name]){for(var b=[],c=I.length;0<=--c;){var d=I[c];if(Kb(a,d))break;b.push(d);++Nb}if(0>c)Eb("Skipping end tag with no start tag",{tag:a});else{var l=a.flags;b.forEach(function(w){l|=w.flags});var k=l&256,h=1E4>Nb,t=[];b.forEach(function(w){var e=w.name;h&&(w.flags&2?t.push(w):h=!1);var g=a.j;k&&(g=lc(g));e=new Fb(2,e,g,0);e.flags=w.flags;fc(e);rc()});fc(a);rc();if(b.length&&1E4>Nb){d=P;for(c=Y.length;0<=--c&&1E4>++Nb;){var p=Y[c];if(p.j>d||p.l&1)break;for(var u=b.length;0<=
--u&&1E4>++Nb;)if(Kb(p,b[u])){b.splice(u,1);t[u]&&t.splice(u,1);d=Math.max(d,p.j+p.k);break}}d>P&&jc(new Fb(3,"i",P,d-P))}t.forEach(function(w){var e=oc(w,P);(w=w.z)&&Hb(e,w)})}}}function rc(){var a=I.pop();--Lb[a.name];G=G.W}function pc(a){var b=a.name,c=a.flags,d=X[b];++Mb[b];if(3!==a.l){var l=[];G.d.forEach(function(h,t){c&512||(h=h&65280|h>>8);l.push(d.d[t]&h)});var k=c|G.flags&32;k&16&&(k&=-33);++Lb[b];I.push(a);G={W:G};G.d=l;G.flags=k}}function Qb(a,b,c,d){return K(2,a,b,c,d||0)}
function Rb(a,b,c){return K(3,"i",a,Math.min(b,Vb-a),c||0)}function oc(a,b){b=K(a.l,a.name,b,0,a.r);Ma(b,Jb(a));return b}
function K(a,b,c,d,l){a=new Fb(a,b,c,d,l||0);X[b]&&(a.flags=X[b].e.flags);if(!(X[b]||-1<"br i pb v".indexOf(a.name))||0>d||0>c||c+d>Vb||/[\\uDC00-\\uDFFF]/.test(T.substring(c,c+1)+T.substring(c+d,c+d+1)))C(a);else if(X[b]&&X[b].D)B.add("warn","Tag is disabled",{tag:a,tagName:b}),C(a);else if(Ub){b=Y.length;for(c=sc(a);0<b&&c>sc(Y[b-1]);)Y[b]=Y[b-1],--b;Y[b]=a}else Y.push(a);return a}function L(a,b,c,d,l,k){d=Qb(a,d,l,-k||0);a=K(1,a,b,c,k||0);Hb(a,d);return a}
function mc(){for(var a={},b=[],c=Y.length;0<=--c;){var d=Y[c],l=sc(d,c);b.push(l);a[l]=d}b.sort();c=b.length;for(Y=[];0<=--c;)Y.push(a[b[c]]);Ub=!0}function sc(a,b){var c=0<=a.r,d=a.r;c||(d+=1073741824);var l=0<a.k,k;l?k=Vb-a.k:k={2:0,3:1,1:2}[a.l];return tc(a.j)+ +c+tc(d)+ +l+tc(k)+tc(b||0)}function tc(a){a=a.toString(16);return"        ".substring(a.length)+a}var uc="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function vc(a){if(uc){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function wc(a,b){if(uc){var c=b.createElement("div");b=b.createDocumentFragment();xc.input=vc(a);xc.transform();for(c.innerHTML=xc.output;c.firstChild;)b.appendChild(c.firstChild);return b}return xc.transformToFragment(vc(a),b)}var xc,yc=vc(xb);
if(uc){var zc=new ActiveXObject("MSXML2.XSLTemplate.6.0");zc.stylesheet=yc;xc=zc.createProcessor()}else xc=new XSLTProcessor,xc.importStylesheet(yc);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){Sb[a]&&(Sb[a].D=!0)},disableTag:function(a){X[a]&&(ec(a).D=!0)},enablePlugin:function(a){Sb[a]&&(Sb[a].D=!1)},enableTag:function(a){X[a]&&(ec(a).D=!1)},getLogger:function(){return B},parse:Yb,preview:function(a,b){function c(h,t){var p=h.childNodes;t=t.childNodes;for(var u=p.length,w=t.length,e,g,q=0,r=0;q<u&&q<w;){e=p[q];g=t[q];if(!d(e,g))break;++q}for(var f=Math.min(u-q,w-q);r<f;){e=p[u-(r+1)];g=t[w-(r+1)];if(!d(e,g))break;++r}for(u-=r;--u>=q;)h.removeChild(p[u]),
k=h;p=w-r;if(!(q>=p)){w=l.createDocumentFragment();u=q;do g=t[u],k=w.appendChild(g);while(u<--p);r?h.insertBefore(w,h.childNodes[q]):h.appendChild(w)}}function d(h,t){if(h.nodeName!==t.nodeName||h.nodeType!==t.nodeType)return!1;if(h instanceof HTMLElement&&t instanceof HTMLElement){if(!h.isEqualNode(t)){for(var p=h.attributes,u=t.attributes,w=u.length,e=p.length,g=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--e;){var q=p[e],r=q.namespaceURI;q=q.name;-1<g.indexOf(" "+q+" ")||t.hasAttributeNS(r,
q)||(h.removeAttributeNS(r,q),k=h)}for(e=w;0<=--e;)p=u[e],r=p.namespaceURI,q=p.name,p=p.value,-1<g.indexOf(" "+q+" ")||p===h.getAttributeNS(r,q)||(h.setAttributeNS(r,q,p),k=h);c(h,t)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===t.nodeValue||(h.nodeValue=t.nodeValue,k=h);return!0}var l=b.ownerDocument;if(!l)throw"Target does not have a ownerDocument";a=wc(Yb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),l);var k=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(h){var t=
document.createElement("script");var p=h.attributes;var u="undefined"!=typeof Symbol&&Symbol.iterator&&p[Symbol.iterator];p=u?u.call(p):{next:ba(p)};for(u=p.next();!u.done;u=p.next())u=u.value,t.setAttribute(u.name,u.value);t.textContent=h.textContent;h.parentNode.replaceChild(t,h)});c(b,a);return k},registeredVars:Qa,setNestingLimit:function(a,b){X[a]&&(ec(a).f=b)},setParameter:function(a,b){uc?xc.addParameter(a,b,""):xc.setParameter(null,a,b)},setTagLimit:function(a,b){X[a]&&(ec(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:10:{s:9:"Autoemail";a:5:{s:10:"quickMatch";s:1:"@";s:11:"regexpLimit";i:50000;s:8:"attrName";s:5:"email";s:6:"regexp";s:39:"/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/Si";s:7:"tagName";s:5:"EMAIL";}s:8:"Autolink";a:5:{s:8:"attrName";s:3:"url";s:6:"regexp";s:135:"#\\b(?:ftp|https?|mailto):(?>[^\\s()\\[\\]\\x{FF01}-\\x{FF0F}\\x{FF1A}-\\x{FF20}\\x{FF3B}-\\x{FF40}\\x{FF5B}-\\x{FF65}]|\\([^\\s()]*\\)|\\[\\w*\\])++#Siu";s:7:"tagName";s:3:"URL";s:10:"quickMatch";s:1:":";s:11:"regexpLimit";i:50000;}s:7:"Escaper";a:4:{s:10:"quickMatch";s:1:"\\";s:11:"regexpLimit";i:50000;s:6:"regexp";s:30:"/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/";s:7:"tagName";s:3:"ESC";}s:10:"FancyPants";a:2:{s:8:"attrName";s:4:"char";s:7:"tagName";s:2:"FP";}s:12:"HTMLComments";a:5:{s:10:"quickMatch";s:4:"<!--";s:11:"regexpLimit";i:50000;s:8:"attrName";s:7:"content";s:6:"regexp";s:22:"/<!--(?!\\[if).*?-->/is";s:7:"tagName";s:2:"HC";}s:12:"HTMLElements";a:5:{s:10:"quickMatch";s:1:"<";s:6:"prefix";s:4:"html";s:6:"regexp";s:385:"#<(?>/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?>\\s+[a-z][-a-z0-9]*(?>\\s*=\\s*(?>"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*+)\\s*/?)\\s*>#i";s:7:"aliases";a:6:{s:1:"a";a:2:{s:0:"";s:3:"URL";s:4:"href";s:3:"url";}s:2:"hr";a:1:{s:0:"";s:2:"HR";}s:2:"em";a:1:{s:0:"";s:2:"EM";}s:1:"s";a:1:{s:0:"";s:1:"S";}s:6:"strong";a:1:{s:0:"";s:6:"STRONG";}s:3:"sup";a:1:{s:0:"";s:3:"SUP";}}s:11:"regexpLimit";i:50000;}s:12:"HTMLEntities";a:5:{s:10:"quickMatch";s:1:"&";s:11:"regexpLimit";i:50000;s:8:"attrName";s:4:"char";s:6:"regexp";s:38:"/&(?>[a-z]+|#(?>[0-9]+|x[0-9a-f]+));/i";s:7:"tagName";s:2:"HE";}s:8:"Litedown";a:1:{s:18:"decodeHtmlEntities";b:1;}s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}s:10:"PipeTables";a:3:{s:16:"overwriteEscapes";b:1;s:17:"overwriteMarkdown";b:1;s:10:"quickMatch";s:1:"|";}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:27:"/^(?:ftp|https?|mailto)$/Di";}s:16:"MediaEmbed.hosts";a:15:{s:12:"bandcamp.com";s:8:"bandcamp";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:12:"liveleak.com";s:8:"liveleak";s:14:"soundcloud.com";s:10:"soundcloud";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:9:"twitch.tv";s:6:"twitch";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:10:{s:8:"bandcamp";a:2:{i:0;a:0:{}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:92;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:98;}}}}}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:121;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:86;}s:8:"facebook";a:2:{i:0;a:5:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:121;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:143;}i:4;a:2:{i:0;s:53:"@facebook.com/groups/[^/]*/(?\'type\'p)osts/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;R:150;}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:98;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:121;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:121;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:98;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:121;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:93:"@soundcloud\\.com/(?!playlists/|tracks/)[-\\w]+/(?:sets/)?[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:43:"@soundcloud(?::/)?:tracks:(?\'track_id\'\\d+)@";i:1;R:111;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:98;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"@soundcloud(?::/)?/playlists:(?\'playlist_id\'\\d+)@";i:1;R:188;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:30:"@soundcloud\\.com/[-\\w]+/sets/@";i:1;R:98;}}}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:121;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:220;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:98;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:128;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:238;}}i:1;R:86;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:67:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)(?:/(?\'h\'\\w+))?\\b!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"h";}}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:128;}}i:1;R:86;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:121;}}i:1;R:86;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:77:"!youtube\\.com/(?:watch.*?v=|shorts/|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:121;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:121;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:128;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;R:86;}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:2:{i:0;i:65519;i:1;i:65457;}s:5:"flags";i:8;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:77:{s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:86;}s:8:"track_id";R:281;s:9:"track_num";R:281;}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:2:{i:0;i:32960;i:1;i:33025;}}s:1:"C";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:66;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:0;i:1;i:0;}}s:4:"CODE";a:7:{s:10:"attributes";a:1:{s:4:"lang";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:23:"/^[- +,.0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:10:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:4436;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:305;}s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:281;s:1:"t";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:3:"DEL";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:512;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";R:274;}s:2:"EM";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:2;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:65477;i:1;i:65409;}}s:5:"EMAIL";a:7:{s:10:"attributes";a:1:{s:5:"email";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:61:"s9e\\TextFormatter\\Parser\\AttributeFilters\\EmailFilter::filter";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:514;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:2:{i:0;i:39819;i:1;i:65457;}}s:3:"ESC";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:1616;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:7;s:7:"allowed";R:305;}s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:281;s:4:"type";R:281;s:4:"user";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:2:"FP";a:7:{s:10:"attributes";a:1:{s:4:"char";a:2:{s:8:"required";b:1;s:11:"filterChain";R:86;}}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:8;s:7:"allowed";a:2:{i:0;i:32896;i:1;i:33153;}}s:2:"H1";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:320;s:12:"fosterParent";R:320;s:5:"flags";i:260;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:3;s:7:"allowed";R:351;}s:2:"H2";R:392;s:2:"H3";R:392;s:2:"H4";R:392;s:2:"H5";R:392;s:2:"H6";R:392;s:2:"HC";a:7:{s:10:"attributes";a:1:{s:7:"content";R:384;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3153;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:7;s:7:"allowed";R:305;}s:2:"HE";R:382;s:2:"HR";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:2:{s:11:"closeParent";R:320;s:5:"flags";i:3349;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:389;}s:3:"IMG";a:7:{s:10:"attributes";a:3:{s:3:"alt";R:281;s:3:"src";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:1;}s:5:"title";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:389;}s:8:"ISPOILER";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:0;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";R:351;}s:2:"LI";a:7:{s:11:"filterChain";a:2:{i:0;R:284;i:1;a:2:{s:8:"callback";s:58:"s9e\\TextFormatter\\Plugins\\TaskLists\\Helper::filterListItem";s:6:"params";a:3:{s:6:"parser";N;s:3:"tag";N;s:4:"text";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"LI";i:1;s:7:"html:li";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:264;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:4;s:7:"allowed";a:2:{i:0;i:65519;i:1;i:65441;}}s:4:"LIST";a:7:{s:10:"attributes";a:2:{s:5:"start";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:360;}}s:8:"required";b:0;}s:4:"type";R:310;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:320;s:12:"fosterParent";R:320;s:5:"flags";i:3460;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:65424;i:1;i:65408;}}s:8:"LIVELEAK";a:7:{s:10:"attributes";a:1:{s:2:"id";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:15;s:7:"allowed";a:2:{i:0;i:65519;i:1;i:65329;}}s:5:"QUOTE";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:320;s:12:"fosterParent";R:320;s:5:"flags";i:268;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:457;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:281;s:11:"playlist_id";R:281;s:12:"secret_token";R:281;s:8:"track_id";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:7:"SPOILER";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:500;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:5;s:7:"allowed";R:457;}s:7:"SPOTIFY";R:475;s:6:"STRONG";R:345;s:3:"SUB";R:425;s:3:"SUP";R:425;s:5:"TABLE";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:468;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:65408;i:1;i:65418;}}s:4:"TASK";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:1;}s:5:"state";R:522;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:389;}s:5:"TBODY";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:20:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:5:"TBODY";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:5:"THEAD";i:1;s:2:"TR";i:1;s:10:"html:tbody";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:10:"html:thead";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:9;s:7:"allowed";a:2:{i:0;i:65408;i:1;i:65416;}}s:2:"TD";a:7:{s:10:"attributes";a:1:{s:5:"align";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:10:"strtolower";s:6:"params";R:360;}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"/^(?:center|justify|left|right)$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:14:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:457;}s:2:"TH";a:7:{s:10:"attributes";R:564;s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:576;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";a:2:{i:0;i:63463;i:1;i:65441;}}s:5:"THEAD";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:320;s:12:"fosterParent";R:320;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:9;s:7:"allowed";R:560;}s:2:"TR";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:16:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:2:"TR";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:11;s:7:"allowed";a:2:{i:0;i:65408;i:1;i:65412;}}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:281;s:7:"clip_id";R:281;s:1:"t";R:281;s:8:"video_id";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:3:"URL";a:7:{s:10:"attributes";a:2:{s:5:"title";R:281;s:3:"url";R:413;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:364;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:368;}s:5:"VIMEO";a:7:{s:10:"attributes";a:3:{s:1:"h";R:281;s:2:"id";R:281;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:360;}}s:8:"required";b:0;}}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:4:"VINE";R:475;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";R:523;s:8:"required";b:0;}s:4:"list";R:281;s:1:"t";R:646;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:292;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:296;}s:9:"html:abbr";a:7:{s:10:"attributes";a:1:{s:5:"title";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:427;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:351;}s:6:"html:b";R:345;s:7:"html:br";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3201;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:65408;i:1;i:65408;}}s:9:"html:code";R:299;s:7:"html:dd";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:dd";i:1;s:7:"html:dt";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:12;s:7:"allowed";R:457;}s:8:"html:del";R:339;s:8:"html:div";a:7:{s:10:"attributes";a:1:{s:5:"class";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:500;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:13;s:7:"allowed";R:274;}s:7:"html:dl";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:468;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:65408;i:1;i:65456;}}s:7:"html:dt";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:677;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:12;s:7:"allowed";R:599;}s:6:"html:i";R:345;s:8:"html:img";a:7:{s:10:"attributes";a:5:{s:3:"alt";R:281;s:6:"height";R:281;s:3:"src";a:2:{s:11:"filterChain";R:414;s:8:"required";b:0;}s:5:"title";R:281;s:5:"width";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:668;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:672;}s:8:"html:ins";R:339;s:7:"html:li";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:440;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:4;s:7:"allowed";R:457;}s:7:"html:ol";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:468;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:472;}s:8:"html:pre";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:320;s:12:"fosterParent";R:320;s:5:"flags";i:276;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:351;}s:7:"html:rb";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:604;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:14;s:7:"allowed";R:672;}s:7:"html:rp";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rp";i:1;s:7:"html:rt";i:1;}s:12:"fosterParent";R:320;s:5:"flags";i:3344;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:14;s:7:"allowed";R:389;}s:7:"html:rt";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:738;s:12:"fosterParent";R:320;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:14;s:7:"allowed";R:351;}s:8:"html:rtc";R:731;s:9:"html:ruby";a:7:{s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:427;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:65477;i:1;i:65473;}}s:9:"html:span";a:7:{s:10:"attributes";R:695;s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:427;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:351;}s:11:"html:strong";R:345;s:8:"html:sub";R:425;s:8:"html:sup";R:425;s:10:"html:table";R:513;s:10:"html:tbody";R:533;s:7:"html:td";a:7:{s:10:"attributes";a:2:{s:7:"colspan";R:281;s:7:"rowspan";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:576;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:457;}s:10:"html:tfoot";R:533;s:7:"html:th";a:7:{s:10:"attributes";a:3:{s:7:"colspan";R:281;s:7:"rowspan";R:281;s:5:"scope";R:281;}s:11:"filterChain";R:283;s:12:"nestingLimit";i:10;s:5:"rules";R:576;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:599;}s:10:"html:thead";R:602;s:7:"html:tr";R:608;s:6:"html:u";R:345;s:7:"html:ul";R:721;}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:42:"s9e\\TextFormatter\\Bundles\\Fatdown\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:2:{s:16:"MEDIAEMBED_THEME";s:0:"";s:18:"TASKLISTS_EDITABLE";s:0:"";}}');
	}
}