// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the MIT Licence.
// See the LICENCE file in the repository root for full licence text.

using Newtonsoft.Json;

namespace osu.Game.Online.API.Requests.Responses
{
    public class CommentableMeta
    {
        [JsonProperty("id")]
        public long Id { get; set; }

        [JsonProperty("owner_id")]
        public long? OwnerId { get; set; }

        [JsonProperty("owner_title")]
        public string? OwnerTitle { get; set; }

        [JsonProperty("title")]
        public string Title { get; set; } = string.Empty;

        [JsonProperty("type")]
        public string Type { get; set; } = string.Empty;

        [JsonProperty("url")]
        public string Url { get; set; } = string.Empty;

        [JsonProperty("current_user_attributes")]
        public CommentableCurrentUserAttributes? CurrentUserAttributes { get; set; }

        public struct CommentableCurrentUserAttributes
        {
            [JsonProperty("can_new_comment_reason")]
            public string? CanNewCommentReason { get; set; }
        }
    }
}
