/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.Collection;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Top;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformerExt;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.utils.CommonUtils;

public class QueryTransformerTop
implements DBCQueryTransformer,
DBCQueryTransformerExt {
    private static final Log log = Log.getLog(QueryTransformerTop.class);
    private Number offset;
    private Number length;
    private boolean limitSet;

    @Override
    public void setParameters(Object ... parameters) {
        this.offset = (Number)parameters[0];
        this.length = (Number)parameters[1];
    }

    @Override
    public String transformQueryString(SQLQuery query) throws DBCException {
        this.limitSet = false;
        if (query.isPlainSelect()) {
            try {
                PlainSelect selectBody;
                Statement statement = query.getStatement();
                if (statement instanceof PlainSelect && (selectBody = (PlainSelect)statement).getTop() == null && CommonUtils.isEmpty((Collection)selectBody.getIntoTables())) {
                    Top top = new Top();
                    top.setPercentage(false);
                    top.setExpression((Expression)new LongValue(this.offset.longValue() + this.length.longValue()));
                    selectBody.setTop(top);
                    this.limitSet = true;
                    return statement.toString();
                }
            }
            catch (Throwable e) {
                log.debug(e);
            }
        }
        return query.getText();
    }

    @Override
    public void transformStatement(DBCStatement statement, int parameterIndex) throws DBCException {
        if (!this.limitSet) {
            statement.setLimit(this.offset.longValue(), this.length.longValue());
        }
    }

    @Override
    public boolean isApplicableTo(SQLQuery query) {
        Statement statement = query.getStatement();
        if (statement instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)statement;
            return query.isPlainSelect() && select.getOffset() == null && select.getFromItem() != null;
        }
        return false;
    }
}

