# Contributing to dash-html-components

## Getting Started

Refer to the [readme](README.md) for installation and development workflow instructions.

## Contributions

[Dash HTML Components][] consist of generic HTML5 elements based on the [MDN spec][] (also see the [W3 index of elements][]). For more complex UI components, see the [Dash Core Components][]. Contributions are welcome! This repository's open [issues][] are a good place to start.

## Making a Contribution
_For larger features, your contribution will have a higher likelihood of getting merged if you create an issue to discuss the changes that you'd like to make before you create a pull request._

1. Create a pull request.
2. After a review has been done and your changes have been approved, they will be merged and included in a future release of Dash.
3. If significant enough, you have created an issue about documenting the new feature or change and you have added it to the [dash-docs](https://github.com/plotly/dash-docs) project.

## Coding Style

Please lint any additions to react components with `npm run lint`. Rules defined in [.eslintrc](.eslintrc) are inherited from [`dash-components-archetype`](https://github.com/plotly/dash-components-archetype)'s [eslintrc-react.json][]

## Pull Request Guidelines

Use the [GitHub flow][] when proposing contributions to this repository (i.e. create a feature branch and submit a PR against the master branch).

## Financial Contributions

If your company wishes to sponsor development of open source dash components, please [get in touch][].

[Dash HTML Components]: https://dash.plotly.com/dash-html-components
[MDN spec]: https://developer.mozilla.org/en-US/docs/Web/HTML/Element
[W3 index of elements]: https://dev.w3.org/html5/html-author/#index-of-elements
[Dash Core Components]: https://github.com/plotly/dash-core-components
[issues]: https://github.com/plotly/dash-html-components/issues
[GitHub flow]: https://guides.github.com/introduction/flow/
[eslintrc-react.json]: https://github.com/plotly/dash-components-archetype/blob/master/config/eslint/eslintrc-react.json
[get in touch]: https://plotly.com/products/consulting-and-oem

