// Copyright (c) Meta Platforms, Inc. and affiliates.
//
// This source code is licensed under the MIT license found in the
// LICENSE file in the root directory of this source tree.
//
// Auto generated for hbt. Do not manually edit.
// @generated

#include <stdexcept>
#include "hbt/src/perf_event/json_events/generated/intel/JsonEvents.h"

namespace facebook::hbt::perf_event::generated {
namespace icelakex_uncore_experimental {

void addEvents(PmuDeviceManager& pmu_manager) {
/*
  Events from icelakex_uncore_experimental.json (3718 experimental events).

  Supported SKUs:
      - Arch: x86, Model: ICX id: 106
      - Arch: x86, Model: ICX id: 108
*/
#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIR_LOOKUP.NO_SNP",
      EventDef::Encoding{.code = 0x53, .umask = 0x02, .umaskExt = 0x00},
      R"(Multi-socket cacheline directory state lookups : Snoop Not Needed)",
      R"(Multi-socket cacheline directory state lookups : Snoop Not Needed : Counts the number of transactions that looked up the directory.  Can be filtered by requests that had to snoop and those that did not have to. : Filters for transactions that did not have to send any snoops because the directory was clean.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIR_LOOKUP.SNP",
      EventDef::Encoding{.code = 0x53, .umask = 0x01, .umaskExt = 0x00},
      R"(Multi-socket cacheline directory state lookups : Snoop Needed)",
      R"(Multi-socket cacheline directory state lookups : Snoop Needed : Counts the number of transactions that looked up the directory.  Can be filtered by requests that had to snoop and those that did not have to. : Filters for transactions that had to send one or more snoops because the directory was not clean.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.EX_RDS",
      EventDef::Encoding{.code = 0x5F, .umask = 0x01, .umaskExt = 0x00},
      R"(Read request from a remote socket which hit in the HitMe Cache to a line In the E state)",
      R"(Counts read requests from a remote socket which hit in the HitME cache (used to cache the multi-socket Directory state) to a line in the E(Exclusive) state.  This includes the following read opcodes (RdCode, RdData, RdDataMigratory, RdCur, RdInv*, Inv*).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x0F, .umaskExt = 0x20},
      R"(Lines Victimized : Local - All Lines)",
      R"(Lines Victimized : Local - All Lines : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.REMOTE_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x0F, .umaskExt = 0x80},
      R"(Lines Victimized : Remote - All Lines)",
      R"(Lines Victimized : Remote - All Lines : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_COUNTER0_OCCUPANCY",
      EventDef::Encoding{.code = 0x1F, .umask = 0x00, .umaskExt = 0x00},
      R"(Counter 0 Occupancy)",
      R"(Counter 0 Occupancy : Since occupancy counts can only be captured in the Cbo's 0 counter, this event allows a user to capture occupancy related information by filtering the Cb0 occupancy count captured in Counter 0.   The filtering available is found in the control register - threshold, invert and edge detect.   E.g. setting threshold to 1 can effectively monitor how many cycles the monitored queue has an entry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.RFO_HIT_S",
      EventDef::Encoding{.code = 0x39, .umask = 0x08, .umaskExt = 0x00},
      R"(Number of times that an RFO hit in S state.)",
      R"(Counts when a RFO (the Read for Ownership issued before a  write) request hit a cacheline in the S (Shared) state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_REQUESTS.INVITOE",
      EventDef::Encoding{.code = 0x50, .umask = 0x30, .umaskExt = 0x00},
      R"(Local INVITOE requests (exclusive ownership of a cache line without receiving data) that miss the SF/LLC and remote INVITOE requests sent to the CHA's home agent)",
      R"(Counts the total number of requests coming from a unit on this socket for exclusive ownership of a cache line without receiving data (INVITOE) to the CHA.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x19, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPI",
      EventDef::Encoding{.code = 0x5C, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoop Responses Received : RspI)",
      R"(Counts when a transaction with the opcode type RspI Snoop Response was received which indicates the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO: the Read for Ownership issued before a write hits non-modified data).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPIFWD",
      EventDef::Encoding{.code = 0x5C, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoop Responses Received : RspIFwd)",
      R"(Counts when a a transaction with the opcode type RspIFwd Snoop Response was received which indicates a remote caching agent forwarded the data and the requesting agent is able to acquire the data in E (Exclusive) or M (modified) states.  This is commonly returned with RFO (the Read for Ownership issued before a write) transactions.  The snoop could have either been to a cacheline in the M,E,F (Modified, Exclusive or Forward)  states.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPS",
      EventDef::Encoding{.code = 0x5C, .umask = 0x02, .umaskExt = 0x00},
      R"(Snoop Responses Received : RspS)",
      R"(Counts when a transaction with the opcode type RspS Snoop Response was received which indicates when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPSFWD",
      EventDef::Encoding{.code = 0x5C, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoop Responses Received : RspSFwd)",
      R"(Counts when a a transaction with the opcode type RspSFwd Snoop Response was received which indicates a remote caching agent forwarded the data but held on to its current copy.  This is common for data and code reads that hit in a remote socket in E (Exclusive) or F (Forward) state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ALL",
      EventDef::Encoding{.code = 0x35, .umask = 0xff, .umaskExt = 0xC001FF},
      R"(TOR Inserts : All)",
      R"(TOR Inserts : All : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_CRD",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC80FFD},
      R"(TOR Occupancy : CRds issued by iA Cores that Hit the LLC)",
      R"(TOR Occupancy : CRds issued by iA Cores that Hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_DRD",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC817FD},
      R"(TOR Occupancy : DRds issued by iA Cores that Hit the LLC)",
      R"(TOR Occupancy : DRds issued by iA Cores that Hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_LLCPREFRFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xCCC7FD},
      R"(TOR Occupancy : LLCPrefRFO issued by iA Cores that hit the LLC)",
      R"(TOR Occupancy : LLCPrefRFO issued by iA Cores that hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_RFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC807FD},
      R"(TOR Occupancy : RFOs issued by iA Cores that Hit the LLC)",
      R"(TOR Occupancy : RFOs issued by iA Cores that Hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_MISS_LLCPREFRFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xCCC7FE},
      R"(TOR Occupancy : LLCPrefRFO issued by iA Cores that missed the LLC)",
      R"(TOR Occupancy : LLCPrefRFO issued by iA Cores that missed the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IO_MISS_RFO",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0xc803fe},
      R"(TOR Inserts : RFOs issued by IO Devices that missed the LLC)",
      R"(TOR Inserts : RFOs issued by IO Devices that missed the LLC : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_MISS_RFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xc803fe},
      R"(TOR Occupancy : RFOs issued by IO Devices that missed the LLC)",
      R"(TOR Occupancy : RFOs issued by IO Devices that missed the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_MISS_ITOM",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xcc43fe},
      R"(TOR Occupancy : ItoMs issued by IO Devices that missed the LLC)",
      R"(TOR Occupancy : ItoMs issued by IO Devices that missed the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_M",
      EventDef::Encoding{.code = 0x12, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoop Responses : Hit M)",
      R"(Snoop Responses : Hit M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.RFO",
      EventDef::Encoding{.code = 0x10, .umask = 0x08, .umaskExt = 0x00},
      R"(RFO request issued by the IRP unit to the mesh with the intention of writing a partial cacheline.)",
      R"(RFO request issued by the IRP unit to the mesh with the intention of writing a partial cacheline to coherent memory.  RFO is a Read For Ownership command that requests ownership of the cacheline and moves data from the mesh to IRP cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RDB_INSERTS",
      EventDef::Encoding{.code = 0x17, .umask = 0x00, .umaskExt = 0x00},
      R"(Read Data Buffer Inserts)",
      R"(Read Data Buffer Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.ACCEPTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x05, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Scoreboard Accesses Accepted)",
      R"(Scoreboard Accesses : Scoreboard Accesses Accepted)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.REJECTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x0A, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Scoreboard Accesses Rejected)",
      R"(Scoreboard Accesses : Scoreboard Accesses Rejected)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_REG",
      EventDef::Encoding{.code = 0x04, .umask = 0x01, .umaskExt = 0x00},
      R"(All DRAM read CAS commands issued (does not include underfills))",
      R"(Counts the total number of DRAM Read CAS commands issued on this channel.  This includes both regular RD CAS commands as well as those with implicit Precharge.   We do not filter based on major mode, as RD_CAS is not issued during WMM (with the exception of underfills).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_UNDERFILL",
      EventDef::Encoding{.code = 0x04, .umask = 0x04, .umaskExt = 0x00},
      R"(DRAM underfill read CAS commands issued)",
      R"(Counts the total of DRAM Read CAS commands issued due to an underfill)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2UPI_NOT_TAKEN_CREDITS",
      EventDef::Encoding{.code = 0x28, .umask = 0x00, .umaskExt = 0x00},
      R"(Number of reads in which direct to Intel UPI transactions were overridden)",
      R"(Number of reads in which direct to Intel UPI transactions were overridden)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2UPI_NOT_TAKEN_DIRSTATE",
      EventDef::Encoding{.code = 0x27, .umask = 0x00, .umaskExt = 0x00},
      R"(Cycles when Direct2UPI was Disabled)",
      R"(Cycles when Direct2UPI was Disabled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2UPI_TXN_OVERRIDE",
      EventDef::Encoding{.code = 0x29, .umask = 0x00, .umaskExt = 0x00},
      R"(Number of reads that a message sent direct2 Intel UPI was overridden)",
      R"(Clockticks of the mesh to PCI (M2P))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.NI",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x1E},
      R"(M2M Writes Issued to iMC : Non-Inclusive - All Channels)",
      R"(M2M Writes Issued to iMC : Non-Inclusive - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TAG_HIT.NM_UFILL_HIT_CLEAN",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .umaskExt = 0x00},
      R"(Tag Hit : Clean NearMem Underfill Hit)",
      R"(Tag Hit : Clean NearMem Underfill Hit : Tag Hit indicates when a request sent to the iMC hit in Near Memory. : Counts clean underfill hits due to a partial write)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TAG_HIT.NM_UFILL_HIT_DIRTY",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .umaskExt = 0x00},
      R"(Tag Hit : Dirty NearMem Underfill Hit)",
      R"(Tag Hit : Dirty NearMem Underfill Hit : Tag Hit indicates when a request sent to the iMC hit in Near Memory. : Counts dirty underfill read hits due to a partial write)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TAG_MISS",
      EventDef::Encoding{.code = 0x61, .umask = 0x00, .umaskExt = 0x00},
      R"(Tag Miss)",
      R"(Tag Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_EGRESS.NOT_TAKEN",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Not Taken)",
      R"(M2M to iMC Bypass : Not Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2CORE_NOT_TAKEN_DIRSTATE",
      EventDef::Encoding{.code = 0x24, .umask = 0x00, .umaskExt = 0x00},
      R"(Cycles when direct to core mode, which bypasses the CHA, was disabled)",
      R"(Cycles when direct to core mode, which bypasses the CHA, was disabled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2CORE_TXN_OVERRIDE",
      EventDef::Encoding{.code = 0x25, .umask = 0x00, .umaskExt = 0x00},
      R"(Number of reads in which direct to core transaction was overridden)",
      R"(Number of reads in which direct to core transaction was overridden)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x07},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - All Channels)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x07},
      R"(M2M Reads Issued to iMC : Normal Priority - All Channels)",
      R"(M2M Reads Issued to iMC : Normal Priority - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : All Writes - All Channels)",
      R"(M2M Writes Issued to iMC : All Writes - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - All Channels)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - All Channels)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_INSERTS",
      EventDef::Encoding{.code = 0x01, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Ingress (from CMS) Allocations)",
      R"(AD Ingress (from CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_OCCUPANCY",
      EventDef::Encoding{.code = 0x02, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Ingress (from CMS) Occupancy)",
      R"(AD Ingress (from CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_INSERTS",
      EventDef::Encoding{.code = 0x05, .umask = 0x00, .umaskExt = 0x00},
      R"(BL Ingress (from CMS) Allocations)",
      R"(BL Ingress (from CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_OCCUPANCY",
      EventDef::Encoding{.code = 0x06, .umask = 0x00, .umaskExt = 0x00},
      R"(BL Ingress (from CMS) Occupancy)",
      R"(BL Ingress (from CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_INSERTS",
      EventDef::Encoding{.code = 0x09, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Egress (to CMS) Allocations)",
      R"(AD Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_OCCUPANCY",
      EventDef::Encoding{.code = 0x0A, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Egress (to CMS) Occupancy)",
      R"(AD Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.ALL",
      EventDef::Encoding{.code = 0x15, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : All)",
      R"(BL Egress (to CMS) Allocations : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Taken)",
      R"(CHA to iMC Bypass : Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that succeeded in taking the full bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.INTERMEDIATE",
      EventDef::Encoding{.code = 0x57, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Intermediate bypass Taken)",
      R"(CHA to iMC Bypass : Intermediate bypass Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that succeeded in taking the intermediate bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.NOT_TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Not Taken)",
      R"(CHA to iMC Bypass : Not Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that could not take the bypass, and issues a read to memory. Note that transactions that did not take the bypass but did not issue read to memory will not be counted.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.REMOTE_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x11, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single Snoop Target from Remote)",
      R"(Core Cross Snoops Issued : Single Snoop Target from Remote : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x21, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single External Snoops)",
      R"(Core Cross Snoops Issued : Single External Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x41, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single Core Requests)",
      R"(Core Cross Snoops Issued : Single Core Requests : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x81, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single Eviction)",
      R"(Core Cross Snoops Issued : Single Eviction : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xF1, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Any Single Snoop)",
      R"(Core Cross Snoops Issued : Any Single Snoop : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.REMOTE_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x12, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple Snoop Targets from Remote)",
      R"(Core Cross Snoops Issued : Multiple Snoop Targets from Remote : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x22, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple External Snoops)",
      R"(Core Cross Snoops Issued : Multiple External Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x42, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple Core Requests)",
      R"(Core Cross Snoops Issued : Multiple Core Requests : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x82, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple Eviction)",
      R"(Core Cross Snoops Issued : Multiple Eviction : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xF2, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Any Cycle with Multiple Snoops)",
      R"(Core Cross Snoops Issued : Any Cycle with Multiple Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_TOR_DEALLOC",
      EventDef::Encoding{.code = 0x6E, .umask = 0x01, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_SUPPRESS_NO_D2C",
      EventDef::Encoding{.code = 0x6E, .umask = 0x02, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_SUPPRESS_DRD",
      EventDef::Encoding{.code = 0x6E, .umask = 0x04, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.EXTCMP",
      EventDef::Encoding{.code = 0x6D, .umask = 0x01, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x02, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.GO",
      EventDef::Encoding{.code = 0x6D, .umask = 0x04, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.GO_PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x08, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.FAST_GO",
      EventDef::Encoding{.code = 0x6D, .umask = 0x10, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.FAST_GO_PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x20, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.NOP",
      EventDef::Encoding{.code = 0x6D, .umask = 0x40, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.IDLE_DUE_SUPPRESS",
      EventDef::Encoding{.code = 0x6D, .umask = 0x80, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.SHARED_OWNREQ",
      EventDef::Encoding{.code = 0x5F, .umask = 0x04, .umaskExt = 0x00},
      R"(Counts Number of Hits in HitMe Cache : Remote socket ownership read requests that hit in S state.)",
      R"(Counts Number of Hits in HitMe Cache : Remote socket ownership read requests that hit in S state. : Shared hit and op is RdInvOwn, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.WBMTOE",
      EventDef::Encoding{.code = 0x5F, .umask = 0x08, .umaskExt = 0x00},
      R"(Counts Number of Hits in HitMe Cache : Remote socket WBMtoE requests)",
      R"(Counts Number of Hits in HitMe Cache : Remote socket WBMtoE requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.WBMTOI_OR_S",
      EventDef::Encoding{.code = 0x5F, .umask = 0x10, .umaskExt = 0x00},
      R"(Counts Number of Hits in HitMe Cache : Remote socket writeback to I or S requests)",
      R"(Counts Number of Hits in HitMe Cache : Remote socket writeback to I or S requests : op is WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_LOOKUP.READ",
      EventDef::Encoding{.code = 0x5E, .umask = 0x01, .umaskExt = 0x00},
      R"(Counts Number of times HitMe Cache is accessed : Remote socket read requests)",
      R"(Counts Number of times HitMe Cache is accessed : Remote socket read requests : op is RdCode, RdData, RdDataMigratory, RdCur, RdInvOwn, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_LOOKUP.WRITE",
      EventDef::Encoding{.code = 0x5E, .umask = 0x02, .umaskExt = 0x00},
      R"(Counts Number of times HitMe Cache is accessed : Remote socket write (i.e. writeback) requests)",
      R"(Counts Number of times HitMe Cache is accessed : Remote socket write (i.e. writeback) requests : op is WbMtoE, WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.SHARED_RDINVOWN",
      EventDef::Encoding{.code = 0x60, .umask = 0x20, .umaskExt = 0x00},
      R"(Counts Number of Misses in HitMe Cache : Remote socket RdInvOwn requests to shared line)",
      R"(Counts Number of Misses in HitMe Cache : Remote socket RdInvOwn requests to shared line : SF/LLC HitS/F and op is RdInvOwn)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.NOTSHARED_RDINVOWN",
      EventDef::Encoding{.code = 0x60, .umask = 0x40, .umaskExt = 0x00},
      R"(Counts Number of Misses in HitMe Cache : Remote socket RdInvOwn requests that are not to shared line)",
      R"(Counts Number of Misses in HitMe Cache : Remote socket RdInvOwn requests that are not to shared line : No SF/LLC HitS/F and op is RdInvOwn)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.READ_OR_INV",
      EventDef::Encoding{.code = 0x60, .umask = 0x80, .umaskExt = 0x00},
      R"(Counts Number of Misses in HitMe Cache : Remote socket read or invalidate requests)",
      R"(Counts Number of Misses in HitMe Cache : Remote socket read or invalidate requests : op is RdCode, RdData, RdDataMigratory, RdCur, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.DEALLOCATE_RSPFWDI_LOC",
      EventDef::Encoding{.code = 0x61, .umask = 0x01, .umaskExt = 0x00},
      R"(Counts the number of Allocate/Update to HitMe Cache : op is RspIFwd or RspIFwdWb for a local request)",
      R"(Counts the number of Allocate/Update to HitMe Cache : op is RspIFwd or RspIFwdWb for a local request : Received RspFwdI* for a local request, but converted HitME$ to SF entry)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.RSPFWDI_REM",
      EventDef::Encoding{.code = 0x61, .umask = 0x02, .umaskExt = 0x00},
      R"(Counts the number of Allocate/Update to HitMe Cache : op is RspIFwd or RspIFwdWb for a remote request)",
      R"(Counts the number of Allocate/Update to HitMe Cache : op is RspIFwd or RspIFwdWb for a remote request : Updated HitME$ on RspFwdI* or local HitM/E received for a remote request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.SHARED",
      EventDef::Encoding{.code = 0x61, .umask = 0x04, .umaskExt = 0x00},
      R"(Counts the number of Allocate/Update to HitMe Cache : Update HitMe Cache to SHARed)",
      R"(Counts the number of Allocate/Update to HitMe Cache : Update HitMe Cache to SHARed)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.RDINVOWN",
      EventDef::Encoding{.code = 0x61, .umask = 0x08, .umaskExt = 0x00},
      R"(Counts the number of Allocate/Update to HitMe Cache : Update HitMe Cache on RdInvOwn even if not RspFwdI*)",
      R"(Counts the number of Allocate/Update to HitMe Cache : Update HitMe Cache on RdInvOwn even if not RspFwdI*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.DEALLOCATE",
      EventDef::Encoding{.code = 0x61, .umask = 0x10, .umaskExt = 0x00},
      R"(Counts the number of Allocate/Update to HitMe Cache : Deallocate HitME$ on Reads without RspFwdI*)",
      R"(Counts the number of Allocate/Update to HitMe Cache : Deallocate HitME$ on Reads without RspFwdI*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_READS_COUNT.PRIORITY",
      EventDef::Encoding{.code = 0x59, .umask = 0x02, .umaskExt = 0x00},
      R"(HA to iMC Reads Issued : ISOCH)",
      R"(HA to iMC Reads Issued : ISOCH : Count of the number of reads issued to any of the memory controller channels.  This can be filtered by the priority of the reads.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL",
      EventDef::Encoding{.code = 0x5B, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : Partial Non-ISOCH)",
      R"(CHA to iMC Full Line Writes Issued : Partial Non-ISOCH : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.FULL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : ISOCH Full Line)",
      R"(CHA to iMC Full Line Writes Issued : ISOCH Full Line : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : ISOCH Partial)",
      R"(CHA to iMC Full Line Writes Issued : ISOCH Partial : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.M_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in M state)",
      R"(Lines Victimized : Lines in M state : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.E_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in E state)",
      R"(Lines Victimized : Lines in E state : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.S_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in S State)",
      R"(Lines Victimized : Lines in S State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_ONLY",
      EventDef::Encoding{.code = 0x37, .umask = 0x00, .umaskExt = 0x20},
      R"(Lines Victimized : Local Only)",
      R"(Lines Victimized : Local Only : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.REMOTE_ONLY",
      EventDef::Encoding{.code = 0x37, .umask = 0x00, .umaskExt = 0x80},
      R"(Lines Victimized : Remote Only)",
      R"(Lines Victimized : Remote Only : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_M",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in M State)",
      R"(Lines Victimized : Local - Lines in M State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_E",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in E State)",
      R"(Lines Victimized : Local - Lines in E State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_S",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in S State)",
      R"(Lines Victimized : Local - Lines in S State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.REMOTE_M",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x80},
      R"(Lines Victimized : Remote - Lines in M State)",
      R"(Lines Victimized : Remote - Lines in M State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.REMOTE_E",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x80},
      R"(Lines Victimized : Remote - Lines in E State)",
      R"(Lines Victimized : Remote - Lines in E State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.REMOTE_S",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x80},
      R"(Lines Victimized : Remote - Lines in S State)",
      R"(Lines Victimized : Remote - Lines in S State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.RSPI_WAS_FSE",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .umaskExt = 0x00},
      R"(Cbo Misc : Silent Snoop Eviction)",
      R"(Cbo Misc : Silent Snoop Eviction : Miscellaneous events in the Cbo. : Counts the number of times when a Snoop hit in FSE states and triggered a silent eviction.  This is useful because this information is lost in the PRE encodings.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.WC_ALIASING",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .umaskExt = 0x00},
      R"(Cbo Misc : Write Combining Aliasing)",
      R"(Cbo Misc : Write Combining Aliasing : Miscellaneous events in the Cbo. : Counts the number of times that a USWC write (WCIL(F)) transaction hit in the LLC in M state, triggering a WBMtoI followed by the USWC write.  This occurs when there is WC aliasing.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_VIC",
      EventDef::Encoding{.code = 0x39, .umask = 0x10, .umaskExt = 0x00},
      R"(Cbo Misc : CV0 Prefetch Victim)",
      R"(Cbo Misc : CV0 Prefetch Victim : Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_MISS",
      EventDef::Encoding{.code = 0x39, .umask = 0x20, .umaskExt = 0x00},
      R"(Cbo Misc : CV0 Prefetch Miss)",
      R"(Cbo Misc : CV0 Prefetch Miss : Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.LOCAL_INVITOE",
      EventDef::Encoding{.code = 0x55, .umask = 0x01, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : Local InvItoE)",
      R"(OSB Snoop Broadcast : Local InvItoE : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.LOCAL_READ",
      EventDef::Encoding{.code = 0x55, .umask = 0x02, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : Local Rd)",
      R"(OSB Snoop Broadcast : Local Rd : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.REMOTE_READ",
      EventDef::Encoding{.code = 0x55, .umask = 0x04, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : Remote Rd)",
      R"(OSB Snoop Broadcast : Remote Rd : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.REMOTE_READINVITOE",
      EventDef::Encoding{.code = 0x55, .umask = 0x08, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : Remote Rd InvItoE)",
      R"(OSB Snoop Broadcast : Remote Rd InvItoE : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.RFO_HITS_SNP_BCAST",
      EventDef::Encoding{.code = 0x55, .umask = 0x10, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : RFO HitS Snoop Broadcast)",
      R"(OSB Snoop Broadcast : RFO HitS Snoop Broadcast : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB.OFF_PWRHEURISTIC",
      EventDef::Encoding{.code = 0x55, .umask = 0x20, .umaskExt = 0x00},
      R"(OSB Snoop Broadcast : Off)",
      R"(OSB Snoop Broadcast : Off : Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.RMW_SETMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_PAMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_ALLOWSNP",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_WAYMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x08, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_ALLWAYRSV",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.PTL_INPIPE",
      EventDef::Encoding{.code = 0x42, .umask = 0x80, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IRQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x01},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.FSF_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x02},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ONE_FSF_VIC",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x04},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.TORID_MATCH_GO_P",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x10},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IPQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x20},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.WAY_MATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x40},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ONE_RSP_CON",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x80},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IDX_INPIPE",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x100},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.SETMATCHENTRYWSCT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x200},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ALLRSFWAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x800},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.RRQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x1000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ISMQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x2000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.SF_WAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x4000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.LLC_WAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x8000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.NOTALLOWSNOOP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x10000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.TOPA_MATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x20000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IVEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x40000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.BLEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x80000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ADEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x100000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.AKEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x200000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.HACREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x400000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_AD_REQ",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x800000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_AD_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x1000000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_BL_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x2000000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC0",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC0)",
      R"(CHA iMC CHNx READ Credits Empty : MC0 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC1",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC1)",
      R"(CHA iMC CHNx READ Credits Empty : MC1 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC2",
      EventDef::Encoding{.code = 0x58, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC2)",
      R"(CHA iMC CHNx READ Credits Empty : MC2 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC3",
      EventDef::Encoding{.code = 0x58, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC3)",
      R"(CHA iMC CHNx READ Credits Empty : MC3 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC4",
      EventDef::Encoding{.code = 0x58, .umask = 0x10, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC4)",
      R"(CHA iMC CHNx READ Credits Empty : MC4 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC5",
      EventDef::Encoding{.code = 0x58, .umask = 0x20, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC5)",
      R"(CHA iMC CHNx READ Credits Empty : MC5 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC6",
      EventDef::Encoding{.code = 0x58, .umask = 0x40, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC6)",
      R"(CHA iMC CHNx READ Credits Empty : MC6 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 6 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC7",
      EventDef::Encoding{.code = 0x58, .umask = 0x80, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC7)",
      R"(CHA iMC CHNx READ Credits Empty : MC7 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 7 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC8",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x01},
      R"(CHA iMC CHNx READ Credits Empty : MC8)",
      R"(CHA iMC CHNx READ Credits Empty : MC8 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 8 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC9",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x02},
      R"(CHA iMC CHNx READ Credits Empty : MC9)",
      R"(CHA iMC CHNx READ Credits Empty : MC9 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 9 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC10",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x04},
      R"(CHA iMC CHNx READ Credits Empty : MC10)",
      R"(CHA iMC CHNx READ Credits Empty : MC10 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 10 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC11",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x08},
      R"(CHA iMC CHNx READ Credits Empty : MC11)",
      R"(CHA iMC CHNx READ Credits Empty : MC11 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 11 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC12",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x10},
      R"(CHA iMC CHNx READ Credits Empty : MC12)",
      R"(CHA iMC CHNx READ Credits Empty : MC12 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 12 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC13",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x20},
      R"(CHA iMC CHNx READ Credits Empty : MC13)",
      R"(CHA iMC CHNx READ Credits Empty : MC13 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 13 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : IRQ)",
      R"(Ingress (from CMS) Allocations : IRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : IRQ Rejected)",
      R"(Ingress (from CMS) Allocations : IRQ Rejected : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IPQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x04, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : IPQ)",
      R"(Ingress (from CMS) Allocations : IPQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : PRQ)",
      R"(Ingress (from CMS) Allocations : PRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : PRQ)",
      R"(Ingress (from CMS) Allocations : PRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.RRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : RRQ)",
      R"(Ingress (from CMS) Allocations : RRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.WBQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : WBQ)",
      R"(Ingress (from CMS) Allocations : WBQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0 : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0 : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x04, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0 : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x08, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0 : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x10, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0 : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x20, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0 : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x22, .umask = 0x40, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x22, .umask = 0x80, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request)",
      R"(IPQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : ANY0)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : ANY0 : Any condition listed in the IPQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : HA)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x08, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : SF Victim)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : SF Victim : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : Victim)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x23, .umask = 0x20, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x23, .umask = 0x80, .umaskExt = 0x00},
      R"(IPQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match)",
      R"(IPQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0 : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0 : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0 : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x08, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0 : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x10, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0 : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x20, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0 : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x40, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x80, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : ANY0)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : ANY0 : Any condition listed in the IRQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : HA)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x04, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x08, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : SF Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : SF Victim : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC or SF Way)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC or SF Way : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x19, .umask = 0x40, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : AD REQ on VN0)",
      R"(ISMQ Rejects - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : AD RSP on VN0)",
      R"(ISMQ Rejects - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x04, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL RSP on VN0)",
      R"(ISMQ Rejects - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x08, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL WB on VN0)",
      R"(ISMQ Rejects - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x10, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL NCB on VN0)",
      R"(ISMQ Rejects - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x20, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL NCS on VN0)",
      R"(ISMQ Rejects - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x40, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : Non UPI AK Request)",
      R"(ISMQ Rejects - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x80, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : Non UPI IV Request)",
      R"(ISMQ Rejects - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : AD REQ on VN0)",
      R"(ISMQ Retries - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : AD RSP on VN0)",
      R"(ISMQ Retries - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL RSP on VN0)",
      R"(ISMQ Retries - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL WB on VN0)",
      R"(ISMQ Retries - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x10, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL NCB on VN0)",
      R"(ISMQ Retries - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x20, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL NCS on VN0)",
      R"(ISMQ Retries - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x40, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : Non UPI AK Request)",
      R"(ISMQ Retries - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x80, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : Non UPI IV Request)",
      R"(ISMQ Retries - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x25, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 1 : ANY0)",
      R"(ISMQ Rejects - Set 1 : ANY0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Any condition listed in the ISMQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x25, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 1 : HA)",
      R"(ISMQ Rejects - Set 1 : HA : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2D, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 1 : ANY0)",
      R"(ISMQ Retries - Set 1 : ANY0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Any condition listed in the ISMQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.HA",
      EventDef::Encoding{.code = 0x2D, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 1 : HA)",
      R"(ISMQ Retries - Set 1 : HA : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.IRQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Occupancy : IRQ)",
      R"(Ingress (from CMS) Occupancy : IRQ : Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.IPQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x04, .umaskExt = 0x00},
      R"(Ingress (from CMS) Occupancy : IPQ)",
      R"(Ingress (from CMS) Occupancy : IPQ : Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.RRQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Occupancy : RRQ)",
      R"(Ingress (from CMS) Occupancy : RRQ : Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.WBQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Occupancy : WBQ)",
      R"(Ingress (from CMS) Occupancy : WBQ : Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x01, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : AD REQ on VN0)",
      R"(Other Retries - Set 0 : AD REQ on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x02, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : AD RSP on VN0)",
      R"(Other Retries - Set 0 : AD RSP on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x04, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL RSP on VN0)",
      R"(Other Retries - Set 0 : BL RSP on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x08, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL WB on VN0)",
      R"(Other Retries - Set 0 : BL WB on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x10, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL NCB on VN0)",
      R"(Other Retries - Set 0 : BL NCB on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x20, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL NCS on VN0)",
      R"(Other Retries - Set 0 : BL NCS on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x40, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : Non UPI AK Request)",
      R"(Other Retries - Set 0 : Non UPI AK Request : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x80, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : Non UPI IV Request)",
      R"(Other Retries - Set 0 : Non UPI IV Request : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2F, .umask = 0x01, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : ANY0)",
      R"(Other Retries - Set 1 : ANY0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Any condition listed in the Other0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.HA",
      EventDef::Encoding{.code = 0x2F, .umask = 0x02, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : HA)",
      R"(Other Retries - Set 1 : HA : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x04, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : LLC Victim)",
      R"(Other Retries - Set 1 : LLC Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x08, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : SF Victim)",
      R"(Other Retries - Set 1 : SF Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x10, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : Victim)",
      R"(Other Retries - Set 1 : Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2F, .umask = 0x20, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : LLC OR SF Way)",
      R"(Other Retries - Set 1 : LLC OR SF Way : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2F, .umask = 0x40, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : Allow Snoop)",
      R"(Other Retries - Set 1 : Allow Snoop : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2F, .umask = 0x80, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : PhyAddr Match)",
      R"(Other Retries - Set 1 : PhyAddr Match : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0 : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0 : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0 : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x08, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0 : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x10, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0 : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x20, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0 : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x40, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x80, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : ANY0)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : ANY0 : Any condition listed in the PRQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : HA)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x04, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x08, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : SF Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : SF Victim : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x10, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x21, .umask = 0x20, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x21, .umask = 0x40, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x21, .umask = 0x80, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x01, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : AD REQ on VN0)",
      R"(Request Queue Retries - Set 0 : AD REQ on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x02, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : AD RSP on VN0)",
      R"(Request Queue Retries - Set 0 : AD RSP on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x04, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL RSP on VN0)",
      R"(Request Queue Retries - Set 0 : BL RSP on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x08, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL WB on VN0)",
      R"(Request Queue Retries - Set 0 : BL WB on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL NCB on VN0)",
      R"(Request Queue Retries - Set 0 : BL NCB on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL NCS on VN0)",
      R"(Request Queue Retries - Set 0 : BL NCS on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : Non UPI AK Request)",
      R"(Request Queue Retries - Set 0 : Non UPI AK Request : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : Non UPI IV Request)",
      R"(Request Queue Retries - Set 0 : Non UPI IV Request : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2B, .umask = 0x01, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : ANY0)",
      R"(Request Queue Retries - Set 1 : ANY0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Any condition listed in the WBQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.HA",
      EventDef::Encoding{.code = 0x2B, .umask = 0x02, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : HA)",
      R"(Request Queue Retries - Set 1 : HA : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x04, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : LLC Victim)",
      R"(Request Queue Retries - Set 1 : LLC Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x08, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : SF Victim)",
      R"(Request Queue Retries - Set 1 : SF Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x10, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : Victim)",
      R"(Request Queue Retries - Set 1 : Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2B, .umask = 0x20, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : LLC OR SF Way)",
      R"(Request Queue Retries - Set 1 : LLC OR SF Way : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2B, .umask = 0x40, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : Allow Snoop)",
      R"(Request Queue Retries - Set 1 : Allow Snoop : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2B, .umask = 0x80, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : PhyAddr Match)",
      R"(Request Queue Retries - Set 1 : PhyAddr Match : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x01, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : AD REQ on VN0)",
      R"(RRQ Rejects - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x02, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : AD RSP on VN0)",
      R"(RRQ Rejects - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x04, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : BL RSP on VN0)",
      R"(RRQ Rejects - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x08, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : BL WB on VN0)",
      R"(RRQ Rejects - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x10, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : BL NCB on VN0)",
      R"(RRQ Rejects - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x20, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : BL NCS on VN0)",
      R"(RRQ Rejects - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x26, .umask = 0x40, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : Non UPI AK Request)",
      R"(RRQ Rejects - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x26, .umask = 0x80, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 0 : Non UPI IV Request)",
      R"(RRQ Rejects - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x27, .umask = 0x01, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : ANY0)",
      R"(RRQ Rejects - Set 1 : ANY0 : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Any condition listed in the RRQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x27, .umask = 0x02, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : HA)",
      R"(RRQ Rejects - Set 1 : HA : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x04, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : LLC Victim)",
      R"(RRQ Rejects - Set 1 : LLC Victim : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x08, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : SF Victim)",
      R"(RRQ Rejects - Set 1 : SF Victim : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x10, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : Victim)",
      R"(RRQ Rejects - Set 1 : Victim : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x27, .umask = 0x20, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : LLC OR SF Way)",
      R"(RRQ Rejects - Set 1 : LLC OR SF Way : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x40, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : Allow Snoop)",
      R"(RRQ Rejects - Set 1 : Allow Snoop : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x27, .umask = 0x80, .umaskExt = 0x00},
      R"(RRQ Rejects - Set 1 : PhyAddr Match)",
      R"(RRQ Rejects - Set 1 : PhyAddr Match : Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry. : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x01, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : AD REQ on VN0)",
      R"(WBQ Rejects - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x02, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : AD RSP on VN0)",
      R"(WBQ Rejects - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x04, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : BL RSP on VN0)",
      R"(WBQ Rejects - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x08, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : BL WB on VN0)",
      R"(WBQ Rejects - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x10, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : BL NCB on VN0)",
      R"(WBQ Rejects - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x20, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : BL NCS on VN0)",
      R"(WBQ Rejects - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x28, .umask = 0x40, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : Non UPI AK Request)",
      R"(WBQ Rejects - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x28, .umask = 0x80, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 0 : Non UPI IV Request)",
      R"(WBQ Rejects - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x29, .umask = 0x01, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : ANY0)",
      R"(WBQ Rejects - Set 1 : ANY0 : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Any condition listed in the WBQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x29, .umask = 0x02, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : HA)",
      R"(WBQ Rejects - Set 1 : HA : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x04, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : LLC Victim)",
      R"(WBQ Rejects - Set 1 : LLC Victim : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x08, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : SF Victim)",
      R"(WBQ Rejects - Set 1 : SF Victim : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x10, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : Victim)",
      R"(WBQ Rejects - Set 1 : Victim : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x29, .umask = 0x20, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : LLC OR SF Way)",
      R"(WBQ Rejects - Set 1 : LLC OR SF Way : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x29, .umask = 0x40, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : Allow Snoop)",
      R"(WBQ Rejects - Set 1 : Allow Snoop : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x29, .umask = 0x80, .umaskExt = 0x00},
      R"(WBQ Rejects - Set 1 : PhyAddr Match)",
      R"(WBQ Rejects - Set 1 : PhyAddr Match : Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry. : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.ALL",
      EventDef::Encoding{.code = 0x51, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoops Sent : All)",
      R"(Snoops Sent : All : Counts the number of snoops issued by the HA.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoops Sent : Snoops sent for Local Requests)",
      R"(Snoops Sent : Snoops sent for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast or directed snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoops Sent : Snoops sent for Remote Requests)",
      R"(Snoops Sent : Snoops sent for Remote Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast or directed snoops issued by the HA responding to remote requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.BCST_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoops Sent : Broadcast snoops for Local Requests)",
      R"(Snoops Sent : Broadcast snoops for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.BCST_REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoops Sent : Broadcast snoops for Remote Requests)",
      R"(Snoops Sent : Broadcast snoops for Remote Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast snoops issued by the HA responding to remote requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.DIRECT_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoops Sent : Directed snoops for Local Requests)",
      R"(Snoops Sent : Directed snoops for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of directed snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.DIRECT_REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x80, .umaskExt = 0x00},
      R"(Snoops Sent : Directed snoops for Remote Requests)",
      R"(Snoops Sent : Directed snoops for Remote Requests : Counts the number of snoops issued by the HA. : Counts the number of directed snoops issued by the HA responding to remote requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPWB",
      EventDef::Encoding{.code = 0x5C, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoop Responses Received : Rsp*WB)",
      R"(Snoop Responses Received : Rsp*WB : Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1. : Filters for a snoop response of RspIWB or RspSWB.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPFWDWB",
      EventDef::Encoding{.code = 0x5C, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoop Responses Received : Rsp*Fwd*WB)",
      R"(Snoop Responses Received : Rsp*Fwd*WB : Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1. : Filters for a snoop response of Rsp*Fwd*WB.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPCNFLCT",
      EventDef::Encoding{.code = 0x5C, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoop Responses Received : RSPCNFLCT*)",
      R"(Snoop Responses Received : RSPCNFLCT* : Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1. : Filters for snoops responses of RspConflict.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPFWD",
      EventDef::Encoding{.code = 0x5C, .umask = 0x80, .umaskExt = 0x00},
      R"(Snoop Responses Received : RspFwd)",
      R"(Snoop Responses Received : RspFwd : Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1. : Filters for a snoop response of RspFwd to a CA request.  This snoop response is only possible for RdCur when a snoop HITM/E in a remote caching agent and it directly forwards data to a requestor without changing the requestor's cache line state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPI",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspI)",
      R"(Snoop Responses Received Local : RspI : Number of snoop responses received for a Local  request : Filters for snoops responses of RspI to local CA requests.  RspI is returned when the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO hits non-modified data).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPS",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspS)",
      R"(Snoop Responses Received Local : RspS : Number of snoop responses received for a Local  request : Filters for snoop responses of RspS to local CA requests.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPIFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspIFwd)",
      R"(Snoop Responses Received Local : RspIFwd : Number of snoop responses received for a Local  request : Filters for snoop responses of RspIFwd to local CA requests.  This is returned when a remote caching agent forwards data and the requesting agent is able to acquire the data in E or M states.  This is commonly returned with RFO transactions.  It can be either a HitM or a HitFE.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPSFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspSFwd)",
      R"(Snoop Responses Received Local : RspSFwd : Number of snoop responses received for a Local  request : Filters for a snoop response of RspSFwd to local CA requests.  This is returned when a remote caching agent forwards data but holds on to its currently copy.  This is common for data and code reads that hit in a remote socket in E or F state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPWB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : Rsp*WB)",
      R"(Snoop Responses Received Local : Rsp*WB : Number of snoop responses received for a Local  request : Filters for a snoop response of RspIWB or RspSWB to local CA requests.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPFWDWB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : Rsp*FWD*WB)",
      R"(Snoop Responses Received Local : Rsp*FWD*WB : Number of snoop responses received for a Local  request : Filters for a snoop response of Rsp*Fwd*WB to local CA requests.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPCNFLCT",
      EventDef::Encoding{.code = 0x5D, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspCnflct)",
      R"(Snoop Responses Received Local : RspCnflct : Number of snoop responses received for a Local  request : Filters for snoops responses of RspConflict to local CA requests.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x80, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspFwd)",
      R"(Snoop Responses Received Local : RspFwd : Number of snoop responses received for a Local  request : Filters for a snoop response of RspFwd to local CA requests.  This snoop response is only possible for RdCur when a snoop HITM/E in a remote caching agent and it directly forwards data to a requestor without changing the requestor's cache line state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.MTOI_RSPIFWDM",
      EventDef::Encoding{.code = 0x6B, .umask = 0x01, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : MtoI RspIFwdM)",
      R"(Misc Snoop Responses Received : MtoI RspIFwdM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.MTOI_RSPDATAM",
      EventDef::Encoding{.code = 0x6B, .umask = 0x02, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : MtoI RspIDataM)",
      R"(Misc Snoop Responses Received : MtoI RspIDataM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.RSPIFWDMPTL_HITSF",
      EventDef::Encoding{.code = 0x6B, .umask = 0x04, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit SF)",
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit SF)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.RSPIFWDMPTL_HITLLC",
      EventDef::Encoding{.code = 0x6B, .umask = 0x08, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit LLC)",
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.PULLDATAPTL_HITSF",
      EventDef::Encoding{.code = 0x6B, .umask = 0x10, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit SF)",
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit SF)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.PULLDATAPTL_HITLLC",
      EventDef::Encoding{.code = 0x6B, .umask = 0x20, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit LLC)",
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.LLC",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .umaskExt = 0x00},
      R"(WbPushMtoI : Pushed to LLC)",
      R"(WbPushMtoI : Pushed to LLC : Counts the number of times when the CHA was received WbPushMtoI : Counts the number of times when the CHA was able to push WbPushMToI to LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.MEM",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .umaskExt = 0x00},
      R"(WbPushMtoI : Pushed to Memory)",
      R"(WbPushMtoI : Pushed to Memory : Counts the number of times when the CHA was received WbPushMtoI : Counts the number of times when the CHA was unable to push WbPushMToI to LLC (hence pushed it to MEM))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC0",
      EventDef::Encoding{.code = 0x5A, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC0)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC0 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC1",
      EventDef::Encoding{.code = 0x5A, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC1)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC1 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC2",
      EventDef::Encoding{.code = 0x5A, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC2)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC2 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC3",
      EventDef::Encoding{.code = 0x5A, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC3)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC3 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC4",
      EventDef::Encoding{.code = 0x5A, .umask = 0x10, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC4)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC4 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC5",
      EventDef::Encoding{.code = 0x5A, .umask = 0x20, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC5)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC5 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC6",
      EventDef::Encoding{.code = 0x5A, .umask = 0x40, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC6)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC6 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 6 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC7",
      EventDef::Encoding{.code = 0x5A, .umask = 0x80, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC7)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC7 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 7 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC8",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x01},
      R"(CHA iMC CHNx WRITE Credits Empty : MC8)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC8 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 8 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC9",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x02},
      R"(CHA iMC CHNx WRITE Credits Empty : MC9)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC9 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 9 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC10",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x04},
      R"(CHA iMC CHNx WRITE Credits Empty : MC10)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC10 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 10 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC11",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x08},
      R"(CHA iMC CHNx WRITE Credits Empty : MC11)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC11 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 11 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC12",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x10},
      R"(CHA iMC CHNx WRITE Credits Empty : MC12)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC12 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 12 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC13",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x20},
      R"(CHA iMC CHNx WRITE Credits Empty : MC13)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC13 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 13 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.SENT0",
      EventDef::Encoding{.code = 0x6f, .umask = 0x01, .umaskExt = 0x00},
      R"(XPT Prefetches : Sent (on 0?))",
      R"(XPT Prefetches : Sent (on 0?) : Number of XPT prefetches sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP0_NOCRD",
      EventDef::Encoding{.code = 0x6f, .umask = 0x04, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 0?) - No Credits)",
      R"(XPT Prefetches : Dropped (on 0?) - No Credits : Number of XPT prefetches dropped due to lack of XPT AD egress credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP0_CONFLICT",
      EventDef::Encoding{.code = 0x6f, .umask = 0x08, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 0?) - Conflict)",
      R"(XPT Prefetches : Dropped (on 0?) - Conflict : Number of XPT prefetches dropped due to AD CMS write port contention)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.SENT1",
      EventDef::Encoding{.code = 0x6f, .umask = 0x10, .umaskExt = 0x00},
      R"(XPT Prefetches : Sent (on 1?))",
      R"(XPT Prefetches : Sent (on 1?) : Number of XPT prefetches sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP1_NOCRD",
      EventDef::Encoding{.code = 0x6f, .umask = 0x40, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 1?) - No Credits)",
      R"(XPT Prefetches : Dropped (on 1?) - No Credits : Number of XPT prefetches dropped due to lack of XPT AD egress credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP1_CONFLICT",
      EventDef::Encoding{.code = 0x6f, .umask = 0x80, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 1?) - Conflict)",
      R"(XPT Prefetches : Dropped (on 1?) - Conflict : Number of XPT prefetches dropped due to AD CMS write port contention)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.FIRST_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(: IOTLB lookups first)",
      R"(: IOTLB lookups first : Some transactions have to look up IOTLB multiple times.  Counts the first time a request looks up IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.ALL_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(: IOTLB lookups all)",
      R"(: IOTLB lookups all : Some transactions have to look up IOTLB multiple times.  Counts every time a request looks up IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.4K_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 4K Page)",
      R"(: IOTLB Hits to a 4K Page : Counts if a transaction to a 4K page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.2M_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x08, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 2M Page)",
      R"(: IOTLB Hits to a 2M Page : Counts if a transaction to a 2M page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.1G_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x10, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 1G Page)",
      R"(: IOTLB Hits to a 1G Page : Counts if a transaction to a 1G page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.MISSES",
      EventDef::Encoding{.code = 0x40, .umask = 0x20, .umaskExt = 0x00},
      R"(: IOTLB Fills (same as IOTLB miss))",
      R"(: IOTLB Fills (same as IOTLB miss) : When a transaction misses IOTLB, it does a page walk to look up memory and bring in the relevant page translation. Counts when this page translation is written to IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.CTXT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x40, .umaskExt = 0x00},
      R"(: Context cache lookups)",
      R"(: Context cache lookups : Counts each time a transaction looks up root context cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.CTXT_CACHE_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x80, .umaskExt = 0x00},
      R"(: Context cache hits)",
      R"(: Context cache hits : Counts each time a first look up of the transaction hits the RCC.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.PWT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x41, .umask = 0x01, .umaskExt = 0x00},
      R"(: PageWalk cache lookup)",
      R"(: PageWalk cache lookup : Counts each time a transaction looks up second level page walk cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.NUM_MEM_ACCESSES",
      EventDef::Encoding{.code = 0x41, .umask = 0x40, .umaskExt = 0x00},
      R"(: IOMMU memory access)",
      R"(: IOMMU memory access : IOMMU sends out memory fetches when it misses the cache look up which is indicated by this signal.  M2IOSF only uses low priority channel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.CYC_PWT_FULL",
      EventDef::Encoding{.code = 0x41, .umask = 0x80, .umaskExt = 0x00},
      R"(: Cycles PWT full)",
      R"(: Cycles PWT full : Counts cycles the IOMMU has reached its maximum limit for outstanding page walks.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU3.INT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x43, .umask = 0x40, .umaskExt = 0x00},
      R"(: Interrupt Entry cache lookup)",
      R"(: Interrupt Entry cache lookup : Counts the number of transaction looks up that interrupt remapping cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU3.INT_CACHE_HITS",
      EventDef::Encoding{.code = 0x43, .umask = 0x80, .umaskExt = 0x00},
      R"(: Interrupt Entry cache hit)",
      R"(: Interrupt Entry cache hit : Counts each time a transaction's first look up hits the IEC.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0",
      EventDef::Encoding{.code = 0x02, .umask = 0x01, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus)",
      R"(AND Mask/match for debug bus : Non-PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x02, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : PCIE bus)",
      R"(AND Mask/match for debug bus : PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x04, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus and !(PCIE bus))",
      R"(AND Mask/match for debug bus : Non-PCIE bus and !(PCIE bus) : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x08, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus and PCIE bus)",
      R"(AND Mask/match for debug bus : Non-PCIE bus and PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x10, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus)",
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x20, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus))",
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus) : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0",
      EventDef::Encoding{.code = 0x03, .umask = 0x01, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus)",
      R"(OR Mask/match for debug bus : Non-PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x02, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : PCIE bus)",
      R"(OR Mask/match for debug bus : PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x04, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus and !(PCIE bus))",
      R"(OR Mask/match for debug bus : Non-PCIE bus and !(PCIE bus) : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x08, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus and PCIE bus)",
      R"(OR Mask/match for debug bus : Non-PCIE bus and PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x10, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus)",
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x20, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus))",
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus) : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_NUM_REQ_OF_CPU.ALL.DROP",
      EventDef::Encoding{.code = 0x85, .umask = 0x02, .umaskExt = 0x00},
      R"(Number requests PCIe makes of the main die : Drop request)",
      R"(Number requests PCIe makes of the main die : Drop request : Counts full PCIe requests before they're broken into a series of cache-line size requests as measured by DATA_REQ_OF_CPU and TXN_REQ_OF_CPU. : Packet error detected, must be dropped)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.ANY",
      EventDef::Encoding{.code = 0x0F, .umask = 0x01, .umaskExt = 0x00},
      R"(Total Write Cache Occupancy : Any Source)",
      R"(Total Write Cache Occupancy : Any Source : Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events. : Tracks all requests from any source port.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.IV_Q",
      EventDef::Encoding{.code = 0x0F, .umask = 0x02, .umaskExt = 0x00},
      R"(Total Write Cache Occupancy : Snoops)",
      R"(Total Write Cache Occupancy : Snoops : Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.CLFLUSH",
      EventDef::Encoding{.code = 0x10, .umask = 0x80, .umaskExt = 0x00},
      R"(Coherent Ops : CLFlush)",
      R"(Coherent Ops : CLFlush : Counts the number of coherency related operations serviced by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.OUTBOUND_INSERTS",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.EVICTS",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .umaskExt = 0x00},
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REQ",
      EventDef::Encoding{.code = 0x1e, .umask = 0x01, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Requests)",
      R"(Counts Timeouts - Set 0 : Fastpath Requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REJ",
      EventDef::Encoding{.code = 0x1E, .umask = 0x02, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Rejects)",
      R"(Counts Timeouts - Set 0 : Fastpath Rejects)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_RD_INSERT",
      EventDef::Encoding{.code = 0x1e, .umask = 0x04, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Read Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Read Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_WR_INSERT",
      EventDef::Encoding{.code = 0x1e, .umask = 0x08, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Write Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Write Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_ATOMIC_INSERT",
      EventDef::Encoding{.code = 0x1E, .umask = 0x10, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Atomic Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Atomic Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_XFER",
      EventDef::Encoding{.code = 0x1E, .umask = 0x20, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Transfers From Primary to Secondary)",
      R"(Counts Timeouts - Set 0 : Fastpath Transfers From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.PF_ACK_HINT",
      EventDef::Encoding{.code = 0x1E, .umask = 0x40, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Prefetch Ack Hints From Primary to Secondary)",
      R"(Counts Timeouts - Set 0 : Prefetch Ack Hints From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.SLOWPATH_FWPF_NO_PRF",
      EventDef::Encoding{.code = 0x1E, .umask = 0x80, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Slow path fwpf didn't find prefetch)",
      R"(Counts Timeouts - Set 0 : Slow path fwpf didn't find prefetch)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_I",
      EventDef::Encoding{.code = 0x1f, .umask = 0x01, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of I Line)",
      R"(Misc Events - Set 1 : Slow Transfer of I Line : Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_S",
      EventDef::Encoding{.code = 0x1f, .umask = 0x02, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of S Line)",
      R"(Misc Events - Set 1 : Slow Transfer of S Line : Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_E",
      EventDef::Encoding{.code = 0x1f, .umask = 0x04, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of E Line)",
      R"(Misc Events - Set 1 : Slow Transfer of E Line : Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_M",
      EventDef::Encoding{.code = 0x1f, .umask = 0x08, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of M Line)",
      R"(Misc Events - Set 1 : Slow Transfer of M Line : Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_INVLD",
      EventDef::Encoding{.code = 0x1F, .umask = 0x20, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Received Invalid)",
      R"(Misc Events - Set 1 : Received Invalid : Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_VLD",
      EventDef::Encoding{.code = 0x1F, .umask = 0x40, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Received Valid)",
      R"(Misc Events - Set 1 : Received Valid : Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.RD",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(P2P Transactions : P2P reads)",
      R"(P2P Transactions : P2P reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.WR",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(P2P Transactions : P2P Writes)",
      R"(P2P Transactions : P2P Writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.MSG",
      EventDef::Encoding{.code = 0x13, .umask = 0x04, .umaskExt = 0x00},
      R"(P2P Transactions : P2P Message)",
      R"(P2P Transactions : P2P Message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.CMPL",
      EventDef::Encoding{.code = 0x13, .umask = 0x08, .umaskExt = 0x00},
      R"(P2P Transactions : P2P completions)",
      R"(P2P Transactions : P2P completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(P2P Transactions : Match if remote only)",
      R"(P2P Transactions : Match if remote only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(P2P Transactions : match if remote and target matches)",
      R"(P2P Transactions : match if remote and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC",
      EventDef::Encoding{.code = 0x13, .umask = 0x40, .umaskExt = 0x00},
      R"(P2P Transactions : match if local only)",
      R"(P2P Transactions : match if local only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x80, .umaskExt = 0x00},
      R"(P2P Transactions : match if local and target matches)",
      R"(P2P Transactions : match if local and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.MISS",
      EventDef::Encoding{.code = 0x12, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoop Responses : Miss)",
      R"(Snoop Responses : Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_I",
      EventDef::Encoding{.code = 0x12, .umask = 0x02, .umaskExt = 0x00},
      R"(Snoop Responses : Hit I)",
      R"(Snoop Responses : Hit I)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_ES",
      EventDef::Encoding{.code = 0x12, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoop Responses : Hit E or S)",
      R"(Snoop Responses : Hit E or S)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPCODE",
      EventDef::Encoding{.code = 0x12, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoop Responses : SnpCode)",
      R"(Snoop Responses : SnpCode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPDATA",
      EventDef::Encoding{.code = 0x12, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoop Responses : SnpData)",
      R"(Snoop Responses : SnpData)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPINV",
      EventDef::Encoding{.code = 0x12, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoop Responses : SnpInv)",
      R"(Snoop Responses : SnpInv)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.WRITES",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Writes)",
      R"(Inbound Transaction Count : Writes : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks only write requests.  Each write request should have a prefetch, so there is no need to explicitly track these requests.  For writes that are tickled and have to retry, the counter will be incremented for each retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.ATOMIC",
      EventDef::Encoding{.code = 0x11, .umask = 0x10, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Atomic)",
      R"(Inbound Transaction Count : Atomic : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks the number of atomic transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.OTHER",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Other)",
      R"(Inbound Transaction Count : Other : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks the number of 'other' kinds of transactions.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.ORDERINGQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Select Source)",
      R"(Inbound Transaction Count : Select Source : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks only those requests that come from the port specified in the IRP_PmonFilter.OrderingQ register.  This register allows one to select one specific queue.  It is not possible to monitor multiple queues at a time.  If this bit is not set, then requests from all sources will be counted.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_EGRESS.TAKEN",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Taken)",
      R"(M2M to iMC Bypass : Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_INGRESS.TAKEN",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Taken)",
      R"(M2M to iMC Bypass : Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_INGRESS.NOT_TAKEN",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Not Taken)",
      R"(M2M to iMC Bypass : Not Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_I",
      EventDef::Encoding{.code = 0x2A, .umask = 0x01, .umaskExt = 0x00},
      R"(Directory Hit : On Dirty Line in I State)",
      R"(Directory Hit : On Dirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_S",
      EventDef::Encoding{.code = 0x2A, .umask = 0x02, .umaskExt = 0x00},
      R"(Directory Hit : On Dirty Line in S State)",
      R"(Directory Hit : On Dirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_P",
      EventDef::Encoding{.code = 0x2A, .umask = 0x04, .umaskExt = 0x00},
      R"(Directory Hit : On Dirty Line in L State)",
      R"(Directory Hit : On Dirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_A",
      EventDef::Encoding{.code = 0x2A, .umask = 0x08, .umaskExt = 0x00},
      R"(Directory Hit : On Dirty Line in A State)",
      R"(Directory Hit : On Dirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_I",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .umaskExt = 0x00},
      R"(Directory Hit : On NonDirty Line in I State)",
      R"(Directory Hit : On NonDirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_S",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .umaskExt = 0x00},
      R"(Directory Hit : On NonDirty Line in S State)",
      R"(Directory Hit : On NonDirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_P",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .umaskExt = 0x00},
      R"(Directory Hit : On NonDirty Line in L State)",
      R"(Directory Hit : On NonDirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_A",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .umaskExt = 0x00},
      R"(Directory Hit : On NonDirty Line in A State)",
      R"(Directory Hit : On NonDirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_I",
      EventDef::Encoding{.code = 0x2B, .umask = 0x01, .umaskExt = 0x00},
      R"(Directory Miss : On Dirty Line in I State)",
      R"(Directory Miss : On Dirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_S",
      EventDef::Encoding{.code = 0x2B, .umask = 0x02, .umaskExt = 0x00},
      R"(Directory Miss : On Dirty Line in S State)",
      R"(Directory Miss : On Dirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_P",
      EventDef::Encoding{.code = 0x2B, .umask = 0x04, .umaskExt = 0x00},
      R"(Directory Miss : On Dirty Line in L State)",
      R"(Directory Miss : On Dirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_A",
      EventDef::Encoding{.code = 0x2B, .umask = 0x08, .umaskExt = 0x00},
      R"(Directory Miss : On Dirty Line in A State)",
      R"(Directory Miss : On Dirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_I",
      EventDef::Encoding{.code = 0x2B, .umask = 0x10, .umaskExt = 0x00},
      R"(Directory Miss : On NonDirty Line in I State)",
      R"(Directory Miss : On NonDirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_S",
      EventDef::Encoding{.code = 0x2B, .umask = 0x20, .umaskExt = 0x00},
      R"(Directory Miss : On NonDirty Line in S State)",
      R"(Directory Miss : On NonDirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_P",
      EventDef::Encoding{.code = 0x2B, .umask = 0x40, .umaskExt = 0x00},
      R"(Directory Miss : On NonDirty Line in L State)",
      R"(Directory Miss : On NonDirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_A",
      EventDef::Encoding{.code = 0x2B, .umask = 0x80, .umaskExt = 0x00},
      R"(Directory Miss : On NonDirty Line in A State)",
      R"(Directory Miss : On NonDirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : Normal Priority - Ch0)",
      R"(M2M Reads Issued to iMC : Normal Priority - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_ISOCH",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : Critical Priority - Ch0)",
      R"(M2M Reads Issued to iMC : Critical Priority - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch0)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_FROM_TGR",
      EventDef::Encoding{.code = 0x37, .umask = 0x40, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : From TGR - Ch0)",
      R"(M2M Reads Issued to iMC : From TGR - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : Normal Priority - Ch1)",
      R"(M2M Reads Issued to iMC : Normal Priority - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_ISOCH",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : Critical Priority - Ch1)",
      R"(M2M Reads Issued to iMC : Critical Priority - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch1)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_FROM_TGR",
      EventDef::Encoding{.code = 0x37, .umask = 0x40, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : From TGR - Ch1)",
      R"(M2M Reads Issued to iMC : From TGR - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH2_FROM_TGR",
      EventDef::Encoding{.code = 0x37, .umask = 0x40, .umaskExt = 0x04},
      R"(M2M Reads Issued to iMC : From TGR - Ch2)",
      R"(M2M Reads Issued to iMC : From TGR - Ch2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch0)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch0)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FULL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x04, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch0)",
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_PARTIAL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x08, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch0)",
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : All Writes - Ch0)",
      R"(M2M Writes Issued to iMC : All Writes - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FROM_TGR",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x05},
      R"(M2M Writes Issued to iMC : From TGR - Ch0)",
      R"(M2M Writes Issued to iMC : From TGR - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_NI",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x06},
      R"(M2M Writes Issued to iMC : Non-Inclusive - Ch0)",
      R"(M2M Writes Issued to iMC : Non-Inclusive - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch1)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch1)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FULL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x04, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch1)",
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_PARTIAL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x08, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch1)",
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : All Writes - Ch1)",
      R"(M2M Writes Issued to iMC : All Writes - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FROM_TGR",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x09},
      R"(M2M Writes Issued to iMC : From TGR - Ch1)",
      R"(M2M Writes Issued to iMC : From TGR - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_NI",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x0A},
      R"(M2M Writes Issued to iMC : Non-Inclusive - Ch1)",
      R"(M2M Writes Issued to iMC : Non-Inclusive - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MESH",
      EventDef::Encoding{.code = 0x4C, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Packet Header Matches : Mesh Match)",
      R"(Number Packet Header Matches : Mesh Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MC",
      EventDef::Encoding{.code = 0x4C, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Packet Header Matches : MC Match)",
      R"(Number Packet Header Matches : MC Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_REG_CRD.CH0",
      EventDef::Encoding{.code = 0x43, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 0)",
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_REG_CRD.CH1",
      EventDef::Encoding{.code = 0x43, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 1)",
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_REG_CRD.CH2",
      EventDef::Encoding{.code = 0x43, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 2)",
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_SPEC_CRD.CH0",
      EventDef::Encoding{.code = 0x44, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 0)",
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_SPEC_CRD.CH1",
      EventDef::Encoding{.code = 0x44, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 1)",
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_SPEC_CRD.CH2",
      EventDef::Encoding{.code = 0x44, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 2)",
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_FULL.CH0",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Cycles Full : Channel 0)",
      R"(Tracker Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_FULL.CH1",
      EventDef::Encoding{.code = 0x45, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Cycles Full : Channel 1)",
      R"(Tracker Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_FULL.CH2",
      EventDef::Encoding{.code = 0x45, .umask = 0x04, .umaskExt = 0x00},
      R"(Tracker Cycles Full : Channel 2)",
      R"(Tracker Cycles Full : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x49, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Inserts : Channel 0)",
      R"(Tracker Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x49, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Inserts : Channel 1)",
      R"(Tracker Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH2",
      EventDef::Encoding{.code = 0x49, .umask = 0x04, .umaskExt = 0x00},
      R"(Tracker Inserts : Channel 2)",
      R"(Tracker Inserts : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_NE.CH0",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Cycles Not Empty : Channel 0)",
      R"(Tracker Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_NE.CH1",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Cycles Not Empty : Channel 1)",
      R"(Tracker Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_NE.CH2",
      EventDef::Encoding{.code = 0x46, .umask = 0x04, .umaskExt = 0x00},
      R"(Tracker Cycles Not Empty : Channel 2)",
      R"(Tracker Cycles Not Empty : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Occupancy : Channel 0)",
      R"(Tracker Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Occupancy : Channel 1)",
      R"(Tracker Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(Tracker Occupancy : Channel 2)",
      R"(Tracker Occupancy : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.NDR",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .umaskExt = 0x00},
      R"(Outbound Ring Transactions on AK : NDR Transactions)",
      R"(Outbound Ring Transactions on AK : NDR Transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.CRD_CBO",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .umaskExt = 0x00},
      R"(Outbound Ring Transactions on AK : CRD Transactions to Cbo)",
      R"(Outbound Ring Transactions on AK : CRD Transactions to Cbo)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x1D, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x1D, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.CMS0",
      EventDef::Encoding{.code = 0x14, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.CMS1",
      EventDef::Encoding{.code = 0x14, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.RDCRD0",
      EventDef::Encoding{.code = 0x14, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCRD0",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCMP0",
      EventDef::Encoding{.code = 0x14, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.RDCRD1",
      EventDef::Encoding{.code = 0x14, .umask = 0x88, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCRD1",
      EventDef::Encoding{.code = 0x14, .umask = 0x90, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCMP1",
      EventDef::Encoding{.code = 0x14, .umask = 0xA0, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.ALL",
      EventDef::Encoding{.code = 0x14, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : All)",
      R"(AK Egress (to CMS) Full : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.CMS0",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.CMS1",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.RDCRD",
      EventDef::Encoding{.code = 0x13, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.WRCRD",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.WRCMP",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x13, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : All)",
      R"(AK Egress (to CMS) Not Empty : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.CMS0",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.CMS1",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.RDCRD",
      EventDef::Encoding{.code = 0x11, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.WRCRD",
      EventDef::Encoding{.code = 0x11, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.WRCMP",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.PREF_RD_CAM_HIT",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.ALL",
      EventDef::Encoding{.code = 0x11, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : All)",
      R"(AK Egress (to CMS) Allocations : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1F, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1F, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.CMS0",
      EventDef::Encoding{.code = 0x12, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.CMS1",
      EventDef::Encoding{.code = 0x12, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.RDCRD",
      EventDef::Encoding{.code = 0x12, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.WRCRD",
      EventDef::Encoding{.code = 0x12, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.WRCMP",
      EventDef::Encoding{.code = 0x12, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.ALL",
      EventDef::Encoding{.code = 0x12, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : All)",
      R"(AK Egress (to CMS) Occupancy : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CACHE",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(Outbound DRS Ring Transactions to Cache : Data to Cache)",
      R"(Outbound DRS Ring Transactions to Cache : Data to Cache)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CORE",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(Outbound DRS Ring Transactions to Cache : Data to Core)",
      R"(Outbound DRS Ring Transactions to Cache : Data to Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_UPI",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(Outbound DRS Ring Transactions to Cache : Data to QPI)",
      R"(Outbound DRS Ring Transactions to Cache : Data to QPI)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.ALL",
      EventDef::Encoding{.code = 0x18, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : All)",
      R"(BL Egress (to CMS) Full : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS0",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS1",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x17, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : All)",
      R"(BL Egress (to CMS) Not Empty : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS0",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS1",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1B, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1B, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x1C, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x1C, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_FLUSH.CH0",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .umaskExt = 0x00},
      R"(WPQ Flush : Channel 0)",
      R"(WPQ Flush : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_FLUSH.CH1",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .umaskExt = 0x00},
      R"(WPQ Flush : Channel 1)",
      R"(WPQ Flush : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_FLUSH.CH2",
      EventDef::Encoding{.code = 0x58, .umask = 0x04, .umaskExt = 0x00},
      R"(WPQ Flush : Channel 2)",
      R"(WPQ Flush : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN0",
      EventDef::Encoding{.code = 0x4D, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 0)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN1",
      EventDef::Encoding{.code = 0x4D, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 1)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN2",
      EventDef::Encoding{.code = 0x4D, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 2)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN0",
      EventDef::Encoding{.code = 0x4E, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 0)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN1",
      EventDef::Encoding{.code = 0x4E, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 1)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN2",
      EventDef::Encoding{.code = 0x4E, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 2)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.CH0",
      EventDef::Encoding{.code = 0x4A, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Channel 0)",
      R"(Write Tracker Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.CH1",
      EventDef::Encoding{.code = 0x4A, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Channel 1)",
      R"(Write Tracker Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.CH2",
      EventDef::Encoding{.code = 0x4A, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Channel 2)",
      R"(Write Tracker Cycles Full : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.MIRR",
      EventDef::Encoding{.code = 0x4A, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Mirror)",
      R"(Write Tracker Cycles Full : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Inserts : Channel 0)",
      R"(Write Tracker Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Inserts : Channel 1)",
      R"(Write Tracker Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_INSERTS.CH2",
      EventDef::Encoding{.code = 0x56, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Inserts : Channel 2)",
      R"(Write Tracker Inserts : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.CH0",
      EventDef::Encoding{.code = 0x4B, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Channel 0)",
      R"(Write Tracker Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.CH1",
      EventDef::Encoding{.code = 0x4B, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Channel 1)",
      R"(Write Tracker Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.CH2",
      EventDef::Encoding{.code = 0x4B, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Channel 2)",
      R"(Write Tracker Cycles Not Empty : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Mirror)",
      R"(Write Tracker Cycles Not Empty : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS.CH0",
      EventDef::Encoding{.code = 0x63, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Inserts : Channel 0)",
      R"(Write Tracker Non-Posted Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS.CH1",
      EventDef::Encoding{.code = 0x63, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Inserts : Channel 1)",
      R"(Write Tracker Non-Posted Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS.CH2",
      EventDef::Encoding{.code = 0x63, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Inserts : Channel 2)",
      R"(Write Tracker Non-Posted Inserts : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x62, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Occupancy : Channel 0)",
      R"(Write Tracker Non-Posted Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x62, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Occupancy : Channel 1)",
      R"(Write Tracker Non-Posted Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x62, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Occupancy : Channel 2)",
      R"(Write Tracker Non-Posted Occupancy : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x55, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Channel 0)",
      R"(Write Tracker Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x55, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Channel 1)",
      R"(Write Tracker Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x55, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Channel 2)",
      R"(Write Tracker Occupancy : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR",
      EventDef::Encoding{.code = 0x55, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Mirror)",
      R"(Write Tracker Occupancy : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_INSERTS.CH0",
      EventDef::Encoding{.code = 0x5E, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Posted Inserts : Channel 0)",
      R"(Write Tracker Posted Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_INSERTS.CH1",
      EventDef::Encoding{.code = 0x5E, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Posted Inserts : Channel 1)",
      R"(Write Tracker Posted Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_INSERTS.CH2",
      EventDef::Encoding{.code = 0x5E, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Posted Inserts : Channel 2)",
      R"(Write Tracker Posted Inserts : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Posted Occupancy : Channel 0)",
      R"(Write Tracker Posted Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Posted Occupancy : Channel 1)",
      R"(Write Tracker Posted Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x5D, .umask = 0x04, .umaskExt = 0x00},
      R"(Write Tracker Posted Occupancy : Channel 2)",
      R"(Write Tracker Posted Occupancy : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.DRS_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x01, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : DRS)",
      R"(M2PCIe IIO Credit Acquired : DRS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.DRS_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x02, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : DRS)",
      R"(M2PCIe IIO Credit Acquired : DRS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCB_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x04, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCB)",
      R"(M2PCIe IIO Credit Acquired : NCB : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCB_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCB)",
      R"(M2PCIe IIO Credit Acquired : NCB : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCS_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCS)",
      R"(M2PCIe IIO Credit Acquired : NCS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCS_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCS)",
      R"(M2PCIe IIO Credit Acquired : NCS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credit for transfer through CMS Port 0s to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.DRS",
      EventDef::Encoding{.code = 0x34, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : DRS)",
      R"(M2PCIe IIO Failed to Acquire a Credit : DRS : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.NCB",
      EventDef::Encoding{.code = 0x34, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : NCB)",
      R"(M2PCIe IIO Failed to Acquire a Credit : NCB : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.NCS",
      EventDef::Encoding{.code = 0x34, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : NCS)",
      R"(M2PCIe IIO Failed to Acquire a Credit : NCS : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.DRS_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x01, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.DRS_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x02, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCB_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x04, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCB_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCS_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCS_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credit for transfer through CMS Port 0s to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.IIO_NCB",
      EventDef::Encoding{.code = 0x10, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.IIO_NCS",
      EventDef::Encoding{.code = 0x10, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x10, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.IIO_NCB",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.IIO_NCS",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.ALL",
      EventDef::Encoding{.code = 0x11, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AD_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AK_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x02, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.BL_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AD_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AK_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x20, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.BL_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AD_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AK_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.BL_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AD_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AK_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x20, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.BL_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AD_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.BL_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AK_CRD_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x08, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AD_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.BL_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AK_CRD_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x80, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.VNA",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .umaskExt = 0x00},
      R"(CBox AD Credits Empty : VNA Messages)",
      R"(CBox AD Credits Empty : VNA Messages : No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.WB",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .umaskExt = 0x00},
      R"(CBox AD Credits Empty : Writebacks)",
      R"(CBox AD Credits Empty : Writebacks : No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.REQ",
      EventDef::Encoding{.code = 0x22, .umask = 0x04, .umaskExt = 0x00},
      R"(CBox AD Credits Empty : Requests)",
      R"(CBox AD Credits Empty : Requests : No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.SNP",
      EventDef::Encoding{.code = 0x22, .umask = 0x08, .umaskExt = 0x00},
      R"(CBox AD Credits Empty : Snoops)",
      R"(CBox AD Credits Empty : Snoops : No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO2_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : IIO2)",
      R"(M2 BL Credits Empty : IIO2 : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO3_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : IIO3)",
      R"(M2 BL Credits Empty : IIO3 : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO4_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x08, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : IIO4)",
      R"(M2 BL Credits Empty : IIO4 : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO5_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : IIO5)",
      R"(M2 BL Credits Empty : IIO5 : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.NCS",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : All IIO targets for NCS are in single mask. ORs them together)",
      R"(M2 BL Credits Empty : All IIO targets for NCS are in single mask. ORs them together : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.NCS_SEL",
      EventDef::Encoding{.code = 0x23, .umask = 0x80, .umaskExt = 0x00},
      R"(M2 BL Credits Empty : Selected M2p BL NCS credits)",
      R"(M2 BL Credits Empty : Selected M2p BL NCS credits : No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x01, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : AD - Slot 0)",
      R"(Multi Slot Flit Received : AD - Slot 0 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT1",
      EventDef::Encoding{.code = 0x3E, .umask = 0x02, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : AD - Slot 1)",
      R"(Multi Slot Flit Received : AD - Slot 1 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT2",
      EventDef::Encoding{.code = 0x3E, .umask = 0x04, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : AD - Slot 2)",
      R"(Multi Slot Flit Received : AD - Slot 2 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.BL_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x08, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : BL - Slot 0)",
      R"(Multi Slot Flit Received : BL - Slot 0 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AK_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x10, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : AK - Slot 0)",
      R"(Multi Slot Flit Received : AK - Slot 0 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AK_SLOT2",
      EventDef::Encoding{.code = 0x3E, .umask = 0x20, .umaskExt = 0x00},
      R"(Multi Slot Flit Received : AK - Slot 2)",
      R"(Multi Slot Flit Received : AK - Slot 2 : Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x4B, .umask = 0x01, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : REQ on AD)",
      R"(Lost Arb for VN0 : REQ on AD : VN0 message requested but lost arbitration : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x4B, .umask = 0x02, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : SNP on AD)",
      R"(Lost Arb for VN0 : SNP on AD : VN0 message requested but lost arbitration : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x4B, .umask = 0x04, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : RSP on AD)",
      R"(Lost Arb for VN0 : RSP on AD : VN0 message requested but lost arbitration : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x4B, .umask = 0x08, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : RSP on BL)",
      R"(Lost Arb for VN0 : RSP on BL : VN0 message requested but lost arbitration : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.BL_WB",
      EventDef::Encoding{.code = 0x4B, .umask = 0x10, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : WB on BL)",
      R"(Lost Arb for VN0 : WB on BL : VN0 message requested but lost arbitration : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x4B, .umask = 0x20, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : NCB on BL)",
      R"(Lost Arb for VN0 : NCB on BL : VN0 message requested but lost arbitration : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x4B, .umask = 0x40, .umaskExt = 0x00},
      R"(Lost Arb for VN0 : NCS on BL)",
      R"(Lost Arb for VN0 : NCS on BL : VN0 message requested but lost arbitration : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x4C, .umask = 0x01, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : REQ on AD)",
      R"(Lost Arb for VN1 : REQ on AD : VN1 message requested but lost arbitration : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x4C, .umask = 0x02, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : SNP on AD)",
      R"(Lost Arb for VN1 : SNP on AD : VN1 message requested but lost arbitration : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x4C, .umask = 0x04, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : RSP on AD)",
      R"(Lost Arb for VN1 : RSP on AD : VN1 message requested but lost arbitration : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x4C, .umask = 0x08, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : RSP on BL)",
      R"(Lost Arb for VN1 : RSP on BL : VN1 message requested but lost arbitration : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.BL_WB",
      EventDef::Encoding{.code = 0x4C, .umask = 0x10, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : WB on BL)",
      R"(Lost Arb for VN1 : WB on BL : VN1 message requested but lost arbitration : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x4C, .umask = 0x20, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : NCB on BL)",
      R"(Lost Arb for VN1 : NCB on BL : VN1 message requested but lost arbitration : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_LOST_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x4C, .umask = 0x40, .umaskExt = 0x00},
      R"(Lost Arb for VN1 : NCS on BL)",
      R"(Lost Arb for VN1 : NCS on BL : VN1 message requested but lost arbitration : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.NO_PROG_AD_VN0",
      EventDef::Encoding{.code = 0x4D, .umask = 0x01, .umaskExt = 0x00},
      R"(Arb Miscellaneous : No Progress on Pending AD VN0)",
      R"(Arb Miscellaneous : No Progress on Pending AD VN0 : Arbitration stage made no progress on pending ad vn0 messages because slotting stage cannot accept new message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.NO_PROG_AD_VN1",
      EventDef::Encoding{.code = 0x4D, .umask = 0x02, .umaskExt = 0x00},
      R"(Arb Miscellaneous : No Progress on Pending AD VN1)",
      R"(Arb Miscellaneous : No Progress on Pending AD VN1 : Arbitration stage made no progress on pending ad vn1 messages because slotting stage cannot accept new message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.NO_PROG_BL_VN0",
      EventDef::Encoding{.code = 0x4D, .umask = 0x04, .umaskExt = 0x00},
      R"(Arb Miscellaneous : No Progress on Pending BL VN0)",
      R"(Arb Miscellaneous : No Progress on Pending BL VN0 : Arbitration stage made no progress on pending bl vn0 messages because slotting stage cannot accept new message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.NO_PROG_BL_VN1",
      EventDef::Encoding{.code = 0x4D, .umask = 0x08, .umaskExt = 0x00},
      R"(Arb Miscellaneous : No Progress on Pending BL VN1)",
      R"(Arb Miscellaneous : No Progress on Pending BL VN1 : Arbitration stage made no progress on pending bl vn1 messages because slotting stage cannot accept new message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.ADBL_PARALLEL_WIN_VN0",
      EventDef::Encoding{.code = 0x4D, .umask = 0x10, .umaskExt = 0x00},
      R"(Arb Miscellaneous : AD, BL Parallel Win VN0)",
      R"(Arb Miscellaneous : AD, BL Parallel Win VN0 : AD and BL messages won arbitration concurrently / in parallel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.ADBL_PARALLEL_WIN_VN1",
      EventDef::Encoding{.code = 0x4D, .umask = 0x20, .umaskExt = 0x00},
      R"(Arb Miscellaneous : AD, BL Parallel Win VN1)",
      R"(Arb Miscellaneous : AD, BL Parallel Win VN1 : AD and BL messages won arbitration concurrently / in parallel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.VN01_PARALLEL_WIN",
      EventDef::Encoding{.code = 0x4D, .umask = 0x40, .umaskExt = 0x00},
      R"(Arb Miscellaneous : VN0, VN1 Parallel Win)",
      R"(Arb Miscellaneous : VN0, VN1 Parallel Win : VN0 and VN1 arbitration sub-pipelines had parallel winners (at least one AD or BL on each side))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_MISC.ALL_PARALLEL_WIN",
      EventDef::Encoding{.code = 0x4D, .umask = 0x80, .umaskExt = 0x00},
      R"(Arb Miscellaneous : Max Parallel Win)",
      R"(Arb Miscellaneous : Max Parallel Win : VN0 and VN1 arbitration sub-pipelines both produced AD and BL winners (maximum possible parallel winners))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : REQ on AD)",
      R"(No Credits to Arb for VN0 : REQ on AD : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : SNP on AD)",
      R"(No Credits to Arb for VN0 : SNP on AD : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : RSP on AD)",
      R"(No Credits to Arb for VN0 : RSP on AD : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x47, .umask = 0x08, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : RSP on BL)",
      R"(No Credits to Arb for VN0 : RSP on BL : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.BL_WB",
      EventDef::Encoding{.code = 0x47, .umask = 0x10, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : WB on BL)",
      R"(No Credits to Arb for VN0 : WB on BL : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x47, .umask = 0x20, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : NCB on BL)",
      R"(No Credits to Arb for VN0 : NCB on BL : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x47, .umask = 0x40, .umaskExt = 0x00},
      R"(No Credits to Arb for VN0 : NCS on BL)",
      R"(No Credits to Arb for VN0 : NCS on BL : VN0 message is blocked from requesting arbitration due to lack of remote UPI credits : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x48, .umask = 0x01, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : REQ on AD)",
      R"(No Credits to Arb for VN1 : REQ on AD : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x48, .umask = 0x02, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : SNP on AD)",
      R"(No Credits to Arb for VN1 : SNP on AD : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x48, .umask = 0x04, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : RSP on AD)",
      R"(No Credits to Arb for VN1 : RSP on AD : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x48, .umask = 0x08, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : RSP on BL)",
      R"(No Credits to Arb for VN1 : RSP on BL : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.BL_WB",
      EventDef::Encoding{.code = 0x48, .umask = 0x10, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : WB on BL)",
      R"(No Credits to Arb for VN1 : WB on BL : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x48, .umask = 0x20, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : NCB on BL)",
      R"(No Credits to Arb for VN1 : NCB on BL : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOCRD_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x48, .umask = 0x40, .umaskExt = 0x00},
      R"(No Credits to Arb for VN1 : NCS on BL)",
      R"(No Credits to Arb for VN1 : NCS on BL : VN1 message is blocked from requesting arbitration due to lack of remote UPI credits : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x49, .umask = 0x01, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : REQ on AD)",
      R"(Can't Arb for VN0 : REQ on AD : VN0 message was not able to request arbitration while some other message won arbitration : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x49, .umask = 0x02, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : SNP on AD)",
      R"(Can't Arb for VN0 : SNP on AD : VN0 message was not able to request arbitration while some other message won arbitration : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x49, .umask = 0x04, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : RSP on AD)",
      R"(Can't Arb for VN0 : RSP on AD : VN0 message was not able to request arbitration while some other message won arbitration : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x49, .umask = 0x08, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : RSP on BL)",
      R"(Can't Arb for VN0 : RSP on BL : VN0 message was not able to request arbitration while some other message won arbitration : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.BL_WB",
      EventDef::Encoding{.code = 0x49, .umask = 0x10, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : WB on BL)",
      R"(Can't Arb for VN0 : WB on BL : VN0 message was not able to request arbitration while some other message won arbitration : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x49, .umask = 0x20, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : NCB on BL)",
      R"(Can't Arb for VN0 : NCB on BL : VN0 message was not able to request arbitration while some other message won arbitration : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x49, .umask = 0x40, .umaskExt = 0x00},
      R"(Can't Arb for VN0 : NCS on BL)",
      R"(Can't Arb for VN0 : NCS on BL : VN0 message was not able to request arbitration while some other message won arbitration : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x4A, .umask = 0x01, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : REQ on AD)",
      R"(Can't Arb for VN1 : REQ on AD : VN1 message was not able to request arbitration while some other message won arbitration : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x4A, .umask = 0x02, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : SNP on AD)",
      R"(Can't Arb for VN1 : SNP on AD : VN1 message was not able to request arbitration while some other message won arbitration : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x4A, .umask = 0x04, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : RSP on AD)",
      R"(Can't Arb for VN1 : RSP on AD : VN1 message was not able to request arbitration while some other message won arbitration : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x4A, .umask = 0x08, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : RSP on BL)",
      R"(Can't Arb for VN1 : RSP on BL : VN1 message was not able to request arbitration while some other message won arbitration : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.BL_WB",
      EventDef::Encoding{.code = 0x4A, .umask = 0x10, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : WB on BL)",
      R"(Can't Arb for VN1 : WB on BL : VN1 message was not able to request arbitration while some other message won arbitration : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x4A, .umask = 0x20, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : NCB on BL)",
      R"(Can't Arb for VN1 : NCB on BL : VN1 message was not able to request arbitration while some other message won arbitration : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_ARB_NOREQ_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x4A, .umask = 0x40, .umaskExt = 0x00},
      R"(Can't Arb for VN1 : NCS on BL)",
      R"(Can't Arb for VN1 : NCS on BL : VN1 message was not able to request arbitration while some other message won arbitration : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_BYPASSED.AD_S0_IDLE",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress Queue Bypasses : AD to Slot 0 on Idle)",
      R"(Ingress Queue Bypasses : AD to Slot 0 on Idle : Number of times message is bypassed around the Ingress Queue : AD is taking bypass to slot 0 of independent flit while pipeline is idle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_BYPASSED.AD_S0_BL_ARB",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(Ingress Queue Bypasses : AD to Slot 0 on BL Arb)",
      R"(Ingress Queue Bypasses : AD to Slot 0 on BL Arb : Number of times message is bypassed around the Ingress Queue : AD is taking bypass to slot 0 of independent flit while bl message is in arbitration)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_BYPASSED.AD_S1_BL_SLOT",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(Ingress Queue Bypasses : AD + BL to Slot 1)",
      R"(Ingress Queue Bypasses : AD + BL to Slot 1 : Number of times message is bypassed around the Ingress Queue : AD is taking bypass to flit slot 1 while merging with bl message in same flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_BYPASSED.AD_S2_BL_SLOT",
      EventDef::Encoding{.code = 0x40, .umask = 0x08, .umaskExt = 0x00},
      R"(Ingress Queue Bypasses : AD + BL to Slot 2)",
      R"(Ingress Queue Bypasses : AD + BL to Slot 2 : Number of times message is bypassed around the Ingress Queue : AD is taking bypass to flit slot 2 while merging with bl message in same flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.ANY_BGF_FIFO",
      EventDef::Encoding{.code = 0x5F, .umask = 0x01, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events : Any In BGF FIFO)",
      R"(Miscellaneous Credit Events : Any In BGF FIFO : Indication that at least one packet (flit) is in the bgf (fifo only))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.ANY_BGF_PATH",
      EventDef::Encoding{.code = 0x5F, .umask = 0x02, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events : Any in BGF Path)",
      R"(Miscellaneous Credit Events : Any in BGF Path : Indication that at least one packet (flit) is in the bgf path (i.e. pipe to fifo))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.VN0_NO_D2K_FOR_ARB",
      EventDef::Encoding{.code = 0x5F, .umask = 0x04, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events : No D2K For Arb)",
      R"(Miscellaneous Credit Events : No D2K For Arb : VN0 BL RSP message was blocked from arbitration request due to lack of D2K CMP credit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.VN1_NO_D2K_FOR_ARB",
      EventDef::Encoding{.code = 0x5F, .umask = 0x08, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events)",
      R"(Miscellaneous Credit Events : VN1 BL RSP message was blocked from arbitration request due to lack of D2K CMP credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.LT1_FOR_D2K",
      EventDef::Encoding{.code = 0x5F, .umask = 0x10, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events)",
      R"(Miscellaneous Credit Events : d2k credit count is less than 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_MISC.LT2_FOR_D2K",
      EventDef::Encoding{.code = 0x5F, .umask = 0x20, .umaskExt = 0x00},
      R"(Miscellaneous Credit Events)",
      R"(Miscellaneous Credit Events : d2k credit count is less than 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.VNA_IN_USE",
      EventDef::Encoding{.code = 0x60, .umask = 0x01, .umaskExt = 0x00},
      R"(Credit Occupancy : VNA In Use)",
      R"(Credit Occupancy : VNA In Use : Remote UPI VNA credit occupancy (number of credits in use), accumulated across all cycles)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.FLITS_IN_FIFO",
      EventDef::Encoding{.code = 0x60, .umask = 0x02, .umaskExt = 0x00},
      R"(Credit Occupancy : Packets in BGF FIFO)",
      R"(Credit Occupancy : Packets in BGF FIFO : Occupancy of m3upi ingress -> upi link layer bgf; packets (flits) in fifo)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.FLITS_IN_PATH",
      EventDef::Encoding{.code = 0x60, .umask = 0x04, .umaskExt = 0x00},
      R"(Credit Occupancy : Packets in BGF Path)",
      R"(Credit Occupancy : Packets in BGF Path : Occupancy of m3upi ingress -> upi link layer bgf; packets (flits) in path (i.e. pipe to fifo or fifo))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.TxQ_CRD",
      EventDef::Encoding{.code = 0x60, .umask = 0x08, .umaskExt = 0x00},
      R"(Credit Occupancy : Transmit Credits)",
      R"(Credit Occupancy : Transmit Credits : Link layer transmit queue credit occupancy (credits in use), accumulated across all cycles)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.D2K_CRD",
      EventDef::Encoding{.code = 0x60, .umask = 0x10, .umaskExt = 0x00},
      R"(Credit Occupancy : D2K Credits)",
      R"(Credit Occupancy : D2K Credits : D2K completion fifo credit occupancy (credits in use), accumulated across all cycles)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.P1P_TOTAL",
      EventDef::Encoding{.code = 0x60, .umask = 0x20, .umaskExt = 0x00},
      R"(Credit Occupancy)",
      R"(Credit Occupancy : count of bl messages in pump-1-pending state, in marker table and in fifo)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.P1P_FIFO",
      EventDef::Encoding{.code = 0x60, .umask = 0x40, .umaskExt = 0x00},
      R"(Credit Occupancy)",
      R"(Credit Occupancy : count of bl messages in pump-1-pending state, in completion fifo only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CRD_OCC.CONSUMED",
      EventDef::Encoding{.code = 0x60, .umask = 0x80, .umaskExt = 0x00},
      R"(Credit Occupancy : Credits Consumed)",
      R"(Credit Occupancy : Credits Consumed : number of remote vna credits consumed per cycle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x43, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : REQ on AD)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : REQ on AD : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x43, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : SNP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : SNP on AD : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x43, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : RSP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : RSP on AD : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x43, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : RSP on BL)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : RSP on BL : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.BL_WB",
      EventDef::Encoding{.code = 0x43, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : WB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : WB on BL : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x43, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : NCB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : NCB on BL : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x43, .umask = 0x40, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : NCS on BL)",
      R"(VN0 Ingress (from CMS) Queue - Cycles Not Empty : NCS on BL : Counts the number of cycles when the UPI Ingress is not empty.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x44, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : REQ on AD)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : REQ on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x44, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : SNP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : SNP on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x44, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : RSP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : RSP on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x44, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : RSP on BL)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : RSP on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.BL_WB",
      EventDef::Encoding{.code = 0x44, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : WB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : WB on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x44, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : NCB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : NCB on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_CYCLES_NE_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x44, .umask = 0x40, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : NCS on BL)",
      R"(VN1 Ingress (from CMS) Queue - Cycles Not Empty : NCS on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT.ALL",
      EventDef::Encoding{.code = 0x55, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Flit Not Sent : All)",
      R"(Data Flit Not Sent : All : Data flit is ready for transmission but could not be sent : data flit is ready for transmission but could not be sent for any reason, e.g. low credits, low tsv, stall injection)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT.TSV_HI",
      EventDef::Encoding{.code = 0x55, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Flit Not Sent : TSV High)",
      R"(Data Flit Not Sent : TSV High : Data flit is ready for transmission but could not be sent : data flit is ready for transmission but was not sent while tsv high)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT.VALID_FOR_FLIT",
      EventDef::Encoding{.code = 0x55, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Flit Not Sent : Cycle valid for Flit)",
      R"(Data Flit Not Sent : Cycle valid for Flit : Data flit is ready for transmission but could not be sent : data flit is ready for transmission but was not sent while cycle is valid for flit transmission)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT.NO_BGF",
      EventDef::Encoding{.code = 0x55, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Flit Not Sent : No BGF Credits)",
      R"(Data Flit Not Sent : No BGF Credits : Data flit is ready for transmission but could not be sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT.NO_TXQ",
      EventDef::Encoding{.code = 0x55, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Flit Not Sent : No TxQ Credits)",
      R"(Data Flit Not Sent : No TxQ Credits : Data flit is ready for transmission but could not be sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P0_WAIT",
      EventDef::Encoding{.code = 0x57, .umask = 0x01, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence : Wait on Pump 0)",
      R"(Generating BL Data Flit Sequence : Wait on Pump 0 : generating bl data flit sequence; waiting for data pump 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1_WAIT",
      EventDef::Encoding{.code = 0x57, .umask = 0x02, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence : Wait on Pump 1)",
      R"(Generating BL Data Flit Sequence : Wait on Pump 1 : generating bl data flit sequence; waiting for data pump 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1P_TO_LIMBO",
      EventDef::Encoding{.code = 0x57, .umask = 0x04, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence)",
      R"(Generating BL Data Flit Sequence : a bl message finished but is in limbo and moved to pump-1-pending logic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1P_BUSY",
      EventDef::Encoding{.code = 0x57, .umask = 0x08, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence)",
      R"(Generating BL Data Flit Sequence : pump-1-pending logic is tracking at least one message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1P_AT_LIMIT",
      EventDef::Encoding{.code = 0x57, .umask = 0x10, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence)",
      R"(Generating BL Data Flit Sequence : pump-1-pending logic is at capacity (pending table plus completion fifo at limit))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1P_HOLD_P0",
      EventDef::Encoding{.code = 0x57, .umask = 0x20, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence)",
      R"(Generating BL Data Flit Sequence : pump-1-pending logic is at or near capacity, such that pump-0-only bl messages are getting stalled in slotting stage)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_GEN_BL.P1P_FIFO_FULL",
      EventDef::Encoding{.code = 0x57, .umask = 0x40, .umaskExt = 0x00},
      R"(Generating BL Data Flit Sequence)",
      R"(Generating BL Data Flit Sequence : pump-1-pending completion fifo is full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_MISC.S2REQ_RECEIVED",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_FLITS_MISC.S2REQ_RECEIVED)",
      R"(: slot 2 request received from link layer while idle (with no slot 2 request active immediately prior))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_MISC.S2REQ_WITHDRAWN",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_FLITS_MISC.S2REQ_WITHDRAWN)",
      R"(: slot 2 request withdrawn during hold-off period or service window)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_MISC.S2REQ_IN_HOLDOFF",
      EventDef::Encoding{.code = 0x58, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_FLITS_MISC.S2REQ_IN_HOLDOFF)",
      R"(: slot 2 request naturally serviced during hold-off period)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_MISC.S2REQ_IN_SERVICE",
      EventDef::Encoding{.code = 0x58, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_FLITS_MISC.S2REQ_IN_SERVICE)",
      R"(: slot 2 request forcibly serviced during service window)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.ALL",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : All)",
      R"(Slotting BL Message Into Header Flit : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.NEED_DATA",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Needs Data Flit)",
      R"(Slotting BL Message Into Header Flit : Needs Data Flit : BL message requires data flit sequence)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.P0_WAIT",
      EventDef::Encoding{.code = 0x56, .umask = 0x04, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Wait on Pump 0)",
      R"(Slotting BL Message Into Header Flit : Wait on Pump 0 : Waiting for header pump 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.P1_WAIT",
      EventDef::Encoding{.code = 0x56, .umask = 0x08, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Wait on Pump 1)",
      R"(Slotting BL Message Into Header Flit : Wait on Pump 1 : Waiting for header pump 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.P1_NOT_REQ",
      EventDef::Encoding{.code = 0x56, .umask = 0x10, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1)",
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1 : Header pump 1 is not required for flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.P1_NOT_REQ_BUT_BUBBLE",
      EventDef::Encoding{.code = 0x56, .umask = 0x20, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1 - Bubble)",
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1 - Bubble : Header pump 1 is not required for flit but flit transmission delayed)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLITS_SLOT_BL.P1_NOT_REQ_NOT_AVAIL",
      EventDef::Encoding{.code = 0x56, .umask = 0x40, .umaskExt = 0x00},
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1 - Not Avail)",
      R"(Slotting BL Message Into Header Flit : Don't Need Pump 1 - Not Avail : Header pump 1 is not required for flit and not available)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.ACCUM",
      EventDef::Encoding{.code = 0x51, .umask = 0x01, .umaskExt = 0x00},
      R"(Flit Gen - Header 1 : Accumulate)",
      R"(Flit Gen - Header 1 : Accumulate : Events related to Header Flit Generation - Set 1 : Header flit slotting control state machine is in any accumulate state; multi-message flit may be assembled over multiple cycles)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.ACCUM_READ",
      EventDef::Encoding{.code = 0x51, .umask = 0x02, .umaskExt = 0x00},
      R"(Flit Gen - Header 1 : Accumulate Ready)",
      R"(Flit Gen - Header 1 : Accumulate Ready : Events related to Header Flit Generation - Set 1 : header flit slotting control state machine is in accum_ready state; flit is ready to send but transmission is blocked; more messages may be slotted into flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.ACCUM_WASTED",
      EventDef::Encoding{.code = 0x51, .umask = 0x04, .umaskExt = 0x00},
      R"(Flit Gen - Header 1 : Accumulate Wasted)",
      R"(Flit Gen - Header 1 : Accumulate Wasted : Events related to Header Flit Generation - Set 1 : Flit is being assembled over multiple cycles, but no additional message is being slotted into flit in current cycle; accumulate cycle is wasted)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.AHEAD_BLOCKED",
      EventDef::Encoding{.code = 0x51, .umask = 0x08, .umaskExt = 0x00},
      R"(Flit Gen - Header 1 : Run-Ahead - Blocked)",
      R"(Flit Gen - Header 1 : Run-Ahead - Blocked : Events related to Header Flit Generation - Set 1 : Header flit slotting entered run-ahead state; new header flit is started while transmission of prior, fully assembled flit is blocked)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.AHEAD_MSG1_DURING",
      EventDef::Encoding{.code = 0x51, .umask = 0x10, .umaskExt = 0x00},
      R"(Flit Gen - Header 1 : Run-Ahead - Message)",
      R"(Flit Gen - Header 1 : Run-Ahead - Message : Events related to Header Flit Generation - Set 1 : run-ahead mode: one message slotted during run-ahead)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.AHEAD_MSG2_AFTER",
      EventDef::Encoding{.code = 0x51, .umask = 0x20, .umaskExt = 0x00},
      R"(Flit Gen - Header 1)",
      R"(Flit Gen - Header 1 : Events related to Header Flit Generation - Set 1 : run-ahead mode: second message slotted immediately after run-ahead; potential run-ahead success)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.AHEAD_MSG2_SENT",
      EventDef::Encoding{.code = 0x51, .umask = 0x40, .umaskExt = 0x00},
      R"(Flit Gen - Header 1)",
      R"(Flit Gen - Header 1 : Events related to Header Flit Generation - Set 1 : run-ahead mode: two (or three) message flit sent immediately after run-ahead; complete run-ahead success)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR1.AHEAD_MSG1_AFTER",
      EventDef::Encoding{.code = 0x51, .umask = 0x80, .umaskExt = 0x00},
      R"(Flit Gen - Header 1)",
      R"(Flit Gen - Header 1 : Events related to Header Flit Generation - Set 1 : run-ahead mode: message was slotted only after run-ahead was over; run-ahead mode definitely wasted)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR2.RMSTALL",
      EventDef::Encoding{.code = 0x52, .umask = 0x01, .umaskExt = 0x00},
      R"(Flit Gen - Header 2 : Rate-matching Stall)",
      R"(Flit Gen - Header 2 : Rate-matching Stall : Events related to Header Flit Generation - Set 2 : Rate-matching stall injected)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR2.RMSTALL_NOMSG",
      EventDef::Encoding{.code = 0x52, .umask = 0x02, .umaskExt = 0x00},
      R"(Flit Gen - Header 2 : Rate-matching Stall - No Message)",
      R"(Flit Gen - Header 2 : Rate-matching Stall - No Message : Events related to Header Flit Generation - Set 2 : Rate matching stall injected, but no additional message slotted during stall cycle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR2.PAR",
      EventDef::Encoding{.code = 0x52, .umask = 0x04, .umaskExt = 0x00},
      R"(Flit Gen - Header 2 : Parallel Ok)",
      R"(Flit Gen - Header 2 : Parallel Ok : Events related to Header Flit Generation - Set 2 : new header flit construction may proceed in parallel with data flit sequence)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR2.PAR_MSG",
      EventDef::Encoding{.code = 0x52, .umask = 0x08, .umaskExt = 0x00},
      R"(Flit Gen - Header 2 : Parallel Message)",
      R"(Flit Gen - Header 2 : Parallel Message : Events related to Header Flit Generation - Set 2 : message is slotted into header flit in parallel with data flit sequence)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_FLIT_GEN_HDR2.PAR_FLIT",
      EventDef::Encoding{.code = 0x52, .umask = 0x10, .umaskExt = 0x00},
      R"(Flit Gen - Header 2 : Parallel Flit Finished)",
      R"(Flit Gen - Header 2 : Parallel Flit Finished : Events related to Header Flit Generation - Set 2 : header flit finished assembly in parallel with data flit sequence)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.1_MSG",
      EventDef::Encoding{.code = 0x54, .umask = 0x01, .umaskExt = 0x00},
      R"(Sent Header Flit : One Message)",
      R"(Sent Header Flit : One Message : One message in flit; VNA or non-VNA flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.2_MSGS",
      EventDef::Encoding{.code = 0x54, .umask = 0x02, .umaskExt = 0x00},
      R"(Sent Header Flit : Two Messages)",
      R"(Sent Header Flit : Two Messages : Two messages in flit; VNA flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.3_MSGS",
      EventDef::Encoding{.code = 0x54, .umask = 0x04, .umaskExt = 0x00},
      R"(Sent Header Flit : Three Messages)",
      R"(Sent Header Flit : Three Messages : Three messages in flit; VNA flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.1_MSG_VNX",
      EventDef::Encoding{.code = 0x54, .umask = 0x08, .umaskExt = 0x00},
      R"(Sent Header Flit : One Message in non-VNA)",
      R"(Sent Header Flit : One Message in non-VNA : One message in flit; non-VNA flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.SLOTS_1",
      EventDef::Encoding{.code = 0x54, .umask = 0x10, .umaskExt = 0x00},
      R"(Sent Header Flit : One Slot Taken)",
      R"(Sent Header Flit : One Slot Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.SLOTS_2",
      EventDef::Encoding{.code = 0x54, .umask = 0x20, .umaskExt = 0x00},
      R"(Sent Header Flit : Two Slots Taken)",
      R"(Sent Header Flit : Two Slots Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLITS_SENT.SLOTS_3",
      EventDef::Encoding{.code = 0x54, .umask = 0x40, .umaskExt = 0x00},
      R"(Sent Header Flit : All Slots Taken)",
      R"(Sent Header Flit : All Slots Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.ALL",
      EventDef::Encoding{.code = 0x53, .umask = 0x01, .umaskExt = 0x00},
      R"(Header Not Sent : All)",
      R"(Header Not Sent : All : header flit is ready for transmission but could not be sent : header flit is ready for transmission but could not be sent for any reason, e.g. no credits, low tsv, stall injection)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.TSV_HI",
      EventDef::Encoding{.code = 0x53, .umask = 0x02, .umaskExt = 0x00},
      R"(Header Not Sent : TSV High)",
      R"(Header Not Sent : TSV High : header flit is ready for transmission but could not be sent : header flit is ready for transmission but was not sent while tsv high)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.VALID_FOR_FLIT",
      EventDef::Encoding{.code = 0x53, .umask = 0x04, .umaskExt = 0x00},
      R"(Header Not Sent : Cycle valid for Flit)",
      R"(Header Not Sent : Cycle valid for Flit : header flit is ready for transmission but could not be sent : header flit is ready for transmission but was not sent while cycle is valid for flit transmission)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.NO_BGF_CRD",
      EventDef::Encoding{.code = 0x53, .umask = 0x08, .umaskExt = 0x00},
      R"(Header Not Sent : No BGF Credits)",
      R"(Header Not Sent : No BGF Credits : header flit is ready for transmission but could not be sent : No BGF credits available)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.NO_TXQ_CRD",
      EventDef::Encoding{.code = 0x53, .umask = 0x10, .umaskExt = 0x00},
      R"(Header Not Sent : No TxQ Credits)",
      R"(Header Not Sent : No TxQ Credits : header flit is ready for transmission but could not be sent : No TxQ credits available)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.NO_BGF_NO_MSG",
      EventDef::Encoding{.code = 0x53, .umask = 0x20, .umaskExt = 0x00},
      R"(Header Not Sent : No BGF Credits + No Extra Message Slotted)",
      R"(Header Not Sent : No BGF Credits + No Extra Message Slotted : header flit is ready for transmission but could not be sent : No BGF credits available; no additional message slotted into flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT.NO_TXQ_NO_MSG",
      EventDef::Encoding{.code = 0x53, .umask = 0x40, .umaskExt = 0x00},
      R"(Header Not Sent : No TxQ Credits + No Extra Message Slotted)",
      R"(Header Not Sent : No TxQ Credits + No Extra Message Slotted : header flit is ready for transmission but could not be sent : No TxQ credits available; no additional message slotted into flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.VN0",
      EventDef::Encoding{.code = 0x50, .umask = 0x01, .umaskExt = 0x00},
      R"(Message Held : VN0)",
      R"(Message Held : VN0 : vn0 message(s) that couldn't be slotted into last vn0 flit are held in slotting stage while processing vn1 flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.VN1",
      EventDef::Encoding{.code = 0x50, .umask = 0x02, .umaskExt = 0x00},
      R"(Message Held : VN1)",
      R"(Message Held : VN1 : vn1 message(s) that couldn't be slotted into last vn1 flit are held in slotting stage while processing vn0 flit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.PARALLEL_ATTEMPT",
      EventDef::Encoding{.code = 0x50, .umask = 0x04, .umaskExt = 0x00},
      R"(Message Held : Parallel Attempt)",
      R"(Message Held : Parallel Attempt : ad and bl messages attempted to slot into the same flit in parallel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.PARALLEL_SUCCESS",
      EventDef::Encoding{.code = 0x50, .umask = 0x08, .umaskExt = 0x00},
      R"(Message Held : Parallel Success)",
      R"(Message Held : Parallel Success : ad and bl messages were actually slotted into the same flit in parallel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.CANT_SLOT_AD",
      EventDef::Encoding{.code = 0x50, .umask = 0x10, .umaskExt = 0x00},
      R"(Message Held : Can't Slot AD)",
      R"(Message Held : Can't Slot AD : some AD message could not be slotted (logical OR of all AD events under INGR_SLOT_CANT_MC_VN{0,1}))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_HELD.CANT_SLOT_BL",
      EventDef::Encoding{.code = 0x50, .umask = 0x20, .umaskExt = 0x00},
      R"(Message Held : Can't Slot BL)",
      R"(Message Held : Can't Slot BL : some BL message could not be slotted (logical OR of all BL events under INGR_SLOT_CANT_MC_VN{0,1}))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x41, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : REQ on AD)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : REQ on AD : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x41, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : SNP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : SNP on AD : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x41, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : RSP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : RSP on AD : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x41, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : RSP on BL)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : RSP on BL : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.BL_WB",
      EventDef::Encoding{.code = 0x41, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : WB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : WB on BL : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x41, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : NCB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : NCB on BL : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x41, .umask = 0x40, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Inserts : NCS on BL)",
      R"(VN0 Ingress (from CMS) Queue - Inserts : NCS on BL : Counts the number of allocations into the UPI Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : REQ on AD)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : REQ on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : SNP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : SNP on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : RSP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : RSP on AD : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : RSP on BL)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : RSP on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.BL_WB",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : WB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : WB on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x42, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : NCB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : NCB on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_INSERTS_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x42, .umask = 0x40, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Inserts : NCS on BL)",
      R"(VN1 Ingress (from CMS) Queue - Inserts : NCS on BL : Counts the number of allocations into the UPI VN1  Ingress.  This tracks one of the three rings that are used by the UPI agent.  This can be used in conjunction with the UPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : REQ on AD)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : REQ on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x45, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : SNP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : SNP on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x45, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : RSP on AD)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : RSP on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x45, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : RSP on BL)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : RSP on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.BL_WB",
      EventDef::Encoding{.code = 0x45, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : WB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : WB on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x45, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : NCB on BL)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : NCB on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x45, .umask = 0x40, .umaskExt = 0x00},
      R"(VN0 Ingress (from CMS) Queue - Occupancy : NCS on BL)",
      R"(VN0 Ingress (from CMS) Queue - Occupancy : NCS on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : REQ on AD)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : REQ on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : SNP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : SNP on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x46, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : RSP on AD)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : RSP on AD : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x46, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : RSP on BL)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : RSP on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.BL_WB",
      EventDef::Encoding{.code = 0x46, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : WB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : WB on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : NCB on BL)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : NCB on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_OCCUPANCY_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x40, .umaskExt = 0x00},
      R"(VN1 Ingress (from CMS) Queue - Occupancy : NCS on BL)",
      R"(VN1 Ingress (from CMS) Queue - Occupancy : NCS on BL : Accumulates the occupancy of a given UPI VN1  Ingress queue in each cycle.  This tracks one of the three ring Ingress buffers.  This can be used with the UPI VN1  Ingress Not Empty event to calculate average occupancy or the UPI VN1  Ingress Allocations event in order to calculate average queuing latency. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.AD_REQ",
      EventDef::Encoding{.code = 0x4E, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : REQ on AD)",
      R"(VN0 message can't slot into flit : REQ on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.AD_SNP",
      EventDef::Encoding{.code = 0x4E, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : SNP on AD)",
      R"(VN0 message can't slot into flit : SNP on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.AD_RSP",
      EventDef::Encoding{.code = 0x4E, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : RSP on AD)",
      R"(VN0 message can't slot into flit : RSP on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.BL_RSP",
      EventDef::Encoding{.code = 0x4E, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : RSP on BL)",
      R"(VN0 message can't slot into flit : RSP on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.BL_WB",
      EventDef::Encoding{.code = 0x4E, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : WB on BL)",
      R"(VN0 message can't slot into flit : WB on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.BL_NCB",
      EventDef::Encoding{.code = 0x4E, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : NCB on BL)",
      R"(VN0 message can't slot into flit : NCB on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN0.BL_NCS",
      EventDef::Encoding{.code = 0x4E, .umask = 0x40, .umaskExt = 0x00},
      R"(VN0 message can't slot into flit : NCS on BL)",
      R"(VN0 message can't slot into flit : NCS on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.AD_REQ",
      EventDef::Encoding{.code = 0x4F, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : REQ on AD)",
      R"(VN1 message can't slot into flit : REQ on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.AD_SNP",
      EventDef::Encoding{.code = 0x4F, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : SNP on AD)",
      R"(VN1 message can't slot into flit : SNP on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.AD_RSP",
      EventDef::Encoding{.code = 0x4F, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : RSP on AD)",
      R"(VN1 message can't slot into flit : RSP on AD : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.BL_RSP",
      EventDef::Encoding{.code = 0x4F, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : RSP on BL)",
      R"(VN1 message can't slot into flit : RSP on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.BL_WB",
      EventDef::Encoding{.code = 0x4F, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : WB on BL)",
      R"(VN1 message can't slot into flit : WB on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.BL_NCB",
      EventDef::Encoding{.code = 0x4F, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : NCB on BL)",
      R"(VN1 message can't slot into flit : NCB on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_PACKING_MISS_VN1.BL_NCS",
      EventDef::Encoding{.code = 0x4F, .umask = 0x40, .umaskExt = 0x00},
      R"(VN1 message can't slot into flit : NCS on BL)",
      R"(VN1 message can't slot into flit : NCS on BL : Count cases where Ingress has packets to send but did not have time to pack into flit before sending to Agent so slot was left NULL which could have been used. : Non-Coherent Standard (NCS) messages on BL.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.CORRECTED",
      EventDef::Encoding{.code = 0x5A, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote VNA Credits : Corrected)",
      R"(Remote VNA Credits : Corrected : Number of remote vna credits corrected (local return) per cycle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.LT1",
      EventDef::Encoding{.code = 0x5A, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote VNA Credits : Level < 1)",
      R"(Remote VNA Credits : Level < 1 : Remote vna credit level is less than 1 (i.e. no vna credits available))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.LT4",
      EventDef::Encoding{.code = 0x5A, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote VNA Credits : Level < 4)",
      R"(Remote VNA Credits : Level < 4 : Remote vna credit level is less than 4; bl (or ad requiring 4 vna) cannot arb on vna)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.LT5",
      EventDef::Encoding{.code = 0x5A, .umask = 0x08, .umaskExt = 0x00},
      R"(Remote VNA Credits : Level < 5)",
      R"(Remote VNA Credits : Level < 5 : Remote vna credit level is less than 5; parallel ad/bl arb on vna not possible)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.LT10",
      EventDef::Encoding{.code = 0x5A, .umask = 0x10, .umaskExt = 0x00},
      R"(Remote VNA Credits : Level < 10)",
      R"(Remote VNA Credits : Level < 10 : remote vna credit level is less than 10; parallel vn0/vn1 arb not possible)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD.ANY_IN_USE",
      EventDef::Encoding{.code = 0x5A, .umask = 0x20, .umaskExt = 0x00},
      R"(Remote VNA Credits : Any In Use)",
      R"(Remote VNA Credits : Any In Use : At least one remote vna credit is in use)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.REQ_VN01_ALLOC_LT10",
      EventDef::Encoding{.code = 0x59, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.REQ_VN01_ALLOC_LT10)",
      R"(: remote vna credit count was less than 10 and allocation to vn0 or vn1 was required)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.REQ_ADBL_ALLOC_L5",
      EventDef::Encoding{.code = 0x59, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.REQ_ADBL_ALLOC_L5)",
      R"(: remote vna credit count was less than 5 and allocation to ad or bl messages was required)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_ONLY",
      EventDef::Encoding{.code = 0x59, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_ONLY)",
      R"(: remote vna credits were allocated only to vn0, not to vn1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_ONLY",
      EventDef::Encoding{.code = 0x59, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_ONLY)",
      R"(: remote vna credits were allocated only to vn1, not to vn0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_JUST_AD",
      EventDef::Encoding{.code = 0x59, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_JUST_AD)",
      R"(: on vn0, remote vna credits were allocated only to ad messages, not to bl)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_JUST_BL",
      EventDef::Encoding{.code = 0x59, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN0_JUST_BL)",
      R"(: on vn0, remote vna credits were allocated only to bl messages, not to ad)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_JUST_AD",
      EventDef::Encoding{.code = 0x59, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_JUST_AD)",
      R"(: on vn1, remote vna credits were allocated only to ad messages, not to bl)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_JUST_BL",
      EventDef::Encoding{.code = 0x59, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_M3UPI_RxC_VNA_CRD_MISC.VN1_JUST_BL)",
      R"(: on vn1, remote vna credits were allocated only to bl messages, not to ad)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_REQ",
      EventDef::Encoding{.code = 0x30, .umask = 0x01, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN0 REQ Messages)",
      R"(Failed ARB for AD : VN0 REQ Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_SNP",
      EventDef::Encoding{.code = 0x30, .umask = 0x02, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN0 SNP Messages)",
      R"(Failed ARB for AD : VN0 SNP Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_RSP",
      EventDef::Encoding{.code = 0x30, .umask = 0x04, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN0 RSP Messages)",
      R"(Failed ARB for AD : VN0 RSP Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_WB",
      EventDef::Encoding{.code = 0x30, .umask = 0x08, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN0 WB Messages)",
      R"(Failed ARB for AD : VN0 WB Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_REQ",
      EventDef::Encoding{.code = 0x30, .umask = 0x10, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN1 REQ Messages)",
      R"(Failed ARB for AD : VN1 REQ Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_SNP",
      EventDef::Encoding{.code = 0x30, .umask = 0x20, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN1 SNP Messages)",
      R"(Failed ARB for AD : VN1 SNP Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_RSP",
      EventDef::Encoding{.code = 0x30, .umask = 0x40, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN1 RSP Messages)",
      R"(Failed ARB for AD : VN1 RSP Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_WB",
      EventDef::Encoding{.code = 0x30, .umask = 0x80, .umaskExt = 0x00},
      R"(Failed ARB for AD : VN1 WB Messages)",
      R"(Failed ARB for AD : VN1 WB Messages : AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x01, .umaskExt = 0x00},
      R"(AD FlowQ Bypass)",
      R"(AD FlowQ Bypass : Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT1",
      EventDef::Encoding{.code = 0x2C, .umask = 0x02, .umaskExt = 0x00},
      R"(AD FlowQ Bypass)",
      R"(AD FlowQ Bypass : Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT2",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .umaskExt = 0x00},
      R"(AD FlowQ Bypass)",
      R"(AD FlowQ Bypass : Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.BL_EARLY_RSP",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .umaskExt = 0x00},
      R"(AD FlowQ Bypass)",
      R"(AD FlowQ Bypass : Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_REQ",
      EventDef::Encoding{.code = 0x27, .umask = 0x01, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN0 REQ Messages)",
      R"(AD Flow Q Not Empty : VN0 REQ Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x02, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN0 SNP Messages)",
      R"(AD Flow Q Not Empty : VN0 SNP Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_RSP",
      EventDef::Encoding{.code = 0x27, .umask = 0x04, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN0 RSP Messages)",
      R"(AD Flow Q Not Empty : VN0 RSP Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_WB",
      EventDef::Encoding{.code = 0x27, .umask = 0x08, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN0 WB Messages)",
      R"(AD Flow Q Not Empty : VN0 WB Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_REQ",
      EventDef::Encoding{.code = 0x27, .umask = 0x10, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN1 REQ Messages)",
      R"(AD Flow Q Not Empty : VN1 REQ Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x20, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN1 SNP Messages)",
      R"(AD Flow Q Not Empty : VN1 SNP Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_RSP",
      EventDef::Encoding{.code = 0x27, .umask = 0x40, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN1 RSP Messages)",
      R"(AD Flow Q Not Empty : VN1 RSP Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_WB",
      EventDef::Encoding{.code = 0x27, .umask = 0x80, .umaskExt = 0x00},
      R"(AD Flow Q Not Empty : VN1 WB Messages)",
      R"(AD Flow Q Not Empty : VN1 WB Messages : Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_REQ",
      EventDef::Encoding{.code = 0x2D, .umask = 0x01, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN0 REQ Messages)",
      R"(AD Flow Q Inserts : VN0 REQ Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_SNP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x02, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN0 SNP Messages)",
      R"(AD Flow Q Inserts : VN0 SNP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_RSP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x04, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN0 RSP Messages)",
      R"(AD Flow Q Inserts : VN0 RSP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_WB",
      EventDef::Encoding{.code = 0x2D, .umask = 0x08, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN0 WB Messages)",
      R"(AD Flow Q Inserts : VN0 WB Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_REQ",
      EventDef::Encoding{.code = 0x2D, .umask = 0x10, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN1 REQ Messages)",
      R"(AD Flow Q Inserts : VN1 REQ Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_SNP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x20, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN1 SNP Messages)",
      R"(AD Flow Q Inserts : VN1 SNP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_RSP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x40, .umaskExt = 0x00},
      R"(AD Flow Q Inserts : VN1 RSP Messages)",
      R"(AD Flow Q Inserts : VN1 RSP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_REQ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x01, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN0 REQ Messages)",
      R"(AD Flow Q Occupancy : VN0 REQ Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_SNP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x02, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN0 SNP Messages)",
      R"(AD Flow Q Occupancy : VN0 SNP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_RSP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x04, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN0 RSP Messages)",
      R"(AD Flow Q Occupancy : VN0 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_WB",
      EventDef::Encoding{.code = 0x1C, .umask = 0x08, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN0 WB Messages)",
      R"(AD Flow Q Occupancy : VN0 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_REQ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x10, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN1 REQ Messages)",
      R"(AD Flow Q Occupancy : VN1 REQ Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_SNP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x20, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN1 SNP Messages)",
      R"(AD Flow Q Occupancy : VN1 SNP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_RSP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x40, .umaskExt = 0x00},
      R"(AD Flow Q Occupancy : VN1 RSP Messages)",
      R"(AD Flow Q Occupancy : VN1 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_RSP",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN0 RSP Messages)",
      R"(Failed ARB for BL : VN0 RSP Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_WB",
      EventDef::Encoding{.code = 0x35, .umask = 0x02, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN0 WB Messages)",
      R"(Failed ARB for BL : VN0 WB Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_NCB",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN0 NCB Messages)",
      R"(Failed ARB for BL : VN0 NCB Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_NCS",
      EventDef::Encoding{.code = 0x35, .umask = 0x08, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN0 NCS Messages)",
      R"(Failed ARB for BL : VN0 NCS Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_RSP",
      EventDef::Encoding{.code = 0x35, .umask = 0x10, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN1 RSP Messages)",
      R"(Failed ARB for BL : VN1 RSP Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_WB",
      EventDef::Encoding{.code = 0x35, .umask = 0x20, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN1 WB Messages)",
      R"(Failed ARB for BL : VN1 WB Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_NCB",
      EventDef::Encoding{.code = 0x35, .umask = 0x40, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN1 NCS Messages)",
      R"(Failed ARB for BL : VN1 NCS Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_NCS",
      EventDef::Encoding{.code = 0x35, .umask = 0x80, .umaskExt = 0x00},
      R"(Failed ARB for BL : VN1 NCB Messages)",
      R"(Failed ARB for BL : VN1 NCB Messages : BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_REQ",
      EventDef::Encoding{.code = 0x28, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN0 REQ Messages)",
      R"(BL Flow Q Not Empty : VN0 REQ Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_SNP",
      EventDef::Encoding{.code = 0x28, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN0 SNP Messages)",
      R"(BL Flow Q Not Empty : VN0 SNP Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_RSP",
      EventDef::Encoding{.code = 0x28, .umask = 0x04, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN0 RSP Messages)",
      R"(BL Flow Q Not Empty : VN0 RSP Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_WB",
      EventDef::Encoding{.code = 0x28, .umask = 0x08, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN0 WB Messages)",
      R"(BL Flow Q Not Empty : VN0 WB Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_REQ",
      EventDef::Encoding{.code = 0x28, .umask = 0x10, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN1 REQ Messages)",
      R"(BL Flow Q Not Empty : VN1 REQ Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_SNP",
      EventDef::Encoding{.code = 0x28, .umask = 0x20, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN1 SNP Messages)",
      R"(BL Flow Q Not Empty : VN1 SNP Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_RSP",
      EventDef::Encoding{.code = 0x28, .umask = 0x40, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN1 RSP Messages)",
      R"(BL Flow Q Not Empty : VN1 RSP Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_WB",
      EventDef::Encoding{.code = 0x28, .umask = 0x80, .umaskExt = 0x00},
      R"(BL Flow Q Not Empty : VN1 WB Messages)",
      R"(BL Flow Q Not Empty : VN1 WB Messages : Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN0_NCB",
      EventDef::Encoding{.code = 0x2E, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN0 RSP Messages)",
      R"(BL Flow Q Inserts : VN0 RSP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN0_NCS",
      EventDef::Encoding{.code = 0x2E, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN0 WB Messages)",
      R"(BL Flow Q Inserts : VN0 WB Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN0_WB",
      EventDef::Encoding{.code = 0x2E, .umask = 0x04, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN0 NCB Messages)",
      R"(BL Flow Q Inserts : VN0 NCB Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN0_RSP",
      EventDef::Encoding{.code = 0x2E, .umask = 0x08, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN0 NCS Messages)",
      R"(BL Flow Q Inserts : VN0 NCS Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN1_NCB",
      EventDef::Encoding{.code = 0x2E, .umask = 0x10, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN1 RSP Messages)",
      R"(BL Flow Q Inserts : VN1 RSP Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN1_NCS",
      EventDef::Encoding{.code = 0x2E, .umask = 0x20, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN1 WB Messages)",
      R"(BL Flow Q Inserts : VN1 WB Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN1_WB",
      EventDef::Encoding{.code = 0x2E, .umask = 0x40, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN1_NCS Messages)",
      R"(BL Flow Q Inserts : VN1_NCS Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_INSERTS.VN1_RSP",
      EventDef::Encoding{.code = 0x2E, .umask = 0x80, .umaskExt = 0x00},
      R"(BL Flow Q Inserts : VN1_NCB Messages)",
      R"(BL Flow Q Inserts : VN1_NCB Messages : Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN0_RSP",
      EventDef::Encoding{.code = 0x1D, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 RSP Messages)",
      R"(BL Flow Q Occupancy : VN0 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN0_WB",
      EventDef::Encoding{.code = 0x1D, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 WB Messages)",
      R"(BL Flow Q Occupancy : VN0 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN0_NCB",
      EventDef::Encoding{.code = 0x1D, .umask = 0x04, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 NCB Messages)",
      R"(BL Flow Q Occupancy : VN0 NCB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN0_NCS",
      EventDef::Encoding{.code = 0x1D, .umask = 0x08, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 NCS Messages)",
      R"(BL Flow Q Occupancy : VN0 NCS Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN1_RSP",
      EventDef::Encoding{.code = 0x1D, .umask = 0x10, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1 RSP Messages)",
      R"(BL Flow Q Occupancy : VN1 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN1_WB",
      EventDef::Encoding{.code = 0x1D, .umask = 0x20, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1 WB Messages)",
      R"(BL Flow Q Occupancy : VN1 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN1_NCB",
      EventDef::Encoding{.code = 0x1D, .umask = 0x40, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1_NCS Messages)",
      R"(BL Flow Q Occupancy : VN1_NCS Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY.VN1_NCS",
      EventDef::Encoding{.code = 0x1D, .umask = 0x80, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1_NCB Messages)",
      R"(BL Flow Q Occupancy : VN1_NCB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN0_LOCAL",
      EventDef::Encoding{.code = 0x1F, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 RSP Messages)",
      R"(BL Flow Q Occupancy : VN0 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN0_THROUGH",
      EventDef::Encoding{.code = 0x1F, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 WB Messages)",
      R"(BL Flow Q Occupancy : VN0 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN0_WRPULL",
      EventDef::Encoding{.code = 0x1F, .umask = 0x04, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN0 NCB Messages)",
      R"(BL Flow Q Occupancy : VN0 NCB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN1_LOCAL",
      EventDef::Encoding{.code = 0x1F, .umask = 0x10, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1 RSP Messages)",
      R"(BL Flow Q Occupancy : VN1 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN1_THROUGH",
      EventDef::Encoding{.code = 0x1F, .umask = 0x20, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1 WB Messages)",
      R"(BL Flow Q Occupancy : VN1 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY.VN1_WRPULL",
      EventDef::Encoding{.code = 0x1F, .umask = 0x40, .umaskExt = 0x00},
      R"(BL Flow Q Occupancy : VN1_NCS Messages)",
      R"(BL Flow Q Occupancy : VN1_NCS Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VNA",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VNA)",
      R"(UPI0 AD Credits Empty : VNA : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_REQ",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN0 REQ Messages)",
      R"(UPI0 AD Credits Empty : VN0 REQ Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_SNP",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN0 SNP Messages)",
      R"(UPI0 AD Credits Empty : VN0 SNP Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_RSP",
      EventDef::Encoding{.code = 0x20, .umask = 0x08, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN0 RSP Messages)",
      R"(UPI0 AD Credits Empty : VN0 RSP Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_REQ",
      EventDef::Encoding{.code = 0x20, .umask = 0x10, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN1 REQ Messages)",
      R"(UPI0 AD Credits Empty : VN1 REQ Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_SNP",
      EventDef::Encoding{.code = 0x20, .umask = 0x20, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN1 SNP Messages)",
      R"(UPI0 AD Credits Empty : VN1 SNP Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_RSP",
      EventDef::Encoding{.code = 0x20, .umask = 0x40, .umaskExt = 0x00},
      R"(UPI0 AD Credits Empty : VN1 RSP Messages)",
      R"(UPI0 AD Credits Empty : VN1 RSP Messages : No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VNA",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VNA)",
      R"(UPI0 BL Credits Empty : VNA : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN0_RSP",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN0 REQ Messages)",
      R"(UPI0 BL Credits Empty : VN0 REQ Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN0_NCS_NCB",
      EventDef::Encoding{.code = 0x21, .umask = 0x04, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN0 RSP Messages)",
      R"(UPI0 BL Credits Empty : VN0 RSP Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN0_WB",
      EventDef::Encoding{.code = 0x21, .umask = 0x08, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN0 SNP Messages)",
      R"(UPI0 BL Credits Empty : VN0 SNP Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_RSP",
      EventDef::Encoding{.code = 0x21, .umask = 0x10, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN1 REQ Messages)",
      R"(UPI0 BL Credits Empty : VN1 REQ Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_NCS_NCB",
      EventDef::Encoding{.code = 0x21, .umask = 0x20, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN1 RSP Messages)",
      R"(UPI0 BL Credits Empty : VN1 RSP Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_WB",
      EventDef::Encoding{.code = 0x21, .umask = 0x40, .umaskExt = 0x00},
      R"(UPI0 BL Credits Empty : VN1 SNP Messages)",
      R"(UPI0 BL Credits Empty : VN1 SNP Messages : No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.REQ",
      EventDef::Encoding{.code = 0x5B, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 Credit Used : REQ on AD)",
      R"(VN0 Credit Used : REQ on AD : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.SNP",
      EventDef::Encoding{.code = 0x5B, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 Credit Used : SNP on AD)",
      R"(VN0 Credit Used : SNP on AD : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.RSP",
      EventDef::Encoding{.code = 0x5B, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 Credit Used : RSP on AD)",
      R"(VN0 Credit Used : RSP on AD : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.WB",
      EventDef::Encoding{.code = 0x5B, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 Credit Used : RSP on BL)",
      R"(VN0 Credit Used : RSP on BL : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.NCB",
      EventDef::Encoding{.code = 0x5B, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 Credit Used : WB on BL)",
      R"(VN0 Credit Used : WB on BL : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_CREDITS_USED.NCS",
      EventDef::Encoding{.code = 0x5B, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 Credit Used : NCB on BL)",
      R"(VN0 Credit Used : NCB on BL : Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across UPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.REQ",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .umaskExt = 0x00},
      R"(VN0 No Credits : REQ on AD)",
      R"(VN0 No Credits : REQ on AD : Number of Cycles there were no VN0 Credits : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.SNP",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .umaskExt = 0x00},
      R"(VN0 No Credits : SNP on AD)",
      R"(VN0 No Credits : SNP on AD : Number of Cycles there were no VN0 Credits : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.RSP",
      EventDef::Encoding{.code = 0x5D, .umask = 0x04, .umaskExt = 0x00},
      R"(VN0 No Credits : RSP on AD)",
      R"(VN0 No Credits : RSP on AD : Number of Cycles there were no VN0 Credits : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.WB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x08, .umaskExt = 0x00},
      R"(VN0 No Credits : RSP on BL)",
      R"(VN0 No Credits : RSP on BL : Number of Cycles there were no VN0 Credits : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.NCB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x10, .umaskExt = 0x00},
      R"(VN0 No Credits : WB on BL)",
      R"(VN0 No Credits : WB on BL : Number of Cycles there were no VN0 Credits : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN0_NO_CREDITS.NCS",
      EventDef::Encoding{.code = 0x5D, .umask = 0x20, .umaskExt = 0x00},
      R"(VN0 No Credits : NCB on BL)",
      R"(VN0 No Credits : NCB on BL : Number of Cycles there were no VN0 Credits : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.REQ",
      EventDef::Encoding{.code = 0x5C, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 Credit Used : REQ on AD)",
      R"(VN1 Credit Used : REQ on AD : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.SNP",
      EventDef::Encoding{.code = 0x5C, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 Credit Used : SNP on AD)",
      R"(VN1 Credit Used : SNP on AD : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.RSP",
      EventDef::Encoding{.code = 0x5C, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 Credit Used : RSP on AD)",
      R"(VN1 Credit Used : RSP on AD : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.WB",
      EventDef::Encoding{.code = 0x5C, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 Credit Used : RSP on BL)",
      R"(VN1 Credit Used : RSP on BL : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.NCB",
      EventDef::Encoding{.code = 0x5C, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 Credit Used : WB on BL)",
      R"(VN1 Credit Used : WB on BL : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_CREDITS_USED.NCS",
      EventDef::Encoding{.code = 0x5C, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 Credit Used : NCB on BL)",
      R"(VN1 Credit Used : NCB on BL : Number of times a VN1 credit was used on the WB message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers. : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.REQ",
      EventDef::Encoding{.code = 0x5E, .umask = 0x01, .umaskExt = 0x00},
      R"(VN1 No Credits : REQ on AD)",
      R"(VN1 No Credits : REQ on AD : Number of Cycles there were no VN1 Credits : Home (REQ) messages on AD.  REQ is generally used to send requests, request responses, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.SNP",
      EventDef::Encoding{.code = 0x5E, .umask = 0x02, .umaskExt = 0x00},
      R"(VN1 No Credits : SNP on AD)",
      R"(VN1 No Credits : SNP on AD : Number of Cycles there were no VN1 Credits : Snoops (SNP) messages on AD.  SNP is used for outgoing snoops.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.RSP",
      EventDef::Encoding{.code = 0x5E, .umask = 0x04, .umaskExt = 0x00},
      R"(VN1 No Credits : RSP on AD)",
      R"(VN1 No Credits : RSP on AD : Number of Cycles there were no VN1 Credits : Response (RSP) messages on AD.  RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.WB",
      EventDef::Encoding{.code = 0x5E, .umask = 0x08, .umaskExt = 0x00},
      R"(VN1 No Credits : RSP on BL)",
      R"(VN1 No Credits : RSP on BL : Number of Cycles there were no VN1 Credits : Response (RSP) messages on BL. RSP packets are used to transmit a variety of protocol flits including grants and completions (CMP).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.NCB",
      EventDef::Encoding{.code = 0x5E, .umask = 0x10, .umaskExt = 0x00},
      R"(VN1 No Credits : WB on BL)",
      R"(VN1 No Credits : WB on BL : Number of Cycles there were no VN1 Credits : Data Response (WB) messages on BL.  WB is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using WB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_VN1_NO_CREDITS.NCS",
      EventDef::Encoding{.code = 0x5E, .umask = 0x20, .umaskExt = 0x00},
      R"(VN1 No Credits : NCB on BL)",
      R"(VN1 No Credits : NCB on BL : Number of Cycles there were no VN1 Credits : Non-Coherent Broadcast (NCB) messages on BL.  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_EQ_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.RT_LT_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x81, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x82, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7E, .umask = 0x84, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0x90, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_GT_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0xA0, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_EQ_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7E, .umask = 0xC0, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_OCC_COMPARE.BOTHNONZERO_RT_LT_LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.LOCALDEST_VN0",
      EventDef::Encoding{.code = 0x7D, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.LOCALDEST_VN0)",
      R"(UNC_M3UPI_WB_PENDING.LOCALDEST_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.ROUTETHRU_VN0",
      EventDef::Encoding{.code = 0x7D, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.ROUTETHRU_VN0)",
      R"(UNC_M3UPI_WB_PENDING.ROUTETHRU_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN0",
      EventDef::Encoding{.code = 0x7D, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN0)",
      R"(UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.WAITING4PULL_VN0",
      EventDef::Encoding{.code = 0x7D, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.WAITING4PULL_VN0)",
      R"(UNC_M3UPI_WB_PENDING.WAITING4PULL_VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.LOCALDEST_VN1",
      EventDef::Encoding{.code = 0x7D, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.LOCALDEST_VN1)",
      R"(UNC_M3UPI_WB_PENDING.LOCALDEST_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.ROUTETHRU_VN1",
      EventDef::Encoding{.code = 0x7D, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.ROUTETHRU_VN1)",
      R"(UNC_M3UPI_WB_PENDING.ROUTETHRU_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN1",
      EventDef::Encoding{.code = 0x7D, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN1)",
      R"(UNC_M3UPI_WB_PENDING.LOCAL_AND_RT_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_WB_PENDING.WAITING4PULL_VN1",
      EventDef::Encoding{.code = 0x7D, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_M3UPI_WB_PENDING.WAITING4PULL_VN1)",
      R"(UNC_M3UPI_WB_PENDING.WAITING4PULL_VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.ARRIVED",
      EventDef::Encoding{.code = 0x61, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.ARRIVED)",
      R"(: xpt prefetch message arrived in ingress pipeline)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.BYPASS",
      EventDef::Encoding{.code = 0x61, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.BYPASS)",
      R"(: xpt prefetch message took bypass path)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.ARB",
      EventDef::Encoding{.code = 0x61, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.ARB)",
      R"(: xpt prefetch message is making arbitration request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.LOST_ARB",
      EventDef::Encoding{.code = 0x61, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.LOST_ARB)",
      R"(: xpt prefetch message lost arbitration)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.FLITTED",
      EventDef::Encoding{.code = 0x61, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.FLITTED)",
      R"(: xpt prefetch message was slotted into flit (non bypass))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.LOST_OLD",
      EventDef::Encoding{.code = 0x61, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.LOST_OLD)",
      R"(: xpt prefetch message was dropped because it became too old)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_XPT_PFTCH.LOST_QFULL",
      EventDef::Encoding{.code = 0x61, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_M3UPI_XPT_PFTCH.LOST_QFULL)",
      R"(: xpt prefetch message was dropped because it was overwritten by new message while prefetch queue was full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.VLW_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(Message Received : VLW)",
      R"(Message Received : VLW : Virtual Logical Wire (legacy) message were received from Uncore.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.MSI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(Message Received : MSI)",
      R"(Message Received : MSI : Message Signaled Interrupts - interrupts sent by devices (including PCIe via IOxAPIC) (Socket Mode only))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.IPI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(Message Received : IPI)",
      R"(Message Received : IPI : Inter Processor Interrupts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.DOORBELL_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x08, .umaskExt = 0x00},
      R"(Message Received : Doorbell)",
      R"(Message Received : Doorbell)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.INT_PRIO",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .umaskExt = 0x00},
      R"(Message Received : Interrupt)",
      R"(Message Received : Interrupt : Interrupts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_PHOLD_CYCLES.ASSERT_TO_ACK",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles PHOLD Assert to Ack : Assert to ACK)",
      R"(Cycles PHOLD Assert to Ack : Assert to ACK : PHOLD cycles.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDRAND",
      EventDef::Encoding{.code = 0x4C, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.RDRAND)",
      R"(UNC_U_RACU_DRNG.RDRAND)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDSEED",
      EventDef::Encoding{.code = 0x4C, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.RDSEED)",
      R"(UNC_U_RACU_DRNG.RDSEED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY",
      EventDef::Encoding{.code = 0x4C, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_DIRECT_ATTEMPTS.D2C",
      EventDef::Encoding{.code = 0x12, .umask = 0x01, .umaskExt = 0x00},
      R"(Direct packet attempts : D2C)",
      R"(Direct packet attempts : D2C : Counts the number of DRS packets that we attempted to do direct2core/direct2UPI on.  There are 4 mutually exclusive filters.  Filter [0] can be used to get successful spawns, while [1:3] provide the different failure cases.  Note that this does not count packets that are not candidates for Direct2Core.  The only candidates for Direct2Core are DRS packets destined for Cbos.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_DIRECT_ATTEMPTS.D2K",
      EventDef::Encoding{.code = 0x12, .umask = 0x02, .umaskExt = 0x00},
      R"(Direct packet attempts : D2K)",
      R"(Direct packet attempts : D2K : Counts the number of DRS packets that we attempted to do direct2core/direct2UPI on.  There are 4 mutually exclusive filters.  Filter [0] can be used to get successful spawns, while [1:3] provide the different failure cases.  Note that this does not count packets that are not candidates for Direct2Core.  The only candidates for Direct2Core are DRS packets destined for Cbos.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1",
      EventDef::Encoding{.code = 0x18, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2",
      EventDef::Encoding{.code = 0x18, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3",
      EventDef::Encoding{.code = 0x18, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2",
      EventDef::Encoding{.code = 0x14, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x14, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3",
      EventDef::Encoding{.code = 0x14, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.BGF_CRD",
      EventDef::Encoding{.code = 0x14, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_M3_BYP_BLOCKED.BGF_CRD)",
      R"(UNC_UPI_M3_BYP_BLOCKED.BGF_CRD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK)",
      R"(UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x15, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH",
      EventDef::Encoding{.code = 0x15, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3",
      EventDef::Encoding{.code = 0x15, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD",
      EventDef::Encoding{.code = 0x15, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK",
      EventDef::Encoding{.code = 0x15, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VNA",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VNA)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VNA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VN0",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN0)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VN1",
      EventDef::Encoding{.code = 0x46, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN1)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.ACK",
      EventDef::Encoding{.code = 0x46, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.ACK)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.ACK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.REQ",
      EventDef::Encoding{.code = 0x05, .umask = 0x08, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Request)",
      R"(Matches on Receive path of a UPI Port : Request : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.REQ_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x08, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Request, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Request, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.SNP",
      EventDef::Encoding{.code = 0x05, .umask = 0x09, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Snoop)",
      R"(Matches on Receive path of a UPI Port : Snoop : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.SNP_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x09, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Snoop, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Snoop, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSP_NODATA",
      EventDef::Encoding{.code = 0x05, .umask = 0x0A, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Response - No Data)",
      R"(Matches on Receive path of a UPI Port : Response - No Data : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSP_NODATA_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x0A, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Response - No Data, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Response - No Data, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSP_DATA",
      EventDef::Encoding{.code = 0x05, .umask = 0x0C, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Response - Data)",
      R"(Matches on Receive path of a UPI Port : Response - Data : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSP_DATA_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x0C, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Response - Data, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Response - Data, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.WB",
      EventDef::Encoding{.code = 0x05, .umask = 0x0D, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Writeback)",
      R"(Matches on Receive path of a UPI Port : Writeback : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.WB_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x0D, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Writeback, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Writeback, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.NCB",
      EventDef::Encoding{.code = 0x05, .umask = 0x0E, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Non-Coherent Bypass)",
      R"(Matches on Receive path of a UPI Port : Non-Coherent Bypass : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.NCB_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x0E, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Non-Coherent Bypass, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Non-Coherent Bypass, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.NCS",
      EventDef::Encoding{.code = 0x05, .umask = 0x0F, .umaskExt = 0x0},
      R"(Matches on Receive path of a UPI Port : Non-Coherent Standard)",
      R"(Matches on Receive path of a UPI Port : Non-Coherent Standard : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.NCS_OPC",
      EventDef::Encoding{.code = 0x05, .umask = 0x0F, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Non-Coherent Standard, Match Opcode)",
      R"(Matches on Receive path of a UPI Port : Non-Coherent Standard, Match Opcode : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSPCNFLT",
      EventDef::Encoding{.code = 0x05, .umask = 0xAA, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Response - Conflict)",
      R"(Matches on Receive path of a UPI Port : Response - Conflict : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BASIC_HDR_MATCH.RSPI",
      EventDef::Encoding{.code = 0x05, .umask = 0x2A, .umaskExt = 0x1},
      R"(Matches on Receive path of a UPI Port : Response - Invalid)",
      R"(Matches on Receive path of a UPI Port : Response - Invalid : Matches on Receive path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BYPASSED.SLOT0",
      EventDef::Encoding{.code = 0x31, .umask = 0x01, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Bypassed : Slot 0)",
      R"(RxQ Flit Buffer Bypassed : Slot 0 : Counts the number of times that an incoming flit was able to bypass the flit buffer and pass directly across the BGF and into the Egress.  This is a latency optimization, and should generally be the common case.  If this value is less than the number of flits transferred, it implies that there was queueing getting onto the ring, and thus the transactions saw higher latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BYPASSED.SLOT1",
      EventDef::Encoding{.code = 0x31, .umask = 0x02, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Bypassed : Slot 1)",
      R"(RxQ Flit Buffer Bypassed : Slot 1 : Counts the number of times that an incoming flit was able to bypass the flit buffer and pass directly across the BGF and into the Egress.  This is a latency optimization, and should generally be the common case.  If this value is less than the number of flits transferred, it implies that there was queueing getting onto the ring, and thus the transactions saw higher latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_BYPASSED.SLOT2",
      EventDef::Encoding{.code = 0x31, .umask = 0x04, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Bypassed : Slot 2)",
      R"(RxQ Flit Buffer Bypassed : Slot 2 : Counts the number of times that an incoming flit was able to bypass the flit buffer and pass directly across the BGF and into the Egress.  This is a latency optimization, and should generally be the common case.  If this value is less than the number of flits transferred, it implies that there was queueing getting onto the ring, and thus the transactions saw higher latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT0",
      EventDef::Encoding{.code = 0x03, .umask = 0x01, .umaskExt = 0x00},
      R"(Valid Flits Received : Slot 0)",
      R"(Valid Flits Received : Slot 0 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 0 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT1",
      EventDef::Encoding{.code = 0x03, .umask = 0x02, .umaskExt = 0x00},
      R"(Valid Flits Received : Slot 1)",
      R"(Valid Flits Received : Slot 1 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 1 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT2",
      EventDef::Encoding{.code = 0x03, .umask = 0x04, .umaskExt = 0x00},
      R"(Valid Flits Received : Slot 2)",
      R"(Valid Flits Received : Slot 2 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 2 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.DATA",
      EventDef::Encoding{.code = 0x03, .umask = 0x08, .umaskExt = 0x00},
      R"(Valid Flits Received : Data)",
      R"(Valid Flits Received : Data : Shows legal flit time (hides impact of L0p and L0c). : Count Data Flits (which consume all slots), but how much to count is based on Slot0-2 mask, so count can be 0-3 depending on which slots are enabled for counting..)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.LLCRD",
      EventDef::Encoding{.code = 0x03, .umask = 0x10, .umaskExt = 0x00},
      R"(Valid Flits Received : LLCRD Not Empty)",
      R"(Valid Flits Received : LLCRD Not Empty : Shows legal flit time (hides impact of L0p and L0c). : Enables counting of LLCRD (with non-zero payload). This only applies to slot 2 since LLCRD is only allowed in slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.NULL",
      EventDef::Encoding{.code = 0x03, .umask = 0x20, .umaskExt = 0x00},
      R"(Valid Flits Received : Slot NULL or LLCRD Empty)",
      R"(Valid Flits Received : Slot NULL or LLCRD Empty : Shows legal flit time (hides impact of L0p and L0c). : LLCRD with all zeros is treated as NULL. Slot 1 is not treated as NULL if slot 0 is a dual slot. This can apply to slot 0,1, or 2.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.LLCTRL",
      EventDef::Encoding{.code = 0x03, .umask = 0x40, .umaskExt = 0x00},
      R"(Valid Flits Received : LLCTRL)",
      R"(Valid Flits Received : LLCTRL : Shows legal flit time (hides impact of L0p and L0c). : Equivalent to an idle packet.  Enables counting of slot 0 LLCTRL messages.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.PROTHDR",
      EventDef::Encoding{.code = 0x03, .umask = 0x80, .umaskExt = 0x00},
      R"(Valid Flits Received : Protocol Header)",
      R"(Valid Flits Received : Protocol Header : Shows legal flit time (hides impact of L0p and L0c). : Enables count of protocol headers in slot 0,1,2 (depending on slot uMask bits))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.IDLE",
      EventDef::Encoding{.code = 0x03, .umask = 0x47, .umaskExt = 0x00},
      R"(Valid Flits Received : Null FLITs received from any slot)",
      R"(Valid Flits Received : Null FLITs received from any slot : Shows legal flit time (hides impact of L0p and L0c).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_INSERTS.SLOT0",
      EventDef::Encoding{.code = 0x30, .umask = 0x01, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Allocations : Slot 0)",
      R"(RxQ Flit Buffer Allocations : Slot 0 : Number of allocations into the UPI Rx Flit Buffer.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_INSERTS.SLOT1",
      EventDef::Encoding{.code = 0x30, .umask = 0x02, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Allocations : Slot 1)",
      R"(RxQ Flit Buffer Allocations : Slot 1 : Number of allocations into the UPI Rx Flit Buffer.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_INSERTS.SLOT2",
      EventDef::Encoding{.code = 0x30, .umask = 0x04, .umaskExt = 0x00},
      R"(RxQ Flit Buffer Allocations : Slot 2)",
      R"(RxQ Flit Buffer Allocations : Slot 2 : Number of allocations into the UPI Rx Flit Buffer.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT0",
      EventDef::Encoding{.code = 0x32, .umask = 0x01, .umaskExt = 0x00},
      R"(RxQ Occupancy - All Packets : Slot 0)",
      R"(RxQ Occupancy - All Packets : Slot 0 : Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT1",
      EventDef::Encoding{.code = 0x32, .umask = 0x02, .umaskExt = 0x00},
      R"(RxQ Occupancy - All Packets : Slot 1)",
      R"(RxQ Occupancy - All Packets : Slot 1 : Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT2",
      EventDef::Encoding{.code = 0x32, .umask = 0x04, .umaskExt = 0x00},
      R"(RxQ Occupancy - All Packets : Slot 2)",
      R"(RxQ Occupancy - All Packets : Slot 2 : Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1",
      EventDef::Encoding{.code = 0x33, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2",
      EventDef::Encoding{.code = 0x33, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0",
      EventDef::Encoding{.code = 0x33, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2",
      EventDef::Encoding{.code = 0x33, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0",
      EventDef::Encoding{.code = 0x33, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1",
      EventDef::Encoding{.code = 0x33, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL",
      EventDef::Encoding{.code = 0x2A, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ",
      EventDef::Encoding{.code = 0x2A, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS",
      EventDef::Encoding{.code = 0x2A, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED",
      EventDef::Encoding{.code = 0x2A, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.TXQ",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.TXQ)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.TXQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RETRY",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RETRY)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RETRY)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.DFX",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.DFX)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.DFX)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.SPARE",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.SPARE)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.SPARE)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.REQ",
      EventDef::Encoding{.code = 0x04, .umask = 0x08, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Request)",
      R"(Matches on Transmit path of a UPI Port : Request : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.REQ_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x08, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Request, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Request, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.SNP",
      EventDef::Encoding{.code = 0x04, .umask = 0x09, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Snoop)",
      R"(Matches on Transmit path of a UPI Port : Snoop : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.SNP_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x09, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Snoop, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Snoop, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSP_NODATA",
      EventDef::Encoding{.code = 0x04, .umask = 0x0A, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Response - No Data)",
      R"(Matches on Transmit path of a UPI Port : Response - No Data : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSP_NODATA_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x0A, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Response - No Data, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Response - No Data, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSP_DATA",
      EventDef::Encoding{.code = 0x04, .umask = 0x0C, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Response - Data)",
      R"(Matches on Transmit path of a UPI Port : Response - Data : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSP_DATA_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x0C, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Response - Data, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Response - Data, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.WB",
      EventDef::Encoding{.code = 0x04, .umask = 0x0D, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Writeback)",
      R"(Matches on Transmit path of a UPI Port : Writeback : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.WB_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x0D, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Writeback, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Writeback, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.NCB",
      EventDef::Encoding{.code = 0x04, .umask = 0x0E, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Bypass)",
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Bypass : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.NCB_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x0E, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Bypass, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Bypass, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.NCS",
      EventDef::Encoding{.code = 0x04, .umask = 0x0F, .umaskExt = 0x0},
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Standard)",
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Standard : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.NCS_OPC",
      EventDef::Encoding{.code = 0x04, .umask = 0x0F, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Standard, Match Opcode)",
      R"(Matches on Transmit path of a UPI Port : Non-Coherent Standard, Match Opcode : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSPCNFLT",
      EventDef::Encoding{.code = 0x04, .umask = 0xAA, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Response - Conflict)",
      R"(Matches on Transmit path of a UPI Port : Response - Conflict : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_BASIC_HDR_MATCH.RSPI",
      EventDef::Encoding{.code = 0x04, .umask = 0x2A, .umaskExt = 0x1},
      R"(Matches on Transmit path of a UPI Port : Response - Invalid)",
      R"(Matches on Transmit path of a UPI Port : Response - Invalid : Matches on Transmit path of a UPI port. Match based on UMask specific bits: Z: Message Class (3-bit) Y: Message Class Enable W: Opcode (4-bit) V: Opcode Enable U: Local Enable T: Remote Enable S: Data Hdr Enable R: Non-Data Hdr Enable Q: Dual Slot Hdr Enable P: Single Slot Hdr Enable Link Layer control types are excluded (LL CTRL, slot NULL, LLCRD) even under specific opcode match_en cases. Note: If Message Class is disabled, we expect opcode to also be disabled.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT0",
      EventDef::Encoding{.code = 0x02, .umask = 0x01, .umaskExt = 0x00},
      R"(Valid Flits Sent : Slot 0)",
      R"(Valid Flits Sent : Slot 0 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 0 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT1",
      EventDef::Encoding{.code = 0x02, .umask = 0x02, .umaskExt = 0x00},
      R"(Valid Flits Sent : Slot 1)",
      R"(Valid Flits Sent : Slot 1 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 1 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT2",
      EventDef::Encoding{.code = 0x02, .umask = 0x04, .umaskExt = 0x00},
      R"(Valid Flits Sent : Slot 2)",
      R"(Valid Flits Sent : Slot 2 : Shows legal flit time (hides impact of L0p and L0c). : Count Slot 2 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.DATA",
      EventDef::Encoding{.code = 0x02, .umask = 0x08, .umaskExt = 0x00},
      R"(Valid Flits Sent : Data)",
      R"(Valid Flits Sent : Data : Shows legal flit time (hides impact of L0p and L0c). : Count Data Flits (which consume all slots), but how much to count is based on Slot0-2 mask, so count can be 0-3 depending on which slots are enabled for counting..)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.LLCRD",
      EventDef::Encoding{.code = 0x02, .umask = 0x10, .umaskExt = 0x00},
      R"(Valid Flits Sent : LLCRD Not Empty)",
      R"(Valid Flits Sent : LLCRD Not Empty : Shows legal flit time (hides impact of L0p and L0c). : Enables counting of LLCRD (with non-zero payload). This only applies to slot 2 since LLCRD is only allowed in slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.NULL",
      EventDef::Encoding{.code = 0x02, .umask = 0x20, .umaskExt = 0x00},
      R"(Valid Flits Sent : Slot NULL or LLCRD Empty)",
      R"(Valid Flits Sent : Slot NULL or LLCRD Empty : Shows legal flit time (hides impact of L0p and L0c). : LLCRD with all zeros is treated as NULL. Slot 1 is not treated as NULL if slot 0 is a dual slot. This can apply to slot 0,1, or 2.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.LLCTRL",
      EventDef::Encoding{.code = 0x02, .umask = 0x40, .umaskExt = 0x00},
      R"(Valid Flits Sent : LLCTRL)",
      R"(Valid Flits Sent : LLCTRL : Shows legal flit time (hides impact of L0p and L0c). : Equivalent to an idle packet.  Enables counting of slot 0 LLCTRL messages.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.PROTHDR",
      EventDef::Encoding{.code = 0x02, .umask = 0x80, .umaskExt = 0x00},
      R"(Valid Flits Sent : Protocol Header)",
      R"(Valid Flits Sent : Protocol Header : Shows legal flit time (hides impact of L0p and L0c). : Enables count of protocol headers in slot 0,1,2 (depending on slot uMask bits))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.IDLE",
      EventDef::Encoding{.code = 0x02, .umask = 0x47, .umaskExt = 0x00},
      R"(Valid Flits Sent : Idle)",
      R"(Valid Flits Sent : Idle : Shows legal flit time (hides impact of L0p and L0c).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_ACT_COUNT.BYP",
      EventDef::Encoding{.code = 0x01, .umask = 0x08, .umaskExt = 0x00},
      R"(DRAM Activate Count : Activate due to Bypass)",
      R"(DRAM Activate Count : Activate due to Bypass : Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_PRE_REG",
      EventDef::Encoding{.code = 0x04, .umask = 0x02, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS commands w/auto-pre)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS commands w/auto-pre : DRAM RD_CAS and WR_CAS Commands : Counts the total number or DRAM Read CAS commands issued on this channel.  This includes both regular RD CAS commands as well as those with explicit Precharge.  AutoPre is only used in systems that are using closed page policy.  We do not filter based on major mode, as RD_CAS is not issued during WMM (with the exception of underfills).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_PRE_UNDERFILL",
      EventDef::Encoding{.code = 0x04, .umask = 0x08, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands.)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS and WR_CAS Commands)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.WR_PRE",
      EventDef::Encoding{.code = 0x04, .umask = 0x20, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM WR_CAS commands w/ auto-pre)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM WR_CAS commands w/ auto-pre : DRAM RD_CAS and WR_CAS Commands)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_0",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_1",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_2",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_3",
      EventDef::Encoding{.code = 0x47, .umask = 0x08, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CRIT_THROTTLE_CYCLES.SLOT0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1. : Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CRIT_THROTTLE_CYCLES.SLOT1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.SLOT0",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1. : Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.SLOT1",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_NE.PCH0",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(Read Pending Queue Not Empty)",
      R"(Read Pending Queue Not Empty : Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_NE.PCH1",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(Read Pending Queue Not Empty)",
      R"(Read Pending Queue Not Empty : Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.RD_ACCEPTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x01, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Read Accepts)",
      R"(Scoreboard Accesses : Read Accepts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.RD_REJECTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x02, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Read Rejects)",
      R"(Scoreboard Accesses : Read Rejects)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.WR_ACCEPTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x04, .umaskExt = 0x00},
      R"(Scoreboard Accesses : NM read completions)",
      R"(Scoreboard Accesses : NM read completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.WR_REJECTS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x08, .umaskExt = 0x00},
      R"(Scoreboard Accesses : NM write completions)",
      R"(Scoreboard Accesses : NM write completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.NM_RD_CMPS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x10, .umaskExt = 0x00},
      R"(Scoreboard Accesses : FM read completions)",
      R"(Scoreboard Accesses : FM read completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.NM_WR_CMPS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x20, .umaskExt = 0x00},
      R"(Scoreboard Accesses : FM write completions)",
      R"(Scoreboard Accesses : FM write completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.FM_RD_CMPS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x40, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Write Accepts)",
      R"(Scoreboard Accesses : Write Accepts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_ACCESSES.FM_WR_CMPS",
      EventDef::Encoding{.code = 0xD2, .umask = 0x80, .umaskExt = 0x00},
      R"(Scoreboard Accesses : Write Rejects)",
      R"(Scoreboard Accesses : Write Rejects)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_CANARY.ALLOC",
      EventDef::Encoding{.code = 0xD9, .umask = 0x01, .umaskExt = 0x00},
      R"(: Alloc)",
      R"(: Alloc)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_CANARY.DEALLOC",
      EventDef::Encoding{.code = 0xD9, .umask = 0x02, .umaskExt = 0x00},
      R"(: Dealloc)",
      R"(: Dealloc)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_CANARY.VLD",
      EventDef::Encoding{.code = 0xD9, .umask = 0x04, .umaskExt = 0x00},
      R"(: Reject)",
      R"(: Reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_INSERTS.RDS",
      EventDef::Encoding{.code = 0xD6, .umask = 0x01, .umaskExt = 0x00},
      R"(Scoreboard Inserts : Reads)",
      R"(Scoreboard Inserts : Reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_INSERTS.WRS",
      EventDef::Encoding{.code = 0xD6, .umask = 0x02, .umaskExt = 0x00},
      R"(Scoreboard Inserts : Writes)",
      R"(Scoreboard Inserts : Writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_INSERTS.BLOCK_RDS",
      EventDef::Encoding{.code = 0xD6, .umask = 0x10, .umaskExt = 0x00},
      R"(Scoreboard Inserts : Block region reads)",
      R"(Scoreboard Inserts : Block region reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_INSERTS.BLOCK_WRS",
      EventDef::Encoding{.code = 0xD6, .umask = 0x20, .umaskExt = 0x00},
      R"(Scoreboard Inserts : Block region writes)",
      R"(Scoreboard Inserts : Block region writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_OCCUPANCY.RDS",
      EventDef::Encoding{.code = 0xD5, .umask = 0x01, .umaskExt = 0x00},
      R"(Scoreboard Occupancy : Reads)",
      R"(Scoreboard Occupancy : Reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_OCCUPANCY.BLOCK_RDS",
      EventDef::Encoding{.code = 0xD5, .umask = 0x20, .umaskExt = 0x00},
      R"(Scoreboard Occupancy : Block region reads)",
      R"(Scoreboard Occupancy : Block region reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_OCCUPANCY.BLOCK_WRS",
      EventDef::Encoding{.code = 0xD5, .umask = 0x40, .umaskExt = 0x00},
      R"(Scoreboard Occupancy : Block region writes)",
      R"(Scoreboard Occupancy : Block region writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_REJECT.NM_SET_CNFLT",
      EventDef::Encoding{.code = 0xD4, .umask = 0x01, .umaskExt = 0x00},
      R"(Number of Scoreboard Requests Rejected : NM requests rejected due to set conflict)",
      R"(Number of Scoreboard Requests Rejected : NM requests rejected due to set conflict)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_REJECT.FM_ADDR_CNFLT",
      EventDef::Encoding{.code = 0xD4, .umask = 0x02, .umaskExt = 0x00},
      R"(Number of Scoreboard Requests Rejected : FM requests rejected due to full address conflict)",
      R"(Number of Scoreboard Requests Rejected : FM requests rejected due to full address conflict)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_REJECT.PATROL_SET_CNFLT",
      EventDef::Encoding{.code = 0xD4, .umask = 0x04, .umaskExt = 0x00},
      R"(Number of Scoreboard Requests Rejected : Patrol requests rejected due to set conflict)",
      R"(Number of Scoreboard Requests Rejected : Patrol requests rejected due to set conflict)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_REJECT.CANARY",
      EventDef::Encoding{.code = 0xD4, .umask = 0x08, .umaskExt = 0x00},
      R"(Number of Scoreboard Requests Rejected)",
      R"(Number of Scoreboard Requests Rejected)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_TAGGED.NEW",
      EventDef::Encoding{.code = 0xDD, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M_SB_TAGGED.NEW)",
      R"(UNC_M_SB_TAGGED.NEW)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_TAGGED.RD_HIT",
      EventDef::Encoding{.code = 0xDD, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M_SB_TAGGED.RD_HIT)",
      R"(UNC_M_SB_TAGGED.RD_HIT)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_TAGGED.RD_MISS",
      EventDef::Encoding{.code = 0xDD, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M_SB_TAGGED.RD_MISS)",
      R"(UNC_M_SB_TAGGED.RD_MISS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_TAGGED.DDR4_CMP",
      EventDef::Encoding{.code = 0xDD, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M_SB_TAGGED.DDR4_CMP)",
      R"(UNC_M_SB_TAGGED.DDR4_CMP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_SB_TAGGED.OCC",
      EventDef::Encoding{.code = 0xDD, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_M_SB_TAGGED.OCC)",
      R"(UNC_M_SB_TAGGED.OCC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_NE.PCH0",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue Not Empty)",
      R"(Write Pending Queue Not Empty : Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the CHA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have posted to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_NE.PCH1",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue Not Empty)",
      R"(Write Pending Queue Not Empty : Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the CHA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have posted to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_READ_HIT.PCH0",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_READ_HIT.PCH1",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_WRITE_HIT.PCH0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_WRITE_HIT.PCH1",
      EventDef::Encoding{.code = 0x24, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.I",
      EventDef::Encoding{.code = 0x34, .umask = 0x01, .umaskExt = 0x00},
      R"(Cache Lookups : I State)",
      R"(Cache Lookups : I State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_S",
      EventDef::Encoding{.code = 0x34, .umask = 0x02, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - S State)",
      R"(Cache Lookups : SnoopFilter - S State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit Shared State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_E",
      EventDef::Encoding{.code = 0x34, .umask = 0x04, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - E State)",
      R"(Cache Lookups : SnoopFilter - E State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit Exclusive State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_H",
      EventDef::Encoding{.code = 0x34, .umask = 0x08, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - H State)",
      R"(Cache Lookups : SnoopFilter - H State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit HitMe State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.S",
      EventDef::Encoding{.code = 0x34, .umask = 0x10, .umaskExt = 0x00},
      R"(Cache Lookups : S State)",
      R"(Cache Lookups : S State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Shared State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.E",
      EventDef::Encoding{.code = 0x34, .umask = 0x20, .umaskExt = 0x00},
      R"(Cache Lookups : E State)",
      R"(Cache Lookups : E State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Exclusive State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.M",
      EventDef::Encoding{.code = 0x34, .umask = 0x40, .umaskExt = 0x00},
      R"(Cache Lookups : M State)",
      R"(Cache Lookups : M State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Modified State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.F",
      EventDef::Encoding{.code = 0x34, .umask = 0x80, .umaskExt = 0x00},
      R"(Cache Lookups : F State)",
      R"(Cache Lookups : F State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Forward State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.RFO",
      EventDef::Encoding{.code = 0x34, .umask = 0xFF, .umaskExt = 0x1BC8},
      R"(Cache Lookups : RFO Requests)",
      R"(Cache Lookups : RFO Requests : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing. : Local or remote RFO transactions to the LLC.  This includes RFO prefetch.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IRQ_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .umaskExt = 0x00},
      R"(TOR Inserts : IRQ - iA)",
      R"(TOR Inserts : IRQ - iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : From an iA Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.EVICT",
      EventDef::Encoding{.code = 0x35, .umask = 0x02, .umaskExt = 0x00},
      R"(TOR Inserts : SF/LLC Evictions)",
      R"(TOR Inserts : SF/LLC Evictions : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PRQ_IOSF",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0x00},
      R"(TOR Inserts : PRQ - IOSF)",
      R"(TOR Inserts : PRQ - IOSF : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : From a PCIe Device)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IPQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x08, .umaskExt = 0x00},
      R"(TOR Inserts : IPQ)",
      R"(TOR Inserts : IPQ : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IRQ_NON_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x10, .umaskExt = 0x00},
      R"(TOR Inserts : IRQ - Non iA)",
      R"(TOR Inserts : IRQ - Non iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PRQ_NON_IOSF",
      EventDef::Encoding{.code = 0x35, .umask = 0x20, .umaskExt = 0x00},
      R"(TOR Inserts : PRQ - Non IOSF)",
      R"(TOR Inserts : PRQ - Non IOSF : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.RRQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x40, .umaskExt = 0x00},
      R"(TOR Inserts : RRQ)",
      R"(TOR Inserts : RRQ : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.WBQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x80, .umaskExt = 0x00},
      R"(TOR Inserts : WBQ)",
      R"(TOR Inserts : WBQ : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_IO",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local IO)",
      R"(TOR Inserts : All from Local IO : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local iA)",
      R"(TOR Inserts : All from Local iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally initiated requests from iA Cores)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_ALL",
      EventDef::Encoding{.code = 0x35, .umask = 0x05, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local iA and IO)",
      R"(TOR Inserts : All from Local iA and IO : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally initiated requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.HIT",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x01},
      R"(TOR Inserts : Just Hits)",
      R"(TOR Inserts : Just Hits : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MISS",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x02},
      R"(TOR Inserts : Just Misses)",
      R"(TOR Inserts : Just Misses : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MMCFG",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x20},
      R"(TOR Inserts : MMCFG Access)",
      R"(TOR Inserts : MMCFG Access : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOCAL_TGT",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x80},
      R"(TOR Inserts : Just Local Targets)",
      R"(TOR Inserts : Just Local Targets : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.REMOTE_TGT",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x100},
      R"(TOR Inserts : Just Remote Targets)",
      R"(TOR Inserts : Just Remote Targets : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MATCH_OPC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x200},
      R"(TOR Inserts : Match the Opcode in b[29:19] of the extended umask field)",
      R"(TOR Inserts : Match the Opcode in b[29:19] of the extended umask field : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PREMORPH_OPC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x400},
      R"(TOR Inserts : Match the PreMorphed Opcode in b[29:19] of the extended umask field)",
      R"(TOR Inserts : Match the PreMorphed Opcode in b[29:19] of the extended umask field : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NEARMEM",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x400000},
      R"(TOR Inserts : Just NearMem)",
      R"(TOR Inserts : Just NearMem : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NOT_NEARMEM",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x800000},
      R"(TOR Inserts : Just NotNearMem)",
      R"(TOR Inserts : Just NotNearMem : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NONCOH",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x1000000},
      R"(TOR Inserts : Just NonCoherent)",
      R"(TOR Inserts : Just NonCoherent : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ISOC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x2000000},
      R"(TOR Inserts : Just ISOC)",
      R"(TOR Inserts : Just ISOC : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IRQ_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0x00},
      R"(TOR Occupancy : IRQ - iA)",
      R"(TOR Occupancy : IRQ - iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : From an iA Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.EVICT",
      EventDef::Encoding{.code = 0x36, .umask = 0x02, .umaskExt = 0x00},
      R"(TOR Occupancy : SF/LLC Evictions)",
      R"(TOR Occupancy : SF/LLC Evictions : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PRQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0x00},
      R"(TOR Occupancy : PRQ - IOSF)",
      R"(TOR Occupancy : PRQ - IOSF : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : From a PCIe Device)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IPQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x08, .umaskExt = 0x00},
      R"(TOR Occupancy : IPQ)",
      R"(TOR Occupancy : IPQ : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IRQ_NON_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x10, .umaskExt = 0x00},
      R"(TOR Occupancy : IRQ - Non iA)",
      R"(TOR Occupancy : IRQ - Non iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PRQ_NON_IOSF",
      EventDef::Encoding{.code = 0x36, .umask = 0x20, .umaskExt = 0x00},
      R"(TOR Occupancy : PRQ - Non IOSF)",
      R"(TOR Occupancy : PRQ - Non IOSF : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_IO",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local IO)",
      R"(TOR Occupancy : All from Local IO : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local iA)",
      R"(TOR Occupancy : All from Local iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally initiated requests from iA Cores)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_ALL",
      EventDef::Encoding{.code = 0x36, .umask = 0x05, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local iA and IO)",
      R"(TOR Occupancy : All from Local iA and IO : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally initiated requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.HIT",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x01},
      R"(TOR Occupancy : Just Hits)",
      R"(TOR Occupancy : Just Hits : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MISS",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x02},
      R"(TOR Occupancy : Just Misses)",
      R"(TOR Occupancy : Just Misses : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MMCFG",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x20},
      R"(TOR Occupancy : MMCFG Access)",
      R"(TOR Occupancy : MMCFG Access : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOCAL_TGT",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x80},
      R"(TOR Occupancy : Just Local Targets)",
      R"(TOR Occupancy : Just Local Targets : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.REMOTE_TGT",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x100},
      R"(TOR Occupancy : Just Remote Targets)",
      R"(TOR Occupancy : Just Remote Targets : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MATCH_OPC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x200},
      R"(TOR Occupancy : Match the Opcode in b[29:19] of the extended umask field)",
      R"(TOR Occupancy : Match the Opcode in b[29:19] of the extended umask field : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PREMORPH_OPC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x400},
      R"(TOR Occupancy : Match the PreMorphed Opcode in b[29:19] of the extended umask field)",
      R"(TOR Occupancy : Match the PreMorphed Opcode in b[29:19] of the extended umask field : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NEARMEM",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x400000},
      R"(TOR Occupancy : Just NearMem)",
      R"(TOR Occupancy : Just NearMem : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NOT_NEARMEM",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x800000},
      R"(TOR Occupancy : Just NotNearMem)",
      R"(TOR Occupancy : Just NotNearMem : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NONCOH",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x1000000},
      R"(TOR Occupancy : Just NonCoherent)",
      R"(TOR Occupancy : Just NonCoherent : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.ISOC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x2000000},
      R"(TOR Occupancy : Just ISOC)",
      R"(TOR Occupancy : Just ISOC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's MMIO space)",
      R"(Data requested by the CPU : Core writing to Card's MMIO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's MMIO space)",
      R"(Data requested by the CPU : Core writing to Card's MMIO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM)",
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM)",
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card writing to DRAM)",
      R"(Data requested of the CPU : Card writing to DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card writing to DRAM)",
      R"(Data requested of the CPU : Card writing to DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card reading from DRAM)",
      R"(Data requested of the CPU : Card reading from DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card reading from DRAM)",
      R"(Data requested of the CPU : Card reading from DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.CMPD.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.CMPD.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to DRAM)",
      R"(Number Transactions requested of the CPU : Card writing to DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to DRAM)",
      R"(Number Transactions requested of the CPU : Card writing to DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from DRAM)",
      R"(Number Transactions requested of the CPU : Card reading from DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from DRAM)",
      R"(Number Transactions requested of the CPU : Card reading from DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.CMPD.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.CMPD.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_NI_MISS",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x20},
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch0)",
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_NI_MISS",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x0C},
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch1)",
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL.CH0",
      EventDef::Encoding{.code = 0x6B, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Full : Channel 0)",
      R"(Prefetch CAM Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL.CH1",
      EventDef::Encoding{.code = 0x6B, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Full : Channel 1)",
      R"(Prefetch CAM Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL.CH2",
      EventDef::Encoding{.code = 0x6B, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Full : Channel 2)",
      R"(Prefetch CAM Cycles Full : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE.CH0",
      EventDef::Encoding{.code = 0x6C, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Not Empty : Channel 0)",
      R"(Prefetch CAM Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE.CH1",
      EventDef::Encoding{.code = 0x6C, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Not Empty : Channel 1)",
      R"(Prefetch CAM Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE.CH2",
      EventDef::Encoding{.code = 0x6C, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Not Empty : Channel 2)",
      R"(Prefetch CAM Cycles Not Empty : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_HITA0_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_HITA1_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_MISS_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_RSP_PDRESET",
      EventDef::Encoding{.code = 0x6E, .umask = 0x08, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_HITA0_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x10, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_HITA1_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x20, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_MISS_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x40, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_RSP_PDRESET",
      EventDef::Encoding{.code = 0x6E, .umask = 0x80, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH2_HITA0_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x00, .umaskExt = 0x01},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH2_HITA1_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x00, .umaskExt = 0x02},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH2_MISS_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x00, .umaskExt = 0x04},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH2_RSP_PDRESET",
      EventDef::Encoding{.code = 0x6E, .umask = 0x00, .umaskExt = 0x08},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH0_XPT",
      EventDef::Encoding{.code = 0x6F, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : XPT - Ch 0)",
      R"(Data Prefetches Dropped : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH0_UPI",
      EventDef::Encoding{.code = 0x6F, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : UPI - Ch 0)",
      R"(Data Prefetches Dropped : UPI - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH1_XPT",
      EventDef::Encoding{.code = 0x6F, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : XPT - Ch 1)",
      R"(Data Prefetches Dropped : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH1_UPI",
      EventDef::Encoding{.code = 0x6F, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : UPI - Ch 1)",
      R"(Data Prefetches Dropped : UPI - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH2_XPT",
      EventDef::Encoding{.code = 0x6F, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : XPT - Ch 2)",
      R"(Data Prefetches Dropped : XPT - Ch 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH2_UPI",
      EventDef::Encoding{.code = 0x6F, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : UPI - Ch 2)",
      R"(Data Prefetches Dropped : UPI - Ch 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_SECURE_DROP",
      EventDef::Encoding{.code = 0x70, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.NOT_PF_SAD_REGION",
      EventDef::Encoding{.code = 0x70, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_CAM_HIT",
      EventDef::Encoding{.code = 0x70, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.STOP_B2B",
      EventDef::Encoding{.code = 0x70, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.ERRORBLK_RxC",
      EventDef::Encoding{.code = 0x70, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_AD_CRD",
      EventDef::Encoding{.code = 0x70, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_CAM_FULL",
      EventDef::Encoding{.code = 0x70, .umask = 0x40, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.WPQ_PROXY",
      EventDef::Encoding{.code = 0x70, .umask = 0x80, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.RPQ_PROXY",
      EventDef::Encoding{.code = 0x70, .umask = 0x00, .umaskExt = 0x01},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.XPT_THRESH",
      EventDef::Encoding{.code = 0x70, .umask = 0x00, .umaskExt = 0x02},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.UPI_THRESH",
      EventDef::Encoding{.code = 0x70, .umask = 0x00, .umaskExt = 0x04},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_SECURE_DROP",
      EventDef::Encoding{.code = 0x71, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.NOT_PF_SAD_REGION",
      EventDef::Encoding{.code = 0x71, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_CAM_HIT",
      EventDef::Encoding{.code = 0x71, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.STOP_B2B",
      EventDef::Encoding{.code = 0x71, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.ERRORBLK_RxC",
      EventDef::Encoding{.code = 0x71, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_AD_CRD",
      EventDef::Encoding{.code = 0x71, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_CAM_FULL",
      EventDef::Encoding{.code = 0x71, .umask = 0x40, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.WPQ_PROXY",
      EventDef::Encoding{.code = 0x71, .umask = 0x80, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.RPQ_PROXY",
      EventDef::Encoding{.code = 0x71, .umask = 0x00, .umaskExt = 0x01},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.XPT_THRESH",
      EventDef::Encoding{.code = 0x71, .umask = 0x00, .umaskExt = 0x02},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.UPI_THRESH",
      EventDef::Encoding{.code = 0x71, .umask = 0x00, .umaskExt = 0x04},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.PF_SECURE_DROP",
      EventDef::Encoding{.code = 0x72, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.NOT_PF_SAD_REGION",
      EventDef::Encoding{.code = 0x72, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.PF_CAM_HIT",
      EventDef::Encoding{.code = 0x72, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.STOP_B2B",
      EventDef::Encoding{.code = 0x72, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.ERRORBLK_RxC",
      EventDef::Encoding{.code = 0x72, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.PF_AD_CRD",
      EventDef::Encoding{.code = 0x72, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.PF_CAM_FULL",
      EventDef::Encoding{.code = 0x72, .umask = 0x40, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.WPQ_PROXY",
      EventDef::Encoding{.code = 0x72, .umask = 0x80, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.RPQ_PROXY",
      EventDef::Encoding{.code = 0x72, .umask = 0x00, .umaskExt = 0x01},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.XPT_THRESH",
      EventDef::Encoding{.code = 0x72, .umask = 0x00, .umaskExt = 0x02},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH2.UPI_THRESH",
      EventDef::Encoding{.code = 0x72, .umask = 0x00, .umaskExt = 0x04},
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      R"(Data Prefetches Dropped Ch2 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH0_XPT",
      EventDef::Encoding{.code = 0x6D, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : XPT - Ch 0)",
      R"(Prefetch CAM Inserts : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH0_UPI",
      EventDef::Encoding{.code = 0x6D, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : UPI - Ch 0)",
      R"(Prefetch CAM Inserts : UPI - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH1_XPT",
      EventDef::Encoding{.code = 0x6D, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : XPT - Ch 1)",
      R"(Prefetch CAM Inserts : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH1_UPI",
      EventDef::Encoding{.code = 0x6D, .umask = 0x08, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : UPI - Ch 1)",
      R"(Prefetch CAM Inserts : UPI - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH2_XPT",
      EventDef::Encoding{.code = 0x6D, .umask = 0x10, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : XPT - Ch 2)",
      R"(Prefetch CAM Inserts : XPT - Ch 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH2_UPI",
      EventDef::Encoding{.code = 0x6D, .umask = 0x20, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : UPI - Ch 2)",
      R"(Prefetch CAM Inserts : UPI - Ch 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x6A, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Occupancy : Channel 0)",
      R"(Prefetch CAM Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x6A, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Occupancy : Channel 1)",
      R"(Prefetch CAM Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x6A, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Occupancy : Channel 2)",
      R"(Prefetch CAM Occupancy : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RESP_MISS.CH0",
      EventDef::Encoding{.code = 0x76, .umask = 0x01, .umaskExt = 0x00},
      R"(: Channel 0)",
      R"(: Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RESP_MISS.CH1",
      EventDef::Encoding{.code = 0x76, .umask = 0x02, .umaskExt = 0x00},
      R"(: Channel 1)",
      R"(: Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RESP_MISS.CH2",
      EventDef::Encoding{.code = 0x76, .umask = 0x04, .umaskExt = 0x00},
      R"(: Channel 2)",
      R"(: Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED",
      EventDef::Encoding{.code = 0x7A, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED",
      EventDef::Encoding{.code = 0x7A, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS",
      EventDef::Encoding{.code = 0x7A, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR_NONTGR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x10, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty)",
      R"(Write Tracker Cycles Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR_PWR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x20, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty)",
      R"(Write Tracker Cycles Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR_NONTGR",
      EventDef::Encoding{.code = 0x55, .umask = 0x10, .umaskExt = 0x00},
      R"(Write Tracker Occupancy)",
      R"(Write Tracker Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR_PWR",
      EventDef::Encoding{.code = 0x55, .umask = 0x20, .umaskExt = 0x00},
      R"(Write Tracker Occupancy)",
      R"(Write Tracker Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x40, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x80, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x47, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF0_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF0_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF1_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF1_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x08, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF2_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF2_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF3_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF3_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF4_NCB",
      EventDef::Encoding{.code = 0x1a, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF4_NCS",
      EventDef::Encoding{.code = 0x1a, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF5_NCB",
      EventDef::Encoding{.code = 0x1a, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF5_NCS",
      EventDef::Encoding{.code = 0x1a, .umask = 0x08, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent0)",
      R"(Local P2P Shared Credits Returned : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent1)",
      R"(Local P2P Shared Credits Returned : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x17, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent2)",
      R"(Local P2P Shared Credits Returned : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x44, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent0)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x44, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent1)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x44, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent2)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_3",
      EventDef::Encoding{.code = 0x44, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent3)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_4",
      EventDef::Encoding{.code = 0x44, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent4)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_5",
      EventDef::Encoding{.code = 0x44, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent5)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x40, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x80, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x41, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x41, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x41, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x41, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x01, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x02, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x04, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x08, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x10, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x20, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x40, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x80, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x4b, .umask = 0x01, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x4b, .umask = 0x02, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x4b, .umask = 0x04, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x4b, .umask = 0x08, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.LOCAL_NCB",
      EventDef::Encoding{.code = 0x14, .umask = 0x01, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Local NCB)",
      R"(P2P Credit Occupancy : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.LOCAL_NCS",
      EventDef::Encoding{.code = 0x14, .umask = 0x02, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Local NCS)",
      R"(P2P Credit Occupancy : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.REMOTE_NCB",
      EventDef::Encoding{.code = 0x14, .umask = 0x04, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Remote NCB)",
      R"(P2P Credit Occupancy : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.REMOTE_NCS",
      EventDef::Encoding{.code = 0x14, .umask = 0x08, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Remote NCS)",
      R"(P2P Credit Occupancy : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.ALL",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : All)",
      R"(P2P Credit Occupancy : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.LOCAL_NCB",
      EventDef::Encoding{.code = 0x16, .umask = 0x01, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Local NCB)",
      R"(Dedicated Credits Received : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.LOCAL_NCS",
      EventDef::Encoding{.code = 0x16, .umask = 0x02, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Local NCS)",
      R"(Dedicated Credits Received : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.REMOTE_NCB",
      EventDef::Encoding{.code = 0x16, .umask = 0x04, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Remote NCB)",
      R"(Dedicated Credits Received : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.REMOTE_NCS",
      EventDef::Encoding{.code = 0x16, .umask = 0x08, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Remote NCS)",
      R"(Dedicated Credits Received : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.ALL",
      EventDef::Encoding{.code = 0x16, .umask = 0x10, .umaskExt = 0x00},
      R"(Dedicated Credits Received : All)",
      R"(Dedicated Credits Received : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.LOCAL_NCB",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .umaskExt = 0x00},
      R"(Shared Credits  Received : Local NCB)",
      R"(Shared Credits  Received : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.LOCAL_NCS",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .umaskExt = 0x00},
      R"(Shared Credits  Received : Local NCS)",
      R"(Shared Credits  Received : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.REMOTE_NCB",
      EventDef::Encoding{.code = 0x15, .umask = 0x04, .umaskExt = 0x00},
      R"(Shared Credits  Received : Remote NCB)",
      R"(Shared Credits  Received : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.REMOTE_NCS",
      EventDef::Encoding{.code = 0x15, .umask = 0x08, .umaskExt = 0x00},
      R"(Shared Credits  Received : Remote NCS)",
      R"(Shared Credits  Received : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.ALL",
      EventDef::Encoding{.code = 0x15, .umask = 0x10, .umaskExt = 0x00},
      R"(Shared Credits  Received : All)",
      R"(Shared Credits  Received : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI0_DRS",
      EventDef::Encoding{.code = 0x48, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - DRS)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - DRS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI0_NCB",
      EventDef::Encoding{.code = 0x48, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - NCB)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI0_NCS",
      EventDef::Encoding{.code = 0x48, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - NCS)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI1_DRS",
      EventDef::Encoding{.code = 0x48, .umask = 0x08, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - DRS)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - DRS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI1_NCB",
      EventDef::Encoding{.code = 0x48, .umask = 0x10, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - NCB)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0.UPI1_NCS",
      EventDef::Encoding{.code = 0x48, .umask = 0x20, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - NCS)",
      R"(Remote Dedicated P2P Credit Taken - 0 : UPI1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_1.UPI2_DRS",
      EventDef::Encoding{.code = 0x49, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - DRS)",
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - DRS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_1.UPI2_NCB",
      EventDef::Encoding{.code = 0x49, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - NCB)",
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_1.UPI2_NCS",
      EventDef::Encoding{.code = 0x49, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - NCS)",
      R"(Remote Dedicated P2P Credit Taken - 1 : UPI2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI0_NCB",
      EventDef::Encoding{.code = 0x1b, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI0 - NCB)",
      R"(Remote P2P Dedicated Credits Returned : UPI0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI0_NCS",
      EventDef::Encoding{.code = 0x1b, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI0 - NCS)",
      R"(Remote P2P Dedicated Credits Returned : UPI0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI1_NCB",
      EventDef::Encoding{.code = 0x1b, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI1 - NCB)",
      R"(Remote P2P Dedicated Credits Returned : UPI1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI1_NCS",
      EventDef::Encoding{.code = 0x1b, .umask = 0x08, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI1 - NCS)",
      R"(Remote P2P Dedicated Credits Returned : UPI1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI2_NCB",
      EventDef::Encoding{.code = 0x1b, .umask = 0x10, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI2 - NCB)",
      R"(Remote P2P Dedicated Credits Returned : UPI2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_DED_RETURNED.UPI2_NCS",
      EventDef::Encoding{.code = 0x1b, .umask = 0x20, .umaskExt = 0x00},
      R"(Remote P2P Dedicated Credits Returned : UPI2 - NCS)",
      R"(Remote P2P Dedicated Credits Returned : UPI2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent0)",
      R"(Remote P2P Shared Credits Returned : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent1)",
      R"(Remote P2P Shared Credits Returned : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent2)",
      R"(Remote P2P Shared Credits Returned : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent0)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x45, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent1)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x45, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent2)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_TAKEN_0.UPI0_DRS",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - DRS)",
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - DRS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_TAKEN_0.UPI0_NCB",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - NCB)",
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_TAKEN_0.UPI0_NCS",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - NCS)",
      R"(Remote Shared P2P Credit Taken - 0 : UPI0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      Event