/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.profiles;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.asamk.signal.manager.storage.profiles.LegacySignalProfile;
import org.asamk.signal.manager.storage.profiles.LegacySignalProfileEntry;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.push.ServiceId;

public class LegacyProfileStore {
    private static final ObjectMapper jsonProcessor = new ObjectMapper();
    @JsonProperty(value="profiles")
    @JsonDeserialize(using=ProfileStoreDeserializer.class)
    private final List<LegacySignalProfileEntry> profiles = new ArrayList<LegacySignalProfileEntry>();

    public List<LegacySignalProfileEntry> getProfileEntries() {
        return this.profiles;
    }

    public static class ProfileStoreDeserializer
    extends JsonDeserializer<List<LegacySignalProfileEntry>> {
        public List<LegacySignalProfileEntry> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            ArrayList<LegacySignalProfileEntry> profileEntries = new ArrayList<LegacySignalProfileEntry>();
            if (node.isArray()) {
                for (JsonNode entry : node) {
                    String name = entry.hasNonNull("name") ? entry.get("name").asText() : null;
                    ServiceId.ACI serviceId = entry.hasNonNull("uuid") ? ServiceId.ACI.parseOrNull((String)entry.get("uuid").asText()) : null;
                    RecipientAddress address = new RecipientAddress(serviceId, name);
                    ProfileKey profileKey = null;
                    try {
                        profileKey = new ProfileKey(Base64.getDecoder().decode(entry.get("profileKey").asText()));
                    }
                    catch (InvalidInputException invalidInputException) {
                        // empty catch block
                    }
                    long lastUpdateTimestamp = entry.get("lastUpdateTimestamp").asLong();
                    LegacySignalProfile profile = (LegacySignalProfile)jsonProcessor.treeToValue((TreeNode)entry.get("profile"), LegacySignalProfile.class);
                    profileEntries.add(new LegacySignalProfileEntry(address, profileKey, lastUpdateTimestamp, profile));
                }
            }
            return profileEntries;
        }
    }
}

