// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// APIBridge api bridge
//
// swagger:model api.Bridge
type APIBridge struct {

	// Any authentication method needed for connect to the bridge, `none`
	// otherwise.
	Auth string `json:"auth,omitempty"`

	// Healthy indicates whether this bridge can be used normally.
	Healthy bool `json:"healthy,omitempty"`

	// Host is a unique identifier for the bridge.
	Host string `json:"host,omitempty"`

	// IP6Addr is the IPv6 address
	Ip6Addr string `json:"ip6_addr,omitempty"`

	// IPAddr is the IPv4 address
	IPAddr string `json:"ip_addr,omitempty"`

	// Load is the fractional load - but for now menshen agent is not measuring
	// load in the bridges.
	Load float64 `json:"load,omitempty"`

	// Location refers to the location to which this bridge points to
	Location string `json:"location,omitempty"`

	// Options contain the map of options that will be passed to the client. It usually
	// contains authentication credentials.
	Options interface{} `json:"options,omitempty"`

	// Overloaded should be set to true if the fractional load is above threshold.
	Overloaded bool `json:"overloaded,omitempty"`

	// For some protocols (like hopping) port is undefined.
	Port int64 `json:"port,omitempty"`

	// TCP, UDP or KCP. This was called "protocol" before.
	Transport string `json:"transport,omitempty"`

	// Type of bridge.
	Type string `json:"type,omitempty"`
}

// Validate validates this api bridge
func (m *APIBridge) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this api bridge based on context it is used
func (m *APIBridge) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *APIBridge) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIBridge) UnmarshalBinary(b []byte) error {
	var res APIBridge
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
