/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ExpandResponse struct for ExpandResponse
type ExpandResponse struct {
	Tree *UsersetTree `json:"tree,omitempty" yaml:"tree,omitempty"`
}

// NewExpandResponse instantiates a new ExpandResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewExpandResponse() *ExpandResponse {
	this := ExpandResponse{}
	return &this
}

// NewExpandResponseWithDefaults instantiates a new ExpandResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewExpandResponseWithDefaults() *ExpandResponse {
	this := ExpandResponse{}
	return &this
}

// GetTree returns the Tree field value if set, zero value otherwise.
func (o *ExpandResponse) GetTree() UsersetTree {
	if o == nil || o.Tree == nil {
		var ret UsersetTree
		return ret
	}
	return *o.Tree
}

// GetTreeOk returns a tuple with the Tree field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ExpandResponse) GetTreeOk() (*UsersetTree, bool) {
	if o == nil || o.Tree == nil {
		return nil, false
	}
	return o.Tree, true
}

// HasTree returns a boolean if a field has been set.
func (o *ExpandResponse) HasTree() bool {
	if o != nil && o.Tree != nil {
		return true
	}

	return false
}

// SetTree gets a reference to the given UsersetTree and assigns it to the Tree field.
func (o *ExpandResponse) SetTree(v UsersetTree) {
	o.Tree = &v
}

func (o ExpandResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Tree != nil {
		toSerialize["tree"] = o.Tree
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableExpandResponse struct {
	value *ExpandResponse
	isSet bool
}

func (v NullableExpandResponse) Get() *ExpandResponse {
	return v.value
}

func (v *NullableExpandResponse) Set(val *ExpandResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableExpandResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableExpandResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableExpandResponse(val *ExpandResponse) *NullableExpandResponse {
	return &NullableExpandResponse{value: val, isSet: true}
}

func (v NullableExpandResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableExpandResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
