<h1>Examples</h1>
<p>Imports used in the examples: </p>

```java
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
```

<p>This document's intention is to explain to new-comers the basics of this project</p>

	
<h2>Part 1: Creating a JSON document</h2>

<h3>Using JSONArray</h3>

```java
private static void JSONExampleArray1() {
	//We create a JSONObject from a String containing an array using JSONArray
	//Firstly, we declare an Array in a String

	String arrayStr = 
		    "["+"true,"+"false,"+ "\"true\","+ "\"false\","+"\"hello\","+"23.45e-4,"+
			"\"23.45\","+"42,"+"\"43\","+"["+"\"world\""+"],"+
				"{"+
			    "\"key1\":\"value1\","+
			    "\"key2\":\"value2\","+
			    "\"key3\":\"value3\","+
			    "\"key4\":\"value4\""+
			"},"+
			"0,"+"\"-1\""+
		    "]";

	//Then, we initializate the JSONArray thanks to its constructor

	JSONArray array = new JSONArray(arrayStr);
	System.out.println("Values array: "+ array);

	//We convert that array into a JSONObject, but first, we need the labels, so we need another JSONArray with the labels.
	//Here we will use an auxiliary function to get one for the example.

	JSONArray list = listNumberArray(array.length());
	System.out.println("Label Array: "+ list.toString());
	//Now, we construct the JSONObject using both the  value array and the label array.
	JSONObject object = array.toJSONObject(list);
	System.out.println("Final JSONOBject: " + object);
}

//This method creates an JSONArray of labels in which those are generated by their positions

private static JSONArray listNumberArray(int max){
	JSONArray res = new JSONArray();
	for (int i=0; i<max;i++) {
		//The value of the labels must be an String in order to make it work
		res.put(String.valueOf(i));
	}
	return res;
}
```
```java
private static void JSONExampleArray2() {

	//We can also create an Array without a String by creating an empty array and adding elements to it

	JSONArray array = new JSONArray();

	//Adding elements with .put()

	array.put("value");
	array.put(5);
	array.put(-23.45e67);
	array.put(true);

	//We convert it to JSONObject providing a label arrray like last time

	JSONArray list = listNumberArray(array.length());
	JSONObject object = array.toJSONObject(list);
	System.out.println("Final JSONOBject: " + object);
}
```

<h3>Using JSONStringer</h3>

```java
private static void JSONExampleStringer() {

	//We initializate the JSONStringer

	JSONStringer jsonStringer = new JSONStringer();

	//Now we start the process of adding elements with .object()

	jsonStringer.object();

	//We can now add elements as keys and values with .values () and .key()

	jsonStringer.key("trueValue").value(true);
	jsonStringer.key("falseValue").value(false);
	jsonStringer.key("nullValue").value(null);
	jsonStringer.key("stringValue").value("hello world!");
	jsonStringer.key("complexStringValue").value("h\be\tllo w\u1234orld!");
	jsonStringer.key("intValue").value(42);
	jsonStringer.key("doubleValue").value(-23.45e67);

	//We end this prcedure with .ednObject

	jsonStringer.endObject();

	//Once we have a JSONStringer, we convert it to JSONObject generating a String and using JSONObject's contructor.

	String str = jsonStringer.toString();
	JSONObject jsonObject = new JSONObject(str);

	System.out.println("Final JSONOBject: " + jsonObject);
}
```
<h3>Using JSONObject</h3>

```java
private static void JSONExampleObject1() {

	//We can create a JSONObject from a String with the class builder

	String string = "{\"0\":\"value\",\"1\":5,\"2\":-2.345E68,\"3\":true}";
	JSONObject example = new JSONObject(string);
	System.out.println("Final JSONObject: " + example);

}
```
```java
private static void JSONExampleObject2() {

	//We can also create a JSONObject directly without messing around with any of the other functions.

	JSONObject example = new JSONObject();


	//Now we add the keys and values in a similar way as the Stringer method
	example.put("key", "value");

	//As you can see, the first entry is the key and the second would be its associeted value.

	example.put("key2", 5);
	example.put("key3", -23.45e67);
	example.put("trueValue", true);

	//We can't add null values thougth

	//example.put("nullValue", null); //This is not possible

	 System.out.println("Final JSONOBject: " + example);
}
```
```java
private static void JSONExampleObject3() {

	//We can also create a JSONObject with a Java Map
	//YoU will need a Map whose keys are Strings. The values can be whatever you want

	Map<String,Double> map = new HashMap<String, Double>();

	map.put("key1", 1.0);
	map.put("key2", -23.45e67);

	//We create the JSONObject with the map with its class builder

	JSONObject example = new JSONObject(map);
	 System.out.println("Final JSONOBject: " + example);
}
```
<h3>Using JSONWriter</h3>

```java
private static void JSONExamplWriter() {

	//This method works in a very similar way to Object  and Stringer in the construction of the JSON.
	//The difference is that it needs a Java object called "Appendable" like StringBuilder

	StringBuilder write = new StringBuilder();
	JSONWriter jsonWriter = new JSONWriter(write);

	//We behave now the same way as Stringer

	jsonWriter.object();

	jsonWriter.key("trueValue").value(true);
	jsonWriter.key("falseValue").value(false);
	jsonWriter.key("nullValue").value(null);
	jsonWriter.key("stringValue").value("hello world!");
	jsonWriter.key("complexStringValue").value("h\be\tllo w\u1234orld!");
	jsonWriter.key("intValue").value(42);
	jsonWriter.key("doubleValue").value(-23.45e67);

	jsonWriter.endObject();

	//The resoult should be in the "write" object

	System.out.println("JSON: " + write.toString());

	//The difference is that we don't get a JSONObject in this one.


}
```
```java
private static void JSONExampleTokener() {

	//A partir de una String podemos crear un JSONTokener, que lo podemos usar alternativamente para JSONArray,JSONObject

	String string = "this is not a valid JSON string";
	JSONTokener token = new JSONTokener(string);

	//Now you can use the token in JSONObject and Array the same way as a String

	JSONObject object = new JSONObject(token);
	JSONArray array = new JSONArray(token);

}
```	
<h2>Part 2: Conversion methods</h2>
<p>We don't need to have a JSON document to work. This project also admits conversions from other type of files.</p>
<p>Secondly, we can also convert from JSON to those type of files.</p>
	
<h3>Extra: Conversion to JSONArray</h3>

```java
private static void JSONObjectToArray() {
	//We start with a JSONObject

	String string = "{\"0\":\"value\",\"1\":5,\"2\":-2.345E68,\"3\":true}";

	JSONObject example = new JSONObject(string);

	//We need a list of key strings like the reverse operation

	JSONArray keyStrings = listNumberArray(example.length());

	//Then we convert to the Array using both elelements

	JSONArray array = example.toJSONArray(keyStrings);

	System.out.println("Final JSONArray: " + array);
}
```
<h3>XML Conversions</h3>

```java
private static void XMLToExampleConversion() {

	//We start with a JSONObject

	String string = "{\"0\":\"value\",\"1\":5,\"2\":-2.345E68,\"3\":true}";
	JSONObject example = new JSONObject(string);

	//We obtain a String with XML format with toString()

	String output = XML.toString(example);
	System.out.println("Final XML: " + output);
}
```
```java
private static void XMLFromExampleConversion() {

	//We start with a string with  the XML format

	String string = "<0>value</0><1>5</1><2>-2.345E+68</2><3>true</3>";

	//We obtain a JSONObject with toJSONOBject()

	JSONObject output = XML.toJSONObject(string);

	System.out.println("Final JSONObject: " + output);
}
```
<h3>Cookie Conversions</h3>

```java
private static void CookieToExampleConversion() {

	//We start with a JSONObject
	//The JSONOBject needs to entries that gives the cookie a name and gives the field "name" a name too.
	//The Cokkie format doesn't support booleans

	String string = "{\"name\":\"Cookie-Name\",\"value\":\"name\",\"1\":5,\"2\":-2.345E68,\"3\":'true'}";
	JSONObject example = new JSONObject(string);

	//We obtain a String with Cookie format with toString()

	String output = Cookie.toString(example);
	System.out.println("Final Cookie: " + output);
}
```
```java
private static void CookieFromExampleConversion() {

	//We start with a string with  the Cookie format

	String string = "Cookie-Name=name;1=5;2=-2.345E%2b68;3=true";

	//We obtain a JSONObject with toJSONOBject()

	JSONObject output = Cookie.toJSONObject(string);
	System.out.println("Final JSONObject: " + output);
}
```

<h3>HTTP Conversions</h3>

```java
private static void HTTPToExampleConversion() {

	//We start with a JSONObject
	//The JSONObject must have the minimun header for a HTTP request or header

	String string = "{\"Method\":\"POST\",\"Request-URI\":'/',\"HTTP-Version\":'HTTP/1.1',\"Value1\":true,\"Value2\":2,\"Value3\":-2.345E68}";

	JSONObject example = new JSONObject(string);

	//We obtain a String with HTTP format with toString()

	String output = HTTP.toString(example);
	System.out.println("Final HTTP: " + output);
}
```
```java
private static void HTTPFromExampleConversion() {

	//We start with a string with  the HTTP format

	String string = "Final HTTP: POST '/' HTTP/1.1 Value3: -2.345E+68 Value1: true Value2: 2";

	//We obtain a JSONObject with toJSONOBject()

	JSONObject output = HTTP.toJSONObject(string);
	System.out.println("Final JSONObject: " + output);
}
```
<h3>CDL Conversions</h3>

```java
private static void CDLToExampleConversion() {

	//We start with some JSONObjects with the same values in the keys but different values in the "values"

	String string = "{\"0\":\"value\",\"1\":5,\"2\":-2.345E68,\"3\":true}";
	JSONObject example = new JSONObject(string);

	String string2 = "{\"0\":\"value2\",\"1\":6,\"2\":-8.345E68,\"3\":false}";
	JSONObject example2 = new JSONObject(string2);

	//We need now a JSONArray with those JSONObjects

	JSONArray array = new JSONArray();
	array.put(example);
	array.put(example2);

	//We obtain a String with XML format with toString()

	String output = CDL.toString(array);
	System.out.println("Final CDL: \r\n" + output);
}
```	
```java
private static void CDLFromExampleConversion() {

	//We start wtih a String with the CDL format

	String string = "0,1,2,3\n"
			+ "value,5,-2.345E+68,true\n"
			+ "value2,6,-8.345E+68,false";

	//We obtain a JSONArray with toJSONOBject()

	JSONArray output = CDL.toJSONArray(string);
	System.out.println("Final JSONArray: " + output);
}
```
<h3>Properties Conversions</h3>

```java
private static Properties PropertyToExampleConversion() {

	//We start with a JSONObject

	String string = "{\"0\":\"value\",\"1\":5,\"2\":-2.345E68,\"3\":true}";
	JSONObject example = new JSONObject(string);

	//We obtain a String with Properties format with toString()

	Properties output = Property.toProperties(example);
	System.out.println("Final Properties: " + output);

	return output;
}
```
```java
private static void PropertyFromExampleConversion() {

	//We start with a Properties object

	Properties input = PropertyToExampleConversion();

	//We obtain a JSONObject with toJSONOBject()

	JSONObject output = Property.toJSONObject(input);
	System.out.println("Final JSONObject: " + output);
}
```
 <h2>List of all examples methods</h2>

```java
public static void main(String[] args) {
	//JSONObjectToArray();
	//JSONExampleArray1();
	//JSONExampleArray2();
	//JSONExampleStringer();
	//JSONExampleObject1();
	//JSONExampleObject2();
	//JSONExampleObject3();
	//JSONExamplWriter();
	//XMLToExampleConversion();
	//XMLFromExampleConversion();
	//CookieToExampleConversion();
	//CookieFromExampleConversion(); 
	//HTTPToExampleConversion();
	//HTTPFromExampleConversion();
	//CDLToExampleConversion();
	//CDLFromExampleConversion();
	//PropertyToExampleConversion();
	//PropertyFromExampleConversion();
}
```

