/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J1\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00072\u0006\u0010\u0006\u001a\u0002H\u00122\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExaScript", "r", "Lcom/intellij/database/dialects/exasol/model/ExaScript;", "describeExaVirtualSchema", "s", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "isPropertyValueDefault", "", "E", "property", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicMetaProperty;)Z", "intellij.database.dialects.exasol"})
public final class ExaDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof ExaScript ? this.describeExaScript((ExaScript)e, context) : (basicElement instanceof ExaVirtualSchema ? this.describeExaVirtualSchema((ExaVirtualSchema)e, context) : super.content(e, context));
    }

    private final String describeExaScript(ExaScript r, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(ExaScript.SCRIPT_TYPE);
        return "script " + StringUtil.toLowerCase((String)String.valueOf((Object)r.getScriptType()));
    }

    private final String describeExaVirtualSchema(ExaVirtualSchema s, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(ExaVirtualSchema.ADAPTER_REF);
        ((Collection)context.getDescribed()).add(ExaVirtualSchema.PROPERTIES);
        String string = this.getName(s.getAdapterRef(), (BasicElement)s.getAdapter());
        List<NameValue> list = s.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        return "vschema using " + string + " props {" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, ExaDescriptionService::describeExaVirtualSchema$lambda$0, (int)30, null);
    }

    protected <E extends BasicElement> boolean isPropertyValueDefault(@NotNull E e, @NotNull BasicMetaProperty<E, ?> property) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual((Object)property.id, (Object)ExaUser.PASSWORD) || Intrinsics.areEqual((Object)property.id, ExaConnection.PASSWORD) || super.isPropertyValueDefault(e, property);
    }

    private static final CharSequence describeExaVirtualSchema$lambda$0(NameValue it) {
        return it.getName() + ":" + it.getValue();
    }
}

