/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.analysis.CoverageInfoCollector;
import com.intellij.coverage.analysis.JavaCoverageClassesAnnotator;
import com.intellij.coverage.analysis.JavaCoverageReportEnumerator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.coverage.view.CoverageClassStructure;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageAnnotator
extends BaseCoverageAnnotator
implements Disposable.Default {
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myPackageCoverageInfos = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myFlattenPackageCoverageInfos = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
    private final Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> myDirCoverageInfos = new HashMap<VirtualFile, PackageAnnotator.PackageCoverageInfo>();
    private final Map<String, PackageAnnotator.ClassCoverageInfo> myClassCoverageInfos = new ConcurrentHashMap<String, PackageAnnotator.ClassCoverageInfo>();
    private final Map<PsiElement, PackageAnnotator.SummaryCoverageInfo> myExtensionCoverageInfos = new WeakHashMap<PsiElement, PackageAnnotator.SummaryCoverageInfo>();
    protected CoverageClassStructure myStructure;

    public JavaCoverageAnnotator(Project project) {
        super(project);
    }

    @Nullable
    public final CoverageClassStructure getStructure() {
        return this.myStructure;
    }

    public static JavaCoverageAnnotator getInstance(Project project) {
        return (JavaCoverageAnnotator)((Object)project.getService(JavaCoverageAnnotator.class));
    }

    @Nullable
    @Nls
    public final String getDirCoverageInformationString(@NotNull PsiDirectory psiDirectory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager coverageDataManager) {
        PsiPackage psiPackage;
        if (psiDirectory == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (currentSuite == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(1);
        }
        if (coverageDataManager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(2);
        }
        if ((psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        return this.getDirCoverageInformationString(psiDirectory.getProject(), virtualFile, currentSuite, coverageDataManager);
    }

    @Nullable
    @Nls
    public final String getDirCoverageInformationString(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager coverageDataManager) {
        if (project == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(4);
        }
        if (currentSuite == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(5);
        }
        if (coverageDataManager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(6);
        }
        if (!currentSuite.isTrackTestFolders() && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project)) {
            return null;
        }
        return JavaCoverageAnnotator.getCoverageInformationString(this.myDirCoverageInfos.get(virtualFile), coverageDataManager.isSubCoverageActive());
    }

    @Nullable
    public final String getFileCoverageInformationString(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        if (psiFile == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(7);
        }
        if (currentSuite == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(9);
        }
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
            PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(this, (PsiNamedElement)psiFile);
            if (info == null) continue;
            return JavaCoverageAnnotator.getCoverageInformationString(info, manager.isSubCoverageActive());
        }
        return null;
    }

    public final void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myPackageCoverageInfos.clear();
        this.myFlattenPackageCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
        this.myClassCoverageInfos.clear();
        this.myExtensionCoverageInfos.clear();
        if (this.myStructure != null) {
            Disposer.dispose((Disposable)this.myStructure);
        }
        this.myStructure = null;
    }

    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        if (suite == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(10);
        }
        if (dataManager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(11);
        }
        Project project = this.getProject();
        return () -> {
            long timeMs = TimeoutUtil.measureExecutionTime(() -> {
                this.collectSummaryInfo(suite, project);
                this.myStructure = new CoverageClassStructure(project, this, suite);
                Disposer.register((Disposable)this, (Disposable)this.myStructure);
                dataManager.triggerPresentationUpdate();
            });
            int annotatedClasses = this.myClassCoverageInfos.size();
            ProjectData data = suite.getCoverageData();
            int loadedClasses = data == null ? 0 : data.getClassesNumber();
            CoverageLogger.logReportBuilding((Project)project, (long)timeMs, (int)annotatedClasses, (int)loadedClasses);
        };
    }

    @Nullable
    @Nls
    public static String getCoverageInformationString(PackageAnnotator.SummaryCoverageInfo info, boolean subCoverageActive) {
        if (info == null) {
            return null;
        }
        if (info.totalClassCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (subCoverageActive) {
            return info.coveredClassCount + info.getCoveredLineCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return JavaCoverageBundle.message("coverage.view.text.classes.covered", (int)((double)info.coveredClassCount / (double)info.totalClassCount * 100.0)) + ", " + CoverageBundle.message((String)"coverage.view.text.lines.covered", (Object[])new Object[]{(int)((double)info.getCoveredLineCount() / (double)info.totalLineCount * 100.0)});
    }

    @Nullable
    public final String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager) {
        if (coverageDataManager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(12);
        }
        return this.getPackageCoverageInformationString(psiPackage, module, coverageDataManager, false);
    }

    @Nullable
    public final String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager, boolean flatten) {
        if (coverageDataManager == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(13);
        }
        if (psiPackage == null) {
            return null;
        }
        boolean subCoverageActive = coverageDataManager.isSubCoverageActive();
        if (module != null) {
            PsiDirectory[] directories = psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
            PackageAnnotator.SummaryCoverageInfo result = null;
            for (PsiDirectory directory : directories) {
                VirtualFile virtualFile = directory.getVirtualFile();
                result = JavaCoverageAnnotator.merge(result, this.myDirCoverageInfos.get(virtualFile));
            }
            return JavaCoverageAnnotator.getCoverageInformationString(result, subCoverageActive);
        }
        PackageAnnotator.PackageCoverageInfo info = this.getPackageCoverageInfo(psiPackage.getQualifiedName(), flatten);
        return JavaCoverageAnnotator.getCoverageInformationString(info, subCoverageActive);
    }

    public final PackageAnnotator.PackageCoverageInfo getPackageCoverageInfo(@NotNull String qualifiedName, boolean flattenPackages) {
        if (qualifiedName == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(14);
        }
        return flattenPackages ? this.myFlattenPackageCoverageInfos.get(qualifiedName) : this.myPackageCoverageInfos.get(qualifiedName);
    }

    public static String getLineCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.getCoveredLineCount(), info.totalLineCount);
    }

    public static String getMethodCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredMethodCount, info.totalMethodCount);
    }

    public static String getClassCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredClassCount, info.totalClassCount);
    }

    public static String getBranchCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredBranchCount, info.totalBranchCount);
    }

    private static String getPercentage(int covered, int total) {
        int percentage = total == 0 ? 100 : (int)((double)covered / (double)total * 100.0);
        return percentage + "% (" + covered + "/" + total + ")";
    }

    public static PackageAnnotator.SummaryCoverageInfo merge(@Nullable PackageAnnotator.SummaryCoverageInfo info, @Nullable PackageAnnotator.SummaryCoverageInfo testInfo) {
        if (info == null) {
            return testInfo;
        }
        if (testInfo == null) {
            return info;
        }
        PackageAnnotator.PackageCoverageInfo coverageInfo = new PackageAnnotator.PackageCoverageInfo();
        coverageInfo.totalClassCount = info.totalClassCount + testInfo.totalClassCount;
        coverageInfo.coveredClassCount = info.coveredClassCount + testInfo.coveredClassCount;
        coverageInfo.totalLineCount = info.totalLineCount + testInfo.totalLineCount;
        coverageInfo.coveredLineCount = info.getCoveredLineCount() + testInfo.getCoveredLineCount();
        coverageInfo.totalBranchCount = info.totalBranchCount + testInfo.totalBranchCount;
        coverageInfo.coveredBranchCount = info.coveredBranchCount + testInfo.coveredBranchCount;
        return coverageInfo;
    }

    @Nullable
    @Nls
    public final String getClassCoverageInformationString(String classFQName, CoverageDataManager coverageDataManager) {
        PackageAnnotator.ClassCoverageInfo info = this.myClassCoverageInfos.get(classFQName);
        return JavaCoverageAnnotator.getClassCoverageInformationString(info, coverageDataManager);
    }

    @Nullable
    @Nls
    public static String getClassCoverageInformationString(PackageAnnotator.ClassCoverageInfo info, CoverageDataManager coverageDataManager) {
        if (info == null) {
            return null;
        }
        if (info.totalMethodCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (coverageDataManager.isSubCoverageActive()) {
            return info.coveredMethodCount + info.fullyCoveredLineCount + info.partiallyCoveredLineCount > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return JavaCoverageBundle.message("coverage.view.text.methods.covered", (int)((double)info.coveredMethodCount / (double)info.totalMethodCount * 100.0)) + ", " + CoverageBundle.message((String)"coverage.view.text.lines.covered", (Object[])new Object[]{(int)((double)(info.fullyCoveredLineCount + info.partiallyCoveredLineCount) / (double)info.totalLineCount * 100.0)});
    }

    @Nullable
    public final PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(@Nullable String classFQName) {
        if (classFQName == null) {
            return null;
        }
        return this.myClassCoverageInfos.get(classFQName);
    }

    public final Map<String, PackageAnnotator.ClassCoverageInfo> getClassesCoverage() {
        return this.myClassCoverageInfos;
    }

    private void collectSummaryInfo(@NotNull CoverageSuitesBundle suite, Project project) {
        if (suite == null) {
            JavaCoverageAnnotator.$$$reportNull$$$0(15);
        }
        JavaCoverageInfoCollector collector = new JavaCoverageInfoCollector(this);
        if (JavaCoverageAnnotator.shouldSkipUnloadedClassesAnalysis(suite)) {
            JavaCoverageReportEnumerator.collectSummaryInReport(suite, project, collector);
        } else {
            new JavaCoverageClassesAnnotator(suite, project, collector).visitSuite();
        }
    }

    private static boolean shouldSkipUnloadedClassesAnalysis(CoverageSuitesBundle bundle) {
        return ContainerUtil.and((Object[])bundle.getSuites(), suite -> {
            JavaCoverageSuite javaSuite;
            return suite instanceof JavaCoverageSuite && (javaSuite = (JavaCoverageSuite)((Object)suite)).isSkipUnloadedClassesAnalysis();
        });
    }

    @Nullable
    public final PackageAnnotator.SummaryCoverageInfo getExtensionCoverageInfo(@Nullable PsiNamedElement value) {
        if (value == null) {
            return null;
        }
        PackageAnnotator.SummaryCoverageInfo cachedInfo = this.myExtensionCoverageInfos.get(value);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        return (PackageAnnotator.SummaryCoverageInfo)JavaCoverageEngineExtension.EP_NAME.computeSafeIfAny(extension -> {
            PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(this, value);
            if (info != null) {
                this.myExtensionCoverageInfos.put((PsiElement)value, info);
                return info;
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/analysis/JavaCoverageAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirCoverageInformationString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileCoverageInformationString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenewRequest";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageCoverageInformationString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageCoverageInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSummaryInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JavaCoverageInfoCollector
    implements CoverageInfoCollector {
        private final JavaCoverageAnnotator myAnnotator;

        public JavaCoverageInfoCollector(JavaCoverageAnnotator annotator) {
            this.myAnnotator = annotator;
        }

        @Override
        public void addPackage(String packageQualifiedName, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, boolean flatten) {
            if (flatten) {
                this.myAnnotator.myFlattenPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
            } else {
                this.myAnnotator.myPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
            }
        }

        @Override
        public void addSourceDirectory(VirtualFile dir, PackageAnnotator.PackageCoverageInfo dirCoverageInfo) {
            this.myAnnotator.myDirCoverageInfos.put(dir, dirCoverageInfo);
        }

        @Override
        public void addClass(String classQualifiedName, PackageAnnotator.ClassCoverageInfo classCoverageInfo) {
            this.myAnnotator.myClassCoverageInfos.put(classQualifiedName, classCoverageInfo);
        }
    }
}

