/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.protobuf.jvm.names.JavaNameGenerator;
import com.intellij.protobuf.jvm.names.NameMatcher;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.psi.PsiClass;
import java.util.Objects;

class Proto2NameMatcher
implements NameMatcher {
    private final String fullyQualifiedClassName;
    private final String elementName;
    private final JavaNameGenerator generator;

    Proto2NameMatcher(PbJavaGotoDeclarationContext context, JavaNameGenerator generator) {
        PsiClass normalizedContextClass = Proto2NameMatcher.normalizeClassContext(context.javaClass);
        Object elementName = context.resolvedElement.getName();
        if (normalizedContextClass != context.javaClass) {
            elementName = "Builder." + (String)elementName;
        }
        this.fullyQualifiedClassName = normalizedContextClass.getQualifiedName();
        this.elementName = elementName;
        this.generator = generator;
    }

    @Override
    public boolean matchesMessage(PbMessageType messageType) {
        return this.generator.messageClassNames(messageType).contains(this.fullyQualifiedClassName);
    }

    @Override
    public boolean matchesField(PbField field) {
        return this.generator.fieldMemberNames(field).contains(this.elementName);
    }

    @Override
    public boolean matchesEnum(PbEnumDefinition enumDefinition) {
        return Objects.equals(this.fullyQualifiedClassName, this.generator.enumClassName(enumDefinition));
    }

    @Override
    public boolean matchesEnumValue(PbEnumValue enumValue) {
        return Objects.equals(this.generator.enumValueName(enumValue), this.elementName);
    }

    @Override
    public boolean matchesOneofMember(PbOneofDefinition oneof) {
        return this.generator.oneofMemberNames(oneof).contains(this.elementName);
    }

    @Override
    public boolean matchesOneofEnum(PbOneofDefinition oneof) {
        return Objects.equals(this.fullyQualifiedClassName, this.generator.oneofEnumClassName(oneof));
    }

    @Override
    public boolean matchesOneofNotSetEnumValue(PbOneofDefinition oneof) {
        return Objects.equals(this.elementName, this.generator.oneofNotSetEnumValueName(oneof));
    }

    @Override
    public boolean matchesOneofEnumValue(PbField oneofField) {
        return Objects.equals(this.elementName, this.generator.oneofEnumValueName(oneofField));
    }

    private static PsiClass normalizeClassContext(PsiClass classContext) {
        if (classContext.isEnum()) {
            return classContext;
        }
        String name = classContext.getName();
        if (name == null) {
            return classContext;
        }
        if (name.equals("Builder")) {
            PsiClass containingClass = classContext.getContainingClass();
            return containingClass != null ? containingClass : classContext;
        }
        return classContext;
    }
}

