/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.jvm.config.ConfigPlaceholderReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class MicroservicesConfigUtils {
    private static final Condition<PsiReference> RELEVANT_REFERENCE_CONDITION = reference -> !(reference instanceof ConfigPlaceholderReference);

    private MicroservicesConfigUtils() {
    }

    public static void highlightValueReferences(@NotNull PsiElement valueElement, @NotNull ProblemsHolder holder) {
        if (valueElement == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(1);
        }
        MicroservicesConfigUtils.highlightValueReferences(valueElement, holder, reference -> LocalQuickFix.EMPTY_ARRAY);
    }

    public static void highlightValueReferences(@NotNull PsiElement valueElement, @NotNull ProblemsHolder holder, @NotNull Function<PsiReference, LocalQuickFix[]> unresolvedReferenceFixesProvider) {
        if (valueElement == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(3);
        }
        if (unresolvedReferenceFixesProvider == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(4);
        }
        List valueReferences = ContainerUtil.filter((Object[])valueElement.getReferences(), RELEVANT_REFERENCE_CONDITION);
        MultiMap unresolvedReferences = new MultiMap();
        HashSet<Integer> resolvedReferencesOffsets = new HashSet<Integer>();
        JavaClassReference javaClassReferenceExtendsCandidate = null;
        for (PsiReference reference : valueReferences) {
            boolean unresolved;
            int startOffset = reference.getRangeInElement().getStartOffset();
            boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
            if (!unresolved) {
                unresolvedReferences.remove((Object)startOffset);
                resolvedReferencesOffsets.add(startOffset);
                if (!(reference instanceof JavaClassReference)) continue;
                javaClassReferenceExtendsCandidate = (JavaClassReference)reference;
                continue;
            }
            if (resolvedReferencesOffsets.contains(startOffset)) continue;
            unresolvedReferences.putValue((Object)startOffset, (Object)reference);
        }
        if (javaClassReferenceExtendsCandidate != null) {
            MicroservicesConfigUtils.highlightJavaClassReferenceExtends(holder, javaClassReferenceExtendsCandidate);
        }
        for (PsiReference reference : unresolvedReferences.values()) {
            if (reference.isSoft()) continue;
            LocalQuickFix[] fixes = unresolvedReferenceFixesProvider.apply(reference);
            if (reference instanceof LocalQuickFixProvider) {
                LocalQuickFixProvider local = (LocalQuickFixProvider)reference;
                fixes = (LocalQuickFix[])Stream.of(fixes, local.getQuickFixes()).flatMap(Stream::of).toArray(LocalQuickFix[]::new);
            }
            holder.registerProblemForReference(reference, ProblemHighlightType.ERROR, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), fixes);
        }
    }

    private static void highlightJavaClassReferenceExtends(ProblemsHolder holder, JavaClassReference reference) {
        List extendClassNames = reference.getSuperClasses();
        if (extendClassNames.isEmpty()) {
            return;
        }
        PsiElement resolve = reference.resolve();
        if (!(resolve instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)resolve;
        PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)psiClass);
        for (String extend : extendClassNames) {
            try {
                PsiType base = PsiElementFactory.getInstance((Project)psiClass.getProject()).createTypeFromText(extend, (PsiElement)psiClass);
                if (!base.isAssignableFrom((PsiType)classType)) continue;
                return;
            }
            catch (IncorrectOperationException incorrectOperationException) {
            }
        }
        holder.registerProblem(reference.getElement(), MicroservicesConfigBundle.message("config.non.assignable.class", ElementManipulators.getValueText((PsiElement)reference.getElement()), StringUtil.join((Collection)extendClassNames, (String)"|")), ProblemHighlightType.ERROR, ElementManipulators.getValueTextRange((PsiElement)reference.getElement()), new LocalQuickFix[0]);
    }

    public static List<TextRange> getListValueRanges(@NotNull PsiElement element) {
        if (element == null) {
            MicroservicesConfigUtils.$$$reportNull$$$0(5);
        }
        final String valueText = ElementManipulators.getValueText((PsiElement)element);
        final int valueOffset = ElementManipulators.getOffsetInElement((PsiElement)element);
        SmartList result = new SmartList();
        new DelimitedListProcessor(",", (List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
                super(arg0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                TextRange tokenRange = new TextRange(start, end);
                String tokenTextTrimmed = tokenRange.substring(valueText).trim();
                int tokenTextTrimmedStartOffset = valueText.indexOf(tokenTextTrimmed, start);
                TextRange realRange = TextRange.from((int)(tokenTextTrimmedStartOffset + valueOffset), (int)tokenTextTrimmed.length());
                this.val$result.add(realRange);
            }
        }.processText(valueText);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedReferenceFixesProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/microservices/jvm/config/MicroservicesConfigUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightValueReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getListValueRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

