/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.kubernetes.view.navigation.KubernetesNamespacedResourceNavigationData;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.psi.PsiReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u0006R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/references/KubernetesResourceReference;", "Lcom/intellij/psi/PsiReference;", "resourceInfo", "Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "getResourceInfo", "()Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "ResourceInfo", "intellij.clouds.kubernetes.backend"})
public interface KubernetesResourceReference
extends PsiReference {
    @Nullable
    public ResourceInfo getResourceInfo();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "", "kind", "", "name", "namespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getKind", "()Ljava/lang/String;", "getName", "getNamespace", "serviceViewNavigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "getServiceViewNavigationData", "()Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "serviceViewNavigationData$delegate", "Lkotlin/Lazy;", "fullName", "getFullName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes.backend"})
    public static final class ResourceInfo {
        @NotNull
        private final String kind;
        @NotNull
        private final String name;
        @Nullable
        private final String namespace;
        @NotNull
        private final Lazy serviceViewNavigationData$delegate;

        public ResourceInfo(@NotNull String kind, @NotNull String name, @Nullable String namespace) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.kind = kind;
            this.name = name;
            this.namespace = namespace;
            this.serviceViewNavigationData$delegate = LazyKt.lazy(() -> ResourceInfo.serviceViewNavigationData_delegate$lambda$0(this));
        }

        public /* synthetic */ ResourceInfo(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final KubernetesResourceNavigationData getServiceViewNavigationData() {
            Lazy lazy = this.serviceViewNavigationData$delegate;
            return (KubernetesResourceNavigationData)lazy.getValue();
        }

        @NotNull
        public final String getFullName() {
            return this.namespace != null ? this.name + " @ " + this.namespace : this.name;
        }

        @NotNull
        public final String component1() {
            return this.kind;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.namespace;
        }

        @NotNull
        public final ResourceInfo copy(@NotNull String kind, @NotNull String name, @Nullable String namespace) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ResourceInfo(kind, name, namespace);
        }

        public static /* synthetic */ ResourceInfo copy$default(ResourceInfo resourceInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = resourceInfo.kind;
            }
            if ((n & 2) != 0) {
                string2 = resourceInfo.name;
            }
            if ((n & 4) != 0) {
                string3 = resourceInfo.namespace;
            }
            return resourceInfo.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ResourceInfo(kind=" + this.kind + ", name=" + this.name + ", namespace=" + this.namespace + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.namespace == null ? 0 : this.namespace.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceInfo)) {
                return false;
            }
            ResourceInfo resourceInfo = (ResourceInfo)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)resourceInfo.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)resourceInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.namespace, (Object)resourceInfo.namespace);
        }

        private static final KubernetesNamespacedResourceNavigationData serviceViewNavigationData_delegate$lambda$0(ResourceInfo this$0) {
            return new KubernetesNamespacedResourceNavigationData(this$0.kind, this$0.namespace, this$0.name);
        }
    }
}

