package mobilemodels

import (
	"encoding/json"

	"0xacab.org/leap/bitmask-core/models"
	"github.com/rs/zerolog/log"
)

// Gateways is a gomobile compatible wrapper around an array of swagger generated
// models.ModelsGateway
type Gateways struct {
	gws []*models.ModelsGateway
}

func NewGateways(gateways []*models.ModelsGateway) *Gateways {
	return &Gateways{
		gws: gateways,
	}
}

func (a *Gateways) Length() int {
	return len(a.gws)
}

func (a *Gateways) Get(i int) *models.ModelsGateway {
	if i < 0 || a.Length()-1 < i {
		return nil
	}
	return a.gws[i]
}

func (a *Gateways) Add(gateway *models.ModelsGateway) {
	a.gws = append(a.gws, gateway)
}

func (a *Gateways) ToJson() (string, error) {
	res, err := json.Marshal(a.gws)
	if err != nil {
		log.Debug().Msgf("Failed to serialize bridges: %v", err)
		return "", err
	}
	return string(res), nil
}
