.\"
.\" nfsdclddb(8)
.\"
.TH nfsdclddb 8 "07 Aug 2019"
.SH NAME
nfsdclddb \- Tool for manipulating the nfsdcld sqlite database
.SH SYNOPSIS
.B nfsdclddb
.RB [ \-h | \-\-help ]
.P
.B nfsdclddb
.RB [ \-p | \-\-path
.IR dbpath ]
.B fix-table-names
.RB [ \-h | \-\-help ]
.P
.B nfsdclddb
.RB [ \-p | \-\-path
.IR dbpath ]
.B downgrade-schema
.RB [ \-h | \-\-help ]
.RB [ \-v | \-\-version
.IR to-version ]
.P
.B nfsdclddb
.RB [ \-p | \-\-path
.IR dbpath ]
.B print
.RB [ \-h | \-\-help ]
.RB [ \-s | \-\-summary ]
.P

.SH DESCRIPTION
.RB "The " nfsdclddb " command is provided to perform some manipulation of the nfsdcld sqlite database schema and to print the contents of the database."
.SS Sub-commands
Valid
.B nfsdclddb
subcommands are:
.IP "\fBfix-table-names\fP"
.RB "A previous version of " nfsdcld "(8) contained a bug that corrupted the reboot epoch table names.  This sub-command will fix those table names."
.IP "\fBdowngrade-schema\fP"
Downgrade the database schema.  Currently the schema can only to downgraded from version 4 to version 3.
.IP "\fBprint\fP"
Display the contents of the database.  Prints the schema version and the values of the current and recovery epochs.  If the
.BR \-s | \-\-summary
option is not given, also prints the clients in the reboot epoch tables.
.SH OPTIONS
.SS Options valid for all sub-commands
.TP
.B \-h, \-\-help
Show the help message and exit
.TP
\fB\-p \fIdbpath\fR, \fB\-\-path \fIdbpath\fR
Open the sqlite database located at
.I dbpath
instead of
.IR /var/lib/nfs/nfsdcld/main.sqlite ".  "
This is mainly for testing purposes.
.SS Options specific to the downgrade-schema sub-command
.TP
\fB\-v \fIto-version\fR, \fB\-\-version \fIto-version\fR
The schema version to downgrade to.  Currently the schema can only be downgraded to version 3.
.SS Options specific to the print sub-command
.TP
.B \-s, \-\-summary
Do not list the clients in the reboot epoch tables in the output.
.SH NOTES
The
.B nfsdclddb
command will not allow the
.B fix-table-names
or
.B downgrade-schema
subcommands to be used if
.BR nfsdcld (8)
is running.
.SH FILES
.TP
.B /var/lib/nfs/nfsdcld/main.sqlite
.SH SEE ALSO
.BR nfsdcld (8)
.SH AUTHOR
Scott Mayhew <smayhew@redhat.com>
