// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package baremetalsolution

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	baremetalsolutionpb "cloud.google.com/go/baremetalsolution/apiv2/baremetalsolutionpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListInstances                   []gax.CallOption
	GetInstance                     []gax.CallOption
	UpdateInstance                  []gax.CallOption
	RenameInstance                  []gax.CallOption
	ResetInstance                   []gax.CallOption
	StartInstance                   []gax.CallOption
	StopInstance                    []gax.CallOption
	EnableInteractiveSerialConsole  []gax.CallOption
	DisableInteractiveSerialConsole []gax.CallOption
	DetachLun                       []gax.CallOption
	ListSSHKeys                     []gax.CallOption
	CreateSSHKey                    []gax.CallOption
	DeleteSSHKey                    []gax.CallOption
	ListVolumes                     []gax.CallOption
	GetVolume                       []gax.CallOption
	UpdateVolume                    []gax.CallOption
	RenameVolume                    []gax.CallOption
	EvictVolume                     []gax.CallOption
	ResizeVolume                    []gax.CallOption
	ListNetworks                    []gax.CallOption
	ListNetworkUsage                []gax.CallOption
	GetNetwork                      []gax.CallOption
	UpdateNetwork                   []gax.CallOption
	CreateVolumeSnapshot            []gax.CallOption
	RestoreVolumeSnapshot           []gax.CallOption
	DeleteVolumeSnapshot            []gax.CallOption
	GetVolumeSnapshot               []gax.CallOption
	ListVolumeSnapshots             []gax.CallOption
	GetLun                          []gax.CallOption
	ListLuns                        []gax.CallOption
	EvictLun                        []gax.CallOption
	GetNfsShare                     []gax.CallOption
	ListNfsShares                   []gax.CallOption
	UpdateNfsShare                  []gax.CallOption
	CreateNfsShare                  []gax.CallOption
	RenameNfsShare                  []gax.CallOption
	DeleteNfsShare                  []gax.CallOption
	ListProvisioningQuotas          []gax.CallOption
	SubmitProvisioningConfig        []gax.CallOption
	GetProvisioningConfig           []gax.CallOption
	CreateProvisioningConfig        []gax.CallOption
	UpdateProvisioningConfig        []gax.CallOption
	RenameNetwork                   []gax.CallOption
	ListOSImages                    []gax.CallOption
	GetLocation                     []gax.CallOption
	ListLocations                   []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("baremetalsolution.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("baremetalsolution.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("baremetalsolution.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://baremetalsolution.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListInstances: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EnableInteractiveSerialConsole: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DisableInteractiveSerialConsole: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DetachLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSSHKeys: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSSHKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSSHKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EvictVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResizeVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNetworks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNetworkUsage: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RestoreVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumeSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListLuns: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EvictLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNfsShares: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListProvisioningQuotas: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SubmitProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListOSImages: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:   []gax.CallOption{},
		ListLocations: []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListInstances: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResetInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopInstance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EnableInteractiveSerialConsole: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DisableInteractiveSerialConsole: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DetachLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSSHKeys: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSSHKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSSHKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EvictVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResizeVolume: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNetworks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNetworkUsage: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RestoreVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVolumeSnapshot: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVolumeSnapshots: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListLuns: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		EvictLun: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListNfsShares: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteNfsShare: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListProvisioningQuotas: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SubmitProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateProvisioningConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RenameNetwork: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListOSImages: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:   []gax.CallOption{},
		ListLocations: []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Bare Metal Solution API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListInstances(context.Context, *baremetalsolutionpb.ListInstancesRequest, ...gax.CallOption) *InstanceIterator
	GetInstance(context.Context, *baremetalsolutionpb.GetInstanceRequest, ...gax.CallOption) (*baremetalsolutionpb.Instance, error)
	UpdateInstance(context.Context, *baremetalsolutionpb.UpdateInstanceRequest, ...gax.CallOption) (*UpdateInstanceOperation, error)
	UpdateInstanceOperation(name string) *UpdateInstanceOperation
	RenameInstance(context.Context, *baremetalsolutionpb.RenameInstanceRequest, ...gax.CallOption) (*baremetalsolutionpb.Instance, error)
	ResetInstance(context.Context, *baremetalsolutionpb.ResetInstanceRequest, ...gax.CallOption) (*ResetInstanceOperation, error)
	ResetInstanceOperation(name string) *ResetInstanceOperation
	StartInstance(context.Context, *baremetalsolutionpb.StartInstanceRequest, ...gax.CallOption) (*StartInstanceOperation, error)
	StartInstanceOperation(name string) *StartInstanceOperation
	StopInstance(context.Context, *baremetalsolutionpb.StopInstanceRequest, ...gax.CallOption) (*StopInstanceOperation, error)
	StopInstanceOperation(name string) *StopInstanceOperation
	EnableInteractiveSerialConsole(context.Context, *baremetalsolutionpb.EnableInteractiveSerialConsoleRequest, ...gax.CallOption) (*EnableInteractiveSerialConsoleOperation, error)
	EnableInteractiveSerialConsoleOperation(name string) *EnableInteractiveSerialConsoleOperation
	DisableInteractiveSerialConsole(context.Context, *baremetalsolutionpb.DisableInteractiveSerialConsoleRequest, ...gax.CallOption) (*DisableInteractiveSerialConsoleOperation, error)
	DisableInteractiveSerialConsoleOperation(name string) *DisableInteractiveSerialConsoleOperation
	DetachLun(context.Context, *baremetalsolutionpb.DetachLunRequest, ...gax.CallOption) (*DetachLunOperation, error)
	DetachLunOperation(name string) *DetachLunOperation
	ListSSHKeys(context.Context, *baremetalsolutionpb.ListSSHKeysRequest, ...gax.CallOption) *SSHKeyIterator
	CreateSSHKey(context.Context, *baremetalsolutionpb.CreateSSHKeyRequest, ...gax.CallOption) (*baremetalsolutionpb.SSHKey, error)
	DeleteSSHKey(context.Context, *baremetalsolutionpb.DeleteSSHKeyRequest, ...gax.CallOption) error
	ListVolumes(context.Context, *baremetalsolutionpb.ListVolumesRequest, ...gax.CallOption) *VolumeIterator
	GetVolume(context.Context, *baremetalsolutionpb.GetVolumeRequest, ...gax.CallOption) (*baremetalsolutionpb.Volume, error)
	UpdateVolume(context.Context, *baremetalsolutionpb.UpdateVolumeRequest, ...gax.CallOption) (*UpdateVolumeOperation, error)
	UpdateVolumeOperation(name string) *UpdateVolumeOperation
	RenameVolume(context.Context, *baremetalsolutionpb.RenameVolumeRequest, ...gax.CallOption) (*baremetalsolutionpb.Volume, error)
	EvictVolume(context.Context, *baremetalsolutionpb.EvictVolumeRequest, ...gax.CallOption) (*EvictVolumeOperation, error)
	EvictVolumeOperation(name string) *EvictVolumeOperation
	ResizeVolume(context.Context, *baremetalsolutionpb.ResizeVolumeRequest, ...gax.CallOption) (*ResizeVolumeOperation, error)
	ResizeVolumeOperation(name string) *ResizeVolumeOperation
	ListNetworks(context.Context, *baremetalsolutionpb.ListNetworksRequest, ...gax.CallOption) *NetworkIterator
	ListNetworkUsage(context.Context, *baremetalsolutionpb.ListNetworkUsageRequest, ...gax.CallOption) (*baremetalsolutionpb.ListNetworkUsageResponse, error)
	GetNetwork(context.Context, *baremetalsolutionpb.GetNetworkRequest, ...gax.CallOption) (*baremetalsolutionpb.Network, error)
	UpdateNetwork(context.Context, *baremetalsolutionpb.UpdateNetworkRequest, ...gax.CallOption) (*UpdateNetworkOperation, error)
	UpdateNetworkOperation(name string) *UpdateNetworkOperation
	CreateVolumeSnapshot(context.Context, *baremetalsolutionpb.CreateVolumeSnapshotRequest, ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error)
	RestoreVolumeSnapshot(context.Context, *baremetalsolutionpb.RestoreVolumeSnapshotRequest, ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error)
	RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation
	DeleteVolumeSnapshot(context.Context, *baremetalsolutionpb.DeleteVolumeSnapshotRequest, ...gax.CallOption) error
	GetVolumeSnapshot(context.Context, *baremetalsolutionpb.GetVolumeSnapshotRequest, ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error)
	ListVolumeSnapshots(context.Context, *baremetalsolutionpb.ListVolumeSnapshotsRequest, ...gax.CallOption) *VolumeSnapshotIterator
	GetLun(context.Context, *baremetalsolutionpb.GetLunRequest, ...gax.CallOption) (*baremetalsolutionpb.Lun, error)
	ListLuns(context.Context, *baremetalsolutionpb.ListLunsRequest, ...gax.CallOption) *LunIterator
	EvictLun(context.Context, *baremetalsolutionpb.EvictLunRequest, ...gax.CallOption) (*EvictLunOperation, error)
	EvictLunOperation(name string) *EvictLunOperation
	GetNfsShare(context.Context, *baremetalsolutionpb.GetNfsShareRequest, ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error)
	ListNfsShares(context.Context, *baremetalsolutionpb.ListNfsSharesRequest, ...gax.CallOption) *NfsShareIterator
	UpdateNfsShare(context.Context, *baremetalsolutionpb.UpdateNfsShareRequest, ...gax.CallOption) (*UpdateNfsShareOperation, error)
	UpdateNfsShareOperation(name string) *UpdateNfsShareOperation
	CreateNfsShare(context.Context, *baremetalsolutionpb.CreateNfsShareRequest, ...gax.CallOption) (*CreateNfsShareOperation, error)
	CreateNfsShareOperation(name string) *CreateNfsShareOperation
	RenameNfsShare(context.Context, *baremetalsolutionpb.RenameNfsShareRequest, ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error)
	DeleteNfsShare(context.Context, *baremetalsolutionpb.DeleteNfsShareRequest, ...gax.CallOption) (*DeleteNfsShareOperation, error)
	DeleteNfsShareOperation(name string) *DeleteNfsShareOperation
	ListProvisioningQuotas(context.Context, *baremetalsolutionpb.ListProvisioningQuotasRequest, ...gax.CallOption) *ProvisioningQuotaIterator
	SubmitProvisioningConfig(context.Context, *baremetalsolutionpb.SubmitProvisioningConfigRequest, ...gax.CallOption) (*baremetalsolutionpb.SubmitProvisioningConfigResponse, error)
	GetProvisioningConfig(context.Context, *baremetalsolutionpb.GetProvisioningConfigRequest, ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error)
	CreateProvisioningConfig(context.Context, *baremetalsolutionpb.CreateProvisioningConfigRequest, ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error)
	UpdateProvisioningConfig(context.Context, *baremetalsolutionpb.UpdateProvisioningConfigRequest, ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error)
	RenameNetwork(context.Context, *baremetalsolutionpb.RenameNetworkRequest, ...gax.CallOption) (*baremetalsolutionpb.Network, error)
	ListOSImages(context.Context, *baremetalsolutionpb.ListOSImagesRequest, ...gax.CallOption) *OSImageIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
}

// Client is a client for interacting with Bare Metal Solution API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Performs management operations on Bare Metal Solution servers.
//
// The baremetalsolution.googleapis.com service provides management
// capabilities for Bare Metal Solution servers. To access the API methods, you
// must assign Bare Metal Solution IAM roles containing the desired permissions
// to your staff in your Google Cloud project. You must also enable the Bare
// Metal Solution API. Once enabled, the methods act
// upon specific servers in your Bare Metal Solution environment.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListInstances list servers in a given project and location.
func (c *Client) ListInstances(ctx context.Context, req *baremetalsolutionpb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	return c.internalClient.ListInstances(ctx, req, opts...)
}

// GetInstance get details about a single server.
func (c *Client) GetInstance(ctx context.Context, req *baremetalsolutionpb.GetInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	return c.internalClient.GetInstance(ctx, req, opts...)
}

// UpdateInstance update details of a single server.
func (c *Client) UpdateInstance(ctx context.Context, req *baremetalsolutionpb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	return c.internalClient.UpdateInstance(ctx, req, opts...)
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *Client) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	return c.internalClient.UpdateInstanceOperation(name)
}

// RenameInstance renameInstance sets a new name for an instance.
// Use with caution, previous names become immediately invalidated.
func (c *Client) RenameInstance(ctx context.Context, req *baremetalsolutionpb.RenameInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	return c.internalClient.RenameInstance(ctx, req, opts...)
}

// ResetInstance perform an ungraceful, hard reset on a server. Equivalent to shutting the
// power off and then turning it back on.
func (c *Client) ResetInstance(ctx context.Context, req *baremetalsolutionpb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	return c.internalClient.ResetInstance(ctx, req, opts...)
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *Client) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return c.internalClient.ResetInstanceOperation(name)
}

// StartInstance starts a server that was shutdown.
func (c *Client) StartInstance(ctx context.Context, req *baremetalsolutionpb.StartInstanceRequest, opts ...gax.CallOption) (*StartInstanceOperation, error) {
	return c.internalClient.StartInstance(ctx, req, opts...)
}

// StartInstanceOperation returns a new StartInstanceOperation from a given name.
// The name must be that of a previously created StartInstanceOperation, possibly from a different process.
func (c *Client) StartInstanceOperation(name string) *StartInstanceOperation {
	return c.internalClient.StartInstanceOperation(name)
}

// StopInstance stop a running server.
func (c *Client) StopInstance(ctx context.Context, req *baremetalsolutionpb.StopInstanceRequest, opts ...gax.CallOption) (*StopInstanceOperation, error) {
	return c.internalClient.StopInstance(ctx, req, opts...)
}

// StopInstanceOperation returns a new StopInstanceOperation from a given name.
// The name must be that of a previously created StopInstanceOperation, possibly from a different process.
func (c *Client) StopInstanceOperation(name string) *StopInstanceOperation {
	return c.internalClient.StopInstanceOperation(name)
}

// EnableInteractiveSerialConsole enable the interactive serial console feature on an instance.
func (c *Client) EnableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.EnableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*EnableInteractiveSerialConsoleOperation, error) {
	return c.internalClient.EnableInteractiveSerialConsole(ctx, req, opts...)
}

// EnableInteractiveSerialConsoleOperation returns a new EnableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created EnableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *Client) EnableInteractiveSerialConsoleOperation(name string) *EnableInteractiveSerialConsoleOperation {
	return c.internalClient.EnableInteractiveSerialConsoleOperation(name)
}

// DisableInteractiveSerialConsole disable the interactive serial console feature on an instance.
func (c *Client) DisableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.DisableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*DisableInteractiveSerialConsoleOperation, error) {
	return c.internalClient.DisableInteractiveSerialConsole(ctx, req, opts...)
}

// DisableInteractiveSerialConsoleOperation returns a new DisableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created DisableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *Client) DisableInteractiveSerialConsoleOperation(name string) *DisableInteractiveSerialConsoleOperation {
	return c.internalClient.DisableInteractiveSerialConsoleOperation(name)
}

// DetachLun detach LUN from Instance.
func (c *Client) DetachLun(ctx context.Context, req *baremetalsolutionpb.DetachLunRequest, opts ...gax.CallOption) (*DetachLunOperation, error) {
	return c.internalClient.DetachLun(ctx, req, opts...)
}

// DetachLunOperation returns a new DetachLunOperation from a given name.
// The name must be that of a previously created DetachLunOperation, possibly from a different process.
func (c *Client) DetachLunOperation(name string) *DetachLunOperation {
	return c.internalClient.DetachLunOperation(name)
}

// ListSSHKeys lists the public SSH keys registered for the specified project.
// These SSH keys are used only for the interactive serial console feature.
func (c *Client) ListSSHKeys(ctx context.Context, req *baremetalsolutionpb.ListSSHKeysRequest, opts ...gax.CallOption) *SSHKeyIterator {
	return c.internalClient.ListSSHKeys(ctx, req, opts...)
}

// CreateSSHKey register a public SSH key in the specified project for use with the
// interactive serial console feature.
func (c *Client) CreateSSHKey(ctx context.Context, req *baremetalsolutionpb.CreateSSHKeyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SSHKey, error) {
	return c.internalClient.CreateSSHKey(ctx, req, opts...)
}

// DeleteSSHKey deletes a public SSH key registered in the specified project.
func (c *Client) DeleteSSHKey(ctx context.Context, req *baremetalsolutionpb.DeleteSSHKeyRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSSHKey(ctx, req, opts...)
}

// ListVolumes list storage volumes in a given project and location.
func (c *Client) ListVolumes(ctx context.Context, req *baremetalsolutionpb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	return c.internalClient.ListVolumes(ctx, req, opts...)
}

// GetVolume get details of a single storage volume.
func (c *Client) GetVolume(ctx context.Context, req *baremetalsolutionpb.GetVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	return c.internalClient.GetVolume(ctx, req, opts...)
}

// UpdateVolume update details of a single storage volume.
func (c *Client) UpdateVolume(ctx context.Context, req *baremetalsolutionpb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	return c.internalClient.UpdateVolume(ctx, req, opts...)
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *Client) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return c.internalClient.UpdateVolumeOperation(name)
}

// RenameVolume renameVolume sets a new name for a volume.
// Use with caution, previous names become immediately invalidated.
func (c *Client) RenameVolume(ctx context.Context, req *baremetalsolutionpb.RenameVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	return c.internalClient.RenameVolume(ctx, req, opts...)
}

// EvictVolume skips volume’s cooloff and deletes it now.
// Volume must be in cooloff state.
func (c *Client) EvictVolume(ctx context.Context, req *baremetalsolutionpb.EvictVolumeRequest, opts ...gax.CallOption) (*EvictVolumeOperation, error) {
	return c.internalClient.EvictVolume(ctx, req, opts...)
}

// EvictVolumeOperation returns a new EvictVolumeOperation from a given name.
// The name must be that of a previously created EvictVolumeOperation, possibly from a different process.
func (c *Client) EvictVolumeOperation(name string) *EvictVolumeOperation {
	return c.internalClient.EvictVolumeOperation(name)
}

// ResizeVolume emergency Volume resize.
func (c *Client) ResizeVolume(ctx context.Context, req *baremetalsolutionpb.ResizeVolumeRequest, opts ...gax.CallOption) (*ResizeVolumeOperation, error) {
	return c.internalClient.ResizeVolume(ctx, req, opts...)
}

// ResizeVolumeOperation returns a new ResizeVolumeOperation from a given name.
// The name must be that of a previously created ResizeVolumeOperation, possibly from a different process.
func (c *Client) ResizeVolumeOperation(name string) *ResizeVolumeOperation {
	return c.internalClient.ResizeVolumeOperation(name)
}

// ListNetworks list network in a given project and location.
func (c *Client) ListNetworks(ctx context.Context, req *baremetalsolutionpb.ListNetworksRequest, opts ...gax.CallOption) *NetworkIterator {
	return c.internalClient.ListNetworks(ctx, req, opts...)
}

// ListNetworkUsage list all Networks (and used IPs for each Network) in the vendor account
// associated with the specified project.
func (c *Client) ListNetworkUsage(ctx context.Context, req *baremetalsolutionpb.ListNetworkUsageRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ListNetworkUsageResponse, error) {
	return c.internalClient.ListNetworkUsage(ctx, req, opts...)
}

// GetNetwork get details of a single network.
func (c *Client) GetNetwork(ctx context.Context, req *baremetalsolutionpb.GetNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	return c.internalClient.GetNetwork(ctx, req, opts...)
}

// UpdateNetwork update details of a single network.
func (c *Client) UpdateNetwork(ctx context.Context, req *baremetalsolutionpb.UpdateNetworkRequest, opts ...gax.CallOption) (*UpdateNetworkOperation, error) {
	return c.internalClient.UpdateNetwork(ctx, req, opts...)
}

// UpdateNetworkOperation returns a new UpdateNetworkOperation from a given name.
// The name must be that of a previously created UpdateNetworkOperation, possibly from a different process.
func (c *Client) UpdateNetworkOperation(name string) *UpdateNetworkOperation {
	return c.internalClient.UpdateNetworkOperation(name)
}

// CreateVolumeSnapshot takes a snapshot of a boot volume.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *Client) CreateVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.CreateVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	return c.internalClient.CreateVolumeSnapshot(ctx, req, opts...)
}

// RestoreVolumeSnapshot uses the specified snapshot to restore its parent volume.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *Client) RestoreVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.RestoreVolumeSnapshotRequest, opts ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error) {
	return c.internalClient.RestoreVolumeSnapshot(ctx, req, opts...)
}

// RestoreVolumeSnapshotOperation returns a new RestoreVolumeSnapshotOperation from a given name.
// The name must be that of a previously created RestoreVolumeSnapshotOperation, possibly from a different process.
func (c *Client) RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation {
	return c.internalClient.RestoreVolumeSnapshotOperation(name)
}

// DeleteVolumeSnapshot deletes a volume snapshot.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *Client) DeleteVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.DeleteVolumeSnapshotRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteVolumeSnapshot(ctx, req, opts...)
}

// GetVolumeSnapshot returns the specified snapshot resource.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *Client) GetVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.GetVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	return c.internalClient.GetVolumeSnapshot(ctx, req, opts...)
}

// ListVolumeSnapshots retrieves the list of snapshots for the specified volume.
// Returns a response with an empty list of snapshots if called
// for a non-boot volume.
func (c *Client) ListVolumeSnapshots(ctx context.Context, req *baremetalsolutionpb.ListVolumeSnapshotsRequest, opts ...gax.CallOption) *VolumeSnapshotIterator {
	return c.internalClient.ListVolumeSnapshots(ctx, req, opts...)
}

// GetLun get details of a single storage logical unit number(LUN).
func (c *Client) GetLun(ctx context.Context, req *baremetalsolutionpb.GetLunRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Lun, error) {
	return c.internalClient.GetLun(ctx, req, opts...)
}

// ListLuns list storage volume luns for given storage volume.
func (c *Client) ListLuns(ctx context.Context, req *baremetalsolutionpb.ListLunsRequest, opts ...gax.CallOption) *LunIterator {
	return c.internalClient.ListLuns(ctx, req, opts...)
}

// EvictLun skips lun’s cooloff and deletes it now.
// Lun must be in cooloff state.
func (c *Client) EvictLun(ctx context.Context, req *baremetalsolutionpb.EvictLunRequest, opts ...gax.CallOption) (*EvictLunOperation, error) {
	return c.internalClient.EvictLun(ctx, req, opts...)
}

// EvictLunOperation returns a new EvictLunOperation from a given name.
// The name must be that of a previously created EvictLunOperation, possibly from a different process.
func (c *Client) EvictLunOperation(name string) *EvictLunOperation {
	return c.internalClient.EvictLunOperation(name)
}

// GetNfsShare get details of a single NFS share.
func (c *Client) GetNfsShare(ctx context.Context, req *baremetalsolutionpb.GetNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	return c.internalClient.GetNfsShare(ctx, req, opts...)
}

// ListNfsShares list NFS shares.
func (c *Client) ListNfsShares(ctx context.Context, req *baremetalsolutionpb.ListNfsSharesRequest, opts ...gax.CallOption) *NfsShareIterator {
	return c.internalClient.ListNfsShares(ctx, req, opts...)
}

// UpdateNfsShare update details of a single NFS share.
func (c *Client) UpdateNfsShare(ctx context.Context, req *baremetalsolutionpb.UpdateNfsShareRequest, opts ...gax.CallOption) (*UpdateNfsShareOperation, error) {
	return c.internalClient.UpdateNfsShare(ctx, req, opts...)
}

// UpdateNfsShareOperation returns a new UpdateNfsShareOperation from a given name.
// The name must be that of a previously created UpdateNfsShareOperation, possibly from a different process.
func (c *Client) UpdateNfsShareOperation(name string) *UpdateNfsShareOperation {
	return c.internalClient.UpdateNfsShareOperation(name)
}

// CreateNfsShare create an NFS share.
func (c *Client) CreateNfsShare(ctx context.Context, req *baremetalsolutionpb.CreateNfsShareRequest, opts ...gax.CallOption) (*CreateNfsShareOperation, error) {
	return c.internalClient.CreateNfsShare(ctx, req, opts...)
}

// CreateNfsShareOperation returns a new CreateNfsShareOperation from a given name.
// The name must be that of a previously created CreateNfsShareOperation, possibly from a different process.
func (c *Client) CreateNfsShareOperation(name string) *CreateNfsShareOperation {
	return c.internalClient.CreateNfsShareOperation(name)
}

// RenameNfsShare renameNfsShare sets a new name for an nfsshare.
// Use with caution, previous names become immediately invalidated.
func (c *Client) RenameNfsShare(ctx context.Context, req *baremetalsolutionpb.RenameNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	return c.internalClient.RenameNfsShare(ctx, req, opts...)
}

// DeleteNfsShare delete an NFS share. The underlying volume is automatically deleted.
func (c *Client) DeleteNfsShare(ctx context.Context, req *baremetalsolutionpb.DeleteNfsShareRequest, opts ...gax.CallOption) (*DeleteNfsShareOperation, error) {
	return c.internalClient.DeleteNfsShare(ctx, req, opts...)
}

// DeleteNfsShareOperation returns a new DeleteNfsShareOperation from a given name.
// The name must be that of a previously created DeleteNfsShareOperation, possibly from a different process.
func (c *Client) DeleteNfsShareOperation(name string) *DeleteNfsShareOperation {
	return c.internalClient.DeleteNfsShareOperation(name)
}

// ListProvisioningQuotas list the budget details to provision resources on a given project.
func (c *Client) ListProvisioningQuotas(ctx context.Context, req *baremetalsolutionpb.ListProvisioningQuotasRequest, opts ...gax.CallOption) *ProvisioningQuotaIterator {
	return c.internalClient.ListProvisioningQuotas(ctx, req, opts...)
}

// SubmitProvisioningConfig submit a provisiong configuration for a given project.
func (c *Client) SubmitProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.SubmitProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SubmitProvisioningConfigResponse, error) {
	return c.internalClient.SubmitProvisioningConfig(ctx, req, opts...)
}

// GetProvisioningConfig get ProvisioningConfig by name.
func (c *Client) GetProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.GetProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	return c.internalClient.GetProvisioningConfig(ctx, req, opts...)
}

// CreateProvisioningConfig create new ProvisioningConfig.
func (c *Client) CreateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.CreateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	return c.internalClient.CreateProvisioningConfig(ctx, req, opts...)
}

// UpdateProvisioningConfig update existing ProvisioningConfig.
func (c *Client) UpdateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.UpdateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	return c.internalClient.UpdateProvisioningConfig(ctx, req, opts...)
}

// RenameNetwork renameNetwork sets a new name for a network.
// Use with caution, previous names become immediately invalidated.
func (c *Client) RenameNetwork(ctx context.Context, req *baremetalsolutionpb.RenameNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	return c.internalClient.RenameNetwork(ctx, req, opts...)
}

// ListOSImages retrieves the list of OS images which are currently approved.
func (c *Client) ListOSImages(ctx context.Context, req *baremetalsolutionpb.ListOSImagesRequest, opts ...gax.CallOption) *OSImageIterator {
	return c.internalClient.ListOSImages(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Bare Metal Solution API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client baremetalsolutionpb.BareMetalSolutionClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewClient creates a new bare metal solution client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Performs management operations on Bare Metal Solution servers.
//
// The baremetalsolution.googleapis.com service provides management
// capabilities for Bare Metal Solution servers. To access the API methods, you
// must assign Bare Metal Solution IAM roles containing the desired permissions
// to your staff in your Google Cloud project. You must also enable the Bare
// Metal Solution API. Once enabled, the methods act
// upon specific servers in your Bare Metal Solution environment.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:        connPool,
		client:          baremetalsolutionpb.NewBareMetalSolutionClient(connPool),
		CallOptions:     &client.CallOptions,
		locationsClient: locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new bare metal solution rest client.
//
// Performs management operations on Bare Metal Solution servers.
//
// The baremetalsolution.googleapis.com service provides management
// capabilities for Bare Metal Solution servers. To access the API methods, you
// must assign Bare Metal Solution IAM roles containing the desired permissions
// to your staff in your Google Cloud project. You must also enable the Bare
// Metal Solution API. Once enabled, the methods act
// upon specific servers in your Bare Metal Solution environment.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://baremetalsolution.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://baremetalsolution.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://baremetalsolution.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://baremetalsolution.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListInstances(ctx context.Context, req *baremetalsolutionpb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListInstances[0:len((*c.CallOptions).ListInstances):len((*c.CallOptions).ListInstances)], opts...)
	it := &InstanceIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListInstancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Instance, string, error) {
		resp := &baremetalsolutionpb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListInstances(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetInstance(ctx context.Context, req *baremetalsolutionpb.GetInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	var resp *baremetalsolutionpb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateInstance(ctx context.Context, req *baremetalsolutionpb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance.name", url.QueryEscape(req.GetInstance().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateInstance[0:len((*c.CallOptions).UpdateInstance):len((*c.CallOptions).UpdateInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RenameInstance(ctx context.Context, req *baremetalsolutionpb.RenameInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RenameInstance[0:len((*c.CallOptions).RenameInstance):len((*c.CallOptions).RenameInstance)], opts...)
	var resp *baremetalsolutionpb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RenameInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ResetInstance(ctx context.Context, req *baremetalsolutionpb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResetInstance[0:len((*c.CallOptions).ResetInstance):len((*c.CallOptions).ResetInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ResetInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) StartInstance(ctx context.Context, req *baremetalsolutionpb.StartInstanceRequest, opts ...gax.CallOption) (*StartInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartInstance[0:len((*c.CallOptions).StartInstance):len((*c.CallOptions).StartInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.StartInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) StopInstance(ctx context.Context, req *baremetalsolutionpb.StopInstanceRequest, opts ...gax.CallOption) (*StopInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopInstance[0:len((*c.CallOptions).StopInstance):len((*c.CallOptions).StopInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.StopInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) EnableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.EnableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*EnableInteractiveSerialConsoleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EnableInteractiveSerialConsole[0:len((*c.CallOptions).EnableInteractiveSerialConsole):len((*c.CallOptions).EnableInteractiveSerialConsole)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.EnableInteractiveSerialConsole(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EnableInteractiveSerialConsoleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DisableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.DisableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*DisableInteractiveSerialConsoleOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DisableInteractiveSerialConsole[0:len((*c.CallOptions).DisableInteractiveSerialConsole):len((*c.CallOptions).DisableInteractiveSerialConsole)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DisableInteractiveSerialConsole(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DisableInteractiveSerialConsoleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DetachLun(ctx context.Context, req *baremetalsolutionpb.DetachLunRequest, opts ...gax.CallOption) (*DetachLunOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance", url.QueryEscape(req.GetInstance()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DetachLun[0:len((*c.CallOptions).DetachLun):len((*c.CallOptions).DetachLun)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DetachLun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DetachLunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListSSHKeys(ctx context.Context, req *baremetalsolutionpb.ListSSHKeysRequest, opts ...gax.CallOption) *SSHKeyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSSHKeys[0:len((*c.CallOptions).ListSSHKeys):len((*c.CallOptions).ListSSHKeys)], opts...)
	it := &SSHKeyIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListSSHKeysRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.SSHKey, string, error) {
		resp := &baremetalsolutionpb.ListSSHKeysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSSHKeys(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSshKeys(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateSSHKey(ctx context.Context, req *baremetalsolutionpb.CreateSSHKeyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SSHKey, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSSHKey[0:len((*c.CallOptions).CreateSSHKey):len((*c.CallOptions).CreateSSHKey)], opts...)
	var resp *baremetalsolutionpb.SSHKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateSSHKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteSSHKey(ctx context.Context, req *baremetalsolutionpb.DeleteSSHKeyRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSSHKey[0:len((*c.CallOptions).DeleteSSHKey):len((*c.CallOptions).DeleteSSHKey)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteSSHKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) ListVolumes(ctx context.Context, req *baremetalsolutionpb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListVolumes[0:len((*c.CallOptions).ListVolumes):len((*c.CallOptions).ListVolumes)], opts...)
	it := &VolumeIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Volume, string, error) {
		resp := &baremetalsolutionpb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListVolumes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetVolume(ctx context.Context, req *baremetalsolutionpb.GetVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	var resp *baremetalsolutionpb.Volume
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateVolume(ctx context.Context, req *baremetalsolutionpb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateVolume[0:len((*c.CallOptions).UpdateVolume):len((*c.CallOptions).UpdateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RenameVolume(ctx context.Context, req *baremetalsolutionpb.RenameVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RenameVolume[0:len((*c.CallOptions).RenameVolume):len((*c.CallOptions).RenameVolume)], opts...)
	var resp *baremetalsolutionpb.Volume
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RenameVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) EvictVolume(ctx context.Context, req *baremetalsolutionpb.EvictVolumeRequest, opts ...gax.CallOption) (*EvictVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EvictVolume[0:len((*c.CallOptions).EvictVolume):len((*c.CallOptions).EvictVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.EvictVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EvictVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ResizeVolume(ctx context.Context, req *baremetalsolutionpb.ResizeVolumeRequest, opts ...gax.CallOption) (*ResizeVolumeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume", url.QueryEscape(req.GetVolume()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResizeVolume[0:len((*c.CallOptions).ResizeVolume):len((*c.CallOptions).ResizeVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ResizeVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResizeVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListNetworks(ctx context.Context, req *baremetalsolutionpb.ListNetworksRequest, opts ...gax.CallOption) *NetworkIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNetworks[0:len((*c.CallOptions).ListNetworks):len((*c.CallOptions).ListNetworks)], opts...)
	it := &NetworkIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListNetworksRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Network, string, error) {
		resp := &baremetalsolutionpb.ListNetworksResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListNetworks(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNetworks(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ListNetworkUsage(ctx context.Context, req *baremetalsolutionpb.ListNetworkUsageRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ListNetworkUsageResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "location", url.QueryEscape(req.GetLocation()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNetworkUsage[0:len((*c.CallOptions).ListNetworkUsage):len((*c.CallOptions).ListNetworkUsage)], opts...)
	var resp *baremetalsolutionpb.ListNetworkUsageResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ListNetworkUsage(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetNetwork(ctx context.Context, req *baremetalsolutionpb.GetNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNetwork[0:len((*c.CallOptions).GetNetwork):len((*c.CallOptions).GetNetwork)], opts...)
	var resp *baremetalsolutionpb.Network
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetNetwork(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateNetwork(ctx context.Context, req *baremetalsolutionpb.UpdateNetworkRequest, opts ...gax.CallOption) (*UpdateNetworkOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "network.name", url.QueryEscape(req.GetNetwork().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNetwork[0:len((*c.CallOptions).UpdateNetwork):len((*c.CallOptions).UpdateNetwork)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateNetwork(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateNetworkOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.CreateVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateVolumeSnapshot[0:len((*c.CallOptions).CreateVolumeSnapshot):len((*c.CallOptions).CreateVolumeSnapshot)], opts...)
	var resp *baremetalsolutionpb.VolumeSnapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RestoreVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.RestoreVolumeSnapshotRequest, opts ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume_snapshot", url.QueryEscape(req.GetVolumeSnapshot()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RestoreVolumeSnapshot[0:len((*c.CallOptions).RestoreVolumeSnapshot):len((*c.CallOptions).RestoreVolumeSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RestoreVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RestoreVolumeSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.DeleteVolumeSnapshotRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteVolumeSnapshot[0:len((*c.CallOptions).DeleteVolumeSnapshot):len((*c.CallOptions).DeleteVolumeSnapshot)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.GetVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVolumeSnapshot[0:len((*c.CallOptions).GetVolumeSnapshot):len((*c.CallOptions).GetVolumeSnapshot)], opts...)
	var resp *baremetalsolutionpb.VolumeSnapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListVolumeSnapshots(ctx context.Context, req *baremetalsolutionpb.ListVolumeSnapshotsRequest, opts ...gax.CallOption) *VolumeSnapshotIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListVolumeSnapshots[0:len((*c.CallOptions).ListVolumeSnapshots):len((*c.CallOptions).ListVolumeSnapshots)], opts...)
	it := &VolumeSnapshotIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumeSnapshotsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.VolumeSnapshot, string, error) {
		resp := &baremetalsolutionpb.ListVolumeSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListVolumeSnapshots(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumeSnapshots(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetLun(ctx context.Context, req *baremetalsolutionpb.GetLunRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Lun, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLun[0:len((*c.CallOptions).GetLun):len((*c.CallOptions).GetLun)], opts...)
	var resp *baremetalsolutionpb.Lun
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetLun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLuns(ctx context.Context, req *baremetalsolutionpb.ListLunsRequest, opts ...gax.CallOption) *LunIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLuns[0:len((*c.CallOptions).ListLuns):len((*c.CallOptions).ListLuns)], opts...)
	it := &LunIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListLunsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Lun, string, error) {
		resp := &baremetalsolutionpb.ListLunsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListLuns(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLuns(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) EvictLun(ctx context.Context, req *baremetalsolutionpb.EvictLunRequest, opts ...gax.CallOption) (*EvictLunOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EvictLun[0:len((*c.CallOptions).EvictLun):len((*c.CallOptions).EvictLun)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.EvictLun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EvictLunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetNfsShare(ctx context.Context, req *baremetalsolutionpb.GetNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNfsShare[0:len((*c.CallOptions).GetNfsShare):len((*c.CallOptions).GetNfsShare)], opts...)
	var resp *baremetalsolutionpb.NfsShare
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetNfsShare(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListNfsShares(ctx context.Context, req *baremetalsolutionpb.ListNfsSharesRequest, opts ...gax.CallOption) *NfsShareIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNfsShares[0:len((*c.CallOptions).ListNfsShares):len((*c.CallOptions).ListNfsShares)], opts...)
	it := &NfsShareIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListNfsSharesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.NfsShare, string, error) {
		resp := &baremetalsolutionpb.ListNfsSharesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListNfsShares(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNfsShares(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) UpdateNfsShare(ctx context.Context, req *baremetalsolutionpb.UpdateNfsShareRequest, opts ...gax.CallOption) (*UpdateNfsShareOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "nfs_share.name", url.QueryEscape(req.GetNfsShare().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNfsShare[0:len((*c.CallOptions).UpdateNfsShare):len((*c.CallOptions).UpdateNfsShare)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateNfsShare(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateNfsShare(ctx context.Context, req *baremetalsolutionpb.CreateNfsShareRequest, opts ...gax.CallOption) (*CreateNfsShareOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateNfsShare[0:len((*c.CallOptions).CreateNfsShare):len((*c.CallOptions).CreateNfsShare)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateNfsShare(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RenameNfsShare(ctx context.Context, req *baremetalsolutionpb.RenameNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RenameNfsShare[0:len((*c.CallOptions).RenameNfsShare):len((*c.CallOptions).RenameNfsShare)], opts...)
	var resp *baremetalsolutionpb.NfsShare
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RenameNfsShare(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteNfsShare(ctx context.Context, req *baremetalsolutionpb.DeleteNfsShareRequest, opts ...gax.CallOption) (*DeleteNfsShareOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteNfsShare[0:len((*c.CallOptions).DeleteNfsShare):len((*c.CallOptions).DeleteNfsShare)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteNfsShare(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListProvisioningQuotas(ctx context.Context, req *baremetalsolutionpb.ListProvisioningQuotasRequest, opts ...gax.CallOption) *ProvisioningQuotaIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListProvisioningQuotas[0:len((*c.CallOptions).ListProvisioningQuotas):len((*c.CallOptions).ListProvisioningQuotas)], opts...)
	it := &ProvisioningQuotaIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListProvisioningQuotasRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.ProvisioningQuota, string, error) {
		resp := &baremetalsolutionpb.ListProvisioningQuotasResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListProvisioningQuotas(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetProvisioningQuotas(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SubmitProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.SubmitProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SubmitProvisioningConfigResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SubmitProvisioningConfig[0:len((*c.CallOptions).SubmitProvisioningConfig):len((*c.CallOptions).SubmitProvisioningConfig)], opts...)
	var resp *baremetalsolutionpb.SubmitProvisioningConfigResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.SubmitProvisioningConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.GetProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetProvisioningConfig[0:len((*c.CallOptions).GetProvisioningConfig):len((*c.CallOptions).GetProvisioningConfig)], opts...)
	var resp *baremetalsolutionpb.ProvisioningConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetProvisioningConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.CreateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateProvisioningConfig[0:len((*c.CallOptions).CreateProvisioningConfig):len((*c.CallOptions).CreateProvisioningConfig)], opts...)
	var resp *baremetalsolutionpb.ProvisioningConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateProvisioningConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.UpdateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "provisioning_config.name", url.QueryEscape(req.GetProvisioningConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProvisioningConfig[0:len((*c.CallOptions).UpdateProvisioningConfig):len((*c.CallOptions).UpdateProvisioningConfig)], opts...)
	var resp *baremetalsolutionpb.ProvisioningConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateProvisioningConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RenameNetwork(ctx context.Context, req *baremetalsolutionpb.RenameNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RenameNetwork[0:len((*c.CallOptions).RenameNetwork):len((*c.CallOptions).RenameNetwork)], opts...)
	var resp *baremetalsolutionpb.Network
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RenameNetwork(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOSImages(ctx context.Context, req *baremetalsolutionpb.ListOSImagesRequest, opts ...gax.CallOption) *OSImageIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOSImages[0:len((*c.CallOptions).ListOSImages):len((*c.CallOptions).ListOSImages)], opts...)
	it := &OSImageIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListOSImagesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.OSImage, string, error) {
		resp := &baremetalsolutionpb.ListOSImagesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListOSImages(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOsImages(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListInstances list servers in a given project and location.
func (c *restClient) ListInstances(ctx context.Context, req *baremetalsolutionpb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	it := &InstanceIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListInstancesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Instance, string, error) {
		resp := &baremetalsolutionpb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/instances", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetInstance get details about a single server.
func (c *restClient) GetInstance(ctx context.Context, req *baremetalsolutionpb.GetInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Instance{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateInstance update details of a single server.
func (c *restClient) UpdateInstance(ctx context.Context, req *baremetalsolutionpb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetInstance()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetInstance().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance.name", url.QueryEscape(req.GetInstance().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &UpdateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RenameInstance renameInstance sets a new name for an instance.
// Use with caution, previous names become immediately invalidated.
func (c *restClient) RenameInstance(ctx context.Context, req *baremetalsolutionpb.RenameInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:rename", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RenameInstance[0:len((*c.CallOptions).RenameInstance):len((*c.CallOptions).RenameInstance)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Instance{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ResetInstance perform an ungraceful, hard reset on a server. Equivalent to shutting the
// power off and then turning it back on.
func (c *restClient) ResetInstance(ctx context.Context, req *baremetalsolutionpb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:reset", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &ResetInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StartInstance starts a server that was shutdown.
func (c *restClient) StartInstance(ctx context.Context, req *baremetalsolutionpb.StartInstanceRequest, opts ...gax.CallOption) (*StartInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:start", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &StartInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StopInstance stop a running server.
func (c *restClient) StopInstance(ctx context.Context, req *baremetalsolutionpb.StopInstanceRequest, opts ...gax.CallOption) (*StopInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:stop", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &StopInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// EnableInteractiveSerialConsole enable the interactive serial console feature on an instance.
func (c *restClient) EnableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.EnableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*EnableInteractiveSerialConsoleOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:enableInteractiveSerialConsole", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &EnableInteractiveSerialConsoleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DisableInteractiveSerialConsole disable the interactive serial console feature on an instance.
func (c *restClient) DisableInteractiveSerialConsole(ctx context.Context, req *baremetalsolutionpb.DisableInteractiveSerialConsoleRequest, opts ...gax.CallOption) (*DisableInteractiveSerialConsoleOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:disableInteractiveSerialConsole", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &DisableInteractiveSerialConsoleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DetachLun detach LUN from Instance.
func (c *restClient) DetachLun(ctx context.Context, req *baremetalsolutionpb.DetachLunRequest, opts ...gax.CallOption) (*DetachLunOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:detachLun", req.GetInstance())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance", url.QueryEscape(req.GetInstance()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &DetachLunOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListSSHKeys lists the public SSH keys registered for the specified project.
// These SSH keys are used only for the interactive serial console feature.
func (c *restClient) ListSSHKeys(ctx context.Context, req *baremetalsolutionpb.ListSSHKeysRequest, opts ...gax.CallOption) *SSHKeyIterator {
	it := &SSHKeyIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListSSHKeysRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.SSHKey, string, error) {
		resp := &baremetalsolutionpb.ListSSHKeysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/sshKeys", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSshKeys(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateSSHKey register a public SSH key in the specified project for use with the
// interactive serial console feature.
func (c *restClient) CreateSSHKey(ctx context.Context, req *baremetalsolutionpb.CreateSSHKeyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SSHKey, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSshKey()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/sshKeys", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("sshKeyId", fmt.Sprintf("%v", req.GetSshKeyId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateSSHKey[0:len((*c.CallOptions).CreateSSHKey):len((*c.CallOptions).CreateSSHKey)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.SSHKey{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteSSHKey deletes a public SSH key registered in the specified project.
func (c *restClient) DeleteSSHKey(ctx context.Context, req *baremetalsolutionpb.DeleteSSHKeyRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// ListVolumes list storage volumes in a given project and location.
func (c *restClient) ListVolumes(ctx context.Context, req *baremetalsolutionpb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	it := &VolumeIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Volume, string, error) {
		resp := &baremetalsolutionpb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/volumes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetVolume get details of a single storage volume.
func (c *restClient) GetVolume(ctx context.Context, req *baremetalsolutionpb.GetVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Volume{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateVolume update details of a single storage volume.
func (c *restClient) UpdateVolume(ctx context.Context, req *baremetalsolutionpb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolume()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetVolume().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RenameVolume renameVolume sets a new name for a volume.
// Use with caution, previous names become immediately invalidated.
func (c *restClient) RenameVolume(ctx context.Context, req *baremetalsolutionpb.RenameVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:rename", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RenameVolume[0:len((*c.CallOptions).RenameVolume):len((*c.CallOptions).RenameVolume)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Volume{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// EvictVolume skips volume’s cooloff and deletes it now.
// Volume must be in cooloff state.
func (c *restClient) EvictVolume(ctx context.Context, req *baremetalsolutionpb.EvictVolumeRequest, opts ...gax.CallOption) (*EvictVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:evict", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &EvictVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ResizeVolume emergency Volume resize.
func (c *restClient) ResizeVolume(ctx context.Context, req *baremetalsolutionpb.ResizeVolumeRequest, opts ...gax.CallOption) (*ResizeVolumeOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:resize", req.GetVolume())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume", url.QueryEscape(req.GetVolume()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &ResizeVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListNetworks list network in a given project and location.
func (c *restClient) ListNetworks(ctx context.Context, req *baremetalsolutionpb.ListNetworksRequest, opts ...gax.CallOption) *NetworkIterator {
	it := &NetworkIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListNetworksRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Network, string, error) {
		resp := &baremetalsolutionpb.ListNetworksResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/networks", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNetworks(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListNetworkUsage list all Networks (and used IPs for each Network) in the vendor account
// associated with the specified project.
func (c *restClient) ListNetworkUsage(ctx context.Context, req *baremetalsolutionpb.ListNetworkUsageRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ListNetworkUsageResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/networks:listNetworkUsage", req.GetLocation())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "location", url.QueryEscape(req.GetLocation()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ListNetworkUsage[0:len((*c.CallOptions).ListNetworkUsage):len((*c.CallOptions).ListNetworkUsage)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.ListNetworkUsageResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetNetwork get details of a single network.
func (c *restClient) GetNetwork(ctx context.Context, req *baremetalsolutionpb.GetNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNetwork[0:len((*c.CallOptions).GetNetwork):len((*c.CallOptions).GetNetwork)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Network{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateNetwork update details of a single network.
func (c *restClient) UpdateNetwork(ctx context.Context, req *baremetalsolutionpb.UpdateNetworkRequest, opts ...gax.CallOption) (*UpdateNetworkOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNetwork()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetNetwork().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "network.name", url.QueryEscape(req.GetNetwork().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &UpdateNetworkOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateVolumeSnapshot takes a snapshot of a boot volume.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *restClient) CreateVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.CreateVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetVolumeSnapshot()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/snapshots", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateVolumeSnapshot[0:len((*c.CallOptions).CreateVolumeSnapshot):len((*c.CallOptions).CreateVolumeSnapshot)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.VolumeSnapshot{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RestoreVolumeSnapshot uses the specified snapshot to restore its parent volume.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *restClient) RestoreVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.RestoreVolumeSnapshotRequest, opts ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:restoreVolumeSnapshot", req.GetVolumeSnapshot())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "volume_snapshot", url.QueryEscape(req.GetVolumeSnapshot()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &RestoreVolumeSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteVolumeSnapshot deletes a volume snapshot.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *restClient) DeleteVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.DeleteVolumeSnapshotRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetVolumeSnapshot returns the specified snapshot resource.
// Returns INVALID_ARGUMENT if called for a non-boot volume.
func (c *restClient) GetVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.GetVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetVolumeSnapshot[0:len((*c.CallOptions).GetVolumeSnapshot):len((*c.CallOptions).GetVolumeSnapshot)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.VolumeSnapshot{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListVolumeSnapshots retrieves the list of snapshots for the specified volume.
// Returns a response with an empty list of snapshots if called
// for a non-boot volume.
func (c *restClient) ListVolumeSnapshots(ctx context.Context, req *baremetalsolutionpb.ListVolumeSnapshotsRequest, opts ...gax.CallOption) *VolumeSnapshotIterator {
	it := &VolumeSnapshotIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumeSnapshotsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.VolumeSnapshot, string, error) {
		resp := &baremetalsolutionpb.ListVolumeSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/snapshots", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetVolumeSnapshots(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetLun get details of a single storage logical unit number(LUN).
func (c *restClient) GetLun(ctx context.Context, req *baremetalsolutionpb.GetLunRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Lun, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLun[0:len((*c.CallOptions).GetLun):len((*c.CallOptions).GetLun)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Lun{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLuns list storage volume luns for given storage volume.
func (c *restClient) ListLuns(ctx context.Context, req *baremetalsolutionpb.ListLunsRequest, opts ...gax.CallOption) *LunIterator {
	it := &LunIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListLunsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Lun, string, error) {
		resp := &baremetalsolutionpb.ListLunsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/luns", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLuns(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// EvictLun skips lun’s cooloff and deletes it now.
// Lun must be in cooloff state.
func (c *restClient) EvictLun(ctx context.Context, req *baremetalsolutionpb.EvictLunRequest, opts ...gax.CallOption) (*EvictLunOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:evict", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &EvictLunOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetNfsShare get details of a single NFS share.
func (c *restClient) GetNfsShare(ctx context.Context, req *baremetalsolutionpb.GetNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNfsShare[0:len((*c.CallOptions).GetNfsShare):len((*c.CallOptions).GetNfsShare)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.NfsShare{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListNfsShares list NFS shares.
func (c *restClient) ListNfsShares(ctx context.Context, req *baremetalsolutionpb.ListNfsSharesRequest, opts ...gax.CallOption) *NfsShareIterator {
	it := &NfsShareIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListNfsSharesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.NfsShare, string, error) {
		resp := &baremetalsolutionpb.ListNfsSharesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/nfsShares", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNfsShares(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateNfsShare update details of a single NFS share.
func (c *restClient) UpdateNfsShare(ctx context.Context, req *baremetalsolutionpb.UpdateNfsShareRequest, opts ...gax.CallOption) (*UpdateNfsShareOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNfsShare()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetNfsShare().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "nfs_share.name", url.QueryEscape(req.GetNfsShare().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &UpdateNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateNfsShare create an NFS share.
func (c *restClient) CreateNfsShare(ctx context.Context, req *baremetalsolutionpb.CreateNfsShareRequest, opts ...gax.CallOption) (*CreateNfsShareOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNfsShare()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/nfsShares", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &CreateNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RenameNfsShare renameNfsShare sets a new name for an nfsshare.
// Use with caution, previous names become immediately invalidated.
func (c *restClient) RenameNfsShare(ctx context.Context, req *baremetalsolutionpb.RenameNfsShareRequest, opts ...gax.CallOption) (*baremetalsolutionpb.NfsShare, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:rename", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RenameNfsShare[0:len((*c.CallOptions).RenameNfsShare):len((*c.CallOptions).RenameNfsShare)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.NfsShare{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteNfsShare delete an NFS share. The underlying volume is automatically deleted.
func (c *restClient) DeleteNfsShare(ctx context.Context, req *baremetalsolutionpb.DeleteNfsShareRequest, opts ...gax.CallOption) (*DeleteNfsShareOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v2/%s", resp.GetName())
	return &DeleteNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListProvisioningQuotas list the budget details to provision resources on a given project.
func (c *restClient) ListProvisioningQuotas(ctx context.Context, req *baremetalsolutionpb.ListProvisioningQuotasRequest, opts ...gax.CallOption) *ProvisioningQuotaIterator {
	it := &ProvisioningQuotaIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListProvisioningQuotasRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.ProvisioningQuota, string, error) {
		resp := &baremetalsolutionpb.ListProvisioningQuotasResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/provisioningQuotas", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetProvisioningQuotas(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SubmitProvisioningConfig submit a provisiong configuration for a given project.
func (c *restClient) SubmitProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.SubmitProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SubmitProvisioningConfigResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/provisioningConfigs:submit", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SubmitProvisioningConfig[0:len((*c.CallOptions).SubmitProvisioningConfig):len((*c.CallOptions).SubmitProvisioningConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.SubmitProvisioningConfigResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetProvisioningConfig get ProvisioningConfig by name.
func (c *restClient) GetProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.GetProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetProvisioningConfig[0:len((*c.CallOptions).GetProvisioningConfig):len((*c.CallOptions).GetProvisioningConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.ProvisioningConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateProvisioningConfig create new ProvisioningConfig.
func (c *restClient) CreateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.CreateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProvisioningConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/provisioningConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEmail() != "" {
		params.Add("email", fmt.Sprintf("%v", req.GetEmail()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateProvisioningConfig[0:len((*c.CallOptions).CreateProvisioningConfig):len((*c.CallOptions).CreateProvisioningConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.ProvisioningConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateProvisioningConfig update existing ProvisioningConfig.
func (c *restClient) UpdateProvisioningConfig(ctx context.Context, req *baremetalsolutionpb.UpdateProvisioningConfigRequest, opts ...gax.CallOption) (*baremetalsolutionpb.ProvisioningConfig, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProvisioningConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetProvisioningConfig().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEmail() != "" {
		params.Add("email", fmt.Sprintf("%v", req.GetEmail()))
	}
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "provisioning_config.name", url.QueryEscape(req.GetProvisioningConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProvisioningConfig[0:len((*c.CallOptions).UpdateProvisioningConfig):len((*c.CallOptions).UpdateProvisioningConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.ProvisioningConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RenameNetwork renameNetwork sets a new name for a network.
// Use with caution, previous names become immediately invalidated.
func (c *restClient) RenameNetwork(ctx context.Context, req *baremetalsolutionpb.RenameNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v:rename", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RenameNetwork[0:len((*c.CallOptions).RenameNetwork):len((*c.CallOptions).RenameNetwork)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &baremetalsolutionpb.Network{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOSImages retrieves the list of OS images which are currently approved.
func (c *restClient) ListOSImages(ctx context.Context, req *baremetalsolutionpb.ListOSImagesRequest, opts ...gax.CallOption) *OSImageIterator {
	it := &OSImageIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListOSImagesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.OSImage, string, error) {
		resp := &baremetalsolutionpb.ListOSImagesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/osImages", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOsImages(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v2/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateNfsShareOperation returns a new CreateNfsShareOperation from a given name.
// The name must be that of a previously created CreateNfsShareOperation, possibly from a different process.
func (c *gRPCClient) CreateNfsShareOperation(name string) *CreateNfsShareOperation {
	return &CreateNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateNfsShareOperation returns a new CreateNfsShareOperation from a given name.
// The name must be that of a previously created CreateNfsShareOperation, possibly from a different process.
func (c *restClient) CreateNfsShareOperation(name string) *CreateNfsShareOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &CreateNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteNfsShareOperation returns a new DeleteNfsShareOperation from a given name.
// The name must be that of a previously created DeleteNfsShareOperation, possibly from a different process.
func (c *gRPCClient) DeleteNfsShareOperation(name string) *DeleteNfsShareOperation {
	return &DeleteNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteNfsShareOperation returns a new DeleteNfsShareOperation from a given name.
// The name must be that of a previously created DeleteNfsShareOperation, possibly from a different process.
func (c *restClient) DeleteNfsShareOperation(name string) *DeleteNfsShareOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &DeleteNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DetachLunOperation returns a new DetachLunOperation from a given name.
// The name must be that of a previously created DetachLunOperation, possibly from a different process.
func (c *gRPCClient) DetachLunOperation(name string) *DetachLunOperation {
	return &DetachLunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DetachLunOperation returns a new DetachLunOperation from a given name.
// The name must be that of a previously created DetachLunOperation, possibly from a different process.
func (c *restClient) DetachLunOperation(name string) *DetachLunOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &DetachLunOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DisableInteractiveSerialConsoleOperation returns a new DisableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created DisableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *gRPCClient) DisableInteractiveSerialConsoleOperation(name string) *DisableInteractiveSerialConsoleOperation {
	return &DisableInteractiveSerialConsoleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DisableInteractiveSerialConsoleOperation returns a new DisableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created DisableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *restClient) DisableInteractiveSerialConsoleOperation(name string) *DisableInteractiveSerialConsoleOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &DisableInteractiveSerialConsoleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EnableInteractiveSerialConsoleOperation returns a new EnableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created EnableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *gRPCClient) EnableInteractiveSerialConsoleOperation(name string) *EnableInteractiveSerialConsoleOperation {
	return &EnableInteractiveSerialConsoleOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EnableInteractiveSerialConsoleOperation returns a new EnableInteractiveSerialConsoleOperation from a given name.
// The name must be that of a previously created EnableInteractiveSerialConsoleOperation, possibly from a different process.
func (c *restClient) EnableInteractiveSerialConsoleOperation(name string) *EnableInteractiveSerialConsoleOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &EnableInteractiveSerialConsoleOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EvictLunOperation returns a new EvictLunOperation from a given name.
// The name must be that of a previously created EvictLunOperation, possibly from a different process.
func (c *gRPCClient) EvictLunOperation(name string) *EvictLunOperation {
	return &EvictLunOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EvictLunOperation returns a new EvictLunOperation from a given name.
// The name must be that of a previously created EvictLunOperation, possibly from a different process.
func (c *restClient) EvictLunOperation(name string) *EvictLunOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &EvictLunOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EvictVolumeOperation returns a new EvictVolumeOperation from a given name.
// The name must be that of a previously created EvictVolumeOperation, possibly from a different process.
func (c *gRPCClient) EvictVolumeOperation(name string) *EvictVolumeOperation {
	return &EvictVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EvictVolumeOperation returns a new EvictVolumeOperation from a given name.
// The name must be that of a previously created EvictVolumeOperation, possibly from a different process.
func (c *restClient) EvictVolumeOperation(name string) *EvictVolumeOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &EvictVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *gRPCClient) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *restClient) ResetInstanceOperation(name string) *ResetInstanceOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &ResetInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ResizeVolumeOperation returns a new ResizeVolumeOperation from a given name.
// The name must be that of a previously created ResizeVolumeOperation, possibly from a different process.
func (c *gRPCClient) ResizeVolumeOperation(name string) *ResizeVolumeOperation {
	return &ResizeVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResizeVolumeOperation returns a new ResizeVolumeOperation from a given name.
// The name must be that of a previously created ResizeVolumeOperation, possibly from a different process.
func (c *restClient) ResizeVolumeOperation(name string) *ResizeVolumeOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &ResizeVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RestoreVolumeSnapshotOperation returns a new RestoreVolumeSnapshotOperation from a given name.
// The name must be that of a previously created RestoreVolumeSnapshotOperation, possibly from a different process.
func (c *gRPCClient) RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation {
	return &RestoreVolumeSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RestoreVolumeSnapshotOperation returns a new RestoreVolumeSnapshotOperation from a given name.
// The name must be that of a previously created RestoreVolumeSnapshotOperation, possibly from a different process.
func (c *restClient) RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &RestoreVolumeSnapshotOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StartInstanceOperation returns a new StartInstanceOperation from a given name.
// The name must be that of a previously created StartInstanceOperation, possibly from a different process.
func (c *gRPCClient) StartInstanceOperation(name string) *StartInstanceOperation {
	return &StartInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartInstanceOperation returns a new StartInstanceOperation from a given name.
// The name must be that of a previously created StartInstanceOperation, possibly from a different process.
func (c *restClient) StartInstanceOperation(name string) *StartInstanceOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &StartInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StopInstanceOperation returns a new StopInstanceOperation from a given name.
// The name must be that of a previously created StopInstanceOperation, possibly from a different process.
func (c *gRPCClient) StopInstanceOperation(name string) *StopInstanceOperation {
	return &StopInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopInstanceOperation returns a new StopInstanceOperation from a given name.
// The name must be that of a previously created StopInstanceOperation, possibly from a different process.
func (c *restClient) StopInstanceOperation(name string) *StopInstanceOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &StopInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *gRPCClient) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	return &UpdateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *restClient) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &UpdateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateNetworkOperation returns a new UpdateNetworkOperation from a given name.
// The name must be that of a previously created UpdateNetworkOperation, possibly from a different process.
func (c *gRPCClient) UpdateNetworkOperation(name string) *UpdateNetworkOperation {
	return &UpdateNetworkOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateNetworkOperation returns a new UpdateNetworkOperation from a given name.
// The name must be that of a previously created UpdateNetworkOperation, possibly from a different process.
func (c *restClient) UpdateNetworkOperation(name string) *UpdateNetworkOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &UpdateNetworkOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateNfsShareOperation returns a new UpdateNfsShareOperation from a given name.
// The name must be that of a previously created UpdateNfsShareOperation, possibly from a different process.
func (c *gRPCClient) UpdateNfsShareOperation(name string) *UpdateNfsShareOperation {
	return &UpdateNfsShareOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateNfsShareOperation returns a new UpdateNfsShareOperation from a given name.
// The name must be that of a previously created UpdateNfsShareOperation, possibly from a different process.
func (c *restClient) UpdateNfsShareOperation(name string) *UpdateNfsShareOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &UpdateNfsShareOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *gRPCClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *restClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	override := fmt.Sprintf("/v2/%s", name)
	return &UpdateVolumeOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
