/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Injection flags for DI.
 *
 * @publicApi
 * @deprecated use an options object for `inject` instead.
 */
export var InjectFlags;
(function (InjectFlags) {
    // TODO(alxhub): make this 'const' (and remove `InternalInjectFlags` enum) when ngc no longer
    // writes exports of it into ngfactory files.
    /** Check self and check parent injector if needed */
    InjectFlags[InjectFlags["Default"] = 0] = "Default";
    /**
     * Specifies that an injector should retrieve a dependency from any injector until reaching the
     * host element of the current component. (Only used with Element Injector)
     */
    InjectFlags[InjectFlags["Host"] = 1] = "Host";
    /** Don't ascend to ancestors of the node requesting injection. */
    InjectFlags[InjectFlags["Self"] = 2] = "Self";
    /** Skip the node that is requesting injection. */
    InjectFlags[InjectFlags["SkipSelf"] = 4] = "SkipSelf";
    /** Inject `defaultValue` instead if token not found. */
    InjectFlags[InjectFlags["Optional"] = 8] = "Optional";
})(InjectFlags || (InjectFlags = {}));
//# sourceMappingURL=data:application/json;base64,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