//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspreviewrepresentableactivityitem?language=objc)
    pub unsafe trait NSPreviewRepresentableActivityItem: NSObjectProtocol {
        /// The item to be shared
        #[unsafe(method(item))]
        #[unsafe(method_family = none)]
        fn item(&self) -> Retained<AnyObject>;

        /// A string representing the name or title of the item to be shared
        #[optional]
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        fn title(&self) -> Option<Retained<NSString>>;

        /// Provides an image appropriate to represent the item.
        ///
        /// This image typically is a full-size representation of the content being shared.
        /// For instance, if sharing a link to a webpage, this might be the hero image on that webpage.
        #[optional]
        #[unsafe(method(imageProvider))]
        #[unsafe(method_family = none)]
        fn imageProvider(&self) -> Option<Retained<NSItemProvider>>;

        /// Provides an icon appropriate to represent the item.
        ///
        /// This icon typically is a thumbnail-sized representation of the source of the content.
        /// For instance, if sharing a link to a webpage, this might be an icon representing the website overall.
        #[optional]
        #[unsafe(method(iconProvider))]
        #[unsafe(method_family = none)]
        fn iconProvider(&self) -> Option<Retained<NSItemProvider>>;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspreviewrepresentingactivityitem?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSPreviewRepresentingActivityItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSPreviewRepresentingActivityItem {}
);

extern_conformance!(
    unsafe impl NSPreviewRepresentableActivityItem for NSPreviewRepresentingActivityItem {}
);

impl NSPreviewRepresentingActivityItem {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        /// - Parameters:
        /// - item: The item to share
        /// - title: A title to show in a preview
        /// - image: An image to show in a preview
        /// - icon: An icon to show in a preview
        ///
        /// For more information about the parameters, see NSPreviewRepresentableActivityItem documentation
        ///
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[unsafe(method(initWithItem:title:image:icon:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItem_title_image_icon(
            this: Allocated<Self>,
            item: &AnyObject,
            title: Option<&NSString>,
            image: Option<&NSImage>,
            icon: Option<&NSImage>,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - item: The item to share
        /// - title: A title to show in a preview
        /// - imageProvider: An NSItemProvider which provides an image to show in a preview
        /// - iconProvider: An NSItemProvider which provides an icon to show in a preview
        ///
        /// For more information about the parameters, see NSPreviewRepresentableActivityItem documentation
        ///
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[unsafe(method(initWithItem:title:imageProvider:iconProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItem_title_imageProvider_iconProvider(
            this: Allocated<Self>,
            item: &AnyObject,
            title: Option<&NSString>,
            image_provider: Option<&NSItemProvider>,
            icon_provider: Option<&NSItemProvider>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
