package geoip

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGeoipInstance invokes the geoip.DescribeGeoipInstance API synchronously
func (client *Client) DescribeGeoipInstance(request *DescribeGeoipInstanceRequest) (response *DescribeGeoipInstanceResponse, err error) {
	response = CreateDescribeGeoipInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGeoipInstanceWithChan invokes the geoip.DescribeGeoipInstance API asynchronously
func (client *Client) DescribeGeoipInstanceWithChan(request *DescribeGeoipInstanceRequest) (<-chan *DescribeGeoipInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeGeoipInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGeoipInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGeoipInstanceWithCallback invokes the geoip.DescribeGeoipInstance API asynchronously
func (client *Client) DescribeGeoipInstanceWithCallback(request *DescribeGeoipInstanceRequest, callback func(response *DescribeGeoipInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGeoipInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeGeoipInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGeoipInstanceRequest is the request struct for api DescribeGeoipInstance
type DescribeGeoipInstanceRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGeoipInstanceResponse is the response struct for api DescribeGeoipInstance
type DescribeGeoipInstanceResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ProductCode     string `json:"ProductCode" xml:"ProductCode"`
	InstanceId      string `json:"InstanceId" xml:"InstanceId"`
	VersionCode     string `json:"VersionCode" xml:"VersionCode"`
	MaxQps          int64  `json:"MaxQps" xml:"MaxQps"`
	MaxQpd          int64  `json:"MaxQpd" xml:"MaxQpd"`
	QueryCount      int64  `json:"QueryCount" xml:"QueryCount"`
	CreateTime      string `json:"CreateTime" xml:"CreateTime"`
	CreateTimestamp int64  `json:"CreateTimestamp" xml:"CreateTimestamp"`
	ExpireTime      string `json:"ExpireTime" xml:"ExpireTime"`
	ExpireTimestamp int64  `json:"ExpireTimestamp" xml:"ExpireTimestamp"`
}

// CreateDescribeGeoipInstanceRequest creates a request to invoke DescribeGeoipInstance API
func CreateDescribeGeoipInstanceRequest() (request *DescribeGeoipInstanceRequest) {
	request = &DescribeGeoipInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("geoip", "2020-01-01", "DescribeGeoipInstance", "geoip", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGeoipInstanceResponse creates a response to parse from DescribeGeoipInstance response
func CreateDescribeGeoipInstanceResponse() (response *DescribeGeoipInstanceResponse) {
	response = &DescribeGeoipInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
