package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceList invokes the edas.GetServiceList API synchronously
func (client *Client) GetServiceList(request *GetServiceListRequest) (response *GetServiceListResponse, err error) {
	response = CreateGetServiceListResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceListWithChan invokes the edas.GetServiceList API asynchronously
func (client *Client) GetServiceListWithChan(request *GetServiceListRequest) (<-chan *GetServiceListResponse, <-chan error) {
	responseChan := make(chan *GetServiceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceListWithCallback invokes the edas.GetServiceList API asynchronously
func (client *Client) GetServiceListWithCallback(request *GetServiceListRequest, callback func(response *GetServiceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceListResponse
		var err error
		defer close(result)
		response, err = client.GetServiceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceListRequest is the request struct for api GetServiceList
type GetServiceListRequest struct {
	*requests.RoaRequest
	ServiceType string `position:"Query" name:"serviceType"`
	Side        string `position:"Query" name:"side"`
	Origin      string `position:"Query" name:"origin"`
	SearchType  string `position:"Query" name:"searchType"`
	Namespace   string `position:"Query" name:"namespace"`
	Region      string `position:"Query" name:"region"`
	SearchValue string `position:"Query" name:"searchValue"`
}

// GetServiceListResponse is the response struct for api GetServiceList
type GetServiceListResponse struct {
	*responses.BaseResponse
	Code    int                  `json:"Code" xml:"Code"`
	Message string               `json:"Message" xml:"Message"`
	Success bool                 `json:"Success" xml:"Success"`
	Data    []MseServiceResponse `json:"Data" xml:"Data"`
}

// CreateGetServiceListRequest creates a request to invoke GetServiceList API
func CreateGetServiceListRequest() (request *GetServiceListRequest) {
	request = &GetServiceListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetServiceList", "/pop/sp/api/mseForOam/getServiceList", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceListResponse creates a response to parse from GetServiceList response
func CreateGetServiceListResponse() (response *GetServiceListResponse) {
	response = &GetServiceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
