package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobDetail invokes the dts.DescribeMigrationJobDetail API synchronously
func (client *Client) DescribeMigrationJobDetail(request *DescribeMigrationJobDetailRequest) (response *DescribeMigrationJobDetailResponse, err error) {
	response = CreateDescribeMigrationJobDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobDetailWithChan invokes the dts.DescribeMigrationJobDetail API asynchronously
func (client *Client) DescribeMigrationJobDetailWithChan(request *DescribeMigrationJobDetailRequest) (<-chan *DescribeMigrationJobDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobDetailWithCallback invokes the dts.DescribeMigrationJobDetail API asynchronously
func (client *Client) DescribeMigrationJobDetailWithCallback(request *DescribeMigrationJobDetailRequest, callback func(response *DescribeMigrationJobDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobDetailRequest is the request struct for api DescribeMigrationJobDetail
type DescribeMigrationJobDetailRequest struct {
	*requests.RpcRequest
	ClientToken                          string           `position:"Query" name:"ClientToken"`
	MigrationModeDataInitialization      requests.Boolean `position:"Query" name:"MigrationMode.DataInitialization"`
	MigrationJobId                       string           `position:"Query" name:"MigrationJobId"`
	PageNum                              requests.Integer `position:"Query" name:"PageNum"`
	AccountId                            string           `position:"Query" name:"AccountId"`
	MigrationModeDataSynchronization     requests.Boolean `position:"Query" name:"MigrationMode.DataSynchronization"`
	PageSize                             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId                              string           `position:"Query" name:"OwnerId"`
	MigrationModeStructureInitialization requests.Boolean `position:"Query" name:"MigrationMode.StructureInitialization"`
}

// DescribeMigrationJobDetailResponse is the response struct for api DescribeMigrationJobDetail
type DescribeMigrationJobDetailResponse struct {
	*responses.BaseResponse
	RequestId                         string                            `json:"RequestId" xml:"RequestId"`
	ErrCode                           string                            `json:"ErrCode" xml:"ErrCode"`
	PageRecordCount                   int                               `json:"PageRecordCount" xml:"PageRecordCount"`
	Success                           string                            `json:"Success" xml:"Success"`
	TotalRecordCount                  int64                             `json:"TotalRecordCount" xml:"TotalRecordCount"`
	ErrMessage                        string                            `json:"ErrMessage" xml:"ErrMessage"`
	PageNumber                        int                               `json:"PageNumber" xml:"PageNumber"`
	DataInitializationDetailList      DataInitializationDetailList      `json:"DataInitializationDetailList" xml:"DataInitializationDetailList"`
	DataSynchronizationDetailList     DataSynchronizationDetailList     `json:"DataSynchronizationDetailList" xml:"DataSynchronizationDetailList"`
	StructureInitializationDetailList StructureInitializationDetailList `json:"StructureInitializationDetailList" xml:"StructureInitializationDetailList"`
}

// CreateDescribeMigrationJobDetailRequest creates a request to invoke DescribeMigrationJobDetail API
func CreateDescribeMigrationJobDetailRequest() (request *DescribeMigrationJobDetailRequest) {
	request = &DescribeMigrationJobDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeMigrationJobDetail", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMigrationJobDetailResponse creates a response to parse from DescribeMigrationJobDetail response
func CreateDescribeMigrationJobDetailResponse() (response *DescribeMigrationJobDetailResponse) {
	response = &DescribeMigrationJobDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
