package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveApRadioSsidConfig invokes the cloudwf.SaveApRadioSsidConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradiossidconfig.html
func (client *Client) SaveApRadioSsidConfig(request *SaveApRadioSsidConfigRequest) (response *SaveApRadioSsidConfigResponse, err error) {
	response = CreateSaveApRadioSsidConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveApRadioSsidConfigWithChan invokes the cloudwf.SaveApRadioSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradiossidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApRadioSsidConfigWithChan(request *SaveApRadioSsidConfigRequest) (<-chan *SaveApRadioSsidConfigResponse, <-chan error) {
	responseChan := make(chan *SaveApRadioSsidConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveApRadioSsidConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveApRadioSsidConfigWithCallback invokes the cloudwf.SaveApRadioSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradiossidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApRadioSsidConfigWithCallback(request *SaveApRadioSsidConfigRequest, callback func(response *SaveApRadioSsidConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveApRadioSsidConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveApRadioSsidConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveApRadioSsidConfigRequest is the request struct for api SaveApRadioSsidConfig
type SaveApRadioSsidConfigRequest struct {
	*requests.RpcRequest
	Nasid               string           `position:"Query" name:"Nasid"`
	AuthPort            requests.Integer `position:"Query" name:"AuthPort"`
	Hidden              requests.Integer `position:"Query" name:"Hidden"`
	DynamicVlan         requests.Integer `position:"Query" name:"DynamicVlan"`
	AuthServer          string           `position:"Query" name:"AuthServer"`
	SecondaryAcctServer string           `position:"Query" name:"SecondaryAcctServer"`
	Ssid                string           `position:"Query" name:"Ssid"`
	Cir                 requests.Integer `position:"Query" name:"Cir"`
	Mac                 string           `position:"Query" name:"Mac"`
	SecondaryAcctSecret string           `position:"Query" name:"SecondaryAcctSecret"`
	Ieee80211w          requests.Integer `position:"Query" name:"Ieee80211w"`
	Network             requests.Integer `position:"Query" name:"Network"`
	Isolate             requests.Integer `position:"Query" name:"Isolate"`
	ApAssetId           requests.Integer `position:"Query" name:"ApAssetId"`
	EncKey              string           `position:"Query" name:"EncKey"`
	MulticastForward    requests.Integer `position:"Query" name:"MulticastForward"`
	Encryption          string           `position:"Query" name:"Encryption"`
	Wmm                 requests.Integer `position:"Query" name:"Wmm"`
	AuthCache           requests.Integer `position:"Query" name:"AuthCache"`
	Disabled            requests.Integer `position:"Query" name:"Disabled"`
	Id                  requests.Integer `position:"Query" name:"Id"`
	RadioIndex          requests.Integer `position:"Query" name:"RadioIndex"`
	IgnoreWeakProbe     requests.Integer `position:"Query" name:"IgnoreWeakProbe"`
	Maxassoc            requests.Integer `position:"Query" name:"Maxassoc"`
	AcctServer          string           `position:"Query" name:"AcctServer"`
	SecondaryAuthServer string           `position:"Query" name:"SecondaryAuthServer"`
	DaeClient           string           `position:"Query" name:"DaeClient"`
	DaeSecret           string           `position:"Query" name:"DaeSecret"`
	DisassocLowAck      requests.Integer `position:"Query" name:"DisassocLowAck"`
	SecondaryAuthPort   requests.Integer `position:"Query" name:"SecondaryAuthPort"`
	AcctSecret          string           `position:"Query" name:"AcctSecret"`
	DisassocWeakRssi    requests.Integer `position:"Query" name:"DisassocWeakRssi"`
	SecondaryAcctPort   requests.Integer `position:"Query" name:"SecondaryAcctPort"`
	DaePort             requests.Integer `position:"Query" name:"DaePort"`
	SsidLb              requests.Integer `position:"Query" name:"SsidLb"`
	AcctPort            requests.Integer `position:"Query" name:"AcctPort"`
	MaxInactivity       requests.Integer `position:"Query" name:"MaxInactivity"`
	VlanDhcp            requests.Integer `position:"Query" name:"VlanDhcp"`
	InstantlyEffective  requests.Integer `position:"Query" name:"InstantlyEffective"`
	ShortPreamble       requests.Integer `position:"Query" name:"ShortPreamble"`
	AuthSecret          string           `position:"Query" name:"AuthSecret"`
	SecondaryAuthSecret string           `position:"Query" name:"SecondaryAuthSecret"`
	Ownip               string           `position:"Query" name:"Ownip"`
}

// SaveApRadioSsidConfigResponse is the response struct for api SaveApRadioSsidConfig
type SaveApRadioSsidConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveApRadioSsidConfigRequest creates a request to invoke SaveApRadioSsidConfig API
func CreateSaveApRadioSsidConfigRequest() (request *SaveApRadioSsidConfigRequest) {
	request = &SaveApRadioSsidConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveApRadioSsidConfig", "cloudwf", "openAPI")
	return
}

// CreateSaveApRadioSsidConfigResponse creates a response to parse from SaveApRadioSsidConfig response
func CreateSaveApRadioSsidConfigResponse() (response *SaveApRadioSsidConfigResponse) {
	response = &SaveApRadioSsidConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
