package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVnCategories invokes the cloudcallcenter.ListVnCategories API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvncategories.html
func (client *Client) ListVnCategories(request *ListVnCategoriesRequest) (response *ListVnCategoriesResponse, err error) {
	response = CreateListVnCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVnCategoriesWithChan invokes the cloudcallcenter.ListVnCategories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvncategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnCategoriesWithChan(request *ListVnCategoriesRequest) (<-chan *ListVnCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListVnCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVnCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVnCategoriesWithCallback invokes the cloudcallcenter.ListVnCategories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvncategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnCategoriesWithCallback(request *ListVnCategoriesRequest, callback func(response *ListVnCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVnCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListVnCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVnCategoriesRequest is the request struct for api ListVnCategories
type ListVnCategoriesRequest struct {
	*requests.RpcRequest
	ParentId   string `position:"Query" name:"ParentId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListVnCategoriesResponse is the response struct for api ListVnCategories
type ListVnCategoriesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Categories []Category `json:"Categories" xml:"Categories"`
}

// CreateListVnCategoriesRequest creates a request to invoke ListVnCategories API
func CreateListVnCategoriesRequest() (request *ListVnCategoriesRequest) {
	request = &ListVnCategoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListVnCategories", "", "")
	request.Method = requests.GET
	return
}

// CreateListVnCategoriesResponse creates a response to parse from ListVnCategories response
func CreateListVnCategoriesResponse() (response *ListVnCategoriesResponse) {
	response = &ListVnCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
