/*
    SPDX-FileCopyrightText: 2008-2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_BYTEARRAYSEARCHJOB_HPP
#define KASTEN_BYTEARRAYSEARCHJOB_HPP

// Okteta core
#include <Okteta/AddressRange>
// Qt
#include <QObject>
#include <QByteArray>
// Std
#include <memory>

namespace Okteta {
class AbstractByteArrayModel;
class CharCodec;
}

namespace Kasten {

class ByteArraySearchJob : public QObject // not yet: KJob
{
    Q_OBJECT

public:
    ByteArraySearchJob(const Okteta::AbstractByteArrayModel* model,
                       const QByteArray& searchData,
                       Okteta::Address startIndex, Okteta::Address endIndex,
                       Qt::CaseSensitivity caseSensitivity, const QString& charCodecName);

    ~ByteArraySearchJob() override;

public:
    [[nodiscard]]
    Okteta::AddressRange exec();
    void start();

Q_SIGNALS:
    void finished(Okteta::AddressRange position);

private Q_SLOTS:
    void onBytesSearched();

private:
    const Okteta::AbstractByteArrayModel* mByteArrayModel;

    QByteArray mSearchData;
    Okteta::Address mStartIndex;
    Okteta::Address mEndIndex;
    Qt::CaseSensitivity mCaseSensitivity;
    const std::unique_ptr<const Okteta::CharCodec> mCharCodec;

    Okteta::AddressRange m_result;
};

}

#endif
